package exploit_test

import (
	"testing"

	"github.com/vulncheck-oss/go-exploit"
)

func TestCheckSemVer_Full(t *testing.T) {
	if !exploit.CheckSemVer("1.0.0", "<= 1.0.0") {
		t.Error("Constraint should have passed")
	}
	if exploit.CheckSemVer("1.0.0", "> 1.0.0") {
		t.Error("Constraint should not have passed")
	}
}

func TestCheckSemVer_BadVersion(t *testing.T) {
	if exploit.CheckSemVer("uwu", "<= 1.0.0") {
		t.Error("Version was invalid, should not have passed")
	}
	if exploit.CheckSemVer("1.0.0 ", "<= 1.0.0") {
		t.Error("Version was invalid, should not have passed")
	}
}

func TestCheckSemVer_BadConstraint(t *testing.T) {
	if exploit.CheckSemVer("1.0.0", "<== 1.0.0") {
		t.Error("Constraint was invalid, should not have passed")
	}
	if exploit.CheckSemVer("1.0.0", "xp") {
		t.Error("Constraint was invalid, should not have passed")
	}
}
