// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package documentai provides access to the Cloud Document AI API.
//
// For product documentation, see: https://cloud.google.com/document-ai/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/documentai/v1"
//	...
//	ctx := context.Background()
//	documentaiService, err := documentai.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	documentaiService, err := documentai.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	documentaiService, err := documentai.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package documentai // import "google.golang.org/api/documentai/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "documentai:v1"
const apiName = "documentai"
const apiVersion = "v1"
const basePath = "https://documentai.googleapis.com/"
const basePathTemplate = "https://documentai.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://documentai.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Operations = NewOperationsService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Operations *OperationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.ProcessorTypes = NewProjectsLocationsProcessorTypesService(s)
	rs.Processors = NewProjectsLocationsProcessorsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Operations *ProjectsLocationsOperationsService

	ProcessorTypes *ProjectsLocationsProcessorTypesService

	Processors *ProjectsLocationsProcessorsService
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsProcessorTypesService(s *Service) *ProjectsLocationsProcessorTypesService {
	rs := &ProjectsLocationsProcessorTypesService{s: s}
	return rs
}

type ProjectsLocationsProcessorTypesService struct {
	s *Service
}

func NewProjectsLocationsProcessorsService(s *Service) *ProjectsLocationsProcessorsService {
	rs := &ProjectsLocationsProcessorsService{s: s}
	rs.HumanReviewConfig = NewProjectsLocationsProcessorsHumanReviewConfigService(s)
	rs.ProcessorVersions = NewProjectsLocationsProcessorsProcessorVersionsService(s)
	return rs
}

type ProjectsLocationsProcessorsService struct {
	s *Service

	HumanReviewConfig *ProjectsLocationsProcessorsHumanReviewConfigService

	ProcessorVersions *ProjectsLocationsProcessorsProcessorVersionsService
}

func NewProjectsLocationsProcessorsHumanReviewConfigService(s *Service) *ProjectsLocationsProcessorsHumanReviewConfigService {
	rs := &ProjectsLocationsProcessorsHumanReviewConfigService{s: s}
	return rs
}

type ProjectsLocationsProcessorsHumanReviewConfigService struct {
	s *Service
}

func NewProjectsLocationsProcessorsProcessorVersionsService(s *Service) *ProjectsLocationsProcessorsProcessorVersionsService {
	rs := &ProjectsLocationsProcessorsProcessorVersionsService{s: s}
	rs.Evaluations = NewProjectsLocationsProcessorsProcessorVersionsEvaluationsService(s)
	return rs
}

type ProjectsLocationsProcessorsProcessorVersionsService struct {
	s *Service

	Evaluations *ProjectsLocationsProcessorsProcessorVersionsEvaluationsService
}

func NewProjectsLocationsProcessorsProcessorVersionsEvaluationsService(s *Service) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsService {
	rs := &ProjectsLocationsProcessorsProcessorVersionsEvaluationsService{s: s}
	return rs
}

type ProjectsLocationsProcessorsProcessorVersionsEvaluationsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// CloudAiDocumentaiLabHifiaToolsValidationValidatorInput: Definition of the
// validation rules. Those are the input to the validator logic and they are
// used to validate a document.
type CloudAiDocumentaiLabHifiaToolsValidationValidatorInput struct {
	ValidationRules []*CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRule `json:"validationRules,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ValidationRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ValidationRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiDocumentaiLabHifiaToolsValidationValidatorInput) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiDocumentaiLabHifiaToolsValidationValidatorInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRule struct {
	// Description: Description of the validation rule. This has no use but for
	// documentation
	Description      string                                                                                `json:"description,omitempty"`
	FieldOccurrences *CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldOccurrences `json:"fieldOccurrences,omitempty"`
	FieldRegex       *CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldRegex       `json:"fieldRegex,omitempty"`
	FormValidation   *CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidation   `json:"formValidation,omitempty"`
	// Name: Name of the validation rule.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRule) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant:
//
//	The constant value used in the validation rules.
type CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant struct {
	FloatValue float64 `json:"floatValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FloatValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FloatValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

type CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField struct {
	// DefaultValue: Default value to use if the field is not present. If the field
	// is missing and the default value is not set, the validation run as if the
	// field is not present in the validation logic.
	DefaultValue *CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant `json:"defaultValue,omitempty"`
	// FieldName: The field name to validate. This can be a simple field name or a
	// nested field one using the ':' (meant as an aggregator) or '*' (meant as
	// foreach) operators.
	FieldName string `json:"fieldName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldOccurrences struct {
	Field          *CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField `json:"field,omitempty"`
	MaxOccurrences int64                                                                      `json:"maxOccurrences,omitempty"`
	// MinOccurrences: Min and max occurrences of the field. If not set, there is
	// limit set. The defined interval is a closed-closed interval, i.e. [min,
	// max].
	MinOccurrences int64 `json:"minOccurrences,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldOccurrences) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldOccurrences
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldRegex struct {
	Field *CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField `json:"field,omitempty"`
	// Pattern: Python regex to validate the field values.
	Pattern string `json:"pattern,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldRegex) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldRegex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidation struct {
	LeftOperand  *CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation `json:"leftOperand,omitempty"`
	RightOperand *CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation `json:"rightOperand,omitempty"`
	// ValidationOperator: The relational operator to be applied to the operands.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED"
	//   "OPERATION_TYPE_EQ"
	//   "OPERATION_TYPE_NE"
	//   "OPERATION_TYPE_LT"
	//   "OPERATION_TYPE_LE"
	//   "OPERATION_TYPE_GT"
	//   "OPERATION_TYPE_GE"
	ValidationOperator string `json:"validationOperator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LeftOperand") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LeftOperand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidation) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation struct {
	// Constants: A list of constants to be used as operands.
	Constants []*CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant `json:"constants,omitempty"`
	// Fields: A list of fields to be used as operands.
	Fields []*CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField `json:"fields,omitempty"`
	// OperationType: The operation type to be applied to all the operands.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED"
	//   "OPERATION_TYPE_SUM"
	//   "OPERATION_TYPE_SUB"
	//   "OPERATION_TYPE_MUL"
	//   "OPERATION_TYPE_DIV"
	//   "OPERATION_TYPE_MAX"
	//   "OPERATION_TYPE_MIN"
	//   "OPERATION_TYPE_ABS"
	//   "OPERATION_TYPE_UNIQUE"
	//   "OPERATION_TYPE_COUNT"
	OperationType string `json:"operationType,omitempty"`
	// Operations: A list of recursive operations to be used as operands.
	Operations []*CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation `json:"operations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Constants") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Constants") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata: Metadata of the
// auto-labeling documents operation.
type GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// IndividualAutoLabelStatuses: The list of individual auto-labeling statuses
	// of the dataset documents.
	IndividualAutoLabelStatuses []*GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus `json:"individualAutoLabelStatuses,omitempty"`
	// TotalDocumentCount: Total number of the auto-labeling documents.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelSt
// atus: The status of individual documents in the auto-labeling process.
type GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus struct {
	// DocumentId: The document id of the auto-labeled document. This will replace
	// the gcs_uri.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of the document auto-labeling.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsResponse: The response proto
// of AutoLabelDocuments method.
type GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ErrorDocumentCount: Total number of documents that failed to be deleted in
	// storage.
	ErrorDocumentCount int64 `json:"errorDocumentCount,omitempty"`
	// IndividualBatchDeleteStatuses: The list of response details of each
	// document.
	IndividualBatchDeleteStatuses []*GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus `json:"individualBatchDeleteStatuses,omitempty"`
	// TotalDocumentCount: Total number of documents deleting from dataset.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDele
// teStatus: The status of each individual document in the batch delete
// process.
type GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of deleting the document in storage.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsResponse: Response of the
// delete documents operation.
type GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// DestDatasetType: The destination dataset split type.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	DestDatasetType string `json:"destDatasetType,omitempty"`
	// DestSplitType: The destination dataset split type.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	DestSplitType string `json:"destSplitType,omitempty"`
	// IndividualBatchMoveStatuses: The list of response details of each document.
	IndividualBatchMoveStatuses []*GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus `json:"individualBatchMoveStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveSt
// atus: The status of each individual document in the batch move process.
type GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of moving the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsResponse: Response of the
// batch move documents operation.
type GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// IndividualBatchUpdateStatuses: The list of response details of each
	// document.
	IndividualBatchUpdateStatuses []*GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus `json:"individualBatchUpdateStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpda
// teStatus: The status of each individual document in the batch update
// process.
type GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of updating the document in storage.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsResponse: Response of the
// batch update documents operation.
type GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata: The common metadata
// for long running operations.
type GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// Resource: A related resource to this operation.
	Resource string `json:"resource,omitempty"`
	// State: The state of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata: The
// long-running operation metadata for the CreateLabelerPool method.
type GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata: The
// long-running operation metadata for DeleteLabelerPool.
type GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata: The long-running
// operation metadata for the DeleteProcessor method.
type GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata: The
// long-running operation metadata for the DeleteProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata: The
// long-running operation metadata for the DeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionResponse: Response
// message for the DeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata: The long-running
// operation metadata for the DisableProcessor method.
type GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DisableProcessorResponse: Response message for
// the DisableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiUiv1beta3DisableProcessorResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3DocumentId: Document Identifier.
type GoogleCloudDocumentaiUiv1beta3DocumentId struct {
	// GcsManagedDocId: A document id within user-managed Cloud Storage.
	GcsManagedDocId *GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId `json:"gcsManagedDocId,omitempty"`
	// RevisionRef: Points to a specific revision of the document if set.
	RevisionRef *GoogleCloudDocumentaiUiv1beta3RevisionRef `json:"revisionRef,omitempty"`
	// UnmanagedDocId: A document id within unmanaged dataset.
	UnmanagedDocId *GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId `json:"unmanagedDocId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsManagedDocId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsManagedDocId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId: Identifies a
// document uniquely within the scope of a dataset in the user-managed Cloud
// Storage option.
type GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId struct {
	// CwDocId: Id of the document (indexed) managed by Content Warehouse.
	CwDocId string `json:"cwDocId,omitempty"`
	// GcsUri: Required. The Cloud Storage URI where the actual document is stored.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CwDocId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CwDocId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId: Identifies a
// document uniquely within the scope of a dataset in unmanaged option.
type GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId struct {
	// DocId: Required. The id of the document.
	DocId string `json:"docId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata: The long-running
// operation metadata for the EnableProcessor method.
type GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3EnableProcessorResponse: Response message for
// the EnableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiUiv1beta3EnableProcessorResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata: Metadata of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse: Response of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse struct {
	// Evaluation: The resource name of the created evaluation.
	Evaluation string `json:"evaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata: Metadata of the batch
// export documents operation.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// IndividualExportStatuses: The list of response details of each document.
	IndividualExportStatuses []*GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus `json:"individualExportStatuses,omitempty"`
	// SplitExportStats: The list of statistics for each dataset split type.
	SplitExportStats []*GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat `json:"splitExportStats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus:
// The status of each individual document in the export process.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus struct {
	// DocumentId: The path to source docproto of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// OutputGcsDestination: The output_gcs_destination of the exported document if
	// it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`
	// Status: The status of the exporting of the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat: The
// statistic representing a dataset split type for this export.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat struct {
	// SplitType: The dataset split type.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	SplitType string `json:"splitType,omitempty"`
	// TotalDocumentCount: Total number of documents with the given dataset split
	// type to be exported.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SplitType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SplitType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsResponse: The response proto of
// ExportDocuments method.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata: Metadata
// message associated with the ExportProcessorVersion operation.
type GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata struct {
	// CommonMetadata: The common metadata about the operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse: Response
// message associated with the ExportProcessorVersion operation.
type GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse struct {
	// GcsUri: The Cloud Storage URI containing the output artifacts.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata: Metadata of the
// import document operation.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ImportConfigValidationResults: Validation statuses of the batch documents
	// import config.
	ImportConfigValidationResults []*GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult `json:"importConfigValidationResults,omitempty"`
	// IndividualImportStatuses: The list of response details of each document.
	IndividualImportStatuses []*GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus `json:"individualImportStatuses,omitempty"`
	// TotalDocumentCount: Total number of the documents that are qualified for
	// importing.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationRe
// sult: The validation status of each import config. Status is set to an error
// if there are no documents to import in the `import_config`, or `OK` if the
// operation will try to proceed with at least one document.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult struct {
	// InputGcsSource: The source Cloud Storage URI specified in the import config.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// Status: The validation status of import config.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus:
// The status of each individual document in the import process.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus struct {
	// InputGcsSource: The source Cloud Storage URI of the document.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// OutputDocumentId: The document id of imported document if it was successful,
	// otherwise empty.
	OutputDocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"outputDocumentId,omitempty"`
	// OutputGcsDestination: The output_gcs_destination of the processed document
	// if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`
	// Status: The status of the importing of the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsResponse: Response of the
// import document operation.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata: The
// long-running operation metadata for the ImportProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata for the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse: The response
// message for the ImportProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse struct {
	// ProcessorVersion: The destination processor version name.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata: The metadata proto of
// `ResyncDataset` method.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// DatasetResyncStatuses: The list of dataset resync statuses. Not checked when
	// ResyncDatasetRequest.dataset_documents is specified.
	DatasetResyncStatuses []*GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus `json:"datasetResyncStatuses,omitempty"`
	// IndividualDocumentResyncStatuses: The list of document resync statuses. The
	// same document could have multiple `individual_document_resync_statuses` if
	// it has multiple inconsistencies.
	IndividualDocumentResyncStatuses []*GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus `json:"individualDocumentResyncStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus:
// Resync status against inconsistency types on the dataset level.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus struct {
	// DatasetInconsistencyType: The type of the inconsistency of the dataset.
	//
	// Possible values:
	//   "DATASET_INCONSISTENCY_TYPE_UNSPECIFIED" - Default value.
	//   "DATASET_INCONSISTENCY_TYPE_NO_STORAGE_MARKER" - The marker file under the
	// dataset folder is not found.
	DatasetInconsistencyType string `json:"datasetInconsistencyType,omitempty"`
	// Status: The status of resyncing the dataset with regards to the detected
	// inconsistency. Empty if ResyncDatasetRequest.validate_only is `true`.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetInconsistencyType")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetInconsistencyType") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncSt
// atus: Resync status for each document per inconsistency type.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus struct {
	// DocumentId: The document identifier.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// DocumentInconsistencyType: The type of document inconsistency.
	//
	// Possible values:
	//   "DOCUMENT_INCONSISTENCY_TYPE_UNSPECIFIED" - Default value.
	//   "DOCUMENT_INCONSISTENCY_TYPE_INVALID_DOCPROTO" - The document proto is
	// invalid.
	//   "DOCUMENT_INCONSISTENCY_TYPE_MISMATCHED_METADATA" - Indexed docproto
	// metadata is mismatched.
	//   "DOCUMENT_INCONSISTENCY_TYPE_NO_PAGE_IMAGE" - The page image or thumbnails
	// are missing.
	DocumentInconsistencyType string `json:"documentInconsistencyType,omitempty"`
	// Status: The status of resyncing the document with regards to the detected
	// inconsistency. Empty if ResyncDatasetRequest.validate_only is `true`.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetResponse: The response proto of
// ResyncDataset method.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3RevisionRef: The revision reference specifies
// which revision on the document to read.
type GoogleCloudDocumentaiUiv1beta3RevisionRef struct {
	// LatestProcessorVersion: Reads the revision generated by the processor
	// version. The format takes the full resource name of processor version.
	// `projects/{project}/locations/{location}/processors/{processor}/processorVers
	// ions/{processorVersion}`
	LatestProcessorVersion string `json:"latestProcessorVersion,omitempty"`
	// RevisionCase: Reads the revision by the predefined case.
	//
	// Possible values:
	//   "REVISION_CASE_UNSPECIFIED" - Unspecified case, fall back to read the
	// `LATEST_HUMAN_REVIEW`.
	//   "LATEST_HUMAN_REVIEW" - The latest revision made by a human.
	//   "LATEST_TIMESTAMP" - The latest revision based on timestamp.
	//   "BASE_OCR_REVISION" - The first (OCR) revision.
	RevisionCase string `json:"revisionCase,omitempty"`
	// RevisionId: Reads the revision given by the id.
	RevisionId string `json:"revisionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatestProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatestProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3RevisionRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3RevisionRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata: Metadata of the
// sample documents operation.
type GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse: Response of the
// sample documents operation.
type GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse struct {
	// SampleTestStatus: The status of sampling documents in test split.
	SampleTestStatus *GoogleRpcStatus `json:"sampleTestStatus,omitempty"`
	// SampleTrainingStatus: The status of sampling documents in training split.
	SampleTrainingStatus *GoogleRpcStatus `json:"sampleTrainingStatus,omitempty"`
	// SelectedDocuments: The result of the sampling process.
	SelectedDocuments []*GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument `json:"selectedDocuments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SampleTestStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SampleTestStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument struct {
	// DocumentId: An internal identifier for document.
	DocumentId string `json:"documentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata: The
// long-running operation metadata for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionResponse: Response
// message for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata: The metadata
// that represents a processor version being created.
type GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// TestDatasetValidation: The test dataset validation information.
	TestDatasetValidation *GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation `json:"testDatasetValidation,omitempty"`
	// TrainingDatasetValidation: The training dataset validation information.
	TrainingDatasetValidation *GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation `json:"trainingDatasetValidation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation:
//
//	The dataset validation information. This includes any and all errors with
//
// documents and the dataset.
type GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation struct {
	// DatasetErrorCount: The total number of dataset errors.
	DatasetErrorCount int64 `json:"datasetErrorCount,omitempty"`
	// DatasetErrors: Error information for the dataset as a whole. A maximum of 10
	// dataset errors will be returned. A single dataset error is terminal for
	// training.
	DatasetErrors []*GoogleRpcStatus `json:"datasetErrors,omitempty"`
	// DocumentErrorCount: The total number of document errors.
	DocumentErrorCount int64 `json:"documentErrorCount,omitempty"`
	// DocumentErrors: Error information pertaining to specific documents. A
	// maximum of 10 document errors will be returned. Any document with errors
	// will not be used throughout training.
	DocumentErrors []*GoogleRpcStatus `json:"documentErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetErrorCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetErrorCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse: The response
// for TrainProcessorVersion.
type GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse struct {
	// ProcessorVersion: The resource name of the processor version produced by
	// training.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata: The
// long-running operation metadata for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionResponse: Response
// message for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata: The
// long-running operation metadata for updating the human review configuration.
type GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata: The
// long-running operation metadata for UpdateLabelerPool.
type GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1Barcode: Encodes the detailed information of a
// barcode.
type GoogleCloudDocumentaiV1Barcode struct {
	// Format: Format of a barcode. The supported formats are: - `CODE_128`: Code
	// 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type. - `CODABAR`:
	// Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. - `ITF`: ITF type. -
	// `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. - `QR_CODE`: 2D QR code type.
	// - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E type. - `PDF417`: PDF417 type. -
	// `AZTEC`: 2D Aztec code type. - `DATABAR`: GS1 DataBar code type.
	Format string `json:"format,omitempty"`
	// RawValue: Raw value encoded in the barcode. For example:
	// `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
	RawValue string `json:"rawValue,omitempty"`
	// ValueFormat: Value format describes the format of the value that a barcode
	// encodes. The supported formats are: - `CONTACT_INFO`: Contact information. -
	// `EMAIL`: Email address. - `ISBN`: ISBN identifier. - `PHONE`: Phone number.
	// - `PRODUCT`: Product. - `SMS`: SMS message. - `TEXT`: Text string. - `URL`:
	// URL address. - `WIFI`: Wifi information. - `GEO`: Geo-localization. -
	// `CALENDAR_EVENT`: Calendar event. - `DRIVER_LICENSE`: Driver's license.
	ValueFormat string `json:"valueFormat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Format") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1Barcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1Barcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchDocumentsInputConfig: The common config to
// specify a set of documents used as input.
type GoogleCloudDocumentaiV1BatchDocumentsInputConfig struct {
	// GcsDocuments: The set of documents individually specified on Cloud Storage.
	GcsDocuments *GoogleCloudDocumentaiV1GcsDocuments `json:"gcsDocuments,omitempty"`
	// GcsPrefix: The set of documents that match the specified Cloud Storage
	// `gcs_prefix`.
	GcsPrefix *GoogleCloudDocumentaiV1GcsPrefix `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDocuments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDocuments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1BatchDocumentsInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BatchDocumentsInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessMetadata: The long-running operation
// metadata for BatchProcessDocuments.
type GoogleCloudDocumentaiV1BatchProcessMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// IndividualProcessStatuses: The list of response details of each document.
	IndividualProcessStatuses []*GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus `json:"individualProcessStatuses,omitempty"`
	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLING" - The batch processing was being cancelled.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the error message if the operation is failed.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1BatchProcessMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BatchProcessMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus: The
// status of a each individual document in the batch process.
type GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus struct {
	// HumanReviewStatus: The status of human review on the processed document.
	HumanReviewStatus *GoogleCloudDocumentaiV1HumanReviewStatus `json:"humanReviewStatus,omitempty"`
	// InputGcsSource: The source of the document, same as the input_gcs_source
	// field in the request when the batch process started.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// OutputGcsDestination: The Cloud Storage output destination (in the request
	// as DocumentOutputConfig.GcsOutputConfig.gcs_uri) of the processed document
	// if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`
	// Status: The status processing the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HumanReviewStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HumanReviewStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessRequest: Request message for
// BatchProcessDocuments.
type GoogleCloudDocumentaiV1BatchProcessRequest struct {
	// DocumentOutputConfig: The output configuration for the BatchProcessDocuments
	// method.
	DocumentOutputConfig *GoogleCloudDocumentaiV1DocumentOutputConfig `json:"documentOutputConfig,omitempty"`
	// InputDocuments: The input documents for the BatchProcessDocuments method.
	InputDocuments *GoogleCloudDocumentaiV1BatchDocumentsInputConfig `json:"inputDocuments,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request.
	// Label keys and values can be no longer than 63 characters (Unicode
	// codepoints) and can only contain lowercase letters, numeric characters,
	// underscores, and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter.
	Labels map[string]string `json:"labels,omitempty"`
	// ProcessOptions: Inference-time options for the process API
	ProcessOptions *GoogleCloudDocumentaiV1ProcessOptions `json:"processOptions,omitempty"`
	// SkipHumanReview: Whether human review should be skipped for this request.
	// Default to `false`.
	SkipHumanReview bool `json:"skipHumanReview,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentOutputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentOutputConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1BatchProcessRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BatchProcessRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessResponse: Response message for
// BatchProcessDocuments.
type GoogleCloudDocumentaiV1BatchProcessResponse struct {
}

// GoogleCloudDocumentaiV1BoundingPoly: A bounding polygon for the detected
// image annotation.
type GoogleCloudDocumentaiV1BoundingPoly struct {
	// NormalizedVertices: The bounding polygon normalized vertices.
	NormalizedVertices []*GoogleCloudDocumentaiV1NormalizedVertex `json:"normalizedVertices,omitempty"`
	// Vertices: The bounding polygon vertices.
	Vertices []*GoogleCloudDocumentaiV1Vertex `json:"vertices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedVertices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedVertices") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1BoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BoundingPoly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1CommonOperationMetadata: The common metadata for long
// running operations.
type GoogleCloudDocumentaiV1CommonOperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// Resource: A related resource to this operation.
	Resource string `json:"resource,omitempty"`
	// State: The state of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1CommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1CommonOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeleteProcessorMetadata: The long-running operation
// metadata for the DeleteProcessor method.
type GoogleCloudDocumentaiV1DeleteProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DeleteProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DeleteProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata: The long-running
// operation metadata for the DeleteProcessorVersion method.
type GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeployProcessorVersionMetadata: The long-running
// operation metadata for the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1DeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeployProcessorVersionRequest: Request message for
// the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1DeployProcessorVersionRequest struct {
}

// GoogleCloudDocumentaiV1DeployProcessorVersionResponse: Response message for
// the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1DeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1DisableProcessorMetadata: The long-running operation
// metadata for the DisableProcessor method.
type GoogleCloudDocumentaiV1DisableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DisableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DisableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DisableProcessorRequest: Request message for the
// DisableProcessor method.
type GoogleCloudDocumentaiV1DisableProcessorRequest struct {
}

// GoogleCloudDocumentaiV1DisableProcessorResponse: Response message for the
// DisableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiV1DisableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1Document: Document represents the canonical document
// resource in Document AI. It is an interchange format that provides insights
// into documents and allows for collaboration between users and Document AI to
// iterate and optimize for quality.
type GoogleCloudDocumentaiV1Document struct {
	// ChunkedDocument: Document chunked based on chunking config.
	ChunkedDocument *GoogleCloudDocumentaiV1DocumentChunkedDocument `json:"chunkedDocument,omitempty"`
	// Content: Optional. Inline document content, represented as a stream of
	// bytes. Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content string `json:"content,omitempty"`
	// Docid: Optional. An internal identifier for document. Should be loggable (no
	// PII).
	Docid string `json:"docid,omitempty"`
	// DocumentLayout: Parsed layout of the document.
	DocumentLayout *GoogleCloudDocumentaiV1DocumentDocumentLayout `json:"documentLayout,omitempty"`
	// Entities: A list of entities detected on Document.text. For document shards,
	// entities in this list may cross shard boundaries.
	Entities []*GoogleCloudDocumentaiV1DocumentEntity `json:"entities,omitempty"`
	// EntityRelations: Placeholder. Relationship among Document.entities.
	EntityRelations []*GoogleCloudDocumentaiV1DocumentEntityRelation `json:"entityRelations,omitempty"`
	// Error: Any error that occurred while processing this document.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// MimeType: An IANA published media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml).
	MimeType string `json:"mimeType,omitempty"`
	// Pages: Visual page layout for the Document.
	Pages []*GoogleCloudDocumentaiV1DocumentPage `json:"pages,omitempty"`
	// Revisions: Placeholder. Revision history of this document.
	Revisions []*GoogleCloudDocumentaiV1DocumentRevision `json:"revisions,omitempty"`
	// ShardInfo: Information about the sharding if this document is sharded part
	// of a larger document. If the document is not sharded, this message is not
	// specified.
	ShardInfo *GoogleCloudDocumentaiV1DocumentShardInfo `json:"shardInfo,omitempty"`
	// Text: Optional. UTF-8 encoded text in reading order from the document.
	Text string `json:"text,omitempty"`
	// TextChanges: Placeholder. A list of text corrections made to Document.text.
	// This is usually used for annotating corrections to OCR mistakes. Text
	// changes for a given revision may not overlap with each other.
	TextChanges []*GoogleCloudDocumentaiV1DocumentTextChange `json:"textChanges,omitempty"`
	// TextStyles: Styles for the Document.text.
	TextStyles []*GoogleCloudDocumentaiV1DocumentStyle `json:"textStyles,omitempty"`
	// Uri: Optional. Currently supports Google Cloud Storage URI of the form
	// `gs://bucket_name/object_name`. Object versioning is not supported. For more
	// information, refer to Google Cloud Storage Request URIs
	// (https://cloud.google.com/storage/docs/reference-uris).
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkedDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkedDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentChunkedDocument: Represents the chunks that
// the document is divided into.
type GoogleCloudDocumentaiV1DocumentChunkedDocument struct {
	// Chunks: List of chunks.
	Chunks []*GoogleCloudDocumentaiV1DocumentChunkedDocumentChunk `json:"chunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentChunkedDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentChunkedDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentChunkedDocumentChunk: Represents a chunk.
type GoogleCloudDocumentaiV1DocumentChunkedDocumentChunk struct {
	// ChunkId: ID of the chunk.
	ChunkId string `json:"chunkId,omitempty"`
	// Content: Text content of the chunk.
	Content string `json:"content,omitempty"`
	// PageFooters: Page footers associated with the chunk.
	PageFooters []*GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageFooter `json:"pageFooters,omitempty"`
	// PageHeaders: Page headers associated with the chunk.
	PageHeaders []*GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageHeader `json:"pageHeaders,omitempty"`
	// PageSpan: Page span of the chunk.
	PageSpan *GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageSpan `json:"pageSpan,omitempty"`
	// SourceBlockIds: Unused.
	SourceBlockIds []string `json:"sourceBlockIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentChunkedDocumentChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentChunkedDocumentChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageFooter:
// Represents the page footer associated with the chunk.
type GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageFooter struct {
	// PageSpan: Page span of the footer.
	PageSpan *GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageSpan `json:"pageSpan,omitempty"`
	// Text: Footer in text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSpan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageFooter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageFooter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageHeader:
// Represents the page header associated with the chunk.
type GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageHeader struct {
	// PageSpan: Page span of the header.
	PageSpan *GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageSpan `json:"pageSpan,omitempty"`
	// Text: Header in text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSpan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageSpan: Represents
// where the chunk starts and ends in the document.
type GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageSpan struct {
	// PageEnd: Page where chunk ends in the document.
	PageEnd int64 `json:"pageEnd,omitempty"`
	// PageStart: Page where chunk starts in the document.
	PageStart int64 `json:"pageStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentChunkedDocumentChunkChunkPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentDocumentLayout: Represents the parsed layout
// of a document as a collection of blocks that the document is divided into.
type GoogleCloudDocumentaiV1DocumentDocumentLayout struct {
	// Blocks: List of blocks in the document.
	Blocks []*GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentDocumentLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentDocumentLayout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlock: Represents
// a block. A block could be one of the various types (text, table, list)
// supported.
type GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlock struct {
	// BlockId: ID of the block.
	BlockId string `json:"blockId,omitempty"`
	// BoundingBox: Identifies the bounding box for the block.
	BoundingBox *GoogleCloudDocumentaiV1BoundingPoly `json:"boundingBox,omitempty"`
	// ListBlock: Block consisting of list content/structure.
	ListBlock *GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock `json:"listBlock,omitempty"`
	// PageSpan: Page span of the block.
	PageSpan *GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan `json:"pageSpan,omitempty"`
	// TableBlock: Block consisting of table content/structure.
	TableBlock *GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock `json:"tableBlock,omitempty"`
	// TextBlock: Block consisting of text content.
	TextBlock *GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock `json:"textBlock,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlo
// ck: Represents a list type block.
type GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock struct {
	// ListEntries: List entries that constitute a list block.
	ListEntries []*GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry `json:"listEntries,omitempty"`
	// Type: Type of the list_entries (if exist). Available options are `ordered`
	// and `unordered`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ListEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ListEntries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListEnt
// ry: Represents an entry in the list.
type GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry struct {
	// Blocks: A list entry is a list of blocks. Repeated blocks support further
	// hierarchies and nested blocks.
	Blocks []*GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpa
// n: Represents where the block starts and ends in the document.
type GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan struct {
	// PageEnd: Page where block ends in the document.
	PageEnd int64 `json:"pageEnd,omitempty"`
	// PageStart: Page where block starts in the document.
	PageStart int64 `json:"pageStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBl
// ock: Represents a table type block.
type GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock struct {
	// BodyRows: Body rows containing main table content.
	BodyRows []*GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow `json:"bodyRows,omitempty"`
	// Caption: Table caption/title.
	Caption string `json:"caption,omitempty"`
	// HeaderRows: Header rows at the top of the table.
	HeaderRows []*GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow `json:"headerRows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BodyRows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCe
// ll: Represents a cell in a table row.
type GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell struct {
	// Blocks: A table cell is a list of blocks. Repeated blocks support further
	// hierarchies and nested blocks.
	Blocks []*GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`
	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRo
// w: Represents a row in a table.
type GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow struct {
	// Cells: A table row is a list of table cells.
	Cells []*GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell `json:"cells,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlo
// ck: Represents a text type block.
type GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock struct {
	// Blocks: A text block could further have child blocks. Repeated blocks
	// support further hierarchies and nested blocks.
	Blocks []*GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// Text: Text content stored in the block.
	Text string `json:"text,omitempty"`
	// Type: Type of the text in the block. Available options are: `paragraph`,
	// `subtitle`, `heading-1`, `heading-2`, `heading-3`, `heading-4`, `heading-5`,
	// `header`, `footer`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentEntity: An entity that could be a phrase in
// the text or a property that belongs to the document. It is a known entity
// type, such as a person, an organization, or location.
type GoogleCloudDocumentaiV1DocumentEntity struct {
	// Confidence: Optional. Confidence of detected Schema entity. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// Id: Optional. Canonical id. This will be a unique value in the entity list
	// for this document.
	Id string `json:"id,omitempty"`
	// MentionId: Optional. Deprecated. Use `id` field instead.
	MentionId string `json:"mentionId,omitempty"`
	// MentionText: Optional. Text value of the entity e.g. `1600 Amphitheatre
	// Pkwy`.
	MentionText string `json:"mentionText,omitempty"`
	// Method: Optional. Specifies how the entity's value is obtained.
	//
	// Possible values:
	//   "METHOD_UNSPECIFIED" - When the method is not specified, it should be
	// treated as `EXTRACT`.
	//   "EXTRACT" - The entity's value is directly extracted as-is from the
	// document text.
	//   "DERIVE" - The entity's value is derived through inference and is not
	// necessarily an exact text extraction from the document.
	Method string `json:"method,omitempty"`
	// NormalizedValue: Optional. Normalized entity value. Absent if the extracted
	// value could not be converted or the type (e.g. address) is not supported for
	// certain parsers. This field is also only populated for certain supported
	// document types.
	NormalizedValue *GoogleCloudDocumentaiV1DocumentEntityNormalizedValue `json:"normalizedValue,omitempty"`
	// PageAnchor: Optional. Represents the provenance of this entity wrt. the
	// location on the page where it was found.
	PageAnchor *GoogleCloudDocumentaiV1DocumentPageAnchor `json:"pageAnchor,omitempty"`
	// Properties: Optional. Entities can be nested to form a hierarchical data
	// structure representing the content in the document.
	Properties []*GoogleCloudDocumentaiV1DocumentEntity `json:"properties,omitempty"`
	// Provenance: Optional. The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// Redacted: Optional. Whether the entity will be redacted for
	// de-identification purposes.
	Redacted bool `json:"redacted,omitempty"`
	// TextAnchor: Optional. Provenance of the entity. Text anchor indexing into
	// the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// Type: Required. Entity type from a schema e.g. `Address`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentEntity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntity
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentEntityNormalizedValue: Parsed and normalized
// entity value.
type GoogleCloudDocumentaiV1DocumentEntityNormalizedValue struct {
	// AddressValue: Postal address. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
	AddressValue *GoogleTypePostalAddress `json:"addressValue,omitempty"`
	// BooleanValue: Boolean value. Can be used for entities with binary values, or
	// for checkboxes.
	BooleanValue bool `json:"booleanValue,omitempty"`
	// DateValue: Date value. Includes year, month, day. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
	DateValue *GoogleTypeDate `json:"dateValue,omitempty"`
	// DatetimeValue: DateTime value. Includes date, time, and timezone. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
	DatetimeValue *GoogleTypeDateTime `json:"datetimeValue,omitempty"`
	// FloatValue: Float value.
	FloatValue float64 `json:"floatValue,omitempty"`
	// IntegerValue: Integer value.
	IntegerValue int64 `json:"integerValue,omitempty"`
	// MoneyValue: Money value. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
	MoneyValue     *GoogleTypeMoney `json:"moneyValue,omitempty"`
	SignatureValue bool             `json:"signatureValue,omitempty"`
	// Text: Optional. An optional field to store a normalized string. For some
	// entity types, one of respective `structured_value` fields may also be
	// populated. Also not all the types of `structured_value` will be normalized.
	// For example, some processors may not generate `float` or `integer`
	// normalized text by default. Below are sample formats mapped to structured
	// values. - Money/Currency type (`money_value`) is in the ISO 4217 text
	// format. - Date type (`date_value`) is in the ISO 8601 text format. -
	// Datetime type (`datetime_value`) is in the ISO 8601 text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentEntityNormalizedValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntityNormalizedValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentEntityNormalizedValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntityNormalizedValue
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleCloudDocumentaiV1DocumentEntityRelation: Relationship between
// Entities.
type GoogleCloudDocumentaiV1DocumentEntityRelation struct {
	// ObjectId: Object entity id.
	ObjectId string `json:"objectId,omitempty"`
	// Relation: Relationship description.
	Relation string `json:"relation,omitempty"`
	// SubjectId: Subject entity id.
	SubjectId string `json:"subjectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentEntityRelation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntityRelation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentOutputConfig: Config that controls the output
// of documents. All documents will be written as a JSON file.
type GoogleCloudDocumentaiV1DocumentOutputConfig struct {
	// GcsOutputConfig: Output config to write the results to Cloud Storage.
	GcsOutputConfig *GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfig `json:"gcsOutputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsOutputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsOutputConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfig: The
// configuration used when outputting documents.
type GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfig struct {
	// FieldMask: Specifies which fields to include in the output documents. Only
	// supports top level document and pages field so it must be in the form of
	// `{document_field_name}` or `pages.{page_field_name}`.
	FieldMask string `json:"fieldMask,omitempty"`
	// GcsUri: The Cloud Storage uri (a directory) of the output.
	GcsUri string `json:"gcsUri,omitempty"`
	// ShardingConfig: Specifies the sharding config for the output document.
	ShardingConfig *GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfigShardingConfig `json:"shardingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldMask") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldMask") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfigShardingConfig:
// The sharding config for the output document.
type GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfigShardingConfig struct {
	// PagesOverlap: The number of overlapping pages between consecutive shards.
	PagesOverlap int64 `json:"pagesOverlap,omitempty"`
	// PagesPerShard: The number of pages per shard.
	PagesPerShard int64 `json:"pagesPerShard,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PagesOverlap") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PagesOverlap") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfigShardingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentOutputConfigGcsOutputConfigShardingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPage: A page in a Document.
type GoogleCloudDocumentaiV1DocumentPage struct {
	// Blocks: A list of visually detected text blocks on the page. A block has a
	// set of lines (collected into paragraphs) that have a common line-spacing and
	// orientation.
	Blocks []*GoogleCloudDocumentaiV1DocumentPageBlock `json:"blocks,omitempty"`
	// DetectedBarcodes: A list of detected barcodes.
	DetectedBarcodes []*GoogleCloudDocumentaiV1DocumentPageDetectedBarcode `json:"detectedBarcodes,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Dimension: Physical dimension of the page.
	Dimension *GoogleCloudDocumentaiV1DocumentPageDimension `json:"dimension,omitempty"`
	// FormFields: A list of visually detected form fields on the page.
	FormFields []*GoogleCloudDocumentaiV1DocumentPageFormField `json:"formFields,omitempty"`
	// Image: Rendered image for this page. This image is preprocessed to remove
	// any skew, rotation, and distortions such that the annotation bounding boxes
	// can be upright and axis-aligned.
	Image *GoogleCloudDocumentaiV1DocumentPageImage `json:"image,omitempty"`
	// ImageQualityScores: Image quality scores.
	ImageQualityScores *GoogleCloudDocumentaiV1DocumentPageImageQualityScores `json:"imageQualityScores,omitempty"`
	// Layout: Layout for the page.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Lines: A list of visually detected text lines on the page. A collection of
	// tokens that a human would perceive as a line.
	Lines []*GoogleCloudDocumentaiV1DocumentPageLine `json:"lines,omitempty"`
	// PageNumber: 1-based index for current Page in a parent Document. Useful when
	// a page is taken out of a Document for individual processing.
	PageNumber int64 `json:"pageNumber,omitempty"`
	// Paragraphs: A list of visually detected text paragraphs on the page. A
	// collection of lines that a human would perceive as a paragraph.
	Paragraphs []*GoogleCloudDocumentaiV1DocumentPageParagraph `json:"paragraphs,omitempty"`
	// Provenance: The history of this page.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// Symbols: A list of visually detected symbols on the page.
	Symbols []*GoogleCloudDocumentaiV1DocumentPageSymbol `json:"symbols,omitempty"`
	// Tables: A list of visually detected tables on the page.
	Tables []*GoogleCloudDocumentaiV1DocumentPageTable `json:"tables,omitempty"`
	// Tokens: A list of visually detected tokens on the page.
	Tokens []*GoogleCloudDocumentaiV1DocumentPageToken `json:"tokens,omitempty"`
	// Transforms: Transformation matrices that were applied to the original
	// document image to produce Page.image.
	Transforms []*GoogleCloudDocumentaiV1DocumentPageMatrix `json:"transforms,omitempty"`
	// VisualElements: A list of detected non-text visual elements e.g. checkbox,
	// signature etc. on the page.
	VisualElements []*GoogleCloudDocumentaiV1DocumentPageVisualElement `json:"visualElements,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageAnchor: Referencing the visual context of
// the entity in the Document.pages. Page anchors can be cross-page, consist of
// multiple bounding polygons and optionally reference specific layout element
// types.
type GoogleCloudDocumentaiV1DocumentPageAnchor struct {
	// PageRefs: One or more references to visual page elements
	PageRefs []*GoogleCloudDocumentaiV1DocumentPageAnchorPageRef `json:"pageRefs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageRefs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageRefs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageAnchor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageAnchorPageRef: Represents a weak
// reference to a page element within a document.
type GoogleCloudDocumentaiV1DocumentPageAnchorPageRef struct {
	// BoundingPoly: Optional. Identifies the bounding polygon of a layout element
	// on the page. If `layout_type` is set, the bounding polygon must be exactly
	// the same to the layout element it's referring to.
	BoundingPoly *GoogleCloudDocumentaiV1BoundingPoly `json:"boundingPoly,omitempty"`
	// Confidence: Optional. Confidence of detected page element, if applicable.
	// Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// LayoutId: Optional. Deprecated. Use PageRef.bounding_poly instead.
	LayoutId string `json:"layoutId,omitempty"`
	// LayoutType: Optional. The type of the layout element that is being
	// referenced if any.
	//
	// Possible values:
	//   "LAYOUT_TYPE_UNSPECIFIED" - Layout Unspecified.
	//   "BLOCK" - References a Page.blocks element.
	//   "PARAGRAPH" - References a Page.paragraphs element.
	//   "LINE" - References a Page.lines element.
	//   "TOKEN" - References a Page.tokens element.
	//   "VISUAL_ELEMENT" - References a Page.visual_elements element.
	//   "TABLE" - Refrrences a Page.tables element.
	//   "FORM_FIELD" - References a Page.form_fields element.
	LayoutType string `json:"layoutType,omitempty"`
	// Page: Required. Index into the Document.pages element, for example using
	// `Document.pages` to locate the related page element. This field is skipped
	// when its value is the default `0`. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	Page int64 `json:"page,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPoly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageAnchorPageRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageAnchorPageRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageAnchorPageRef) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageAnchorPageRef
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageBlock: A block has a set of lines
// (collected into paragraphs) that have a common line-spacing and orientation.
type GoogleCloudDocumentaiV1DocumentPageBlock struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Block.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageDetectedBarcode: A detected barcode.
type GoogleCloudDocumentaiV1DocumentPageDetectedBarcode struct {
	// Barcode: Detailed barcode information of the DetectedBarcode.
	Barcode *GoogleCloudDocumentaiV1Barcode `json:"barcode,omitempty"`
	// Layout: Layout for DetectedBarcode.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Barcode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Barcode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageDetectedBarcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDetectedBarcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageDetectedLanguage: Detected language for a
// structural component.
type GoogleCloudDocumentaiV1DocumentPageDetectedLanguage struct {
	// Confidence: Confidence of detected language. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// LanguageCode: The BCP-47 language code
	// (https://www.unicode.org/reports/tr35/#Unicode_locale_identifier), such as
	// `en-US` or `sr-Latn`.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageDetectedLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDetectedLanguage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageDetectedLanguage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDetectedLanguage
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageDimension: Dimension for the page.
type GoogleCloudDocumentaiV1DocumentPageDimension struct {
	// Height: Page height.
	Height float64 `json:"height,omitempty"`
	// Unit: Dimension unit.
	Unit string `json:"unit,omitempty"`
	// Width: Page width.
	Width float64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageDimension) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDimension
	var s1 struct {
		Height gensupport.JSONFloat64 `json:"height"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Height = float64(s1.Height)
	s.Width = float64(s1.Width)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageFormField: A form field detected on the
// page.
type GoogleCloudDocumentaiV1DocumentPageFormField struct {
	// CorrectedKeyText: Created for Labeling UI to export key text. If corrections
	// were made to the text identified by the `field_name.text_anchor`, this field
	// will contain the correction.
	CorrectedKeyText string `json:"correctedKeyText,omitempty"`
	// CorrectedValueText: Created for Labeling UI to export value text. If
	// corrections were made to the text identified by the
	// `field_value.text_anchor`, this field will contain the correction.
	CorrectedValueText string `json:"correctedValueText,omitempty"`
	// FieldName: Layout for the FormField name. e.g. `Address`, `Email`, `Grand
	// total`, `Phone number`, etc.
	FieldName *GoogleCloudDocumentaiV1DocumentPageLayout `json:"fieldName,omitempty"`
	// FieldValue: Layout for the FormField value.
	FieldValue *GoogleCloudDocumentaiV1DocumentPageLayout `json:"fieldValue,omitempty"`
	// NameDetectedLanguages: A list of detected languages for name together with
	// confidence.
	NameDetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"nameDetectedLanguages,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ValueDetectedLanguages: A list of detected languages for value together with
	// confidence.
	ValueDetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"valueDetectedLanguages,omitempty"`
	// ValueType: If the value is non-textual, this field represents the type.
	// Current valid values are: - blank (this indicates the `field_value` is
	// normal text) - `unfilled_checkbox` - `filled_checkbox`
	ValueType string `json:"valueType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrectedKeyText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrectedKeyText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageFormField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageFormField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageImage: Rendered image contents for this
// page.
type GoogleCloudDocumentaiV1DocumentPageImage struct {
	// Content: Raw byte content of the image.
	Content string `json:"content,omitempty"`
	// Height: Height of the image in pixels.
	Height int64 `json:"height,omitempty"`
	// MimeType: Encoding media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml) for the
	// image.
	MimeType string `json:"mimeType,omitempty"`
	// Width: Width of the image in pixels.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageImageQualityScores: Image quality scores
// for the page image.
type GoogleCloudDocumentaiV1DocumentPageImageQualityScores struct {
	// DetectedDefects: A list of detected defects.
	DetectedDefects []*GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect `json:"detectedDefects,omitempty"`
	// QualityScore: The overall quality score. Range `[0, 1]` where `1` is perfect
	// quality.
	QualityScore float64 `json:"qualityScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedDefects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedDefects") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageImageQualityScores) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImageQualityScores
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageImageQualityScores) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImageQualityScores
	var s1 struct {
		QualityScore gensupport.JSONFloat64 `json:"qualityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.QualityScore = float64(s1.QualityScore)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect: Image
// Quality Defects
type GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect struct {
	// Confidence: Confidence of detected defect. Range `[0, 1]` where `1`
	// indicates strong confidence that the defect exists.
	Confidence float64 `json:"confidence,omitempty"`
	// Type: Name of the defect type. Supported values are: -
	// `quality/defect_blurry` - `quality/defect_noisy` - `quality/defect_dark` -
	// `quality/defect_faint` - `quality/defect_text_too_small` -
	// `quality/defect_document_cutoff` - `quality/defect_text_cutoff` -
	// `quality/defect_glare`
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageLayout: Visual element describing a
// layout unit on a page.
type GoogleCloudDocumentaiV1DocumentPageLayout struct {
	// BoundingPoly: The bounding polygon for the Layout.
	BoundingPoly *GoogleCloudDocumentaiV1BoundingPoly `json:"boundingPoly,omitempty"`
	// Confidence: Confidence of the current Layout within context of the object
	// this layout is for. e.g. confidence can be for a single token, a table, a
	// visual element, etc. depending on context. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// Orientation: Detected orientation for the Layout.
	//
	// Possible values:
	//   "ORIENTATION_UNSPECIFIED" - Unspecified orientation.
	//   "PAGE_UP" - Orientation is aligned with page up.
	//   "PAGE_RIGHT" - Orientation is aligned with page right. Turn the head 90
	// degrees clockwise from upright to read.
	//   "PAGE_DOWN" - Orientation is aligned with page down. Turn the head 180
	// degrees from upright to read.
	//   "PAGE_LEFT" - Orientation is aligned with page left. Turn the head 90
	// degrees counterclockwise from upright to read.
	Orientation string `json:"orientation,omitempty"`
	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPoly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageLayout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageLayout) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageLayout
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageLine: A collection of tokens that a human
// would perceive as a line. Does not cross column boundaries, can be
// horizontal, vertical, etc.
type GoogleCloudDocumentaiV1DocumentPageLine struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Line.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageLine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageLine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageMatrix: Representation for transformation
// matrix, intended to be compatible and used with OpenCV format for image
// manipulation.
type GoogleCloudDocumentaiV1DocumentPageMatrix struct {
	// Cols: Number of columns in the matrix.
	Cols int64 `json:"cols,omitempty"`
	// Data: The matrix data.
	Data string `json:"data,omitempty"`
	// Rows: Number of rows in the matrix.
	Rows int64 `json:"rows,omitempty"`
	// Type: This encodes information about what data type the matrix uses. For
	// example, 0 (CV_8U) is an unsigned 8-bit image. For the full list of OpenCV
	// primitive data types, please refer to
	// https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
	Type int64 `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cols") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cols") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageMatrix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageParagraph: A collection of lines that a
// human would perceive as a paragraph.
type GoogleCloudDocumentaiV1DocumentPageParagraph struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Paragraph.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageParagraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageParagraph
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageSymbol: A detected symbol.
type GoogleCloudDocumentaiV1DocumentPageSymbol struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Symbol.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageSymbol) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageSymbol
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTable: A table representation similar to
// HTML table structure.
type GoogleCloudDocumentaiV1DocumentPageTable struct {
	// BodyRows: Body rows of the table.
	BodyRows []*GoogleCloudDocumentaiV1DocumentPageTableTableRow `json:"bodyRows,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// HeaderRows: Header rows of the table.
	HeaderRows []*GoogleCloudDocumentaiV1DocumentPageTableTableRow `json:"headerRows,omitempty"`
	// Layout: Layout for Table.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this table.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BodyRows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTableTableCell: A cell representation
// inside the table.
type GoogleCloudDocumentaiV1DocumentPageTableTableCell struct {
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for TableCell.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColSpan") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTableTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTableTableCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTableTableRow: A row of table cells.
type GoogleCloudDocumentaiV1DocumentPageTableTableRow struct {
	// Cells: Cells that make up this row.
	Cells []*GoogleCloudDocumentaiV1DocumentPageTableTableCell `json:"cells,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTableTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTableTableRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageToken: A detected token.
type GoogleCloudDocumentaiV1DocumentPageToken struct {
	// DetectedBreak: Detected break at the end of a Token.
	DetectedBreak *GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak `json:"detectedBreak,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Token.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// StyleInfo: Text style attributes.
	StyleInfo *GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo `json:"styleInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedBreak") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedBreak") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak: Detected break at the
// end of a Token.
type GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak struct {
	// Type: Detected break type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified break type.
	//   "SPACE" - A single whitespace.
	//   "WIDE_SPACE" - A wider whitespace.
	//   "HYPHEN" - A hyphen that indicates that a token has been split across
	// lines.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo: Font and other text style
// attributes.
type GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo struct {
	// BackgroundColor: Color of the background.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`
	// Bold: Whether the text is bold (equivalent to font_weight is at least
	// `700`).
	Bold bool `json:"bold,omitempty"`
	// FontSize: Font size in points (`1` point is `¹⁄₇₂` inches).
	FontSize int64 `json:"fontSize,omitempty"`
	// FontType: Name or style of the font.
	FontType string `json:"fontType,omitempty"`
	// FontWeight: TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
	// Normal is `400`, bold is `700`.
	FontWeight int64 `json:"fontWeight,omitempty"`
	// Handwritten: Whether the text is handwritten.
	Handwritten bool `json:"handwritten,omitempty"`
	// Italic: Whether the text is italic.
	Italic bool `json:"italic,omitempty"`
	// LetterSpacing: Letter spacing in points.
	LetterSpacing float64 `json:"letterSpacing,omitempty"`
	// PixelFontSize: Font size in pixels, equal to _unrounded font_size_ *
	// _resolution_ ÷ `72.0`.
	PixelFontSize float64 `json:"pixelFontSize,omitempty"`
	// Smallcaps: Whether the text is in small caps. This feature is not supported
	// yet.
	Smallcaps bool `json:"smallcaps,omitempty"`
	// Strikeout: Whether the text is strikethrough. This feature is not supported
	// yet.
	Strikeout bool `json:"strikeout,omitempty"`
	// Subscript: Whether the text is a subscript. This feature is not supported
	// yet.
	Subscript bool `json:"subscript,omitempty"`
	// Superscript: Whether the text is a superscript. This feature is not
	// supported yet.
	Superscript bool `json:"superscript,omitempty"`
	// TextColor: Color of the text.
	TextColor *GoogleTypeColor `json:"textColor,omitempty"`
	// Underlined: Whether the text is underlined.
	Underlined bool `json:"underlined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackgroundColor") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo
	var s1 struct {
		LetterSpacing gensupport.JSONFloat64 `json:"letterSpacing"`
		PixelFontSize gensupport.JSONFloat64 `json:"pixelFontSize"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LetterSpacing = float64(s1.LetterSpacing)
	s.PixelFontSize = float64(s1.PixelFontSize)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageVisualElement: Detected non-text visual
// elements e.g. checkbox, signature etc. on the page.
type GoogleCloudDocumentaiV1DocumentPageVisualElement struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for VisualElement.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Type: Type of the VisualElement.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageVisualElement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageVisualElement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentProvenance: Structure to identify provenance
// relationships between annotations in different revisions.
type GoogleCloudDocumentaiV1DocumentProvenance struct {
	// Id: The Id of this operation. Needs to be unique within the scope of the
	// revision.
	Id int64 `json:"id,omitempty"`
	// Parents: References to the original elements that are replaced.
	Parents []*GoogleCloudDocumentaiV1DocumentProvenanceParent `json:"parents,omitempty"`
	// Revision: The index of the revision that produced this element.
	Revision int64 `json:"revision,omitempty"`
	// Type: The type of provenance operation.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Operation type unspecified. If no operation
	// is specified a provenance entry is simply used to match against a `parent`.
	//   "ADD" - Add an element.
	//   "REMOVE" - Remove an element identified by `parent`.
	//   "UPDATE" - Updates any fields within the given provenance scope of the
	// message. It overwrites the fields rather than replacing them. Use this when
	// you want to update a field value of an entity without also updating all the
	// child properties.
	//   "REPLACE" - Currently unused. Replace an element identified by `parent`.
	//   "EVAL_REQUESTED" - Deprecated. Request human review for the element
	// identified by `parent`.
	//   "EVAL_APPROVED" - Deprecated. Element is reviewed and approved at human
	// review, confidence will be set to 1.0.
	//   "EVAL_SKIPPED" - Deprecated. Element is skipped in the validation process.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentProvenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentProvenanceParent: The parent element the
// current element is based on. Used for referencing/aligning, removal and
// replacement operations.
type GoogleCloudDocumentaiV1DocumentProvenanceParent struct {
	// Id: The id of the parent provenance.
	Id int64 `json:"id,omitempty"`
	// Index: The index of the parent item in the corresponding item list (eg. list
	// of entities, properties within entities, etc.) in the parent revision.
	Index int64 `json:"index,omitempty"`
	// Revision: The index of the index into current revision's parent_ids list.
	Revision int64 `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentProvenanceParent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentProvenanceParent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentRevision: Contains past or forward revisions
// of this document.
type GoogleCloudDocumentaiV1DocumentRevision struct {
	// Agent: If the change was made by a person specify the name or id of that
	// person.
	Agent string `json:"agent,omitempty"`
	// CreateTime: The time that the revision was created, internally generated by
	// doc proto storage at the time of create.
	CreateTime string `json:"createTime,omitempty"`
	// HumanReview: Human Review information of this revision.
	HumanReview *GoogleCloudDocumentaiV1DocumentRevisionHumanReview `json:"humanReview,omitempty"`
	// Id: Id of the revision, internally generated by doc proto storage. Unique
	// within the context of the document.
	Id string `json:"id,omitempty"`
	// Parent: The revisions that this revision is based on. This can include one
	// or more parent (when documents are merged.) This field represents the index
	// into the `revisions` field.
	Parent []int64 `json:"parent,omitempty"`
	// ParentIds: The revisions that this revision is based on. Must include all
	// the ids that have anything to do with this revision - eg. there are
	// `provenance.parent.revision` fields that index into this field.
	ParentIds []string `json:"parentIds,omitempty"`
	// Processor: If the annotation was made by processor identify the processor by
	// its resource name.
	Processor string `json:"processor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentRevision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentRevisionHumanReview: Human Review information
// of the document.
type GoogleCloudDocumentaiV1DocumentRevisionHumanReview struct {
	// State: Human review state. e.g. `requested`, `succeeded`, `rejected`.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the rejection reason when the state is `rejected`.
	StateMessage string `json:"stateMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentRevisionHumanReview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentRevisionHumanReview
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentSchema: The schema defines the output of the
// processed document by a processor.
type GoogleCloudDocumentaiV1DocumentSchema struct {
	// Description: Description of the schema.
	Description string `json:"description,omitempty"`
	// DisplayName: Display name to show to users.
	DisplayName string `json:"displayName,omitempty"`
	// EntityTypes: Entity types of the schema.
	EntityTypes []*GoogleCloudDocumentaiV1DocumentSchemaEntityType `json:"entityTypes,omitempty"`
	// Metadata: Metadata of the schema.
	Metadata *GoogleCloudDocumentaiV1DocumentSchemaMetadata `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentSchemaEntityType: EntityType is the wrapper
// of a label of the corresponding model with detailed attributes and
// limitations for entity-based processors. Multiple types can also compose a
// dependency tree to represent nested types.
type GoogleCloudDocumentaiV1DocumentSchemaEntityType struct {
	// BaseTypes: The entity type that this type is derived from. For now, one and
	// only one should be set.
	BaseTypes []string `json:"baseTypes,omitempty"`
	// DisplayName: User defined name for the type.
	DisplayName string `json:"displayName,omitempty"`
	// EnumValues: If specified, lists all the possible values for this entity.
	// This should not be more than a handful of values. If the number of values is
	// >10 or could change frequently use the `EntityType.value_ontology` field and
	// specify a list of all possible values in a value ontology file.
	EnumValues *GoogleCloudDocumentaiV1DocumentSchemaEntityTypeEnumValues `json:"enumValues,omitempty"`
	// Name: Name of the type. It must be unique within the schema file and cannot
	// be a "Common Type". The following naming conventions are used: - Use
	// `snake_casing`. - Name matching is case-sensitive. - Maximum 64 characters.
	// - Must start with a letter. - Allowed characters: ASCII letters
	// `[a-z0-9_-]`. (For backward compatibility internal infrastructure and
	// tooling can handle any ascii character.) - The `/` is sometimes used to
	// denote a property of a type. For example `line_item/amount`. This convention
	// is deprecated, but will still be honored for backward compatibility.
	Name string `json:"name,omitempty"`
	// Properties: Description the nested structure, or composition of an entity.
	Properties []*GoogleCloudDocumentaiV1DocumentSchemaEntityTypeProperty `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentSchemaEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentSchemaEntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentSchemaEntityTypeEnumValues: Defines the a
// list of enum values.
type GoogleCloudDocumentaiV1DocumentSchemaEntityTypeEnumValues struct {
	// Values: The individual values that this enum values type can include.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentSchemaEntityTypeEnumValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentSchemaEntityTypeEnumValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentSchemaEntityTypeProperty: Defines properties
// that can be part of the entity type.
type GoogleCloudDocumentaiV1DocumentSchemaEntityTypeProperty struct {
	// DisplayName: User defined name for the property.
	DisplayName string `json:"displayName,omitempty"`
	// Method: Specifies how the entity's value is obtained.
	//
	// Possible values:
	//   "METHOD_UNSPECIFIED" - Unspecified method. It defaults to `EXTRACT`.
	//   "EXTRACT" - The entity's value is directly extracted as-is from the
	// document text.
	//   "DERIVE" - The entity's value is derived through inference and is not
	// necessarily an exact text extraction from the document.
	Method string `json:"method,omitempty"`
	// Name: The name of the property. Follows the same guidelines as the
	// EntityType name.
	Name string `json:"name,omitempty"`
	// OccurrenceType: Occurrence type limits the number of instances an entity
	// type appears in the document.
	//
	// Possible values:
	//   "OCCURRENCE_TYPE_UNSPECIFIED" - Unspecified occurrence type.
	//   "OPTIONAL_ONCE" - There will be zero or one instance of this entity type.
	// The same entity instance may be mentioned multiple times.
	//   "OPTIONAL_MULTIPLE" - The entity type will appear zero or multiple times.
	//   "REQUIRED_ONCE" - The entity type will only appear exactly once. The same
	// entity instance may be mentioned multiple times.
	//   "REQUIRED_MULTIPLE" - The entity type will appear once or more times.
	OccurrenceType string `json:"occurrenceType,omitempty"`
	// ValueType: A reference to the value type of the property. This type is
	// subject to the same conventions as the `Entity.base_types` field.
	ValueType string `json:"valueType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentSchemaEntityTypeProperty) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentSchemaEntityTypeProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentSchemaMetadata: Metadata for global schema
// behavior.
type GoogleCloudDocumentaiV1DocumentSchemaMetadata struct {
	// DocumentAllowMultipleLabels: If true, on a given page, there can be multiple
	// `document` annotations covering it.
	DocumentAllowMultipleLabels bool `json:"documentAllowMultipleLabels,omitempty"`
	// DocumentSplitter: If true, a `document` entity type can be applied to
	// subdocument (splitting). Otherwise, it can only be applied to the entire
	// document (classification).
	DocumentSplitter bool `json:"documentSplitter,omitempty"`
	// PrefixedNamingOnProperties: If set, all the nested entities must be prefixed
	// with the parents.
	PrefixedNamingOnProperties bool `json:"prefixedNamingOnProperties,omitempty"`
	// SkipNamingValidation: If set, we will skip the naming format validation in
	// the schema. So the string values in `DocumentSchema.EntityType.name` and
	// `DocumentSchema.EntityType.Property.name` will not be checked.
	SkipNamingValidation bool `json:"skipNamingValidation,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DocumentAllowMultipleLabels") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentAllowMultipleLabels") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentShardInfo: For a large document, sharding may
// be performed to produce several document shards. Each document shard
// contains this field to detail which shard it is.
type GoogleCloudDocumentaiV1DocumentShardInfo struct {
	// ShardCount: Total number of shards.
	ShardCount int64 `json:"shardCount,omitempty,string"`
	// ShardIndex: The 0-based index of this shard.
	ShardIndex int64 `json:"shardIndex,omitempty,string"`
	// TextOffset: The index of the first character in Document.text in the overall
	// document global text.
	TextOffset int64 `json:"textOffset,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ShardCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShardCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentShardInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentShardInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentStyle: Annotation for common text style
// attributes. This adheres to CSS conventions as much as possible.
type GoogleCloudDocumentaiV1DocumentStyle struct {
	// BackgroundColor: Text background color.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`
	// Color: Text color.
	Color *GoogleTypeColor `json:"color,omitempty"`
	// FontFamily: Font family such as `Arial`, `Times New Roman`.
	// https://www.w3schools.com/cssref/pr_font_font-family.asp
	FontFamily string `json:"fontFamily,omitempty"`
	// FontSize: Font size.
	FontSize *GoogleCloudDocumentaiV1DocumentStyleFontSize `json:"fontSize,omitempty"`
	// FontWeight: Font weight
	// (https://www.w3schools.com/cssref/pr_font_weight.asp). Possible values are
	// `normal`, `bold`, `bolder`, and `lighter`.
	FontWeight string `json:"fontWeight,omitempty"`
	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// TextDecoration: Text decoration
	// (https://www.w3schools.com/cssref/pr_text_text-decoration.asp). Follows CSS
	// standard.
	TextDecoration string `json:"textDecoration,omitempty"`
	// TextStyle: Text style
	// (https://www.w3schools.com/cssref/pr_font_font-style.asp). Possible values
	// are `normal`, `italic`, and `oblique`.
	TextStyle string `json:"textStyle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackgroundColor") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentStyle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentStyle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentStyleFontSize: Font size with unit.
type GoogleCloudDocumentaiV1DocumentStyleFontSize struct {
	// Size: Font size for the text.
	Size float64 `json:"size,omitempty"`
	// Unit: Unit for the font size. Follows CSS naming (such as `in`, `px`, and
	// `pt`).
	Unit string `json:"unit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Size") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Size") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentStyleFontSize) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentStyleFontSize
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentStyleFontSize) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentStyleFontSize
	var s1 struct {
		Size gensupport.JSONFloat64 `json:"size"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Size = float64(s1.Size)
	return nil
}

// GoogleCloudDocumentaiV1DocumentTextAnchor: Text reference indexing into the
// Document.text.
type GoogleCloudDocumentaiV1DocumentTextAnchor struct {
	// Content: Contains the content of the text span so that users do not have to
	// look it up in the text_segments. It is always populated for formFields.
	Content string `json:"content,omitempty"`
	// TextSegments: The text segments from the Document.text.
	TextSegments []*GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment `json:"textSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentTextAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentTextAnchor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment: A text segment in the
// Document.text. The indices may be out of bounds which indicate that the text
// extends into another document shard for large sharded documents. See
// ShardInfo.text_offset
type GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment struct {
	// EndIndex: TextSegment half open end UTF-8 char index in the Document.text.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// StartIndex: TextSegment start UTF-8 char index in the Document.text.
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentTextChange: This message is used for text
// changes aka. OCR corrections.
type GoogleCloudDocumentaiV1DocumentTextChange struct {
	// ChangedText: The text that replaces the text identified in the
	// `text_anchor`.
	ChangedText string `json:"changedText,omitempty"`
	// Provenance: The history of this annotation.
	Provenance []*GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// TextAnchor: Provenance of the correction. Text anchor indexing into the
	// Document.text. There can only be a single `TextAnchor.text_segments`
	// element. If the start and end index of the text segment are the same, the
	// text change is inserted before that index.
	TextAnchor *GoogleCloudDocumentaiV1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChangedText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangedText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentTextChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentTextChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EnableProcessorMetadata: The long-running operation
// metadata for the EnableProcessor method.
type GoogleCloudDocumentaiV1EnableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EnableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EnableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EnableProcessorRequest: Request message for the
// EnableProcessor method.
type GoogleCloudDocumentaiV1EnableProcessorRequest struct {
}

// GoogleCloudDocumentaiV1EnableProcessorResponse: Response message for the
// EnableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiV1EnableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata: Metadata of the
// EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EvaluateProcessorVersionRequest: Evaluates the given
// ProcessorVersion against the supplied documents.
type GoogleCloudDocumentaiV1EvaluateProcessorVersionRequest struct {
	// EvaluationDocuments: Optional. The documents used in the evaluation. If
	// unspecified, use the processor's dataset as evaluation input.
	EvaluationDocuments *GoogleCloudDocumentaiV1BatchDocumentsInputConfig `json:"evaluationDocuments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluationDocuments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationDocuments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluateProcessorVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluateProcessorVersionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse: Response of the
// EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse struct {
	// Evaluation: The resource name of the created evaluation.
	Evaluation string `json:"evaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1Evaluation: An evaluation of a ProcessorVersion's
// performance.
type GoogleCloudDocumentaiV1Evaluation struct {
	// AllEntitiesMetrics: Metrics for all the entities in aggregate.
	AllEntitiesMetrics *GoogleCloudDocumentaiV1EvaluationMultiConfidenceMetrics `json:"allEntitiesMetrics,omitempty"`
	// CreateTime: The time that the evaluation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DocumentCounters: Counters for the documents used in the evaluation.
	DocumentCounters *GoogleCloudDocumentaiV1EvaluationCounters `json:"documentCounters,omitempty"`
	// EntityMetrics: Metrics across confidence levels, for different entities.
	EntityMetrics map[string]GoogleCloudDocumentaiV1EvaluationMultiConfidenceMetrics `json:"entityMetrics,omitempty"`
	// KmsKeyName: The KMS key name used for encryption.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// KmsKeyVersionName: The KMS key version with which data is encrypted.
	KmsKeyVersionName string `json:"kmsKeyVersionName,omitempty"`
	// Name: The resource name of the evaluation. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/processorVers
	// ions/{processor_version}/evaluations/{evaluation}`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllEntitiesMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllEntitiesMetrics") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1Evaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1Evaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EvaluationConfidenceLevelMetrics: Evaluations
// metrics, at a specific confidence level.
type GoogleCloudDocumentaiV1EvaluationConfidenceLevelMetrics struct {
	// ConfidenceLevel: The confidence level.
	ConfidenceLevel float64 `json:"confidenceLevel,omitempty"`
	// Metrics: The metrics at the specific confidence level.
	Metrics *GoogleCloudDocumentaiV1EvaluationMetrics `json:"metrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceLevel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluationConfidenceLevelMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluationConfidenceLevelMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1EvaluationConfidenceLevelMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1EvaluationConfidenceLevelMetrics
	var s1 struct {
		ConfidenceLevel gensupport.JSONFloat64 `json:"confidenceLevel"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceLevel = float64(s1.ConfidenceLevel)
	return nil
}

// GoogleCloudDocumentaiV1EvaluationCounters: Evaluation counters for the
// documents that were used.
type GoogleCloudDocumentaiV1EvaluationCounters struct {
	// EvaluatedDocumentsCount: How many documents were used in the evaluation.
	EvaluatedDocumentsCount int64 `json:"evaluatedDocumentsCount,omitempty"`
	// FailedDocumentsCount: How many documents were not included in the evaluation
	// as Document AI failed to process them.
	FailedDocumentsCount int64 `json:"failedDocumentsCount,omitempty"`
	// InputDocumentsCount: How many documents were sent for evaluation.
	InputDocumentsCount int64 `json:"inputDocumentsCount,omitempty"`
	// InvalidDocumentsCount: How many documents were not included in the
	// evaluation as they didn't pass validation.
	InvalidDocumentsCount int64 `json:"invalidDocumentsCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluatedDocumentsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluatedDocumentsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluationCounters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluationCounters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EvaluationMetrics: Evaluation metrics, either in
// aggregate or about a specific entity.
type GoogleCloudDocumentaiV1EvaluationMetrics struct {
	// F1Score: The calculated f1 score.
	F1Score float64 `json:"f1Score,omitempty"`
	// FalseNegativesCount: The amount of false negatives.
	FalseNegativesCount int64 `json:"falseNegativesCount,omitempty"`
	// FalsePositivesCount: The amount of false positives.
	FalsePositivesCount int64 `json:"falsePositivesCount,omitempty"`
	// GroundTruthDocumentCount: The amount of documents with a ground truth
	// occurrence.
	GroundTruthDocumentCount int64 `json:"groundTruthDocumentCount,omitempty"`
	// GroundTruthOccurrencesCount: The amount of occurrences in ground truth
	// documents.
	GroundTruthOccurrencesCount int64 `json:"groundTruthOccurrencesCount,omitempty"`
	// Precision: The calculated precision.
	Precision float64 `json:"precision,omitempty"`
	// PredictedDocumentCount: The amount of documents with a predicted occurrence.
	PredictedDocumentCount int64 `json:"predictedDocumentCount,omitempty"`
	// PredictedOccurrencesCount: The amount of occurrences in predicted documents.
	PredictedOccurrencesCount int64 `json:"predictedOccurrencesCount,omitempty"`
	// Recall: The calculated recall.
	Recall float64 `json:"recall,omitempty"`
	// TotalDocumentsCount: The amount of documents that had an occurrence of this
	// label.
	TotalDocumentsCount int64 `json:"totalDocumentsCount,omitempty"`
	// TruePositivesCount: The amount of true positives.
	TruePositivesCount int64 `json:"truePositivesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "F1Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "F1Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluationMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1EvaluationMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1EvaluationMetrics
	var s1 struct {
		F1Score   gensupport.JSONFloat64 `json:"f1Score"`
		Precision gensupport.JSONFloat64 `json:"precision"`
		Recall    gensupport.JSONFloat64 `json:"recall"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.F1Score = float64(s1.F1Score)
	s.Precision = float64(s1.Precision)
	s.Recall = float64(s1.Recall)
	return nil
}

// GoogleCloudDocumentaiV1EvaluationMultiConfidenceMetrics: Metrics across
// multiple confidence levels.
type GoogleCloudDocumentaiV1EvaluationMultiConfidenceMetrics struct {
	// Auprc: The calculated area under the precision recall curve (AUPRC),
	// computed by integrating over all confidence thresholds.
	Auprc float64 `json:"auprc,omitempty"`
	// AuprcExact: The AUPRC for metrics with fuzzy matching disabled, i.e., exact
	// matching only.
	AuprcExact float64 `json:"auprcExact,omitempty"`
	// ConfidenceLevelMetrics: Metrics across confidence levels with fuzzy matching
	// enabled.
	ConfidenceLevelMetrics []*GoogleCloudDocumentaiV1EvaluationConfidenceLevelMetrics `json:"confidenceLevelMetrics,omitempty"`
	// ConfidenceLevelMetricsExact: Metrics across confidence levels with only
	// exact matching.
	ConfidenceLevelMetricsExact []*GoogleCloudDocumentaiV1EvaluationConfidenceLevelMetrics `json:"confidenceLevelMetricsExact,omitempty"`
	// EstimatedCalibrationError: The Estimated Calibration Error (ECE) of the
	// confidence of the predicted entities.
	EstimatedCalibrationError float64 `json:"estimatedCalibrationError,omitempty"`
	// EstimatedCalibrationErrorExact: The ECE for the predicted entities with
	// fuzzy matching disabled, i.e., exact matching only.
	EstimatedCalibrationErrorExact float64 `json:"estimatedCalibrationErrorExact,omitempty"`
	// MetricsType: The metrics type for the label.
	//
	// Possible values:
	//   "METRICS_TYPE_UNSPECIFIED" - The metrics type is unspecified. By default,
	// metrics without a particular specification are for leaf entity types (i.e.,
	// top-level entity types without child types, or child types which are not
	// parent types themselves).
	//   "AGGREGATE" - Indicates whether metrics for this particular label type
	// represent an aggregate of metrics for other types instead of being based on
	// actual TP/FP/FN values for the label type. Metrics for parent (i.e.,
	// non-leaf) entity types are an aggregate of metrics for their children.
	MetricsType string `json:"metricsType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Auprc") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Auprc") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluationMultiConfidenceMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluationMultiConfidenceMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1EvaluationMultiConfidenceMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1EvaluationMultiConfidenceMetrics
	var s1 struct {
		Auprc                          gensupport.JSONFloat64 `json:"auprc"`
		AuprcExact                     gensupport.JSONFloat64 `json:"auprcExact"`
		EstimatedCalibrationError      gensupport.JSONFloat64 `json:"estimatedCalibrationError"`
		EstimatedCalibrationErrorExact gensupport.JSONFloat64 `json:"estimatedCalibrationErrorExact"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Auprc = float64(s1.Auprc)
	s.AuprcExact = float64(s1.AuprcExact)
	s.EstimatedCalibrationError = float64(s1.EstimatedCalibrationError)
	s.EstimatedCalibrationErrorExact = float64(s1.EstimatedCalibrationErrorExact)
	return nil
}

// GoogleCloudDocumentaiV1EvaluationReference: Gives a short summary of an
// evaluation, and links to the evaluation itself.
type GoogleCloudDocumentaiV1EvaluationReference struct {
	// AggregateMetrics: An aggregate of the statistics for the evaluation with
	// fuzzy matching on.
	AggregateMetrics *GoogleCloudDocumentaiV1EvaluationMetrics `json:"aggregateMetrics,omitempty"`
	// AggregateMetricsExact: An aggregate of the statistics for the evaluation
	// with fuzzy matching off.
	AggregateMetricsExact *GoogleCloudDocumentaiV1EvaluationMetrics `json:"aggregateMetricsExact,omitempty"`
	// Evaluation: The resource name of the evaluation.
	Evaluation string `json:"evaluation,omitempty"`
	// Operation: The resource name of the Long Running Operation for the
	// evaluation.
	Operation string `json:"operation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregateMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregateMetrics") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluationReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluationReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1FetchProcessorTypesResponse: Response message for the
// FetchProcessorTypes method.
type GoogleCloudDocumentaiV1FetchProcessorTypesResponse struct {
	// ProcessorTypes: The list of processor types.
	ProcessorTypes []*GoogleCloudDocumentaiV1ProcessorType `json:"processorTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ProcessorTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1FetchProcessorTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1FetchProcessorTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1GcsDocument: Specifies a document stored on Cloud
// Storage.
type GoogleCloudDocumentaiV1GcsDocument struct {
	// GcsUri: The Cloud Storage object uri.
	GcsUri string `json:"gcsUri,omitempty"`
	// MimeType: An IANA MIME type (RFC6838) of the content.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1GcsDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1GcsDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1GcsDocuments: Specifies a set of documents on Cloud
// Storage.
type GoogleCloudDocumentaiV1GcsDocuments struct {
	// Documents: The list of documents.
	Documents []*GoogleCloudDocumentaiV1GcsDocument `json:"documents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1GcsDocuments) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1GcsDocuments
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1GcsPrefix: Specifies all documents on Cloud Storage
// with a common prefix.
type GoogleCloudDocumentaiV1GcsPrefix struct {
	// GcsUriPrefix: The URI prefix.
	GcsUriPrefix string `json:"gcsUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUriPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1GcsPrefix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1GcsPrefix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1HumanReviewStatus: The status of human review on a
// processed document.
type GoogleCloudDocumentaiV1HumanReviewStatus struct {
	// HumanReviewOperation: The name of the operation triggered by the processed
	// document. This field is populated only when the state is
	// `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and metadata as
	// the long-running operation returned by ReviewDocument.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`
	// State: The state of human review on the processing request.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Human review state is unspecified. Most likely due
	// to an internal error.
	//   "SKIPPED" - Human review is skipped for the document. This can happen
	// because human review isn't enabled on the processor or the processing
	// request has been set to skip this document.
	//   "VALIDATION_PASSED" - Human review validation is triggered and passed, so
	// no review is needed.
	//   "IN_PROGRESS" - Human review validation is triggered and the document is
	// under review.
	//   "ERROR" - Some error happened during triggering human review, see the
	// state_message for details.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the human review state.
	StateMessage string `json:"stateMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HumanReviewOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HumanReviewOperation") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1HumanReviewStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1HumanReviewStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ListEvaluationsResponse: The response from
// `ListEvaluations`.
type GoogleCloudDocumentaiV1ListEvaluationsResponse struct {
	// Evaluations: The evaluations requested.
	Evaluations []*GoogleCloudDocumentaiV1Evaluation `json:"evaluations,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Evaluations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ListEvaluationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ListEvaluationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ListProcessorTypesResponse: Response message for the
// ListProcessorTypes method.
type GoogleCloudDocumentaiV1ListProcessorTypesResponse struct {
	// NextPageToken: Points to the next page, otherwise empty.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ProcessorTypes: The processor types.
	ProcessorTypes []*GoogleCloudDocumentaiV1ProcessorType `json:"processorTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ListProcessorTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ListProcessorTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ListProcessorVersionsResponse: Response message for
// the ListProcessorVersions method.
type GoogleCloudDocumentaiV1ListProcessorVersionsResponse struct {
	// NextPageToken: Points to the next processor, otherwise empty.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ProcessorVersions: The list of processors.
	ProcessorVersions []*GoogleCloudDocumentaiV1ProcessorVersion `json:"processorVersions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ListProcessorVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ListProcessorVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ListProcessorsResponse: Response message for the
// ListProcessors method.
type GoogleCloudDocumentaiV1ListProcessorsResponse struct {
	// NextPageToken: Points to the next processor, otherwise empty.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Processors: The list of processors.
	Processors []*GoogleCloudDocumentaiV1Processor `json:"processors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ListProcessorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ListProcessorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1NormalizedVertex: A vertex represents a 2D point in
// the image. NOTE: the normalized vertex coordinates are relative to the
// original image and range from 0 to 1.
type GoogleCloudDocumentaiV1NormalizedVertex struct {
	// X: X coordinate.
	X float64 `json:"x,omitempty"`
	// Y: Y coordinate (starts from the top of the image).
	Y float64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1NormalizedVertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1NormalizedVertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1NormalizedVertex) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1NormalizedVertex
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// GoogleCloudDocumentaiV1OcrConfig: Config for Document OCR.
type GoogleCloudDocumentaiV1OcrConfig struct {
	// AdvancedOcrOptions: A list of advanced OCR options to further fine-tune OCR
	// behavior. Current valid values are: - `legacy_layout`: a heuristics layout
	// detection algorithm, which serves as an alternative to the current ML-based
	// layout detection algorithm. Customers can choose the best suitable layout
	// algorithm based on their situation.
	AdvancedOcrOptions []string `json:"advancedOcrOptions,omitempty"`
	// ComputeStyleInfo: Turn on font identification model and return font style
	// information. Deprecated, use PremiumFeatures.compute_style_info instead.
	ComputeStyleInfo bool `json:"computeStyleInfo,omitempty"`
	// DisableCharacterBoxesDetection: Turn off character box detector in OCR
	// engine. Character box detection is enabled by default in OCR 2.0 (and later)
	// processors.
	DisableCharacterBoxesDetection bool `json:"disableCharacterBoxesDetection,omitempty"`
	// EnableImageQualityScores: Enables intelligent document quality scores after
	// OCR. Can help with diagnosing why OCR responses are of poor quality for a
	// given input. Adds additional latency comparable to regular OCR to the
	// process call.
	EnableImageQualityScores bool `json:"enableImageQualityScores,omitempty"`
	// EnableNativePdfParsing: Enables special handling for PDFs with existing text
	// information. Results in better text extraction quality in such PDF inputs.
	EnableNativePdfParsing bool `json:"enableNativePdfParsing,omitempty"`
	// EnableSymbol: Includes symbol level OCR information if set to true.
	EnableSymbol bool `json:"enableSymbol,omitempty"`
	// Hints: Hints for the OCR model.
	Hints *GoogleCloudDocumentaiV1OcrConfigHints `json:"hints,omitempty"`
	// PremiumFeatures: Configurations for premium OCR features.
	PremiumFeatures *GoogleCloudDocumentaiV1OcrConfigPremiumFeatures `json:"premiumFeatures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedOcrOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedOcrOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1OcrConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1OcrConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1OcrConfigHints: Hints for OCR Engine
type GoogleCloudDocumentaiV1OcrConfigHints struct {
	// LanguageHints: List of BCP-47 language codes to use for OCR. In most cases,
	// not specifying it yields the best results since it enables automatic
	// language detection. For languages based on the Latin alphabet, setting hints
	// is not needed. In rare cases, when the language of the text in the image is
	// known, setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong).
	LanguageHints []string `json:"languageHints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageHints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageHints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1OcrConfigHints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1OcrConfigHints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1OcrConfigPremiumFeatures: Configurations for premium
// OCR features.
type GoogleCloudDocumentaiV1OcrConfigPremiumFeatures struct {
	// ComputeStyleInfo: Turn on font identification model and return font style
	// information.
	ComputeStyleInfo bool `json:"computeStyleInfo,omitempty"`
	// EnableMathOcr: Turn on the model that can extract LaTeX math formulas.
	EnableMathOcr bool `json:"enableMathOcr,omitempty"`
	// EnableSelectionMarkDetection: Turn on selection mark detector in OCR engine.
	// Only available in OCR 2.0 (and later) processors.
	EnableSelectionMarkDetection bool `json:"enableSelectionMarkDetection,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComputeStyleInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComputeStyleInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1OcrConfigPremiumFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1OcrConfigPremiumFeatures
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessOptions: Options for Process API
type GoogleCloudDocumentaiV1ProcessOptions struct {
	// FromEnd: Only process certain pages from the end, same as above.
	FromEnd int64 `json:"fromEnd,omitempty"`
	// FromStart: Only process certain pages from the start. Process all if the
	// document has fewer pages.
	FromStart int64 `json:"fromStart,omitempty"`
	// IndividualPageSelector: Which pages to process (1-indexed).
	IndividualPageSelector *GoogleCloudDocumentaiV1ProcessOptionsIndividualPageSelector `json:"individualPageSelector,omitempty"`
	// LayoutConfig: Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
	// Returns error if set on other processor types.
	LayoutConfig *GoogleCloudDocumentaiV1ProcessOptionsLayoutConfig `json:"layoutConfig,omitempty"`
	// OcrConfig: Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
	// Returns error if set on other processor types.
	OcrConfig *GoogleCloudDocumentaiV1OcrConfig `json:"ocrConfig,omitempty"`
	// SchemaOverride: Optional. Override the schema of the ProcessorVersion. Will
	// return an Invalid Argument error if this field is set when the underlying
	// ProcessorVersion doesn't support schema override.
	SchemaOverride *GoogleCloudDocumentaiV1DocumentSchema `json:"schemaOverride,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FromEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FromEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessOptionsIndividualPageSelector: A list of
// individual page numbers.
type GoogleCloudDocumentaiV1ProcessOptionsIndividualPageSelector struct {
	// Pages: Optional. Indices of the pages (starting from 1).
	Pages []int64 `json:"pages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Pages") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessOptionsIndividualPageSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessOptionsIndividualPageSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessOptionsLayoutConfig: Serving config for layout
// parser processor.
type GoogleCloudDocumentaiV1ProcessOptionsLayoutConfig struct {
	// ChunkingConfig: Optional. Config for chunking in layout parser processor.
	ChunkingConfig *GoogleCloudDocumentaiV1ProcessOptionsLayoutConfigChunkingConfig `json:"chunkingConfig,omitempty"`
	// ReturnBoundingBoxes: Optional. Whether to include bounding boxes in layout
	// parser processor response.
	ReturnBoundingBoxes bool `json:"returnBoundingBoxes,omitempty"`
	// ReturnImages: Optional. Whether to include images in layout parser processor
	// response.
	ReturnImages bool `json:"returnImages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessOptionsLayoutConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessOptionsLayoutConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessOptionsLayoutConfigChunkingConfig: Serving
// config for chunking.
type GoogleCloudDocumentaiV1ProcessOptionsLayoutConfigChunkingConfig struct {
	// ChunkSize: Optional. The chunk sizes to use when splitting documents, in
	// order of level.
	ChunkSize int64 `json:"chunkSize,omitempty"`
	// IncludeAncestorHeadings: Optional. Whether or not to include ancestor
	// headings when splitting.
	IncludeAncestorHeadings bool `json:"includeAncestorHeadings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessOptionsLayoutConfigChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessOptionsLayoutConfigChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessRequest: Request message for the
// ProcessDocument method.
type GoogleCloudDocumentaiV1ProcessRequest struct {
	// FieldMask: Specifies which fields to include in the ProcessResponse.document
	// output. Only supports top-level document and pages field, so it must be in
	// the form of `{document_field_name}` or `pages.{page_field_name}`.
	FieldMask string `json:"fieldMask,omitempty"`
	// GcsDocument: A raw document on Google Cloud Storage.
	GcsDocument *GoogleCloudDocumentaiV1GcsDocument `json:"gcsDocument,omitempty"`
	// ImagelessMode: Optional. Option to remove images from the document.
	ImagelessMode bool `json:"imagelessMode,omitempty"`
	// InlineDocument: An inline document proto.
	InlineDocument *GoogleCloudDocumentaiV1Document `json:"inlineDocument,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request.
	// Label keys and values can be no longer than 63 characters (Unicode
	// codepoints) and can only contain lowercase letters, numeric characters,
	// underscores, and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter.
	Labels map[string]string `json:"labels,omitempty"`
	// ProcessOptions: Inference-time options for the process API
	ProcessOptions *GoogleCloudDocumentaiV1ProcessOptions `json:"processOptions,omitempty"`
	// RawDocument: A raw document content (bytes).
	RawDocument *GoogleCloudDocumentaiV1RawDocument `json:"rawDocument,omitempty"`
	// SkipHumanReview: Whether human review should be skipped for this request.
	// Default to `false`.
	SkipHumanReview bool `json:"skipHumanReview,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldMask") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldMask") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessResponse: Response message for the
// ProcessDocument method.
type GoogleCloudDocumentaiV1ProcessResponse struct {
	// Document: The document payload, will populate fields based on the
	// processor's behavior.
	Document *GoogleCloudDocumentaiV1Document `json:"document,omitempty"`
	// HumanReviewStatus: The status of human review on the processed document.
	HumanReviewStatus *GoogleCloudDocumentaiV1HumanReviewStatus `json:"humanReviewStatus,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1Processor: The first-class citizen for Document AI.
// Each processor defines how to extract structural information from a
// document.
type GoogleCloudDocumentaiV1Processor struct {
	// CreateTime: Output only. The time the processor was created.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultProcessorVersion: The default processor version.
	DefaultProcessorVersion string `json:"defaultProcessorVersion,omitempty"`
	// DisplayName: The display name of the processor.
	DisplayName string `json:"displayName,omitempty"`
	// KmsKeyName: The KMS key (https://cloud.google.com/security-key-management)
	// used for encryption and decryption in CMEK scenarios.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// Name: Output only. Immutable. The resource name of the processor. Format:
	// `projects/{project}/locations/{location}/processors/{processor}`
	Name string `json:"name,omitempty"`
	// ProcessEndpoint: Output only. Immutable. The http endpoint that can be
	// called to invoke processing.
	ProcessEndpoint string `json:"processEndpoint,omitempty"`
	// ProcessorVersionAliases: Output only. The processor version aliases.
	ProcessorVersionAliases []*GoogleCloudDocumentaiV1ProcessorVersionAlias `json:"processorVersionAliases,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// State: Output only. The state of the processor.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The processor is in an unspecified state.
	//   "ENABLED" - The processor is enabled, i.e., has an enabled version which
	// can currently serve processing requests and all the feature dependencies
	// have been successfully initialized.
	//   "DISABLED" - The processor is disabled.
	//   "ENABLING" - The processor is being enabled, will become `ENABLED` if
	// successful.
	//   "DISABLING" - The processor is being disabled, will become `DISABLED` if
	// successful.
	//   "CREATING" - The processor is being created, will become either `ENABLED`
	// (for successful creation) or `FAILED` (for failed ones). Once a processor is
	// in this state, it can then be used for document processing, but the feature
	// dependencies of the processor might not be fully created yet.
	//   "FAILED" - The processor failed during creation or initialization of
	// feature dependencies. The user should delete the processor and recreate one
	// as all the functionalities of the processor are disabled.
	//   "DELETING" - The processor is being deleted, will be removed if
	// successful.
	State string `json:"state,omitempty"`
	// Type: The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`. To
	// get a list of processor types, see FetchProcessorTypes.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1Processor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1Processor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessorType: A processor type is responsible for
// performing a certain document understanding task on a certain type of
// document.
type GoogleCloudDocumentaiV1ProcessorType struct {
	// AllowCreation: Whether the processor type allows creation. If true, users
	// can create a processor of this processor type. Otherwise, users need to
	// request access.
	AllowCreation bool `json:"allowCreation,omitempty"`
	// AvailableLocations: The locations in which this processor is available.
	AvailableLocations []*GoogleCloudDocumentaiV1ProcessorTypeLocationInfo `json:"availableLocations,omitempty"`
	// Category: The processor category, used by UI to group processor types.
	Category string `json:"category,omitempty"`
	// LaunchStage: Launch stage of the processor type
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// [Terms of Service](https://cloud.google.com/terms/) and the [Google Cloud
	// Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`
	// Name: The resource name of the processor type. Format:
	// `projects/{project}/processorTypes/{processor_type}`
	Name string `json:"name,omitempty"`
	// SampleDocumentUris: A set of Cloud Storage URIs of sample documents for this
	// processor.
	SampleDocumentUris []string `json:"sampleDocumentUris,omitempty"`
	// Type: The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowCreation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowCreation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessorType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessorType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessorTypeLocationInfo: The location information
// about where the processor is available.
type GoogleCloudDocumentaiV1ProcessorTypeLocationInfo struct {
	// LocationId: The location ID. For supported locations, refer to regional and
	// multi-regional support (/document-ai/docs/regions).
	LocationId string `json:"locationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessorTypeLocationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessorTypeLocationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessorVersion: A processor version is an
// implementation of a processor. Each processor can have multiple versions,
// pretrained by Google internally or uptrained by the customer. A processor
// can only have one default version at a time. Its document-processing
// behavior is defined by that version.
type GoogleCloudDocumentaiV1ProcessorVersion struct {
	// CreateTime: Output only. The time the processor version was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeprecationInfo: Output only. If set, information about the eventual
	// deprecation of this version.
	DeprecationInfo *GoogleCloudDocumentaiV1ProcessorVersionDeprecationInfo `json:"deprecationInfo,omitempty"`
	// DisplayName: The display name of the processor version.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentSchema: Output only. The schema of the processor version. Describes
	// the output.
	DocumentSchema *GoogleCloudDocumentaiV1DocumentSchema `json:"documentSchema,omitempty"`
	// GenAiModelInfo: Output only. Information about Generative AI model-based
	// processor versions.
	GenAiModelInfo *GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfo `json:"genAiModelInfo,omitempty"`
	// GoogleManaged: Output only. Denotes that this `ProcessorVersion` is managed
	// by Google.
	GoogleManaged bool `json:"googleManaged,omitempty"`
	// KmsKeyName: Output only. The KMS key name used for encryption.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// KmsKeyVersionName: Output only. The KMS key version with which data is
	// encrypted.
	KmsKeyVersionName string `json:"kmsKeyVersionName,omitempty"`
	// LatestEvaluation: Output only. The most recently invoked evaluation for the
	// processor version.
	LatestEvaluation *GoogleCloudDocumentaiV1EvaluationReference `json:"latestEvaluation,omitempty"`
	// ModelType: Output only. The model type of this processor version.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - The processor version has unspecified model
	// type.
	//   "MODEL_TYPE_GENERATIVE" - The processor version has generative model type.
	//   "MODEL_TYPE_CUSTOM" - The processor version has custom model type.
	ModelType string `json:"modelType,omitempty"`
	// Name: Identifier. The resource name of the processor version. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/processorVers
	// ions/{processor_version}`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// State: Output only. The state of the processor version.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The processor version is in an unspecified state.
	//   "DEPLOYED" - The processor version is deployed and can be used for
	// processing.
	//   "DEPLOYING" - The processor version is being deployed.
	//   "UNDEPLOYED" - The processor version is not deployed and cannot be used
	// for processing.
	//   "UNDEPLOYING" - The processor version is being undeployed.
	//   "CREATING" - The processor version is being created.
	//   "DELETING" - The processor version is being deleted.
	//   "FAILED" - The processor version failed and is in an indeterminate state.
	//   "IMPORTING" - The processor version is being imported.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessorVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessorVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessorVersionAlias: Contains the alias and the
// aliased resource name of processor version.
type GoogleCloudDocumentaiV1ProcessorVersionAlias struct {
	// Alias: The alias in the form of `processor_version` resource name.
	Alias string `json:"alias,omitempty"`
	// ProcessorVersion: The resource name of aliased processor version.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessorVersionAlias) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessorVersionAlias
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessorVersionDeprecationInfo: Information about
// the upcoming deprecation of this processor version.
type GoogleCloudDocumentaiV1ProcessorVersionDeprecationInfo struct {
	// DeprecationTime: The time at which this processor version will be
	// deprecated.
	DeprecationTime string `json:"deprecationTime,omitempty"`
	// ReplacementProcessorVersion: If set, the processor version that will be used
	// as a replacement.
	ReplacementProcessorVersion string `json:"replacementProcessorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeprecationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeprecationTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessorVersionDeprecationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessorVersionDeprecationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfo: Information about
// Generative AI model-based processor versions.
type GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfo struct {
	// CustomGenAiModelInfo: Information for a custom Generative AI model created
	// by the user.
	CustomGenAiModelInfo *GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoCustomGenAiModelInfo `json:"customGenAiModelInfo,omitempty"`
	// FoundationGenAiModelInfo: Information for a pretrained Google-managed
	// foundation model.
	FoundationGenAiModelInfo *GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoFoundationGenAiModelInfo `json:"foundationGenAiModelInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomGenAiModelInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomGenAiModelInfo") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoCustomGenAiModelInfo:
// Information for a custom Generative AI model created by the user. These are
// created with `Create New Version` in either the `Call foundation model` or
// `Fine tuning` tabs.
type GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoCustomGenAiModelInfo struct {
	// BaseProcessorVersionId: The base processor version ID for the custom model.
	BaseProcessorVersionId string `json:"baseProcessorVersionId,omitempty"`
	// CustomModelType: The type of custom model created by the user.
	//
	// Possible values:
	//   "CUSTOM_MODEL_TYPE_UNSPECIFIED" - The model type is unspecified.
	//   "VERSIONED_FOUNDATION" - The model is a versioned foundation model.
	//   "FINE_TUNED" - The model is a finetuned foundation model.
	CustomModelType string `json:"customModelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseProcessorVersionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseProcessorVersionId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoCustomGenAiModelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoCustomGenAiModelInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoFoundationGenAiModelInfo
// : Information for a pretrained Google-managed foundation model.
type GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoFoundationGenAiModelInfo struct {
	// FinetuningAllowed: Whether finetuning is allowed for this base processor
	// version.
	FinetuningAllowed bool `json:"finetuningAllowed,omitempty"`
	// MinTrainLabeledDocuments: The minimum number of labeled documents in the
	// training dataset required for finetuning.
	MinTrainLabeledDocuments int64 `json:"minTrainLabeledDocuments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FinetuningAllowed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FinetuningAllowed") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoFoundationGenAiModelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ProcessorVersionGenAiModelInfoFoundationGenAiModelInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1RawDocument: Payload message of raw document content
// (bytes).
type GoogleCloudDocumentaiV1RawDocument struct {
	// Content: Inline document content.
	Content string `json:"content,omitempty"`
	// DisplayName: The display name of the document, it supports all Unicode
	// characters except the following: `*`, `?`, `[`, `]`, `%`, `{`, `}`,`'`,
	// `\", `,` `~`, `=` and `:` are reserved. If not specified, a default ID is
	// generated.
	DisplayName string `json:"displayName,omitempty"`
	// MimeType: An IANA MIME type (RFC6838) indicating the nature and format of
	// the content.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1RawDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1RawDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata: The long-running
// operation metadata for the ReviewDocument method.
type GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// QuestionId: The Crowd Compute question ID.
	QuestionId string `json:"questionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ReviewDocumentRequest: Request message for the
// ReviewDocument method.
type GoogleCloudDocumentaiV1ReviewDocumentRequest struct {
	// DocumentSchema: The document schema of the human review task.
	DocumentSchema *GoogleCloudDocumentaiV1DocumentSchema `json:"documentSchema,omitempty"`
	// EnableSchemaValidation: Whether the validation should be performed on the
	// ad-hoc review request.
	EnableSchemaValidation bool `json:"enableSchemaValidation,omitempty"`
	// InlineDocument: An inline document proto.
	InlineDocument *GoogleCloudDocumentaiV1Document `json:"inlineDocument,omitempty"`
	// Priority: The priority of the human review task.
	//
	// Possible values:
	//   "DEFAULT" - The default priority level.
	//   "URGENT" - The urgent priority level. The labeling manager should allocate
	// labeler resource to the urgent task queue to respect this priority level.
	Priority string `json:"priority,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentSchema") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ReviewDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ReviewDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ReviewDocumentResponse: Response message for the
// ReviewDocument method.
type GoogleCloudDocumentaiV1ReviewDocumentResponse struct {
	// GcsDestination: The Cloud Storage uri for the human reviewed document if the
	// review is succeeded.
	GcsDestination string `json:"gcsDestination,omitempty"`
	// RejectionReason: The reason why the review is rejected by reviewer.
	RejectionReason string `json:"rejectionReason,omitempty"`
	// State: The state of the review operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "REJECTED" - The review operation is rejected by the reviewer.
	//   "SUCCEEDED" - The review operation is succeeded.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ReviewDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ReviewDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata: The long-running
// operation metadata for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1SetDefaultProcessorVersionRequest: Request message
// for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1SetDefaultProcessorVersionRequest struct {
	// DefaultProcessorVersion: Required. The resource name of child
	// ProcessorVersion to use as default. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/processorVers
	// ions/{version}`
	DefaultProcessorVersion string `json:"defaultProcessorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1SetDefaultProcessorVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1SetDefaultProcessorVersionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1SetDefaultProcessorVersionResponse: Response message
// for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1SetDefaultProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1TrainProcessorVersionMetadata: The metadata that
// represents a processor version being created.
type GoogleCloudDocumentaiV1TrainProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// TestDatasetValidation: The test dataset validation information.
	TestDatasetValidation *GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation `json:"testDatasetValidation,omitempty"`
	// TrainingDatasetValidation: The training dataset validation information.
	TrainingDatasetValidation *GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation `json:"trainingDatasetValidation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation: The
// dataset validation information. This includes any and all errors with
// documents and the dataset.
type GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation struct {
	// DatasetErrorCount: The total number of dataset errors.
	DatasetErrorCount int64 `json:"datasetErrorCount,omitempty"`
	// DatasetErrors: Error information for the dataset as a whole. A maximum of 10
	// dataset errors will be returned. A single dataset error is terminal for
	// training.
	DatasetErrors []*GoogleRpcStatus `json:"datasetErrors,omitempty"`
	// DocumentErrorCount: The total number of document errors.
	DocumentErrorCount int64 `json:"documentErrorCount,omitempty"`
	// DocumentErrors: Error information pertaining to specific documents. A
	// maximum of 10 document errors will be returned. Any document with errors
	// will not be used throughout training.
	DocumentErrors []*GoogleRpcStatus `json:"documentErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetErrorCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetErrorCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1TrainProcessorVersionRequest: Request message for the
// TrainProcessorVersion method.
type GoogleCloudDocumentaiV1TrainProcessorVersionRequest struct {
	// BaseProcessorVersion: Optional. The processor version to use as a base for
	// training. This processor version must be a child of `parent`. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/processorVers
	// ions/{processorVersion}`.
	BaseProcessorVersion string `json:"baseProcessorVersion,omitempty"`
	// CustomDocumentExtractionOptions: Options to control Custom Document
	// Extraction (CDE) Processor.
	CustomDocumentExtractionOptions *GoogleCloudDocumentaiV1TrainProcessorVersionRequestCustomDocumentExtractionOptions `json:"customDocumentExtractionOptions,omitempty"`
	// DocumentSchema: Optional. The schema the processor version will be trained
	// with.
	DocumentSchema *GoogleCloudDocumentaiV1DocumentSchema `json:"documentSchema,omitempty"`
	// FoundationModelTuningOptions: Options to control foundation model tuning of
	// a processor.
	FoundationModelTuningOptions *GoogleCloudDocumentaiV1TrainProcessorVersionRequestFoundationModelTuningOptions `json:"foundationModelTuningOptions,omitempty"`
	// InputData: Optional. The input data used to train the ProcessorVersion.
	InputData *GoogleCloudDocumentaiV1TrainProcessorVersionRequestInputData `json:"inputData,omitempty"`
	// ProcessorVersion: Required. The processor version to be created.
	ProcessorVersion *GoogleCloudDocumentaiV1ProcessorVersion `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseProcessorVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1TrainProcessorVersionRequestCustomDocumentExtractionOp
// tions: Options to control the training of the Custom Document Extraction
// (CDE) Processor.
type GoogleCloudDocumentaiV1TrainProcessorVersionRequestCustomDocumentExtractionOptions struct {
	// TrainingMethod: Optional. Training method to use for CDE training.
	//
	// Possible values:
	//   "TRAINING_METHOD_UNSPECIFIED"
	//   "MODEL_BASED"
	//   "TEMPLATE_BASED"
	TrainingMethod string `json:"trainingMethod,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingMethod") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingMethod") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionRequestCustomDocumentExtractionOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionRequestCustomDocumentExtractionOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1TrainProcessorVersionRequestFoundationModelTuningOptio
// ns: Options to control foundation model tuning of the processor.
type GoogleCloudDocumentaiV1TrainProcessorVersionRequestFoundationModelTuningOptions struct {
	// LearningRateMultiplier: Optional. The multiplier to apply to the recommended
	// learning rate. Valid values are between 0.1 and 10. If not provided,
	// recommended learning rate will be used.
	LearningRateMultiplier float64 `json:"learningRateMultiplier,omitempty"`
	// TrainSteps: Optional. The number of steps to run for model tuning. Valid
	// values are between 1 and 400. If not provided, recommended steps will be
	// used.
	TrainSteps int64 `json:"trainSteps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LearningRateMultiplier") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LearningRateMultiplier") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionRequestFoundationModelTuningOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionRequestFoundationModelTuningOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1TrainProcessorVersionRequestFoundationModelTuningOptions) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionRequestFoundationModelTuningOptions
	var s1 struct {
		LearningRateMultiplier gensupport.JSONFloat64 `json:"learningRateMultiplier"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LearningRateMultiplier = float64(s1.LearningRateMultiplier)
	return nil
}

// GoogleCloudDocumentaiV1TrainProcessorVersionRequestInputData: The input data
// used to train a new ProcessorVersion.
type GoogleCloudDocumentaiV1TrainProcessorVersionRequestInputData struct {
	// TestDocuments: The documents used for testing the trained version.
	TestDocuments *GoogleCloudDocumentaiV1BatchDocumentsInputConfig `json:"testDocuments,omitempty"`
	// TrainingDocuments: The documents used for training the new version.
	TrainingDocuments *GoogleCloudDocumentaiV1BatchDocumentsInputConfig `json:"trainingDocuments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestDocuments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestDocuments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionRequestInputData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionRequestInputData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1TrainProcessorVersionResponse: The response for
// TrainProcessorVersion.
type GoogleCloudDocumentaiV1TrainProcessorVersionResponse struct {
	// ProcessorVersion: The resource name of the processor version produced by
	// training.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata: The long-running
// operation metadata for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1UndeployProcessorVersionRequest: Request message for
// the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1UndeployProcessorVersionRequest struct {
}

// GoogleCloudDocumentaiV1UndeployProcessorVersionResponse: Response message
// for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1UndeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1Vertex: A vertex represents a 2D point in the image.
// NOTE: the vertex coordinates are in the same scale as the original image.
type GoogleCloudDocumentaiV1Vertex struct {
	// X: X coordinate.
	X int64 `json:"x,omitempty"`
	// Y: Y coordinate (starts from the top of the image).
	Y int64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1Vertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1Vertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ErrorDocumentCount: Total number of documents that failed to be deleted in
	// storage.
	ErrorDocumentCount int64 `json:"errorDocumentCount,omitempty"`
	// IndividualBatchDeleteStatuses: The list of response details of each
	// document.
	IndividualBatchDeleteStatuses []*GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus `json:"individualBatchDeleteStatuses,omitempty"`
	// TotalDocumentCount: Total number of documents deleting from dataset.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDelete
// Status: The status of each individual document in the batch delete process.
type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiV1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of deleting the document in storage.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsResponse: Response of the
// delete documents operation.
type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsResponse struct {
}

// GoogleCloudDocumentaiV1beta3BatchProcessMetadata: The long-running operation
// metadata for BatchProcessDocuments.
type GoogleCloudDocumentaiV1beta3BatchProcessMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// IndividualProcessStatuses: The list of response details of each document.
	IndividualProcessStatuses []*GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus `json:"individualProcessStatuses,omitempty"`
	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLING" - The batch processing was being cancelled.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the error message if the operation is failed.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3BatchProcessMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchProcessMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus: The
// status of a each individual document in the batch process.
type GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus struct {
	// HumanReviewOperation: The name of the operation triggered by the processed
	// document. If the human review process isn't triggered, this field will be
	// empty. It has the same response type and metadata as the long-running
	// operation returned by the ReviewDocument method.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`
	// HumanReviewStatus: The status of human review on the processed document.
	HumanReviewStatus *GoogleCloudDocumentaiV1beta3HumanReviewStatus `json:"humanReviewStatus,omitempty"`
	// InputGcsSource: The source of the document, same as the input_gcs_source
	// field in the request when the batch process started.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// OutputGcsDestination: The Cloud Storage output destination (in the request
	// as DocumentOutputConfig.GcsOutputConfig.gcs_uri) of the processed document
	// if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`
	// Status: The status processing the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HumanReviewOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HumanReviewOperation") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessResponse: Response message for
// BatchProcessDocuments.
type GoogleCloudDocumentaiV1beta3BatchProcessResponse struct {
}

// GoogleCloudDocumentaiV1beta3CommonOperationMetadata: The common metadata for
// long running operations.
type GoogleCloudDocumentaiV1beta3CommonOperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// Resource: A related resource to this operation.
	Resource string `json:"resource,omitempty"`
	// State: The state of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3CommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3CommonOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3Dataset: A singleton resource under a Processor
// which configures a collection of documents.
type GoogleCloudDocumentaiV1beta3Dataset struct {
	// DocumentWarehouseConfig: Optional. Deprecated. Warehouse-based dataset
	// configuration is not supported.
	DocumentWarehouseConfig *GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig `json:"documentWarehouseConfig,omitempty"`
	// GcsManagedConfig: Optional. User-managed Cloud Storage dataset
	// configuration. Use this configuration if the dataset documents are stored
	// under a user-managed Cloud Storage location.
	GcsManagedConfig *GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig `json:"gcsManagedConfig,omitempty"`
	// Name: Dataset resource name. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/dataset`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SpannerIndexingConfig: Optional. A lightweight indexing source with low
	// latency and high reliability, but lacking advanced features like CMEK and
	// content-based search.
	SpannerIndexingConfig *GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig `json:"spannerIndexingConfig,omitempty"`
	// State: Required. State of the dataset. Ignored when updating dataset.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified enum, should not be used.
	//   "UNINITIALIZED" - Dataset has not been initialized.
	//   "INITIALIZING" - Dataset is being initialized.
	//   "INITIALIZED" - Dataset has been initialized.
	State string `json:"state,omitempty"`
	// UnmanagedDatasetConfig: Optional. Unmanaged dataset configuration. Use this
	// configuration if the dataset documents are managed by the document service
	// internally (not user-managed).
	UnmanagedDatasetConfig *GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig `json:"unmanagedDatasetConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentWarehouseConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentWarehouseConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig: Configuration
// specific to the Document AI Warehouse-based implementation.
type GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig struct {
	// Collection: Output only. The collection in Document AI Warehouse associated
	// with the dataset.
	Collection string `json:"collection,omitempty"`
	// Schema: Output only. The schema in Document AI Warehouse associated with the
	// dataset.
	Schema string `json:"schema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Collection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Collection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig: Configuration specific
// to the Cloud Storage-based implementation.
type GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig struct {
	// GcsPrefix: Required. The Cloud Storage URI (a directory) where the documents
	// belonging to the dataset must be stored.
	GcsPrefix *GoogleCloudDocumentaiV1beta3GcsPrefix `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig: Configuration
// specific to spanner-based indexing.
type GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig struct {
}

// GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig: Configuration
// specific to an unmanaged dataset.
type GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig struct {
}

// GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata: The long-running
// operation metadata for the DeleteProcessor method.
type GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata: The long-running
// operation metadata for the DeleteProcessorVersion method.
type GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata: The long-running
// operation metadata for the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DeployProcessorVersionResponse: Response message
// for the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3DeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1beta3DisableProcessorMetadata: The long-running
// operation metadata for the DisableProcessor method.
type GoogleCloudDocumentaiV1beta3DisableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DisableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DisableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DisableProcessorResponse: Response message for
// the DisableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiV1beta3DisableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1beta3DocumentId: Document Identifier.
type GoogleCloudDocumentaiV1beta3DocumentId struct {
	// GcsManagedDocId: A document id within user-managed Cloud Storage.
	GcsManagedDocId *GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId `json:"gcsManagedDocId,omitempty"`
	// RevisionRef: Points to a specific revision of the document if set.
	RevisionRef *GoogleCloudDocumentaiV1beta3RevisionRef `json:"revisionRef,omitempty"`
	// UnmanagedDocId: A document id within unmanaged dataset.
	UnmanagedDocId *GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId `json:"unmanagedDocId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsManagedDocId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsManagedDocId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId: Identifies a
// document uniquely within the scope of a dataset in the user-managed Cloud
// Storage option.
type GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId struct {
	// CwDocId: Id of the document (indexed) managed by Content Warehouse.
	CwDocId string `json:"cwDocId,omitempty"`
	// GcsUri: Required. The Cloud Storage URI where the actual document is stored.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CwDocId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CwDocId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId: Identifies a
// document uniquely within the scope of a dataset in unmanaged option.
type GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId struct {
	// DocId: Required. The id of the document.
	DocId string `json:"docId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EnableProcessorMetadata: The long-running
// operation metadata for the EnableProcessor method.
type GoogleCloudDocumentaiV1beta3EnableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3EnableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EnableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EnableProcessorResponse: Response message for
// the EnableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiV1beta3EnableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata: Metadata of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse: Response of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse struct {
	// Evaluation: The resource name of the created evaluation.
	Evaluation string `json:"evaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3GcsPrefix: Specifies all documents on Cloud
// Storage with a common prefix.
type GoogleCloudDocumentaiV1beta3GcsPrefix struct {
	// GcsUriPrefix: The URI prefix.
	GcsUriPrefix string `json:"gcsUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUriPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3GcsPrefix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3GcsPrefix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3HumanReviewStatus: The status of human review on
// a processed document.
type GoogleCloudDocumentaiV1beta3HumanReviewStatus struct {
	// HumanReviewOperation: The name of the operation triggered by the processed
	// document. This field is populated only when the state is
	// `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and metadata as
	// the long-running operation returned by ReviewDocument.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`
	// State: The state of human review on the processing request.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Human review state is unspecified. Most likely due
	// to an internal error.
	//   "SKIPPED" - Human review is skipped for the document. This can happen
	// because human review isn't enabled on the processor or the processing
	// request has been set to skip this document.
	//   "VALIDATION_PASSED" - Human review validation is triggered and passed, so
	// no review is needed.
	//   "IN_PROGRESS" - Human review validation is triggered and the document is
	// under review.
	//   "ERROR" - Some error happened during triggering human review, see the
	// state_message for details.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the human review state.
	StateMessage string `json:"stateMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HumanReviewOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HumanReviewOperation") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3HumanReviewStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3HumanReviewStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata: Metadata of the import
// document operation.
type GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ImportConfigValidationResults: Validation statuses of the batch documents
	// import config.
	ImportConfigValidationResults []*GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult `json:"importConfigValidationResults,omitempty"`
	// IndividualImportStatuses: The list of response details of each document.
	IndividualImportStatuses []*GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus `json:"individualImportStatuses,omitempty"`
	// TotalDocumentCount: Total number of the documents that are qualified for
	// importing.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResu
// lt: The validation status of each import config. Status is set to an error
// if there are no documents to import in the `import_config`, or `OK` if the
// operation will try to proceed with at least one document.
type GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult struct {
	// InputGcsSource: The source Cloud Storage URI specified in the import config.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// Status: The validation status of import config.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus:
// The status of each individual document in the import process.
type GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus struct {
	// InputGcsSource: The source Cloud Storage URI of the document.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// OutputDocumentId: The document id of imported document if it was successful,
	// otherwise empty.
	OutputDocumentId *GoogleCloudDocumentaiV1beta3DocumentId `json:"outputDocumentId,omitempty"`
	// Status: The status of the importing of the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsResponse: Response of the import
// document operation.
type GoogleCloudDocumentaiV1beta3ImportDocumentsResponse struct {
}

// GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata: The long-running
// operation metadata for the ImportProcessorVersion method.
type GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata for the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse: The response
// message for the ImportProcessorVersion method.
type GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse struct {
	// ProcessorVersion: The destination processor version name.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata: The
// long-running operation metadata for the ReviewDocument method.
type GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// QuestionId: The Crowd Compute question ID.
	QuestionId string `json:"questionId,omitempty"`
	// State: Used only when Operation.done is false.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the error message if the operation is failed.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ReviewDocumentResponse: Response message for the
// ReviewDocument method.
type GoogleCloudDocumentaiV1beta3ReviewDocumentResponse struct {
	// GcsDestination: The Cloud Storage uri for the human reviewed document if the
	// review is succeeded.
	GcsDestination string `json:"gcsDestination,omitempty"`
	// RejectionReason: The reason why the review is rejected by reviewer.
	RejectionReason string `json:"rejectionReason,omitempty"`
	// State: The state of the review operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "REJECTED" - The review operation is rejected by the reviewer.
	//   "SUCCEEDED" - The review operation is succeeded.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ReviewDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ReviewDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3RevisionRef: The revision reference specifies
// which revision on the document to read.
type GoogleCloudDocumentaiV1beta3RevisionRef struct {
	// LatestProcessorVersion: Reads the revision generated by the processor
	// version. The format takes the full resource name of processor version.
	// `projects/{project}/locations/{location}/processors/{processor}/processorVers
	// ions/{processorVersion}`
	LatestProcessorVersion string `json:"latestProcessorVersion,omitempty"`
	// RevisionCase: Reads the revision by the predefined case.
	//
	// Possible values:
	//   "REVISION_CASE_UNSPECIFIED" - Unspecified case, fall back to read the
	// `LATEST_HUMAN_REVIEW`.
	//   "LATEST_HUMAN_REVIEW" - The latest revision made by a human.
	//   "LATEST_TIMESTAMP" - The latest revision based on timestamp.
	//   "BASE_OCR_REVISION" - The first (OCR) revision.
	RevisionCase string `json:"revisionCase,omitempty"`
	// RevisionId: Reads the revision given by the id.
	RevisionId string `json:"revisionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatestProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatestProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3RevisionRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3RevisionRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata: The
// long-running operation metadata for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionResponse: Response
// message for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata: The metadata that
// represents a processor version being created.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// TestDatasetValidation: The test dataset validation information.
	TestDatasetValidation *GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation `json:"testDatasetValidation,omitempty"`
	// TrainingDatasetValidation: The training dataset validation information.
	TrainingDatasetValidation *GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation `json:"trainingDatasetValidation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation:
// The dataset validation information. This includes any and all errors with
// documents and the dataset.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation struct {
	// DatasetErrorCount: The total number of dataset errors.
	DatasetErrorCount int64 `json:"datasetErrorCount,omitempty"`
	// DatasetErrors: Error information for the dataset as a whole. A maximum of 10
	// dataset errors will be returned. A single dataset error is terminal for
	// training.
	DatasetErrors []*GoogleRpcStatus `json:"datasetErrors,omitempty"`
	// DocumentErrorCount: The total number of document errors.
	DocumentErrorCount int64 `json:"documentErrorCount,omitempty"`
	// DocumentErrors: Error information pertaining to specific documents. A
	// maximum of 10 document errors will be returned. Any document with errors
	// will not be used throughout training.
	DocumentErrors []*GoogleRpcStatus `json:"documentErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetErrorCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetErrorCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse: The response for
// TrainProcessorVersion.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse struct {
	// ProcessorVersion: The resource name of the processor version produced by
	// training.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata: The
// long-running operation metadata for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3UndeployProcessorVersionResponse: Response
// message for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3UndeployProcessorVersionResponse struct {
}

type GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationListLocationsResponse: The response message for
// Locations.ListLocations.
type GoogleCloudLocationListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*GoogleCloudLocationLocation `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudLocationListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationLocation: A resource that represents a Google Cloud
// location.
type GoogleCloudLocationLocation struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudLocationLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeColor: Represents a color in the RGBA color space. This
// representation is designed for simplicity of conversion to and from color
// representations in various languages over compactness. For example, the
// fields of this representation can be trivially provided to the constructor
// of `java.awt.Color` in Java; it can also be trivially provided to UIColor's
// `+colorWithRed:green:blue:alpha` method in iOS; and, with just a little
// work, it can be easily formatted into a CSS `rgba()` string in JavaScript.
// This reference page doesn't have information about the absolute color space
// that should be used to interpret the RGB value—for example, sRGB, Adobe
// RGB, DCI-P3, and BT.2020. By default, applications should assume the sRGB
// color space. When color equality needs to be decided, implementations,
// unless documented otherwise, treat two colors as equal if all their red,
// green, blue, and alpha values each differ by at most `1e-5`. Example (Java):
// import com.google.type.Color; // ... public static java.awt.Color
// fromProto(Color protocolor) { float alpha = protocolor.hasAlpha() ?
// protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color(
// protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); }
// public static Color toProto(java.awt.Color color) { float red = (float)
// color.getRed(); float green = (float) color.getGreen(); float blue = (float)
// color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder =
// Color .newBuilder() .setRed(red / denominator) .setGreen(green /
// denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if
// (alpha != 255) { result.setAlpha( FloatValue .newBuilder()
// .setValue(((float) alpha) / denominator) .build()); } return
// resultBuilder.build(); } // ... Example (iOS / Obj-C): // ... static
// UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float
// green = [protocolor green]; float blue = [protocolor blue]; FloatValue*
// alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper !=
// nil) { alpha = [alpha_wrapper value]; } return [UIColor colorWithRed:red
// green:green blue:blue alpha:alpha]; } static Color* toProto(UIColor* color)
// { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green
// blue:&blue alpha:&alpha]) { return nil; } Color* result = [[Color alloc]
// init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue];
// if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; }
// [result autorelease]; return result; } // ... Example (JavaScript): // ...
// var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red ||
// 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue
// || 0.0; var red = Math.floor(redFrac * 255); var green =
// Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if
// (!('alpha' in rgb_color)) { return rgbToCssColor(red, green, blue); } var
// alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green,
// blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join(”);
// }; var rgbToCssColor = function(red, green, blue) { var rgbNumber = new
// Number((red << 16) | (green << 8) | blue); var hexString =
// rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var
// resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) {
// resultBuilder.push('0'); } resultBuilder.push(hexString); return
// resultBuilder.join(”); }; // ...
type GoogleTypeColor struct {
	// Alpha: The fraction of this color that should be applied to the pixel. That
	// is, the final pixel color is defined by the equation: `pixel color = alpha *
	// (this color) + (1.0 - alpha) * (background color)` This means that a value
	// of 1.0 corresponds to a solid color, whereas a value of 0.0 corresponds to a
	// completely transparent color. This uses a wrapper message rather than a
	// simple float scalar so that it is possible to distinguish between a default
	// value and the value being unset. If omitted, this color object is rendered
	// as a solid color (as if the alpha value had been explicitly given a value of
	// 1.0).
	Alpha float64 `json:"alpha,omitempty"`
	// Blue: The amount of blue in the color as a value in the interval [0, 1].
	Blue float64 `json:"blue,omitempty"`
	// Green: The amount of green in the color as a value in the interval [0, 1].
	Green float64 `json:"green,omitempty"`
	// Red: The amount of red in the color as a value in the interval [0, 1].
	Red float64 `json:"red,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alpha") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeColor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeColor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeColor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeColor
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		Blue  gensupport.JSONFloat64 `json:"blue"`
		Green gensupport.JSONFloat64 `json:"green"`
		Red   gensupport.JSONFloat64 `json:"red"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	s.Blue = float64(s1.Blue)
	s.Green = float64(s1.Green)
	s.Red = float64(s1.Red)
	return nil
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeDateTime: Represents civil time (or occasionally physical time).
// This type can represent a civil time in one of a few possible ways: * When
// utc_offset is set and time_zone is unset: a civil time on a calendar day
// with a particular offset from UTC. * When time_zone is set and utc_offset is
// unset: a civil time on a calendar day in a particular time zone. * When
// neither time_zone nor utc_offset is set: a civil time on a calendar day in
// local time. The date is relative to the Proleptic Gregorian Calendar. If
// year, month, or day are 0, the DateTime is considered not to have a specific
// year, month, or day respectively. This type may also be used to represent a
// physical time if all the date and time fields are set and either case of the
// `time_offset` oneof is set. Consider using `Timestamp` message for physical
// time instead. If your use case also would like to store the user's timezone,
// that can be done in another field. This type is more flexible than some
// applications may want. Make sure to document and validate your application's
// limitations.
type GoogleTypeDateTime struct {
	// Day: Optional. Day of month. Must be from 1 to 31 and valid for the year and
	// month, or 0 if specifying a datetime without a day.
	Day int64 `json:"day,omitempty"`
	// Hours: Optional. Hours of day in 24 hour format. Should be from 0 to 23,
	// defaults to 0 (midnight). An API may choose to allow the value "24:00:00"
	// for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Optional. Minutes of hour of day. Must be from 0 to 59, defaults to
	// 0.
	Minutes int64 `json:"minutes,omitempty"`
	// Month: Optional. Month of year. Must be from 1 to 12, or 0 if specifying a
	// datetime without a month.
	Month int64 `json:"month,omitempty"`
	// Nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0 to
	// 999,999,999, defaults to 0.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Optional. Seconds of minutes of the time. Must normally be from 0
	// to 59, defaults to 0. An API may allow the value 60 if it allows
	// leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// TimeZone: Time zone.
	TimeZone *GoogleTypeTimeZone `json:"timeZone,omitempty"`
	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and +18
	// hours. For example, a UTC offset of -4:00 would be represented as { seconds:
	// -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`
	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
	// datetime without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDateTime) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDateTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeMoney: Represents an amount of money with its currency type.
type GoogleTypeMoney struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Nanos: Number of nano (10^-9) units of the amount. The value must be between
	// -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos`
	// must be positive or zero. If `units` is zero, `nanos` can be positive, zero,
	// or negative. If `units` is negative, `nanos` must be negative or zero. For
	// example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`
	// Units: The whole units of the amount. For example if `currencyCode` is
	// "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeMoney) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeMoney
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypePostalAddress: Represents a postal address, such as for postal
// delivery or payments addresses. With a postal address, a postal service can
// deliver items to a premise, P.O. box, or similar. A postal address is not
// intended to model geographical locations like roads, towns, or mountains. In
// typical usage, an address would be created by user input or from importing
// existing data, depending on the type of process. Advice on address input or
// editing: - Use an internationalization-ready address widget such as
// https://github.com/google/libaddressinput. - Users should not be presented
// with UI elements for input or editing of fields outside countries where that
// field is used. For more guidance on how to use this schema, see:
// https://support.google.com/business/answer/6397478.
type GoogleTypePostalAddress struct {
	// AddressLines: Unstructured address lines describing the lower levels of an
	// address. Because values in `address_lines` do not have type information and
	// may sometimes contain multiple values in a single field (for example,
	// "Austin, TX"), it is important that the line order is clear. The order of
	// address lines should be "envelope order" for the country or region of the
	// address. In places where this can vary (for example, Japan),
	// `address_language` is used to make it explicit (for example, "ja" for
	// large-to-small ordering and "ja-Latn" or "en" for small-to-large). In this
	// way, the most specific line of an address can be selected based on the
	// language. The minimum permitted structural representation of an address
	// consists of a `region_code` with all remaining information placed in the
	// `address_lines`. It would be possible to format such an address very
	// approximately without geocoding, but no semantic reasoning could be made
	// about any of the address components until it was at least partially
	// resolved. Creating an address only containing a `region_code` and
	// `address_lines` and then geocoding is the recommended way to handle
	// completely unstructured addresses (as opposed to guessing which parts of the
	// address should be localities or administrative areas).
	AddressLines []string `json:"addressLines,omitempty"`
	// AdministrativeArea: Optional. Highest administrative subdivision which is
	// used for postal addresses of a country or region. For example, this can be a
	// state, a province, an oblast, or a prefecture. For Spain, this is the
	// province and not the autonomous community (for example, "Barcelona" and not
	// "Catalonia"). Many countries don't use an administrative area in postal
	// addresses. For example, in Switzerland, this should be left unpopulated.
	AdministrativeArea string `json:"administrativeArea,omitempty"`
	// LanguageCode: Optional. BCP-47 language code of the contents of this address
	// (if known). This is often the UI language of the input form or is expected
	// to match one of the languages used in the address' country/region, or their
	// transliterated equivalents. This can affect formatting in certain countries,
	// but is not critical to the correctness of the data and will never affect any
	// validation or other non-formatting related operations. If this value is not
	// known, it should be omitted (rather than specifying a possibly incorrect
	// default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
	LanguageCode string `json:"languageCode,omitempty"`
	// Locality: Optional. Generally refers to the city or town portion of the
	// address. Examples: US city, IT comune, UK post town. In regions of the world
	// where localities are not well defined or do not fit into this structure
	// well, leave `locality` empty and use `address_lines`.
	Locality string `json:"locality,omitempty"`
	// Organization: Optional. The name of the organization at the address.
	Organization string `json:"organization,omitempty"`
	// PostalCode: Optional. Postal code of the address. Not all countries use or
	// require postal codes to be present, but where they are used, they may
	// trigger additional validation with other parts of the address (for example,
	// state or zip code validation in the United States).
	PostalCode string `json:"postalCode,omitempty"`
	// Recipients: Optional. The recipient at the address. This field may, under
	// certain circumstances, contain multiline information. For example, it might
	// contain "care of" information.
	Recipients []string `json:"recipients,omitempty"`
	// RegionCode: Required. CLDR region code of the country/region of the address.
	// This is never inferred and it is up to the user to ensure the value is
	// correct. See https://cldr.unicode.org/ and
	// https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
	// for details. Example: "CH" for Switzerland.
	RegionCode string `json:"regionCode,omitempty"`
	// Revision: The schema revision of the `PostalAddress`. This must be set to 0,
	// which is the latest revision. All new revisions **must** be backward
	// compatible with old revisions.
	Revision int64 `json:"revision,omitempty"`
	// SortingCode: Optional. Additional, country-specific, sorting code. This is
	// not used in most regions. Where it is used, the value is either a string
	// like "CEDEX", optionally followed by a number (for example, "CEDEX 7"), or
	// just a number alone, representing the "sector code" (Jamaica), "delivery
	// area indicator" (Malawi) or "post office indicator" (Côte d'Ivoire).
	SortingCode string `json:"sortingCode,omitempty"`
	// Sublocality: Optional. Sublocality of the address. For example, this can be
	// a neighborhood, borough, or district.
	Sublocality string `json:"sublocality,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressLines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressLines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypePostalAddress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypePostalAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeTimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type GoogleTypeTimeZone struct {
	// Id: IANA Time Zone Database time zone. For example "America/New_York".
	Id string `json:"id,omitempty"`
	// Version: Optional. IANA Time Zone Database version number. For example
	// "2019a".
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeTimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeTimeZone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *OperationsService) Delete(name string) *OperationsDeleteCall {
	c := &OperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OperationsDeleteCall) Fields(s ...googleapi.Field) *OperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OperationsDeleteCall) Context(ctx context.Context) *OperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OperationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFetchProcessorTypesCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchProcessorTypes: Fetches processor types. Note that we don't use
// ListProcessorTypes here, because it isn't paginated.
//
//   - parent: The location of processor types to list. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsService) FetchProcessorTypes(parent string) *ProjectsLocationsFetchProcessorTypesCall {
	c := &ProjectsLocationsFetchProcessorTypesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFetchProcessorTypesCall) Fields(s ...googleapi.Field) *ProjectsLocationsFetchProcessorTypesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsFetchProcessorTypesCall) IfNoneMatch(entityTag string) *ProjectsLocationsFetchProcessorTypesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFetchProcessorTypesCall) Context(ctx context.Context) *ProjectsLocationsFetchProcessorTypesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFetchProcessorTypesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFetchProcessorTypesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:fetchProcessorTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.fetchProcessorTypes", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.fetchProcessorTypes" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1FetchProcessorTypesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsFetchProcessorTypesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1FetchProcessorTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1FetchProcessorTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.fetchProcessorTypes", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationLocation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationLocation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationLocation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Unless
// explicitly documented otherwise, don't use this unsupported field which is
// primarily intended for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationListLocationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*GoogleCloudLocationListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsCancelCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsProcessorTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a processor type detail.
//
// - name: The processor type resource name.
func (r *ProjectsLocationsProcessorTypesService) Get(name string) *ProjectsLocationsProcessorTypesGetCall {
	c := &ProjectsLocationsProcessorTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorTypesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsProcessorTypesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorTypesGetCall) Context(ctx context.Context) *ProjectsLocationsProcessorTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processorTypes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processorTypes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1ProcessorType.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorTypesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1ProcessorType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1ProcessorType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processorTypes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the processor types that exist.
//
//   - parent: The location of processor types to list. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsProcessorTypesService) List(parent string) *ProjectsLocationsProcessorTypesListCall {
	c := &ProjectsLocationsProcessorTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// processor types to return. If unspecified, at most `100` processor types
// will be returned. The maximum value is `500`. Values above `500` will be
// coerced to `500`.
func (c *ProjectsLocationsProcessorTypesListCall) PageSize(pageSize int64) *ProjectsLocationsProcessorTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Used to retrieve the next
// page of results, empty if at the end of the list.
func (c *ProjectsLocationsProcessorTypesListCall) PageToken(pageToken string) *ProjectsLocationsProcessorTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorTypesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsProcessorTypesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorTypesListCall) Context(ctx context.Context) *ProjectsLocationsProcessorTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/processorTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processorTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processorTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1ListProcessorTypesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorTypesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1ListProcessorTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1ListProcessorTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processorTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsProcessorTypesListCall) Pages(ctx context.Context, f func(*GoogleCloudDocumentaiV1ListProcessorTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsProcessorsBatchProcessCall struct {
	s                                          *Service
	name                                       string
	googleclouddocumentaiv1batchprocessrequest *GoogleCloudDocumentaiV1BatchProcessRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// BatchProcess: LRO endpoint to batch process many documents. The output is
// written to Cloud Storage as JSON in the [Document] format.
//
//   - name: The resource name of Processor or ProcessorVersion. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`, or
//     `projects/{project}/locations/{location}/processors/{processor}/processorVe
//     rsions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsService) BatchProcess(name string, googleclouddocumentaiv1batchprocessrequest *GoogleCloudDocumentaiV1BatchProcessRequest) *ProjectsLocationsProcessorsBatchProcessCall {
	c := &ProjectsLocationsProcessorsBatchProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1batchprocessrequest = googleclouddocumentaiv1batchprocessrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsBatchProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsBatchProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsBatchProcessCall) Context(ctx context.Context) *ProjectsLocationsProcessorsBatchProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsBatchProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsBatchProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1batchprocessrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:batchProcess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.batchProcess", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.batchProcess" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsBatchProcessCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.batchProcess", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsCreateCall struct {
	s                                *Service
	parent                           string
	googleclouddocumentaiv1processor *GoogleCloudDocumentaiV1Processor
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Create: Creates a processor from the ProcessorType provided. The processor
// will be at `ENABLED` state by default after its creation. Note that this
// method requires the `documentai.processors.create` permission on the
// project, which is highly privileged. A user or service account with this
// permission can create new processors that can interact with any gcs bucket
// in your project.
//
//   - parent: The parent (project and location) under which to create the
//     processor. Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsProcessorsService) Create(parent string, googleclouddocumentaiv1processor *GoogleCloudDocumentaiV1Processor) *ProjectsLocationsProcessorsCreateCall {
	c := &ProjectsLocationsProcessorsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddocumentaiv1processor = googleclouddocumentaiv1processor
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsCreateCall) Context(ctx context.Context) *ProjectsLocationsProcessorsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1processor)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/processors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1Processor.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1Processor, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1Processor{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the processor, unloads all deployed model artifacts if it
// was enabled and then deletes all artifacts associated with this processor.
//
// - name: The processor resource name to be deleted.
func (r *ProjectsLocationsProcessorsService) Delete(name string) *ProjectsLocationsProcessorsDeleteCall {
	c := &ProjectsLocationsProcessorsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsDeleteCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsDisableCall struct {
	s                                              *Service
	name                                           string
	googleclouddocumentaiv1disableprocessorrequest *GoogleCloudDocumentaiV1DisableProcessorRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Disable: Disables a processor
//
// - name: The processor resource name to be disabled.
func (r *ProjectsLocationsProcessorsService) Disable(name string, googleclouddocumentaiv1disableprocessorrequest *GoogleCloudDocumentaiV1DisableProcessorRequest) *ProjectsLocationsProcessorsDisableCall {
	c := &ProjectsLocationsProcessorsDisableCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1disableprocessorrequest = googleclouddocumentaiv1disableprocessorrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsDisableCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDisableCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsDisableCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDisableCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsDisableCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDisableCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1disableprocessorrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:disable")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.disable", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.disable" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsDisableCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.disable", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsEnableCall struct {
	s                                             *Service
	name                                          string
	googleclouddocumentaiv1enableprocessorrequest *GoogleCloudDocumentaiV1EnableProcessorRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Enable: Enables a processor
//
// - name: The processor resource name to be enabled.
func (r *ProjectsLocationsProcessorsService) Enable(name string, googleclouddocumentaiv1enableprocessorrequest *GoogleCloudDocumentaiV1EnableProcessorRequest) *ProjectsLocationsProcessorsEnableCall {
	c := &ProjectsLocationsProcessorsEnableCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1enableprocessorrequest = googleclouddocumentaiv1enableprocessorrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsEnableCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsEnableCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsEnableCall) Context(ctx context.Context) *ProjectsLocationsProcessorsEnableCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsEnableCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsEnableCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1enableprocessorrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:enable")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.enable", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.enable" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsEnableCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.enable", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a processor detail.
//
// - name: The processor resource name.
func (r *ProjectsLocationsProcessorsService) Get(name string) *ProjectsLocationsProcessorsGetCall {
	c := &ProjectsLocationsProcessorsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsProcessorsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsGetCall) Context(ctx context.Context) *ProjectsLocationsProcessorsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1Processor.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1Processor, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1Processor{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all processors which belong to this project.
//
//   - parent: The parent (project and location) which owns this collection of
//     Processors. Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsProcessorsService) List(parent string) *ProjectsLocationsProcessorsListCall {
	c := &ProjectsLocationsProcessorsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// processors to return. If unspecified, at most `50` processors will be
// returned. The maximum value is `100`. Values above `100` will be coerced to
// `100`.
func (c *ProjectsLocationsProcessorsListCall) PageSize(pageSize int64) *ProjectsLocationsProcessorsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": We will return the
// processors sorted by creation time. The page token will point to the next
// processor.
func (c *ProjectsLocationsProcessorsListCall) PageToken(pageToken string) *ProjectsLocationsProcessorsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsProcessorsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsListCall) Context(ctx context.Context) *ProjectsLocationsProcessorsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/processors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1ListProcessorsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1ListProcessorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1ListProcessorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsProcessorsListCall) Pages(ctx context.Context, f func(*GoogleCloudDocumentaiV1ListProcessorsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsProcessorsProcessCall struct {
	s                                     *Service
	name                                  string
	googleclouddocumentaiv1processrequest *GoogleCloudDocumentaiV1ProcessRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Process: Processes a single document.
//
//   - name: The resource name of the Processor or ProcessorVersion to use for
//     processing. If a Processor is specified, the server will use its default
//     version. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`, or
//     `projects/{project}/locations/{location}/processors/{processor}/processorVe
//     rsions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsService) Process(name string, googleclouddocumentaiv1processrequest *GoogleCloudDocumentaiV1ProcessRequest) *ProjectsLocationsProcessorsProcessCall {
	c := &ProjectsLocationsProcessorsProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1processrequest = googleclouddocumentaiv1processrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1processrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:process")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.process", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.process" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1ProcessResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1ProcessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1ProcessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.process", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsSetDefaultProcessorVersionCall struct {
	s                                                        *Service
	processor                                                string
	googleclouddocumentaiv1setdefaultprocessorversionrequest *GoogleCloudDocumentaiV1SetDefaultProcessorVersionRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// SetDefaultProcessorVersion: Set the default (active) version of a Processor
// that will be used in ProcessDocument and BatchProcessDocuments.
//
// - processor: The resource name of the Processor to change default version.
func (r *ProjectsLocationsProcessorsService) SetDefaultProcessorVersion(processor string, googleclouddocumentaiv1setdefaultprocessorversionrequest *GoogleCloudDocumentaiV1SetDefaultProcessorVersionRequest) *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall {
	c := &ProjectsLocationsProcessorsSetDefaultProcessorVersionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.processor = processor
	c.googleclouddocumentaiv1setdefaultprocessorversionrequest = googleclouddocumentaiv1setdefaultprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) Context(ctx context.Context) *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1setdefaultprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+processor}:setDefaultProcessorVersion")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"processor": c.processor,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.setDefaultProcessorVersion", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.setDefaultProcessorVersion" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.setDefaultProcessorVersion", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall struct {
	s                                            *Service
	humanReviewConfig                            string
	googleclouddocumentaiv1reviewdocumentrequest *GoogleCloudDocumentaiV1ReviewDocumentRequest
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// ReviewDocument: Send a document for Human Review. The input document should
// be processed by the specified processor.
//
//   - humanReviewConfig: The resource name of the HumanReviewConfig that the
//     document will be reviewed with.
func (r *ProjectsLocationsProcessorsHumanReviewConfigService) ReviewDocument(humanReviewConfig string, googleclouddocumentaiv1reviewdocumentrequest *GoogleCloudDocumentaiV1ReviewDocumentRequest) *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall {
	c := &ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.humanReviewConfig = humanReviewConfig
	c.googleclouddocumentaiv1reviewdocumentrequest = googleclouddocumentaiv1reviewdocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) Context(ctx context.Context) *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1reviewdocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+humanReviewConfig}:reviewDocument")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"humanReviewConfig": c.humanReviewConfig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.humanReviewConfig.reviewDocument", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.humanReviewConfig.reviewDocument" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.humanReviewConfig.reviewDocument", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall struct {
	s                                          *Service
	name                                       string
	googleclouddocumentaiv1batchprocessrequest *GoogleCloudDocumentaiV1BatchProcessRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// BatchProcess: LRO endpoint to batch process many documents. The output is
// written to Cloud Storage as JSON in the [Document] format.
//
//   - name: The resource name of Processor or ProcessorVersion. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`, or
//     `projects/{project}/locations/{location}/processors/{processor}/processorVe
//     rsions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) BatchProcess(name string, googleclouddocumentaiv1batchprocessrequest *GoogleCloudDocumentaiV1BatchProcessRequest) *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1batchprocessrequest = googleclouddocumentaiv1batchprocessrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1batchprocessrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:batchProcess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.batchProcess", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.batchProcess" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.batchProcess", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the processor version, all artifacts under the processor
// version will be deleted.
//
// - name: The processor version resource name to be deleted.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Delete(name string) *ProjectsLocationsProcessorsProcessorVersionsDeleteCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsDeployCall struct {
	s                                                    *Service
	name                                                 string
	googleclouddocumentaiv1deployprocessorversionrequest *GoogleCloudDocumentaiV1DeployProcessorVersionRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// Deploy: Deploys the processor version.
//
// - name: The processor version resource name to be deployed.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Deploy(name string, googleclouddocumentaiv1deployprocessorversionrequest *GoogleCloudDocumentaiV1DeployProcessorVersionRequest) *ProjectsLocationsProcessorsProcessorVersionsDeployCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsDeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1deployprocessorversionrequest = googleclouddocumentaiv1deployprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsDeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsDeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1deployprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:deploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.deploy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.deploy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.deploy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall struct {
	s                                                      *Service
	processorVersion                                       string
	googleclouddocumentaiv1evaluateprocessorversionrequest *GoogleCloudDocumentaiV1EvaluateProcessorVersionRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// EvaluateProcessorVersion: Evaluates a ProcessorVersion against annotated
// documents, producing an Evaluation.
//
//   - processorVersion: The resource name of the ProcessorVersion to evaluate.
//     `projects/{project}/locations/{location}/processors/{processor}/processorVe
//     rsions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) EvaluateProcessorVersion(processorVersion string, googleclouddocumentaiv1evaluateprocessorversionrequest *GoogleCloudDocumentaiV1EvaluateProcessorVersionRequest) *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.processorVersion = processorVersion
	c.googleclouddocumentaiv1evaluateprocessorversionrequest = googleclouddocumentaiv1evaluateprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1evaluateprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+processorVersion}:evaluateProcessorVersion")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"processorVersion": c.processorVersion,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.evaluateProcessorVersion", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.evaluateProcessorVersion" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.evaluateProcessorVersion", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a processor version detail.
//
// - name: The processor resource name.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Get(name string) *ProjectsLocationsProcessorsProcessorVersionsGetCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsProcessorVersionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1ProcessorVersion.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1ProcessorVersion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1ProcessorVersion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all versions of a processor.
//
//   - parent: The parent (project, location and processor) to list all versions.
//     Format: `projects/{project}/locations/{location}/processors/{processor}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) List(parent string) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// processor versions to return. If unspecified, at most `10` processor
// versions will be returned. The maximum value is `20`. Values above `20` will
// be coerced to `20`.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": We will return the
// processor versions sorted by creation time. The page token will point to the
// next processor version.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) PageToken(pageToken string) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/processorVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1ListProcessorVersionsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1ListProcessorVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1ListProcessorVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Pages(ctx context.Context, f func(*GoogleCloudDocumentaiV1ListProcessorVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsProcessorsProcessorVersionsProcessCall struct {
	s                                     *Service
	name                                  string
	googleclouddocumentaiv1processrequest *GoogleCloudDocumentaiV1ProcessRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Process: Processes a single document.
//
//   - name: The resource name of the Processor or ProcessorVersion to use for
//     processing. If a Processor is specified, the server will use its default
//     version. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`, or
//     `projects/{project}/locations/{location}/processors/{processor}/processorVe
//     rsions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Process(name string, googleclouddocumentaiv1processrequest *GoogleCloudDocumentaiV1ProcessRequest) *ProjectsLocationsProcessorsProcessorVersionsProcessCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1processrequest = googleclouddocumentaiv1processrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1processrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:process")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.process", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.process" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1ProcessResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1ProcessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1ProcessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.process", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsTrainCall struct {
	s                                                   *Service
	parent                                              string
	googleclouddocumentaiv1trainprocessorversionrequest *GoogleCloudDocumentaiV1TrainProcessorVersionRequest
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Train: Trains a new processor version. Operation metadata is returned as
// TrainProcessorVersionMetadata.
//
//   - parent: The parent (project, location and processor) to create the new
//     version for. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Train(parent string, googleclouddocumentaiv1trainprocessorversionrequest *GoogleCloudDocumentaiV1TrainProcessorVersionRequest) *ProjectsLocationsProcessorsProcessorVersionsTrainCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsTrainCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddocumentaiv1trainprocessorversionrequest = googleclouddocumentaiv1trainprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsTrainCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsTrainCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1trainprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/processorVersions:train")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.train", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.train" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.train", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsUndeployCall struct {
	s                                                      *Service
	name                                                   string
	googleclouddocumentaiv1undeployprocessorversionrequest *GoogleCloudDocumentaiV1UndeployProcessorVersionRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// Undeploy: Undeploys the processor version.
//
// - name: The processor version resource name to be undeployed.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Undeploy(name string, googleclouddocumentaiv1undeployprocessorversionrequest *GoogleCloudDocumentaiV1UndeployProcessorVersionRequest) *ProjectsLocationsProcessorsProcessorVersionsUndeployCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsUndeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1undeployprocessorversionrequest = googleclouddocumentaiv1undeployprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsUndeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsUndeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1undeployprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:undeploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.undeploy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.undeploy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.undeploy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a specific evaluation.
//
//   - name: The resource name of the Evaluation to get.
//     `projects/{project}/locations/{location}/processors/{processor}/processorVe
//     rsions/{processorVersion}/evaluations/{evaluation}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsEvaluationsService) Get(name string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.evaluations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.evaluations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1Evaluation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1Evaluation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1Evaluation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.evaluations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a set of evaluations for a given processor version.
//
//   - parent: The resource name of the ProcessorVersion to list evaluations for.
//     `projects/{project}/locations/{location}/processors/{processor}/processorVe
//     rsions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsEvaluationsService) List(parent string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size. If unspecified, at most `5` evaluations are returned. The maximum
// value is `100`. Values above `100` are coerced to `100`.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) PageSize(pageSize int64) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListEvaluations` call. Provide this to retrieve the
// subsequent page.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) PageToken(pageToken string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/evaluations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.evaluations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.evaluations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1ListEvaluationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1ListEvaluationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1ListEvaluationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.processors.processorVersions.evaluations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Pages(ctx context.Context, f func(*GoogleCloudDocumentaiV1ListEvaluationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsOperationsService) Get(name string) *ProjectsOperationsGetCall {
	c := &ProjectsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsOperationsGetCall) Context(ctx context.Context) *ProjectsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
