/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class IvyArtifactNameSerializer
extends AbstractSerializer<IvyArtifactName> {
    public static final IvyArtifactNameSerializer INSTANCE = new IvyArtifactNameSerializer();

    private IvyArtifactNameSerializer() {
    }

    public IvyArtifactName read(Decoder decoder) throws IOException {
        String artifactName = decoder.readString();
        String type = decoder.readString();
        String extension = decoder.readNullableString();
        String classifier = decoder.readNullableString();
        return new DefaultIvyArtifactName(artifactName, type, extension, classifier);
    }

    public void write(Encoder encoder, IvyArtifactName value) throws IOException {
        encoder.writeString((CharSequence)value.getName());
        encoder.writeString((CharSequence)value.getType());
        encoder.writeNullableString((CharSequence)value.getExtension());
        encoder.writeNullableString((CharSequence)value.getClassifier());
    }

    public void writeNullable(Encoder encoder, @Nullable IvyArtifactName value) throws IOException {
        if (value == null) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            this.write(encoder, value);
        }
    }

    @Nullable
    public IvyArtifactName readNullable(Decoder decoder) throws IOException {
        boolean hasArtifact = decoder.readBoolean();
        if (hasArtifact) {
            return this.read(decoder);
        }
        return null;
    }
}

