/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnSealedExhaustivenessChecker;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\fH\u0007J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\fH\u0007J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!J \u0010\"\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u000f\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010%\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenChecker;", "", "<init>", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "getClassIdForTypeIfEnum", "Lorg/jetbrains/kotlin/name/ClassId;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getClassDescriptorOfTypeIfEnum", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptorOfTypeIfSealed", "whenSubjectType", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getEnumMissingCases", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "enumClassDescriptor", "getSealedMissingCases", "sealedClassDescriptor", "getMissingCases", "isWhenExhaustive", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "containsNullCase", "checkDuplicatedLabels", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isTrivial", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkDeprecatedWhenSyntax", "checkSealedWhenIsReserved", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "element", "Lcom/intellij/psi/PsiElement;", "frontend"})
@SourceDebugExtension(value={"SMAP\nWhenChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhenChecker.kt\norg/jetbrains/kotlin/cfg/WhenChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,472:1\n1#2:473\n774#3:474\n865#3,2:475\n1563#3:477\n1634#3,3:478\n*S KotlinDebug\n*F\n+ 1 WhenChecker.kt\norg/jetbrains/kotlin/cfg/WhenChecker\n*L\n329#1:474\n329#1:475,2\n331#1:477\n331#1:478,3\n*E\n"})
public final class WhenChecker {
    @NotNull
    public static final WhenChecker INSTANCE = new WhenChecker();
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    private WhenChecker() {
    }

    @JvmStatic
    @Nullable
    public static final ClassId getClassIdForTypeIfEnum(@Nullable KotlinType type) {
        ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(type);
        return classDescriptor != null ? DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor) : null;
    }

    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable KotlinType type) {
        if (type == null) {
            return null;
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2.getKind() != ClassKind.ENUM_CLASS) {
            return null;
        }
        return classDescriptor2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfSealed(@Nullable KotlinType type) {
        Annotated annotated;
        KotlinType kotlinType = type;
        Annotated annotated2 = kotlinType;
        if (kotlinType == null) return null;
        KotlinType it = annotated2;
        boolean bl = false;
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(it);
        annotated2 = classDescriptor;
        if (classDescriptor == null) return null;
        it = annotated = annotated2;
        boolean bl2 = false;
        if (!DescriptorUtils.isSealedClass((DeclarationDescriptor)((Object)it))) return null;
        Annotated annotated3 = annotated;
        return annotated3;
    }

    @JvmStatic
    @Nullable
    public static final KotlinType whenSubjectType(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        KtProperty subjectVariable = expression2.getSubjectVariable();
        KtExpression subjectExpression = expression2.getSubjectExpression();
        if (subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)context2.get(BindingContext.VARIABLE, subjectVariable);
            object = variableDescriptor != null ? variableDescriptor.getType() : null;
        } else if (subjectExpression != null) {
            object = (ExplicitSmartCasts)context2.get(BindingContext.SMARTCAST, subjectExpression);
            if (object == null || (object = object.getDefaultType()) == null) {
                object = context2.getType(subjectExpression);
            }
        } else {
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getEnumMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, @NotNull ClassDescriptor enumClassDescriptor) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(enumClassDescriptor, "enumClassDescriptor");
        return WhenOnEnumExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, enumClassDescriptor, false);
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getSealedMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, @NotNull ClassDescriptor sealedClassDescriptor) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(sealedClassDescriptor, "sealedClassDescriptor");
        return WhenOnSealedExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, sealedClassDescriptor, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        void $this$mapTo$iv$iv;
        WhenExhaustivenessChecker it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        KotlinType kotlinType = WhenChecker.whenSubjectType(expression2, context2);
        if (kotlinType == null) {
            return CollectionsKt.listOf(WhenMissingCase.Unknown.INSTANCE);
        }
        KotlinType type = kotlinType;
        boolean nullable = type.isMarkedNullable();
        Iterable $this$filter$iv = exhaustivenessCheckers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WhenExhaustivenessChecker)element$iv$iv;
            boolean bl = false;
            if (!it.isApplicable(type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List checkers = (List)destination$iv$iv;
        if (checkers.isEmpty()) {
            return CollectionsKt.listOf(WhenMissingCase.Unknown.INSTANCE);
        }
        Iterable $this$map$iv = checkers;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WhenExhaustivenessChecker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMissingCases(expression2, context2, TypeUtils.getClassDescriptor(type), nullable));
        }
        return CollectionsKt.flatten((List)destination$iv$iv);
    }

    @JvmStatic
    public static final boolean isWhenExhaustive(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(trace, "trace");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        if (INSTANCE.getMissingCases(expression2, bindingContext).isEmpty()) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean containsNullCase(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        return WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, true).isEmpty();
    }

    public final void checkDuplicatedLabels(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (expression2.getSubjectExpression() == null) {
            return;
        }
        HashSet<Pair<KotlinType, Boolean>> checkedTypes = new HashSet<Pair<KotlinType, Boolean>>();
        Map checkedConstants = new LinkedHashMap();
        Map notTrivialBranches = new LinkedHashMap();
        for (KtWhenEntry entry : expression2.getEntries()) {
            if (entry.isElse()) continue;
            for (KtWhenCondition condition : entry.getConditions()) {
                KotlinType type;
                KtTypeReference typeReference;
                KtWhenCondition ktWhenCondition = condition;
                if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
                    boolean isTrivial;
                    CompileTimeConstant<?> constant;
                    KtExpression constantExpression;
                    if (((KtWhenConditionWithExpression)condition).getExpression() == null) continue;
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                    if (ConstantExpressionEvaluator.Companion.getConstant(constantExpression, bindingContext) == null) continue;
                    Boolean bl = (Boolean)checkedConstants.get(constant);
                    if (Intrinsics.areEqual(bl, true)) {
                        WhenChecker.checkDuplicatedLabels$report(trace, constantExpression);
                        continue;
                    }
                    if (Intrinsics.areEqual(bl, false)) {
                        isTrivial = this.isTrivial(constant, constantExpression, languageVersionSettings);
                        if (isTrivial) {
                            Object v2 = notTrivialBranches.remove(constant);
                            Intrinsics.checkNotNull(v2);
                            KtExpression reportOn = (KtExpression)v2;
                            WhenChecker.checkDuplicatedLabels$report(trace, reportOn);
                            checkedConstants.put(constant, true);
                            continue;
                        }
                        WhenChecker.checkDuplicatedLabels$report(trace, constantExpression);
                        continue;
                    }
                    if (bl == null) {
                        isTrivial = this.isTrivial(constant, constantExpression, languageVersionSettings);
                        checkedConstants.put(constant, isTrivial);
                        if (isTrivial) continue;
                        notTrivialBranches.put(constant, constantExpression);
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                if (!(ktWhenCondition instanceof KtWhenConditionIsPattern) || ((KtWhenConditionIsPattern)condition).getTypeReference() == null || (KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) continue;
                Pair<KotlinType, Boolean> typeWithIsNegation = TuplesKt.to(type, ((KtWhenConditionIsPattern)condition).isNegated());
                if (checkedTypes.contains(typeWithIsNegation)) {
                    trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on(typeReference));
                    continue;
                }
                checkedTypes.add(typeWithIsNegation);
            }
        }
    }

    private final boolean isTrivial(CompileTimeConstant<?> $this$isTrivial, KtExpression expression2, LanguageVersionSettings languageVersionSettings) {
        if ($this$isTrivial.getUsesVariableAsConstant()) {
            return false;
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSimplificationOfNonTrivialConstBooleanExpressions)) {
            return !ConstantExpressionEvaluator.Companion.isComplexBooleanConstant(expression2, $this$isTrivial);
        }
        return true;
    }

    public final void checkDeprecatedWhenSyntax(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (expression2.getSubjectExpression() != null) {
            return;
        }
        block0: for (KtWhenEntry entry : expression2.getEntries()) {
            if (entry.isElse()) continue;
            for (PsiElement child = entry.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNode().getElementType() == KtTokens.COMMA) {
                    trace.report(Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT.on(child));
                }
                if (child.getNode().getElementType() == KtTokens.ARROW) continue block0;
            }
        }
    }

    public final void checkSealedWhenIsReserved(@NotNull DiagnosticSink sink, @NotNull PsiElement element) {
        block0: {
            Intrinsics.checkNotNullParameter(sink, "sink");
            Intrinsics.checkNotNullParameter(element, "element");
            PsiElement psiElement = KtPsiUtil.getPreviousWord(element, "sealed");
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl = false;
            sink.report(Errors.UNSUPPORTED_SEALED_WHEN.on(it));
        }
    }

    private static final void checkDuplicatedLabels$report(BindingTrace $trace, KtExpression reportOn) {
        $trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on(reportOn));
    }

    static {
        WhenExhaustivenessChecker[] whenExhaustivenessCheckerArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf(whenExhaustivenessCheckerArray);
    }
}

