/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.email;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.pentaho.reporting.libraries.repository.email.EmailContentItem;
import org.pentaho.reporting.libraries.repository.email.EmailRepository;

public class EmailEntryOutputStream
extends OutputStream {
    private ByteArrayOutputStream outputStream;
    private boolean closed;
    private EmailContentItem item;

    public EmailEntryOutputStream(EmailContentItem item) {
        this.item = item;
        this.outputStream = new ByteArrayOutputStream();
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.outputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.outputStream.write(b, off, len);
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.outputStream.close();
        byte[] data = this.outputStream.toByteArray();
        EmailRepository repository = (EmailRepository)this.item.getRepository();
        try {
            if (repository.isTreatHtmlContentAsBody() && this.item.getMimeType().endsWith("text/html")) {
                MimeBodyPart messageBodyPart = repository.getBodypart();
                ByteArrayDataSource dataSource = new ByteArrayDataSource(data, this.item.getMimeType());
                messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
            } else {
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                String contentId = (String)this.item.getContentId();
                ByteArrayDataSource dataSource = new ByteArrayDataSource((InputStream)bin, this.item.getMimeType());
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                messageBodyPart.setHeader("Content-ID", contentId);
                repository.getMultipart().addBodyPart((BodyPart)messageBodyPart);
                bin.close();
            }
        }
        catch (Exception e) {
            throw new IOException("Error closing stream: " + e.getMessage());
        }
        this.closed = true;
    }

    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.outputStream.write(b);
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.outputStream.flush();
    }
}

