/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjdoc;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.javacc.jjdoc.Generator;
import org.javacc.jjdoc.HTMLGenerator;
import org.javacc.jjdoc.JJDocGlobals;
import org.javacc.parser.Action;
import org.javacc.parser.BNFProduction;
import org.javacc.parser.CharacterRange;
import org.javacc.parser.Choice;
import org.javacc.parser.Expansion;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.JavaCCParserInternals;
import org.javacc.parser.JavaCodeProduction;
import org.javacc.parser.Lookahead;
import org.javacc.parser.NonTerminal;
import org.javacc.parser.NormalProduction;
import org.javacc.parser.OneOrMore;
import org.javacc.parser.Options;
import org.javacc.parser.RCharacterList;
import org.javacc.parser.RChoice;
import org.javacc.parser.REndOfFile;
import org.javacc.parser.RJustName;
import org.javacc.parser.ROneOrMore;
import org.javacc.parser.RSequence;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.RZeroOrMore;
import org.javacc.parser.RZeroOrOne;
import org.javacc.parser.RegularExpression;
import org.javacc.parser.Sequence;
import org.javacc.parser.SingleCharacter;
import org.javacc.parser.Token;
import org.javacc.parser.TokenProduction;
import org.javacc.parser.TryBlock;
import org.javacc.parser.ZeroOrMore;
import org.javacc.parser.ZeroOrOne;

public class JJDoc
extends JavaCCGlobals {
    static void start() {
        PrintWriter pw = JJDoc.create_output_stream();
        Generator gen = Options.B("TEXT") ? new Generator(pw) : new HTMLGenerator(pw);
        gen.documentStart();
        JJDoc.emitTokenProductions(gen, JavaCCGlobals.rexprlist);
        JJDoc.emitNormalProductions(gen, JavaCCGlobals.bnfproductions);
        gen.documentEnd();
        pw.close();
    }

    private static Token getPrecedingSpecialToken(Token tok) {
        Token t = tok;
        while (t.specialToken != null) {
            t = t.specialToken;
        }
        return t != tok ? t : null;
    }

    private static void emitTopLevelSpecialTokens(Token tok, Generator gen) {
        if (tok == null) {
            return;
        }
        tok = JJDoc.getPrecedingSpecialToken(tok);
        String s = "";
        if (tok != null) {
            JavaCCGlobals.cline = tok.beginLine;
            JavaCCGlobals.ccol = tok.beginColumn;
            while (tok != null) {
                s = s + JavaCCGlobals.printTokenOnly(tok);
                tok = tok.next;
            }
        }
        gen.specialTokens(s);
    }

    private static boolean toplevelExpansion(Expansion exp) {
        return exp.parent != null && (exp.parent instanceof NormalProduction || exp.parent instanceof TokenProduction);
    }

    private static void emitTokenProductions(Generator gen, Vector prods) {
        Enumeration enumeration = prods.elements();
        while (enumeration.hasMoreElements()) {
            TokenProduction tokenProduction = (TokenProduction)enumeration.nextElement();
        }
    }

    private static void emitNormalProductions(Generator gen, Vector prods) {
        gen.nonterminalsStart();
        Enumeration enumeration = prods.elements();
        while (enumeration.hasMoreElements()) {
            NormalProduction np = (NormalProduction)enumeration.nextElement();
            JJDoc.emitTopLevelSpecialTokens(np.firstToken, gen);
            if (np instanceof BNFProduction) {
                gen.productionStart(np);
                if (np.expansion instanceof Choice) {
                    boolean first = true;
                    Choice c = (Choice)np.expansion;
                    Enumeration enume = c.choices.elements();
                    while (enume.hasMoreElements()) {
                        Expansion e = (Expansion)enume.nextElement();
                        gen.expansionStart(e, first);
                        JJDoc.emitExpansionTree(e, gen);
                        gen.expansionEnd(e, first);
                        first = false;
                    }
                } else {
                    gen.expansionStart(np.expansion, true);
                    JJDoc.emitExpansionTree(np.expansion, gen);
                    gen.expansionEnd(np.expansion, true);
                }
                gen.productionEnd(np);
                continue;
            }
            if (!(np instanceof JavaCodeProduction)) continue;
            gen.javacode((JavaCodeProduction)np);
        }
        gen.nonterminalsEnd();
    }

    private static void emitExpansionTree(Expansion exp, Generator gen) {
        if (exp instanceof Action) {
            JJDoc.emitExpansionAction((Action)exp, gen);
        } else if (exp instanceof Choice) {
            JJDoc.emitExpansionChoice((Choice)exp, gen);
        } else if (exp instanceof Lookahead) {
            JJDoc.emitExpansionLookahead((Lookahead)exp, gen);
        } else if (exp instanceof NonTerminal) {
            JJDoc.emitExpansionNonTerminal((NonTerminal)exp, gen);
        } else if (exp instanceof OneOrMore) {
            JJDoc.emitExpansionOneOrMore((OneOrMore)exp, gen);
        } else if (exp instanceof RegularExpression) {
            JJDoc.emitExpansionRegularExpression((RegularExpression)exp, gen);
        } else if (exp instanceof Sequence) {
            JJDoc.emitExpansionSequence((Sequence)exp, gen);
        } else if (exp instanceof TryBlock) {
            JJDoc.emitExpansionTryBlock((TryBlock)exp, gen);
        } else if (exp instanceof ZeroOrMore) {
            JJDoc.emitExpansionZeroOrMore((ZeroOrMore)exp, gen);
        } else if (exp instanceof ZeroOrOne) {
            JJDoc.emitExpansionZeroOrOne((ZeroOrOne)exp, gen);
        } else {
            System.out.println("Oops: Unknown expansion type.");
        }
    }

    private static void emitExpansionAction(Action a, Generator gen) {
    }

    private static void emitExpansionChoice(Choice c, Generator gen) {
        Enumeration enumeration = c.choices.elements();
        while (enumeration.hasMoreElements()) {
            Expansion e = (Expansion)enumeration.nextElement();
            JJDoc.emitExpansionTree(e, gen);
            if (!enumeration.hasMoreElements()) continue;
            gen.text(" | ");
        }
    }

    private static void emitExpansionLookahead(Lookahead l, Generator gen) {
    }

    private static void emitExpansionNonTerminal(NonTerminal nt, Generator gen) {
        gen.nonTerminalStart(nt);
        gen.text(nt.name);
        gen.nonTerminalEnd(nt);
    }

    private static void emitExpansionOneOrMore(OneOrMore o, Generator gen) {
        gen.text("( ");
        JJDoc.emitExpansionTree(o.expansion, gen);
        gen.text(" )+");
    }

    private static void emitExpansionRegularExpression(RegularExpression r, Generator gen) {
        gen.reStart(r);
        JJDoc.emitRE(r, gen);
        gen.reEnd(r);
    }

    private static void emitExpansionSequence(Sequence s, Generator gen) {
        boolean firstUnit = true;
        Enumeration enumeration = s.units.elements();
        while (enumeration.hasMoreElements()) {
            boolean needParens;
            Expansion e = (Expansion)enumeration.nextElement();
            if (e instanceof Lookahead || e instanceof Action) continue;
            if (!firstUnit) {
                gen.text(" ");
            }
            boolean bl = needParens = e instanceof Choice || e instanceof Sequence;
            if (needParens) {
                gen.text("( ");
            }
            JJDoc.emitExpansionTree(e, gen);
            if (needParens) {
                gen.text(" )");
            }
            firstUnit = false;
        }
    }

    private static void emitExpansionTryBlock(TryBlock t, Generator gen) {
        boolean needParens = t.exp instanceof Choice;
        if (needParens) {
            gen.text("( ");
        }
        JJDoc.emitExpansionTree(t.exp, gen);
        if (needParens) {
            gen.text(" )");
        }
    }

    private static void emitExpansionZeroOrMore(ZeroOrMore z, Generator gen) {
        gen.text("( ");
        JJDoc.emitExpansionTree(z.expansion, gen);
        gen.text(" )*");
    }

    private static void emitExpansionZeroOrOne(ZeroOrOne z, Generator gen) {
        gen.text("( ");
        JJDoc.emitExpansionTree(z.expansion, gen);
        gen.text(" )?");
    }

    private static void emitRE(RegularExpression re, Generator gen) {
        boolean needBrackets;
        boolean hasLabel = !re.label.equals("");
        boolean justName = re instanceof RJustName;
        boolean eof = re instanceof REndOfFile;
        boolean isString = re instanceof RStringLiteral;
        boolean toplevelRE = re.tpContext != null;
        boolean bl = needBrackets = justName || eof || hasLabel || !isString && toplevelRE;
        if (needBrackets) {
            gen.text("<");
            if (!justName) {
                if (re.private_rexp) {
                    gen.text("#");
                }
                if (hasLabel) {
                    gen.text(re.label);
                    gen.text(": ");
                }
            }
        }
        if (re instanceof RCharacterList) {
            RCharacterList cl = (RCharacterList)re;
            if (cl.negated_list) {
                gen.text("~");
            }
            gen.text("[");
            Enumeration enumeration = cl.descriptors.elements();
            while (enumeration.hasMoreElements()) {
                char[] s;
                Object o = enumeration.nextElement();
                if (o instanceof SingleCharacter) {
                    gen.text("\"");
                    s = new char[]{((SingleCharacter)o).ch};
                    gen.text(JavaCCGlobals.add_escapes(new String(s)));
                    gen.text("\"");
                } else if (o instanceof CharacterRange) {
                    gen.text("\"");
                    s = new char[]{((CharacterRange)o).left};
                    gen.text(JavaCCGlobals.add_escapes(new String(s)));
                    gen.text("\"-\"");
                    s[0] = ((CharacterRange)o).right;
                    gen.text(JavaCCGlobals.add_escapes(new String(s)));
                    gen.text("\"");
                } else {
                    System.out.println("Oops: unknown character list element type.");
                }
                if (!enumeration.hasMoreElements()) continue;
                gen.text(",");
            }
            gen.text("]");
        } else if (re instanceof RChoice) {
            RChoice c = (RChoice)re;
            Enumeration enumeration = c.choices.elements();
            while (enumeration.hasMoreElements()) {
                RegularExpression sub = (RegularExpression)enumeration.nextElement();
                JJDoc.emitRE(sub, gen);
                if (!enumeration.hasMoreElements()) continue;
                gen.text(" | ");
            }
        } else if (re instanceof REndOfFile) {
            gen.text("EOF");
        } else if (re instanceof RJustName) {
            RJustName jn = (RJustName)re;
            gen.text(jn.label);
        } else if (re instanceof ROneOrMore) {
            ROneOrMore om = (ROneOrMore)re;
            gen.text("(");
            JJDoc.emitRE(om.regexpr, gen);
            gen.text(")+");
        } else if (re instanceof RSequence) {
            RSequence s = (RSequence)re;
            Enumeration enumeration = s.units.elements();
            while (enumeration.hasMoreElements()) {
                RegularExpression sub = (RegularExpression)enumeration.nextElement();
                boolean needParens = false;
                if (sub instanceof RChoice) {
                    needParens = true;
                }
                if (needParens) {
                    gen.text("(");
                }
                JJDoc.emitRE(sub, gen);
                if (needParens) {
                    gen.text(")");
                }
                if (!enumeration.hasMoreElements()) continue;
                gen.text(" ");
            }
        } else if (re instanceof RStringLiteral) {
            RStringLiteral sl = (RStringLiteral)re;
            gen.text("\"" + JavaCCParserInternals.add_escapes(sl.image) + "\"");
        } else if (re instanceof RZeroOrMore) {
            RZeroOrMore zm = (RZeroOrMore)re;
            gen.text("(");
            JJDoc.emitRE(zm.regexpr, gen);
            gen.text(")*");
        } else if (re instanceof RZeroOrOne) {
            RZeroOrOne zo = (RZeroOrOne)re;
            gen.text("(");
            JJDoc.emitRE(zo.regexpr, gen);
            gen.text(")?");
        } else {
            System.out.println("Oops: Unknown regular expression type.");
        }
        if (needBrackets) {
            gen.text(">");
        }
    }

    private static String v2s(Vector v, boolean newLine) {
        String s = "";
        boolean firstToken = true;
        Enumeration enumeration = v.elements();
        while (enumeration.hasMoreElements()) {
            Token tok = (Token)enumeration.nextElement();
            Token stok = JJDoc.getPrecedingSpecialToken(tok);
            if (firstToken) {
                if (stok != null) {
                    JavaCCGlobals.cline = stok.beginLine;
                    JavaCCGlobals.ccol = stok.beginColumn;
                } else {
                    JavaCCGlobals.cline = tok.beginLine;
                    JavaCCGlobals.ccol = tok.beginColumn;
                }
                s = JJDoc.ws(JavaCCGlobals.ccol - 1);
                firstToken = false;
            }
            while (stok != null) {
                s = s + JavaCCGlobals.printToken(stok);
                stok = stok.next;
            }
            s = s + JavaCCGlobals.printToken(tok);
        }
        return s;
    }

    private static PrintWriter create_output_stream() {
        PrintWriter ostr;
        if (Options.S("OUTPUT_FILE").equals("")) {
            String suffix;
            int i;
            if (JJDocGlobals.input_file.equals("standard input")) {
                return new PrintWriter(new OutputStreamWriter(System.out));
            }
            String ext = ".html";
            if (Options.B("TEXT")) {
                ext = ".txt";
            }
            JJDocGlobals.output_file = (i = JJDocGlobals.input_file.lastIndexOf(46)) == -1 ? JJDocGlobals.input_file + ext : ((suffix = JJDocGlobals.input_file.substring(i)).equals(ext) ? JJDocGlobals.input_file + ext : JJDocGlobals.input_file.substring(0, i) + ext);
        } else {
            JJDocGlobals.output_file = Options.S("OUTPUT_FILE");
        }
        try {
            ostr = new PrintWriter(new FileWriter(JJDocGlobals.output_file));
        }
        catch (IOException e) {
            System.err.println("JJDoc: can't open output stream on file " + JJDocGlobals.output_file + ".  Using standard output.");
            ostr = new PrintWriter(new OutputStreamWriter(System.out));
        }
        return ostr;
    }

    private static String ws(int len) {
        String s = "";
        int i = 0;
        while (i < len) {
            s = s + " ";
            ++i;
        }
        return s;
    }
}

