# configuration file

# used by mrsync.py to find the executables multicaster, multicatcher, trFilelist
# hopefully, all machines put them in the same place as on the master machine.
binDir                = '/a/path/name';  # bin
rBinDir               = binDir;  # for remote target machines.

# This is a general bookkeeping file for mrsync.py.
# It records start_time and end_time of a mrsync session.
# Each mrsync.py appends time info into this file.
# So it should be a path that can be accessed by any machine invoking mrsync.py

multicast_log         = '/path/multicast.log';

#---------------------------------------------------------------------------
# The following three file-names are for tmp storage
#
# To allow for multiple multicast sessions at the same time, the actual
# name of the file will be that specified here plus a suffix = .mmddhhmmss
# The latter (mmddhhmm) is generated by mrsync.py
# --> It is necessary to clean up old files :))
#

# This is a path on all target machines for a running multicatcher
# to catch its stderr output if any.  Usually we don't expect any output in this file.
# It's there for debugging purpose in case any error event occurs.
#
# Set it to /dev/null, if we don't want any output.
#
catcher_err_log       = '/a_path/catcher.err';

# The goodTargetsFile is for mrsync.py to output names of the machines that are accessible.
# It is read by multicaster.
caster_log_dir        = '/A_PATH/sync/';   
goodTargetsFile       = caster_log_dir + 'syncing';

# The file path for storing list of to-be-transfered files
# It is used by multicaster.
syncFileList          = caster_log_dir + 'syncfile.lst';
#
# ---------------------------------------------------------------------------
#

# Path to find the rsync binary
rsyncPath             = '/usr/local/bin/rsync';
remote_rsyncPath      = rsyncPath;

#
reshell               = "rsh";  # can be changed thru command line option

#
# Do NOT change the following unless you know what you are doing.
#
# This is the absolute minimum of rsync options for multicaster
# rsync is used only to find files that need to be synced.
#   -- to add other options such as --exclude --include, use command line option
#      those extra options will be appended to this min_rsync_opt
min_rsync_opt         = '--rsh=%s -avW --dry-run --delete';

#
# varioius binary codes used
#
# the binary to translate file_list generated by rsync or manually for multicaster
translate             = 'trFilelist';
catcher               = 'multicatcher';
caster                = 'multicaster';
codes                 = [ translate, catcher, caster];
