/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.debug.CndTraceFlags;

public final class CsmCacheMap
implements CsmCacheManager.CsmClientCache {
    private final long initTime;
    private final Map<Object, Value> values;
    private final String name;
    private final int timeThreshold;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;

    public CsmCacheMap(String name) {
        this(name, 0, 16);
    }

    public CsmCacheMap(String name, int timeThreshold) {
        this(name, timeThreshold, 16);
    }

    public CsmCacheMap(String name, int timeThreshold, int initialCapacity) {
        this.name = name;
        this.values = new HashMap<Object, Value>(initialCapacity);
        this.initTime = System.currentTimeMillis();
        this.timeThreshold = timeThreshold;
    }

    public final Value get(@NonNull Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Value res = this.values.get(key);
        if (res instanceof TraceValue) {
            TraceValue out = (TraceValue)res;
            out.onCacheHit();
            if (CsmCacheManager.LOGGER.isLoggable(Level.FINE)) {
                CsmCacheManager.LOGGER.log(Level.FINE, "HIT {0} (Hits {1}) {2}=>{3}\n", new Object[]{this.name, out.getHitsCount(), key, out.getResult()});
            }
        }
        return res;
    }

    public final Value put(@NonNull Object key, Value value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return this.values.put(key, null);
        }
        if (this.timeThreshold == 0 || !(value instanceof TimeConsumingValue) || ((TimeConsumingValue)value).getCalculationTime() >= (long)this.timeThreshold) {
            return this.values.put(key, value);
        }
        return null;
    }

    @Override
    public void cleanup() {
        if (CndTraceFlags.TRACE_CSM_CACHE || CsmCacheManager.LOGGER.isLoggable(Level.FINE)) {
            int hits = 0;
            int savedTime = 0;
            int nullResolved = 0;
            for (Map.Entry<Object, Value> entry : this.values.entrySet()) {
                TraceValue value;
                Value v = entry.getValue();
                if (!(v instanceof TraceValue) || (value = (TraceValue)v).getCalculationTime() == Integer.MAX_VALUE) continue;
                hits += value.getHitsCount();
                savedTime = (int)((long)savedTime + (long)value.getHitsCount() * value.getCalculationTime());
                if (value.getResult() != null) continue;
                ++nullResolved;
            }
            if (hits > 0 && savedTime > 0 || CsmCacheManager.LOGGER.isLoggable(Level.FINE)) {
                long usedTime = System.currentTimeMillis() - this.initTime;
                CsmCacheManager.LOGGER.log(Level.INFO, "{0}: HITS={1}, Used {2}ms, SavedTime={3}ms, Cached {4} Values (NULLs={5}) ([{6}]{7})\n", new Object[]{this.name, hits, usedTime, savedTime, this.values.size(), nullResolved, Thread.currentThread().getId(), Thread.currentThread().getName()});
            }
        }
        this.values.clear();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (Map.Entry<Object, Value> entry : this.values.entrySet()) {
            out.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return out.toString();
    }

    public static Value toValue(Object cachedResult, long resultCalculationTime) {
        if (CndTraceFlags.TRACE_CSM_CACHE) {
            return new TraceValueImpl(cachedResult, resultCalculationTime);
        }
        return new ValueImpl(cachedResult, resultCalculationTime);
    }

    public static Object getFromCache(CsmCacheMap cache, Object key, boolean[] found) {
        if (found != null) {
            found[0] = false;
        }
        Object result = null;
        Value cacheValue = null;
        if (cache != null) {
            cacheValue = cache.get(key);
        }
        if (cacheValue != null) {
            if (found != null) {
                found[0] = true;
            }
            result = cacheValue.getResult();
        }
        return result;
    }

    private static final class TraceValueImpl
    implements TraceValue {
        private final Object cachedResult;
        private final long calculationTime;
        private int hits;

        private TraceValueImpl(Object cachedResult, long resultCalculationTime) {
            this.cachedResult = cachedResult;
            this.calculationTime = resultCalculationTime;
            this.hits = 0;
        }

        public String toString() {
            String saved = "";
            if (this.hits > 0 && this.calculationTime > 0L) {
                saved = ", saved=" + (long)this.hits * this.calculationTime + "ms";
            }
            return "HITS=" + this.hits + ", resolveTime=" + this.calculationTime + saved + ", result=" + this.cachedResult;
        }

        @Override
        public Object getResult() {
            return this.cachedResult;
        }

        @Override
        public int onCacheHit() {
            return ++this.hits;
        }

        @Override
        public int getHitsCount() {
            return this.hits;
        }

        @Override
        public long getCalculationTime() {
            return this.calculationTime;
        }
    }

    private static final class ValueImpl
    implements TimeConsumingValue {
        private final Object cachedResult;
        private final int calculationTime;

        private ValueImpl(Object cachedResult, long calculationTime) {
            this.cachedResult = cachedResult;
            this.calculationTime = calculationTime < Integer.MAX_VALUE ? (int)calculationTime : Integer.MAX_VALUE;
        }

        public String toString() {
            return "resolveTime=" + this.calculationTime + "result=" + this.getResult();
        }

        @Override
        public final Object getResult() {
            return this.cachedResult;
        }

        @Override
        public long getCalculationTime() {
            return this.calculationTime;
        }
    }

    public static interface TraceValue
    extends TimeConsumingValue {
        public int onCacheHit();

        public int getHitsCount();
    }

    public static interface TimeConsumingValue
    extends Value {
        public long getCalculationTime();
    }

    public static interface Value {
        public Object getResult();
    }
}

