/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.modelutil.ClassifiersAntiLoop;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;

public abstract class CsmVirtualInfoQuery {
    private static final CsmVirtualInfoQuery EMPTY = new Empty();
    private static CsmVirtualInfoQuery defaultQuery;

    protected CsmVirtualInfoQuery() {
    }

    public static CsmVirtualInfoQuery getDefault() {
        if (defaultQuery != null) {
            return defaultQuery;
        }
        defaultQuery = (CsmVirtualInfoQuery)Lookup.getDefault().lookup(CsmVirtualInfoQuery.class);
        return defaultQuery == null ? EMPTY : defaultQuery;
    }

    public abstract boolean isVirtual(CsmMethod var1);

    public abstract Collection<CsmMethod> getTopmostBaseDeclarations(CsmMethod var1);

    public abstract Collection<CsmMethod> getFirstBaseDeclarations(CsmMethod var1);

    public abstract Collection<CsmMethod> getAllBaseDeclarations(CsmMethod var1);

    public abstract Collection<CsmMethod> getOverriddenMethods(CsmMethod var1, boolean var2);

    public abstract CsmMethod getFirstDestructor(CsmClass var1);

    public abstract CsmOverriddenChain getOverriddenChain(CsmMethod var1);

    private static boolean methodEquals(CsmMethod toSearch, CsmMethod method) {
        if (CsmKindUtilities.isDestructor((CsmObject)toSearch) && CsmKindUtilities.isDestructor((CsmObject)method)) {
            return true;
        }
        if (!toSearch.getName().equals(method.getName())) {
            return false;
        }
        Collection list1 = toSearch.getParameters();
        Collection list2 = method.getParameters();
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator it2 = list2.iterator();
        for (CsmParameter p1 : list1) {
            CsmParameter p2 = (CsmParameter)it2.next();
            if (p1 != null && p2 != null) {
                if (p1.isVarArgs() && p2.isVarArgs()) continue;
                CsmType type1 = p1.getType();
                CsmType type2 = p2.getType();
                if (type1 != null && type2 != null) {
                    if (CsmUtilities.checkTypesEqual((CsmType)type1, (CsmFile)p1.getContainingFile(), (CsmType)type2, (CsmFile)p2.getContainingFile(), (CsmUtilities.QualifiersEqualizer)new CsmUtilities.ExactMatchQualsEqualizer())) continue;
                    return false;
                }
                if (type1 == null && type2 == null) {
                    continue;
                }
            } else if (p1 == null && p2 == null) continue;
            return false;
        }
        return true;
    }

    private static final class Empty
    extends CsmVirtualInfoQuery {
        private Empty() {
        }

        @Override
        public boolean isVirtual(CsmMethod method) {
            CsmCacheManager.enter();
            try {
                if (method.isVirtual()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = this.processClass(method, this.getFilterFor(method), method.getContainingClass(), new ClassifiersAntiLoop());
                return bl;
            }
            finally {
                CsmCacheManager.leave();
            }
        }

        @Override
        public CsmMethod getFirstDestructor(CsmClass cls) {
            return this.processClass(cls, this.getFilterDestructor(), new ClassifiersAntiLoop());
        }

        private CsmMethod processClass(CsmClass cls, CsmSelect.CsmFilter filter, ClassifiersAntiLoop antilLoop) {
            if (cls == null || antilLoop.contains((CsmClassifier)cls)) {
                return null;
            }
            antilLoop.add((CsmClassifier)cls);
            Iterator<CsmMember> classMembers = CsmSelect.getClassMembers(cls, filter);
            while (classMembers.hasNext()) {
                CsmMember m = classMembers.next();
                if (!CsmKindUtilities.isDestructor((CsmObject)m)) continue;
                return (CsmMethod)m;
            }
            for (CsmInheritance inh : cls.getBaseClasses()) {
                CsmMethod res = this.processClass(CsmInheritanceUtilities.getCsmClass(inh), filter, antilLoop);
                if (res == null) continue;
                return res;
            }
            return null;
        }

        private boolean processClass(CsmMethod toSearch, CsmSelect.CsmFilter filter, CsmClass cls, ClassifiersAntiLoop antilLoop) {
            if (cls == null || antilLoop.contains((CsmClassifier)cls)) {
                return false;
            }
            antilLoop.add((CsmClassifier)cls);
            Iterator<CsmMember> classMembers = CsmSelect.getClassMembers(cls, filter);
            while (classMembers.hasNext()) {
                CsmMethod met;
                CsmMember m = classMembers.next();
                if (!CsmKindUtilities.isMethod((CsmObject)m) || !CsmVirtualInfoQuery.methodEquals(toSearch, met = (CsmMethod)m)) continue;
                if (!met.isVirtual()) break;
                return true;
            }
            for (CsmInheritance inh : cls.getBaseClasses()) {
                if (!this.processClass(toSearch, filter, CsmInheritanceUtilities.getCsmClass(inh), antilLoop)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<CsmMethod> getTopmostBaseDeclarations(CsmMethod method) {
            HashMap<CsmMethod, CsmOverrideInfo> result = new HashMap<CsmMethod, CsmOverrideInfo>();
            this.getBaseDeclaration(result, method, Overridden.TOP);
            return result.keySet();
        }

        @Override
        public Collection<CsmMethod> getFirstBaseDeclarations(CsmMethod method) {
            HashMap<CsmMethod, CsmOverrideInfo> result = new HashMap<CsmMethod, CsmOverrideInfo>();
            this.getBaseDeclaration(result, method, Overridden.FIRST);
            return result.keySet();
        }

        @Override
        public Collection<CsmMethod> getAllBaseDeclarations(CsmMethod method) {
            HashMap<CsmMethod, CsmOverrideInfo> result = new HashMap<CsmMethod, CsmOverrideInfo>();
            this.getBaseDeclaration(result, method, Overridden.ALL);
            return result.keySet();
        }

        @Override
        public CsmOverriddenChain getOverriddenChain(CsmMethod method) {
            HashMap<CsmMethod, CsmOverrideInfo> result = new HashMap<CsmMethod, CsmOverrideInfo>();
            boolean virtual = this.getBaseDeclaration(result, method, Overridden.PSEUDO);
            CsmOverrideInfo current = new CsmOverrideInfo((CsmFunction)method, virtual);
            ArrayList<CsmOverrideInfo> overridden = new ArrayList<CsmOverrideInfo>();
            for (CsmMethod m : this.getOverriddenMethods(method, false)) {
                overridden.add(new CsmOverrideInfo((CsmFunction)m, virtual || m.isVirtual()));
            }
            overridden.trimToSize();
            return new CsmOverriddenChain(result.values(), current, overridden);
        }

        private boolean getBaseDeclaration(Map<CsmMethod, CsmOverrideInfo> result, CsmMethod method, Overridden overridden) {
            LinkedList<CharSequence> antilLoop = new LinkedList<CharSequence>();
            CsmClass cls = method.getContainingClass();
            boolean virtual = method.isVirtual();
            if (cls != null) {
                CsmSelect.CsmFilter filter = this.getFilterFor(method);
                for (CsmInheritance inh : cls.getBaseClasses()) {
                    virtual |= this.processMethod(method, filter, CsmInheritanceUtilities.getCsmClass(inh), antilLoop, null, null, result, overridden);
                }
            }
            return virtual;
        }

        private CsmSelect.CsmFilter getFilterFor(CsmMethod method) {
            if (CsmKindUtilities.isDestructor((CsmObject)method)) {
                return this.getFilterDestructor();
            }
            return CsmSelect.getFilterBuilder().createNameFilter(method.getName(), true, true, false);
        }

        private CsmSelect.CsmFilter getFilterDestructor() {
            return CsmSelect.getFilterBuilder().createNameFilter("~", false, true, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private boolean processMethod(CsmMethod toSearch, CsmSelect.CsmFilter filter, CsmClass cls, LinkedList<CharSequence> antilLoop, CsmMethod firstFound, CsmMethod lastFound, Map<CsmMethod, CsmOverrideInfo> result, Overridden overridden) {
            block21: {
                virtual = false;
                if (cls == null || antilLoop.contains(cls.getQualifiedName())) {
                    theLastInHierarchy = true;
                } else {
                    antilLoop.addLast(cls.getQualifiedName());
                    try {
                        classMembers = CsmSelect.getClassMembers(cls, filter);
                        while (classMembers.hasNext()) {
                            member = classMembers.next();
                            if (!CsmKindUtilities.isMethod((CsmObject)member) || !CsmVirtualInfoQuery.access$100(toSearch, method = (CsmMethod)member)) continue;
                            if (firstFound == null) {
                                firstFound = method;
                            }
                            lastFound = method;
                            if (!method.isVirtual()) break;
                            virtual = true;
                            switch (1.$SwitchMap$org$netbeans$modules$cnd$api$model$services$CsmVirtualInfoQuery$Empty$Overridden[overridden.ordinal()]) {
                                case 1: {
                                    result.put(firstFound, new CsmOverrideInfo((CsmFunction)firstFound, virtual));
                                    var14_14 = true;
                                    return var14_14;
                                }
                            }
                            break;
                        }
                        theLastInHierarchy = cls.getBaseClasses().isEmpty();
                        for (CsmInheritance inh : cls.getBaseClasses()) {
                            virtual |= this.processMethod(toSearch, filter, CsmInheritanceUtilities.getCsmClass(inh), antilLoop, firstFound, lastFound, result, overridden);
                        }
                        if (lastFound == null) break block21;
                        switch (1.$SwitchMap$org$netbeans$modules$cnd$api$model$services$CsmVirtualInfoQuery$Empty$Overridden[overridden.ordinal()]) {
                            case 2: {
                                result.put(lastFound, new CsmOverrideInfo((CsmFunction)lastFound, virtual));
                                ** break;
lbl33:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                if (!virtual) ** break;
                                result.put(lastFound, new CsmOverrideInfo((CsmFunction)lastFound, virtual));
                                break;
                            }
                            ** default:
lbl40:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        antilLoop.removeLast();
                    }
                }
            }
            if (theLastInHierarchy && lastFound != null && lastFound.isVirtual()) {
                CndUtils.assertNotNull((Object)firstFound, (String)"last found != null && first found == null ?!");
                switch (1.$SwitchMap$org$netbeans$modules$cnd$api$model$services$CsmVirtualInfoQuery$Empty$Overridden[overridden.ordinal()]) {
                    case 1: {
                        result.put(firstFound, new CsmOverrideInfo((CsmFunction)firstFound, true));
                        break;
                    }
                    case 4: {
                        result.put(lastFound, new CsmOverrideInfo((CsmFunction)lastFound, true));
                    }
                }
                return true;
            }
            return virtual;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<CsmMethod> getOverriddenMethods(CsmMethod method, boolean searchFromBase) {
            CsmCacheManager.enter();
            try {
                Collection<CsmMethod> collection = this.getOverriddenMethodsImpl(method, searchFromBase);
                return collection;
            }
            finally {
                CsmCacheManager.leave();
            }
        }

        private Collection<CsmMethod> getOverriddenMethodsImpl(CsmMethod method, boolean searchFromBase) {
            CsmClass cls;
            HashSet<CsmMethod> res = new HashSet<CsmMethod>();
            if (searchFromBase) {
                Iterator<CsmMethod> it = this.getTopmostBaseDeclarations(method).iterator();
                if (it.hasNext()) {
                    method = it.next();
                }
                res.add(method);
            }
            if ((cls = method.getContainingClass()) != null) {
                CsmSelect.CsmFilter filter = this.getFilterFor(method);
                block0: for (CsmReference ref : CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, false)) {
                    CsmClass c = (CsmClass)ref.getReferencedObject();
                    if (c == null) continue;
                    Iterator<CsmMember> classMembers = CsmSelect.getClassMembers(c, filter);
                    while (classMembers.hasNext()) {
                        CsmMethod met;
                        CsmMember m = classMembers.next();
                        if (!CsmKindUtilities.isMethod((CsmObject)m) || !CsmVirtualInfoQuery.methodEquals(met = (CsmMethod)m, method)) continue;
                        res.add(met);
                        continue block0;
                    }
                }
            }
            return res;
        }

        private static enum Overridden {
            FIRST,
            TOP,
            ALL,
            PSEUDO;

        }
    }

    public static final class CsmOverrideInfo {
        private final CsmFunction method;
        private final boolean virtual;

        public CsmOverrideInfo(CsmFunction method, boolean virtual) {
            this.method = method;
            this.virtual = virtual;
        }

        public CsmFunction getMethod() {
            return this.method;
        }

        public boolean isVirtual() {
            return this.virtual;
        }

        public boolean hasVirtualKeyword() {
            if (CsmKindUtilities.isMethod((CsmObject)this.method)) {
                return ((CsmMethod)this.method).isVirtual();
            }
            return false;
        }
    }

    public static final class CsmOverriddenChain {
        private final Collection<CsmOverrideInfo> baseMethods;
        private final CsmOverrideInfo thisMethod;
        private final Collection<CsmOverrideInfo> derivedMethods;

        private CsmOverriddenChain(Collection<CsmOverrideInfo> baseMethods, CsmOverrideInfo thisMethod, Collection<CsmOverrideInfo> derivedMethods) {
            this.baseMethods = baseMethods;
            this.thisMethod = thisMethod;
            this.derivedMethods = derivedMethods;
        }

        public Collection<CsmOverrideInfo> getBaseMethods() {
            return Collections.unmodifiableCollection(this.baseMethods);
        }

        public Collection<CsmOverrideInfo> getDerivedMethods() {
            return Collections.unmodifiableCollection(this.derivedMethods);
        }

        public CsmOverrideInfo getThisMethod() {
            return this.thisMethod;
        }
    }
}

