/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.trace.TraceProjectLookupProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class NativeProjectProvider {
    private NativeProjectProvider() {
    }

    public static NativeProject createProject(String projectRoot, List<File> files, List<String> libProjectsPaths, List<String> sysIncludes, List<String> usrIncludes, List<String> sysIncludeHeaders, List<String> usrFiles, List<String> sysMacros, List<String> usrMacros, List<String> undefinedMacros, boolean pathsRelCurFile) throws IOException {
        InstanceContent ic = new InstanceContent();
        NativeProjectImpl project = new NativeProjectImpl(projectRoot, libProjectsPaths, sysIncludes, usrIncludes, sysIncludeHeaders, usrFiles, sysMacros, usrMacros, undefinedMacros, pathsRelCurFile, ic);
        TraceProjectLookupProvider lkp = (TraceProjectLookupProvider)Lookup.getDefault().lookup(TraceProjectLookupProvider.class);
        if (lkp != null) {
            lkp.createLookup(ic, project);
        }
        project.addFiles(files);
        return project;
    }

    public static void fireAllFilesChanged(NativeProject nativeProject) {
        if (nativeProject instanceof NativeProjectImpl) {
            ((NativeProjectImpl)nativeProject).fireAllFilesChanged();
        }
    }

    public static void setUserMacros(NativeProject nativeProject, List<String> usrMacros) {
        if (nativeProject instanceof NativeProjectImpl) {
            ((NativeProjectImpl)nativeProject).usrMacros.clear();
            ((NativeProjectImpl)nativeProject).usrMacros.addAll(usrMacros);
        }
    }

    public static NativeFileItem.Language getLanguage(File file, DataObject dobj) {
        CndUtils.assertNotNull((Object)file, (String)"null file");
        FileObject fo = null;
        if (dobj != null) {
            fo = dobj.getPrimaryFile();
        }
        String mimeType = fo != null ? MIMESupport.getSourceFileMIMEType((FileObject)fo) : MIMESupport.getSourceFileMIMEType((File)file);
        return NativeProjectProvider.getLanguage(mimeType);
    }

    public static NativeFileItem.Language getLanguage(FileObject fo, DataObject dobj) {
        CndUtils.assertNotNull((Object)fo, (String)"null file object");
        String mimeType = MIMESupport.getSourceFileMIMEType((FileObject)fo);
        return NativeProjectProvider.getLanguage(mimeType);
    }

    private static NativeFileItem.Language getLanguage(String mimeType) {
        if ("text/x-c++".equals(mimeType)) {
            return NativeFileItem.Language.CPP;
        }
        if ("text/x-c".equals(mimeType)) {
            return NativeFileItem.Language.C;
        }
        if ("text/x-fortran".equals(mimeType)) {
            return NativeFileItem.Language.FORTRAN;
        }
        if ("text/x-h".equals(mimeType)) {
            return NativeFileItem.Language.C_HEADER;
        }
        return NativeFileItem.Language.OTHER;
    }

    private static NativeFileItem.LanguageFlavor getLanguageFlavor(File file) {
        if (DebugUtils.getBoolean((String)"cnd.language.flavor.cpp11", (boolean)false)) {
            return NativeFileItem.LanguageFlavor.CPP11;
        }
        String cpp11Dirs = System.getProperty("cnd.tests.cpp11directories");
        if (cpp11Dirs != null && !cpp11Dirs.isEmpty()) {
            String[] cpp11DirList;
            for (String cpp11Dir : cpp11DirList = cpp11Dirs.split(";")) {
                if (!file.getAbsolutePath().contains(cpp11Dir)) continue;
                return NativeFileItem.LanguageFlavor.CPP11;
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN;
    }

    public static DataObject getDataObject(FileObject fo) {
        DataObject dobj = null;
        if (fo != null) {
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dobj;
    }

    public static DataObject getDataObject(File file) {
        CndUtils.assertNormalized((File)file);
        return NativeProjectProvider.getDataObject(CndFileUtils.toFileObject((File)file));
    }

    static void registerItemInDataObject(DataObject obj, NativeFileItem item) {
        NativeFileItemSet set;
        if (obj != null && (set = (NativeFileItemSet)obj.getLookup().lookup(NativeFileItemSet.class)) != null) {
            set.add(item);
            if (item instanceof NativeFileItemImpl) {
                ((NativeFileItemImpl)item).lastDataObject = obj;
            }
        }
    }

    private static final class NativeFileItemImpl
    implements NativeFileItem {
        private final File file;
        private final NativeProjectImpl project;
        private final NativeFileItem.Language lang;
        private final NativeFileItem.LanguageFlavor flavor;
        private DataObject lastDataObject;

        public NativeFileItemImpl(File file, NativeProjectImpl project, NativeFileItem.Language language, NativeFileItem.LanguageFlavor flavor) {
            this.project = project;
            this.file = CndFileUtils.normalizeFile((File)file);
            this.lang = language;
            this.flavor = flavor;
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public FileObject getFileObject() {
            return CndFileUtils.toFileObject((File)this.file);
        }

        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        public String getName() {
            return this.file.getName();
        }

        public List<IncludePath> getSystemIncludePaths() {
            List<IncludePath> result = this.project.getSystemIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsoluteItemPath(result) : result;
        }

        public List<IncludePath> getUserIncludePaths() {
            List<IncludePath> result = this.project.getUserIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsoluteItemPath(result) : result;
        }

        public List<FSPath> getSystemIncludeHeaders() {
            List<FSPath> result = this.project.getSystemIncludeHeaders();
            return this.project.pathsRelCurFile ? this.toAbsolute(result) : result;
        }

        public List<FSPath> getIncludeFiles() {
            return this.project.getIncludeFiles();
        }

        private List<FSPath> toAbsolute(List<FSPath> orig) {
            File base = this.file.getParentFile();
            ArrayList<FSPath> result = new ArrayList<FSPath>(orig.size());
            for (FSPath path : orig) {
                File pathFile = new File(path.getPath());
                if (pathFile.isAbsolute()) {
                    result.add(path);
                    continue;
                }
                pathFile = new File(base, path.getPath());
                result.add(new FSPath(CndFileUtils.getLocalFileSystem(), pathFile.getAbsolutePath()));
            }
            return result;
        }

        private List<IncludePath> toAbsoluteItemPath(List<IncludePath> orig) {
            File base = this.file.getParentFile();
            ArrayList<IncludePath> result = new ArrayList<IncludePath>(orig.size());
            for (IncludePath path : orig) {
                File pathFile = new File(path.getFSPath().getPath());
                if (pathFile.isAbsolute()) {
                    result.add(path);
                    continue;
                }
                pathFile = new File(base, path.getFSPath().getPath());
                result.add(new IncludePath(CndFileUtils.getLocalFileSystem(), pathFile.getAbsolutePath(), path.isFramework()));
            }
            return result;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.project.getSystemMacroDefinitions();
        }

        public List<String> getUserMacroDefinitions() {
            return this.project.getUserMacroDefinitions();
        }

        public NativeFileItem.Language getLanguage() {
            return this.lang;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return this.flavor;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }
    }

    public static final class NativeProjectImpl
    implements NativeProject,
    Lookup.Provider {
        private final List<String> sysIncludes;
        private final List<String> usrIncludes;
        private final List<String> sysIncludeHeaders;
        private final List<String> usrFiles;
        private final List<String> sysMacros;
        private final List<String> usrMacros;
        private final List<NativeFileItem> files = new ArrayList<NativeFileItem>();
        private final String projectRoot;
        private final boolean pathsRelCurFile;
        private final String name;
        private final List<NativeProjectItemsListener> listeners = new ArrayList<NativeProjectItemsListener>();
        private final List<NativeProject> libProjects;
        private final Object listenersLock = new Lock();
        private final Lookup lookup;

        private NativeProjectImpl(String projectRoot, List<String> libProjectsPaths, List<String> sysIncludes, List<String> usrIncludes, List<String> sysIncludeHeaders, List<String> usrFiles, List<String> sysMacros, List<String> usrMacros, List<String> undefinedMacros, boolean pathsRelCurFile, InstanceContent ic) {
            this.projectRoot = projectRoot;
            ArrayList<NativeProject> libs = new ArrayList<NativeProject>();
            Collection projects = CsmModelAccessor.getModel().projects();
            for (String libPath : libProjectsPaths) {
                boolean found = false;
                for (CsmProject csmProject : projects) {
                    Object platformProject = csmProject.getPlatformProject();
                    if (!(platformProject instanceof NativeProjectImpl) || !((NativeProjectImpl)platformProject).projectRoot.equals(libPath)) continue;
                    assert (!found) : "two projects for the same root " + libPath + libs + csmProject;
                    found = true;
                    libs.add((NativeProjectImpl)platformProject);
                }
                assert (found) : " not found project for " + libPath + " in " + projects;
            }
            this.libProjects = libs;
            this.pathsRelCurFile = pathsRelCurFile;
            this.sysIncludes = this.createIncludes(sysIncludes);
            this.usrIncludes = this.createIncludes(usrIncludes);
            this.sysIncludeHeaders = this.createIncludes(sysIncludeHeaders);
            this.usrFiles = this.createIncludes(usrFiles);
            this.sysMacros = new ArrayList<String>(sysMacros);
            this.usrMacros = new ArrayList<String>(usrMacros);
            this.name = this.initName(projectRoot);
            this.lookup = ic == null ? Lookups.fixed((Object[])new Object[0]) : new AbstractLookup((AbstractLookup.Content)ic);
        }

        private String initName(String projectRoot) {
            String out = System.getProperty("cnd.modelimpl.tracemodel.project.name");
            if (out == null) {
                out = PathUtilities.getBaseName((String)projectRoot);
                String dir = PathUtilities.getDirName((String)projectRoot);
                if (dir != null) {
                    dir = PathUtilities.getBaseName((String)dir);
                }
                if (dir != null) {
                    out = dir + "_" + out;
                }
            }
            return out;
        }

        private List<String> createIncludes(List<String> src) {
            if (this.pathsRelCurFile) {
                return new ArrayList<String>(src);
            }
            ArrayList<String> result = new ArrayList<String>(src.size());
            for (String path : src) {
                File file = new File(path);
                result.add(file.getAbsolutePath());
            }
            return result;
        }

        private void addFiles(List<File> files) throws IOException {
            for (File file : files) {
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getAbsoluteFile()));
                if (fo == null) {
                    throw new IOException("no file object for " + file);
                }
                this.addFile(fo);
            }
        }

        public Lookup.Provider getProject() {
            return this;
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public FileSystem getFileSystem() {
            return CndFileUtils.getLocalFileSystem();
        }

        public List<String> getSourceRoots() {
            return Collections.emptyList();
        }

        public String getProjectRoot() {
            return this.projectRoot;
        }

        public String getProjectDisplayName() {
            return this.name;
        }

        public List<NativeFileItem> getAllFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public List<NativeFileItem> getStandardHeadersIndexers() {
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectItemsListener(NativeProjectItemsListener listener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProjectItemsListener(NativeProjectItemsListener listener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireFileChanged(FileObject fo) {
            ArrayList<NativeProjectItemsListener> listenersCopy;
            NativeFileItem item = this.findFileItem(fo);
            Object object = this.listenersLock;
            synchronized (object) {
                listenersCopy = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            List<NativeFileItem> list = Collections.singletonList(item);
            for (NativeProjectItemsListener listener : listenersCopy) {
                listener.filesPropertiesChanged(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireFileAdded(FileObject fo) {
            ArrayList<NativeProjectItemsListener> listenersCopy;
            NativeFileItem item = this.findFileItem(fo);
            if (item == null) {
                item = this.addFile(fo);
            }
            Object object = this.listenersLock;
            synchronized (object) {
                listenersCopy = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            List<NativeFileItem> list = Collections.singletonList(item);
            for (NativeProjectItemsListener listener : listenersCopy) {
                listener.filesAdded(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireAllFilesChanged() {
            ArrayList<NativeProjectItemsListener> listenersCopy;
            Object object = this.listenersLock;
            synchronized (object) {
                listenersCopy = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            List<NativeFileItem> items = Collections.unmodifiableList(this.files);
            for (NativeProjectItemsListener listener : listenersCopy) {
                listener.filesPropertiesChanged(items);
            }
        }

        public NativeFileItem findFileItem(FileObject fileObject) {
            return this.findFileItem(CndFileUtils.normalizePath((FileObject)fileObject));
        }

        private NativeFileItem findFileItem(String path) {
            for (NativeFileItem item : this.files) {
                if (!item.getAbsolutePath().equalsIgnoreCase(path)) continue;
                return item;
            }
            return null;
        }

        public List<IncludePath> getSystemIncludePaths() {
            return IncludePath.toIncludePathList((FileSystem)CndFileUtils.getLocalFileSystem(), this.sysIncludes);
        }

        public List<IncludePath> getUserIncludePaths() {
            return IncludePath.toIncludePathList((FileSystem)CndFileUtils.getLocalFileSystem(), this.usrIncludes);
        }

        public List<FSPath> getSystemIncludeHeaders() {
            return CndFileUtils.toFSPathList((FileSystem)CndFileUtils.getLocalFileSystem(), this.sysIncludeHeaders);
        }

        public List<FSPath> getIncludeFiles() {
            return CndFileUtils.toFSPathList((FileSystem)CndFileUtils.getLocalFileSystem(), this.usrFiles);
        }

        public List<String> getSystemMacroDefinitions() {
            return this.sysMacros;
        }

        public List<String> getUserMacroDefinitions() {
            return this.usrMacros;
        }

        private NativeFileItem addFile(FileObject fo) {
            File file = FileUtil.toFile((FileObject)fo);
            DataObject dobj = NativeProjectProvider.getDataObject(fo);
            NativeFileItem.Language lang = NativeProjectProvider.getLanguage(fo, dobj);
            NativeFileItem.LanguageFlavor flavor = NativeProjectProvider.getLanguageFlavor(file);
            NativeFileItemImpl item = new NativeFileItemImpl(file, this, lang, flavor);
            this.files.add(item);
            return item;
        }

        public List<NativeProject> getDependences() {
            return this.libProjects;
        }

        public void runOnProjectReadiness(NamedRunnable task) {
            task.run();
        }

        public void fireFilesPropertiesChanged() {
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }
}

