/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class SQLLexer
implements Lexer<SQLTokenId> {
    private final LexerRestartInfo<SQLTokenId> info;
    private final LexerInput input;
    private final TokenFactory<SQLTokenId> factory;
    private State state = State.INIT;
    private int startQuoteChar = -1;

    public SQLLexer(LexerRestartInfo<SQLTokenId> info) {
        this.info = info;
        this.input = info.input();
        this.factory = info.tokenFactory();
    }

    public Token<SQLTokenId> nextToken() {
        int actChar;
        while ((actChar = this.input.read()) != -1) {
            block0 : switch (this.state) {
                case INIT: {
                    switch (actChar) {
                        case 39: {
                            this.state = State.ISI_STRING;
                            break block0;
                        }
                        case 47: {
                            this.state = State.ISA_SLASH;
                            break block0;
                        }
                        case 35: {
                            this.state = State.ISA_HASH;
                            break block0;
                        }
                        case 33: 
                        case 37: 
                        case 38: 
                        case 42: 
                        case 43: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 94: 
                        case 124: 
                        case 126: {
                            this.state = State.INIT;
                            int lookAhead = this.input.read();
                            if (lookAhead == 61) {
                                switch (actChar) {
                                    case 33: 
                                    case 37: 
                                    case 38: 
                                    case 42: 
                                    case 43: 
                                    case 45: 
                                    case 47: 
                                    case 58: 
                                    case 60: 
                                    case 62: 
                                    case 94: 
                                    case 124: {
                                        return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                                    }
                                }
                            }
                            if (actChar == 124 && lookAhead == 124) {
                                return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                            }
                            if (actChar == 33 && (lookAhead == 61 || lookAhead == 62 || lookAhead == 60)) {
                                return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                            }
                            if (actChar == 60 && lookAhead == 62) {
                                return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                            }
                            this.input.backup(1);
                            if (actChar != 58) {
                                return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                            }
                            this.state = State.ISI_IDENTIFIER;
                            break block0;
                        }
                        case 40: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.LPAREN);
                        }
                        case 41: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.RPAREN);
                        }
                        case 44: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.COMMA);
                        }
                        case 45: {
                            this.state = State.ISA_MINUS;
                            break block0;
                        }
                        case 48: {
                            this.state = State.ISA_ZERO;
                            break block0;
                        }
                        case 46: {
                            this.state = State.ISA_DOT;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(actChar)) {
                        this.state = State.ISI_WHITESPACE;
                        break;
                    }
                    if (Character.isDigit(actChar)) {
                        this.state = State.ISI_INT;
                        break;
                    }
                    if (SQLLexer.isStartIdentifierQuoteChar(actChar)) {
                        this.startQuoteChar = actChar;
                    }
                    this.state = State.ISI_IDENTIFIER;
                    break;
                }
                case ISI_WHITESPACE: {
                    if (Character.isWhitespace(actChar)) break;
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.WHITESPACE);
                }
                case ISI_LINE_COMMENT: {
                    if (actChar != 10) break;
                    this.state = State.INIT;
                    return this.factory.createToken((TokenId)SQLTokenId.LINE_COMMENT);
                }
                case ISI_BLOCK_COMMENT: {
                    if (actChar != 42) break;
                    this.state = State.ISA_STAR_IN_BLOCK_COMMENT;
                    break;
                }
                case ISI_STRING: {
                    switch (actChar) {
                        case 39: {
                            this.state = State.ISA_QUOTE_IN_STRING;
                        }
                    }
                    break;
                }
                case ISA_QUOTE_IN_STRING: {
                    switch (actChar) {
                        case 39: {
                            this.state = State.ISI_STRING;
                            break block0;
                        }
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.STRING);
                }
                case ISI_IDENTIFIER: {
                    if (this.startQuoteChar != -1) {
                        if (!SQLLexer.isEndIdentifierQuoteChar(this.startQuoteChar, actChar)) break;
                        this.state = State.ISA_QUOTE_IN_IDENTIFIER;
                        break;
                    }
                    if (Character.isLetterOrDigit(actChar) || actChar == 95 || actChar == 35) break;
                    this.input.backup(1);
                    this.state = State.INIT;
                    this.startQuoteChar = -1;
                    return this.factory.createToken((TokenId)SQLLexer.testKeyword(this.input.readText()));
                }
                case ISA_QUOTE_IN_IDENTIFIER: {
                    if (SQLLexer.isEndIdentifierQuoteChar(this.startQuoteChar, actChar)) {
                        this.state = State.ISI_IDENTIFIER;
                        break;
                    }
                    this.state = State.INIT;
                    this.startQuoteChar = -1;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLLexer.testKeyword(this.input.readText()));
                }
                case ISA_SLASH: {
                    switch (actChar) {
                        case 42: {
                            this.state = State.ISI_BLOCK_COMMENT;
                            break block0;
                        }
                        case 61: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                        }
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                }
                case ISA_MINUS: {
                    switch (actChar) {
                        case 45: {
                            this.state = State.ISI_LINE_COMMENT;
                            break block0;
                        }
                        case 61: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                        }
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                }
                case ISA_HASH: {
                    if (Character.isWhitespace(actChar)) {
                        this.state = State.ISI_LINE_COMMENT;
                        break;
                    }
                    this.state = State.ISI_IDENTIFIER;
                    break;
                }
                case ISA_STAR_IN_BLOCK_COMMENT: {
                    switch (actChar) {
                        case 47: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.BLOCK_COMMENT);
                        }
                        case 42: {
                            this.state = State.ISA_STAR_IN_BLOCK_COMMENT;
                            break block0;
                        }
                    }
                    this.state = State.ISI_BLOCK_COMMENT;
                    break;
                }
                case ISA_ZERO: {
                    switch (actChar) {
                        case 46: {
                            this.state = State.ISI_DOUBLE;
                            break block0;
                        }
                    }
                    if (Character.isDigit(actChar)) {
                        this.state = State.ISI_INT;
                        break;
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.INT_LITERAL);
                }
                case ISI_INT: {
                    switch (actChar) {
                        case 46: {
                            this.state = State.ISI_DOUBLE;
                            break block0;
                        }
                    }
                    if (Character.isDigit(actChar)) {
                        this.state = State.ISI_INT;
                        break;
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.INT_LITERAL);
                }
                case ISI_DOUBLE: {
                    if (actChar >= 48 && actChar <= 57) {
                        this.state = State.ISI_DOUBLE;
                        break;
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.DOUBLE_LITERAL);
                }
                case ISA_DOT: {
                    if (Character.isDigit(actChar)) {
                        this.state = State.ISI_DOUBLE;
                        break;
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.DOT);
                }
            }
        }
        SQLTokenId id = null;
        PartType part = PartType.COMPLETE;
        switch (this.state) {
            case ISA_QUOTE_IN_STRING: {
                id = SQLTokenId.STRING;
                break;
            }
            case ISA_QUOTE_IN_IDENTIFIER: {
                id = SQLTokenId.IDENTIFIER;
                break;
            }
            case ISI_WHITESPACE: {
                id = SQLTokenId.WHITESPACE;
                break;
            }
            case ISI_IDENTIFIER: {
                if (this.startQuoteChar == -1) {
                    id = SQLLexer.testKeyword(this.input.readText());
                    break;
                }
                id = SQLTokenId.INCOMPLETE_IDENTIFIER;
                break;
            }
            case ISI_LINE_COMMENT: {
                id = SQLTokenId.LINE_COMMENT;
                break;
            }
            case ISI_BLOCK_COMMENT: 
            case ISA_STAR_IN_BLOCK_COMMENT: {
                id = SQLTokenId.BLOCK_COMMENT;
                part = PartType.START;
                break;
            }
            case ISI_STRING: {
                id = SQLTokenId.INCOMPLETE_STRING;
                part = PartType.START;
                break;
            }
            case ISA_ZERO: 
            case ISI_INT: {
                id = SQLTokenId.INT_LITERAL;
                break;
            }
            case ISI_DOUBLE: {
                id = SQLTokenId.DOUBLE_LITERAL;
                break;
            }
            case ISA_DOT: {
                id = SQLTokenId.DOT;
                break;
            }
            case ISA_SLASH: {
                id = SQLTokenId.OPERATOR;
                break;
            }
            case ISA_MINUS: {
                id = SQLTokenId.OPERATOR;
            }
        }
        if (id != null) {
            this.state = State.INIT;
            return this.factory.createToken((TokenId)id, this.input.readLength(), part);
        }
        if (this.state != State.INIT) {
            throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state) + " at end of file");
        }
        return null;
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    public static boolean isStartStringQuoteChar(int start) {
        return start == 39;
    }

    public static boolean isStartIdentifierQuoteChar(int start) {
        return start == 34 || start == 96 || start == 91;
    }

    public static int getMatchingQuote(int start) {
        switch (start) {
            case 91: {
                return 93;
            }
        }
        return start;
    }

    public static boolean isEndIdentifierQuoteChar(int start, int end) {
        return SQLLexer.isStartIdentifierQuoteChar(start) && end == SQLLexer.getMatchingQuote(start);
    }

    public static boolean isEndStringQuoteChar(int start, int end) {
        return SQLLexer.isStartStringQuoteChar(start) && end == SQLLexer.getMatchingQuote(start);
    }

    private static SQLTokenId testKeyword(CharSequence value) {
        if (SQLKeywords.isSQL99Keyword((String)value.toString().toUpperCase(), (boolean)true)) {
            return SQLTokenId.KEYWORD;
        }
        return SQLTokenId.IDENTIFIER;
    }

    private static enum State {
        INIT,
        ISI_WHITESPACE,
        ISI_LINE_COMMENT,
        ISI_BLOCK_COMMENT,
        ISI_STRING,
        ISI_IDENTIFIER,
        ISA_SLASH,
        ISA_HASH,
        ISA_MINUS,
        ISA_STAR_IN_BLOCK_COMMENT,
        ISA_ZERO,
        ISI_INT,
        ISI_DOUBLE,
        ISA_DOT,
        ISA_QUOTE_IN_STRING,
        ISA_QUOTE_IN_IDENTIFIER;

    }
}

