/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.parser;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.makefile.MakefileElement;
import org.netbeans.modules.cnd.api.makefile.MakefileRule;
import org.netbeans.modules.cnd.api.makefile.MakefileSupport;
import org.netbeans.modules.cnd.builds.MakefileTargetProvider;
import org.netbeans.modules.cnd.makefile.parser.MakefileUtils;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.filesystems.FileObject;

public class MakefileTargetProviderImpl
implements MakefileTargetProvider {
    private final FileObject fileObject;

    public MakefileTargetProviderImpl(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public Set<String> getPreferredTargets() throws IOException {
        try {
            List<MakefileElement> elements = MakefileSupport.parseFile(this.fileObject);
            return MakefileTargetProviderImpl.getPreferredTargetNames(elements);
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
    }

    public Set<String> getRunnableTargets() throws IOException {
        try {
            List<MakefileElement> elements = MakefileSupport.parseFile(this.fileObject);
            return MakefileTargetProviderImpl.getRunnableTargetNames(elements);
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
    }

    private static Set<String> getPreferredTargetNames(List<MakefileElement> elements) {
        return MakefileTargetProviderImpl.getTargetNames(elements, true);
    }

    private static Set<String> getRunnableTargetNames(List<MakefileElement> elements) {
        return MakefileTargetProviderImpl.getTargetNames(elements, false);
    }

    private static Set<String> getTargetNames(List<MakefileElement> elements, boolean preferred) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (MakefileElement element : elements) {
            if (element.getKind() != MakefileElement.Kind.RULE) continue;
            MakefileRule rule = (MakefileRule)element;
            for (String target : rule.getTargets()) {
                if ((!preferred || !MakefileUtils.isPreferredTarget(target)) && (preferred || !MakefileUtils.isRunnableTarget(target))) continue;
                result.add(target);
            }
        }
        return result;
    }
}

