/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import org.netbeans.modules.cnd.makefile.wizard.EnterItemsPanel;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.TargetData;

public class MakefileIncludesPanel
extends EnterItemsPanel {
    static final long serialVersionUID = -3932940292545539665L;
    private int key;
    private boolean initialized;

    MakefileIncludesPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = this.getString("LBL_MakefileIncludesPanel");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        this.create(this.getString("LBL_IncDir"), this.getString("MNEM_IncDir").charAt(0), 10);
    }

    @Override
    protected String getListLabel() {
        return this.getString("LBL_IncludesList");
    }

    @Override
    protected char getListMnemonic() {
        return this.getString("MNEM_IncludesList").charAt(0);
    }

    @Override
    public void validateData(ArrayList<String> msgs, int key) {
        TargetData target = this.getMakefileData().getTarget(key);
        String[] ilist = target.getIncludesList();
        if (ilist == null) {
            this.warn(msgs, WARN_NO_INC_DIRS, target.getName());
        } else {
            int i;
            String cwd = this.getMakefileData().getBaseDirectory(true);
            ArrayList<String> dne = new ArrayList<String>();
            ArrayList<String> notDir = new ArrayList<String>();
            for (i = 0; i < ilist.length; ++i) {
                String incDir = ilist[i];
                File dir = incDir.startsWith(File.separator) ? new File(incDir) : new File(cwd, incDir);
                if (dir == null) continue;
                if (!dir.exists()) {
                    dne.add("\t" + dir.getPath() + "\n");
                    continue;
                }
                if (dir.isDirectory()) continue;
                notDir.add("\t" + dir.getPath() + "\n");
            }
            if (dne.size() > 0) {
                if (dne.size() < 5) {
                    this.warn(msgs, WARN_DNE_INCDIR, target.getName());
                    for (i = 0; i < dne.size(); ++i) {
                        msgs.add((String)dne.get(i));
                    }
                    msgs.add("\n");
                } else {
                    this.warn(msgs, WARN_DNE_COUNT, target.getName(), String.valueOf(dne.size()));
                }
            }
            if (notDir.size() > 0) {
                if (notDir.size() < 5) {
                    this.warn(msgs, WARN_INC_NOT_DIR, target.getName());
                    for (i = 0; i < notDir.size(); ++i) {
                        msgs.add((String)notDir.get(i));
                    }
                    msgs.add("\n");
                } else {
                    this.warn(msgs, WARN_INC_NOT_DIR_COUNT, target.getName(), String.valueOf(notDir.size()));
                }
            }
        }
    }

    @Override
    protected EnterItemsPanel.ErrorInfo getErrorInfo() {
        return new EnterItemsPanel.ErrorInfo(this.getString("DLG_MIP_EmptyRE"), this.getString("MSG_NoFilesMatched"));
    }

    @Override
    protected String validateInput(String text) {
        if (text.startsWith("-I")) {
            return text.substring(2);
        }
        if (text.charAt(0) == '-') {
            return null;
        }
        return text;
    }

    @Override
    public void addNotify() {
        TargetData target = this.getMakefileData().getCurrentTarget();
        this.key = target.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.removeAllElements();
        String[] ilist = target.getIncludesList();
        if (ilist != null) {
            for (int i = 0; i < ilist.length; ++i) {
                model.addElement(ilist[i]);
            }
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TargetData target = this.getMakefileData().getTarget(this.key);
        target.setIncludesList(this.getListItems());
    }
}

