/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support.java.method;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openide.util.Parameters;

public final class MethodModel {
    private final String name;
    private final String returnType;
    private final String body;
    private final List<Variable> parameters;
    private final List<String> exceptions;
    private final Set<Modifier> modifiers;
    private final List<Annotation> annotations;

    private MethodModel(String name, String returnType, String body, List<Variable> parameters, List<String> exceptions, Set<Modifier> modifiers, List<Annotation> annotations) {
        this.name = name;
        this.returnType = returnType;
        this.body = body;
        this.parameters = Collections.unmodifiableList(parameters);
        this.exceptions = Collections.unmodifiableList(exceptions);
        this.modifiers = Collections.unmodifiableSet(modifiers);
        this.annotations = Collections.unmodifiableList(annotations);
    }

    public static MethodModel create(String name, String returnType, String body, List<Variable> parameters, List<String> exceptions, Set<Modifier> modifiers) {
        Parameters.javaIdentifier((CharSequence)"name", (CharSequence)name);
        Parameters.notWhitespace((CharSequence)"returnType", (CharSequence)returnType);
        Parameters.notNull((CharSequence)"parameters", parameters);
        Parameters.notNull((CharSequence)"exceptions", exceptions);
        Parameters.notNull((CharSequence)"modifiers", modifiers);
        return new MethodModel(name, returnType, body, parameters, exceptions, modifiers, Collections.<Annotation>emptyList());
    }

    public static MethodModel create(String name, String returnType, String body, List<Variable> parameters, List<String> exceptions, Set<Modifier> modifiers, List<Annotation> annotations) {
        Parameters.javaIdentifier((CharSequence)"name", (CharSequence)name);
        Parameters.notWhitespace((CharSequence)"returnType", (CharSequence)returnType);
        Parameters.notNull((CharSequence)"parameters", parameters);
        Parameters.notNull((CharSequence)"exceptions", exceptions);
        Parameters.notNull((CharSequence)"modifiers", modifiers);
        Parameters.notNull((CharSequence)"annotations", annotations);
        return new MethodModel(name, returnType, body, parameters, exceptions, modifiers, annotations);
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getBody() {
        return this.body;
    }

    public List<Variable> getParameters() {
        return this.parameters;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "MethodModel<" + this.modifiers + "," + this.returnType + "," + this.name + "," + this.parameters + "," + this.exceptions + ",{" + this.body + "}>";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodModel other = (MethodModel)obj;
        if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
            return false;
        }
        return this.parameters == other.parameters || this.parameters != null && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 13 * hash + (this.parameters != null ? this.parameters.hashCode() : 0);
        return hash;
    }

    public static final class Annotation {
        private final String type;
        private final Map<String, Object> arguments;

        private Annotation(String type, Map<String, Object> arguments) {
            this.type = type;
            this.arguments = arguments;
        }

        public static Annotation create(String type) {
            Parameters.notNull((CharSequence)"type", (Object)type);
            return new Annotation(type, null);
        }

        public static Annotation create(String type, Map<String, String> arguments) {
            Parameters.notNull((CharSequence)"type", (Object)type);
            Parameters.notNull((CharSequence)"arguments", arguments);
            return new Annotation(type, new HashMap<String, Object>(arguments));
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Object> getArguments() {
            return this.arguments;
        }
    }

    public static final class Variable {
        private final String type;
        private final String name;
        private final boolean finalModifier;

        private Variable(String type, String name, boolean finalModifier) {
            this.type = type;
            this.name = name;
            this.finalModifier = finalModifier;
        }

        public static Variable create(String type, String name) {
            Parameters.notWhitespace((CharSequence)"type", (CharSequence)type);
            Parameters.javaIdentifier((CharSequence)"name", (CharSequence)name);
            return new Variable(type, name, false);
        }

        public static Variable create(String type, String name, boolean finalModifier) {
            Parameters.notWhitespace((CharSequence)"type", (CharSequence)type);
            Parameters.javaIdentifier((CharSequence)"name", (CharSequence)name);
            return new Variable(type, name, finalModifier);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Variable other = (Variable)obj;
            return this.type == other.type || this.type != null && this.type.equals(other.type);
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.type != null ? this.type.hashCode() : 0);
            return hash;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean getFinalModifier() {
            return this.finalModifier;
        }
    }
}

