/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitObjectType;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.LogCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class GetPreviousCommitCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final String revision;
    private GitRevisionInfo previousRevision;
    private final VCSFileProxy file;
    private final ProgressMonitor monitor;

    public GetPreviousCommitCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy file, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.file = file;
        this.revision = revision;
        this.monitor = monitor;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "log");
        this.addArgument(0, "--raw");
        this.addArgument(0, "--pretty=raw");
        this.addArgument(0, "--full-diff");
        this.addArgument(0, "-2");
        this.addArgument(0, this.revision);
        this.addArgument(0, "--");
        this.addArgument(0, Utils.getRelativePath(this.getRepository().getLocation(), this.file));
    }

    public GitRevisionInfo getRevision() {
        return this.previousRevision;
    }

    @Override
    protected void run() throws GitException {
        block5: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final LinkedHashMap statuses = new LinkedHashMap();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        LogCommand.parseLog(output, statuses);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        for (String msg : error.split("\n")) {
                            if (!msg.startsWith("fatal: Invalid object")) continue;
                            throw new GitException.MissingObjectException("HEAD", GitObjectType.COMMIT);
                        }
                        super.errorParser(error);
                    }
                }.runCLI();
                if (statuses.size() == 2) {
                    Iterator iterator = statuses.values().iterator();
                    iterator.next();
                    this.previousRevision = this.getClassFactory().createRevisionInfo((GitRevisionInfo.GitRevCommit)iterator.next(), this.getRepository());
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block5;
                throw new GitException(t);
            }
        }
    }
}

