/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitConfig;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;

public class SetRemoteCommand
extends GitCommand {
    private final GitRemoteConfig remote;

    public SetRemoteCommand(JGitRepository repository, GitClassFactory gitFactory, GitRemoteConfig remoteConfig, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.remote = remoteConfig;
    }

    @Override
    protected void run() throws GitException {
        JGitConfig config = this.getRepository().getConfig();
        config.load();
        config.unset("remote", this.remote.getRemoteName(), "url");
        config.unset("remote", this.remote.getRemoteName(), "pushurl");
        config.unset("remote", this.remote.getRemoteName(), "fetch");
        config.unset("remote", this.remote.getRemoteName(), "push");
        for (String uri : this.remote.getUris()) {
            config.setString("remote", this.remote.getRemoteName(), "url", uri);
        }
        for (String uri : this.remote.getPushUris()) {
            config.setString("remote", this.remote.getRemoteName(), "pushurl", uri);
        }
        for (String spec : this.remote.getFetchRefSpecs()) {
            config.setString("remote", this.remote.getRemoteName(), "fetch", spec);
        }
        for (String spec : this.remote.getPushRefSpecs()) {
            config.setString("remote", this.remote.getRemoteName(), "push", spec);
        }
        config.save();
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "setting up remote");
        this.addArgument(0, this.remote.getRemoteName());
    }
}

