/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.actions.Openable;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.CppDeclarationNode;
import org.netbeans.modules.cnd.qnavigator.navigator.StatementNode;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsElement;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

class BreadcrumbsElementImpl
implements BreadcrumbsElement {
    private final Node node;
    private final Lookup lookup;
    private final DataObject cdo;
    private BreadcrumbsElement parent;
    private List<BreadcrumbsElement> children;
    private final AtomicBoolean canceled;
    private final CharSequence text;

    public BreadcrumbsElementImpl(BreadcrumbsElement parent, Node node, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        this.lookup = Lookups.fixed((Object[])new Object[]{new OpenableImpl(node)});
        this.parent = parent;
        this.node = node;
        this.cdo = cdo;
        this.canceled = canceled;
        this.text = text;
    }

    public String getHtmlDisplayName() {
        String name = this.node.getName();
        if (name.indexOf(40) > 0) {
            CharSequence methodDefinitionScopeName;
            name = name.substring(0, name.indexOf(40));
            if (this.node instanceof CppDeclarationNode && (methodDefinitionScopeName = ((CppDeclarationNode)this.node).getMethodDefinitionScopeName()) != null && methodDefinitionScopeName.length() > 0) {
                name = methodDefinitionScopeName + "::" + name;
            }
        }
        name = CsmDisplayUtilities.htmlize((CharSequence)name);
        return name;
    }

    public Image getIcon(int type) {
        return this.node.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return this.node.getOpenedIcon(type);
    }

    public List<BreadcrumbsElement> getChildren() {
        if (this.children == null) {
            CsmObject csmObject;
            this.children = new ArrayList<BreadcrumbsElement>();
            if (this.node instanceof CppDeclarationNode && CsmKindUtilities.isOffsetable((Object)(csmObject = ((CppDeclarationNode)this.node).getCsmObject())) && CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                CsmFunctionDefinition funDef = (CsmFunctionDefinition)csmObject;
                CsmCompoundStatement body = funDef.getBody();
                if (body != null) {
                    if (this.canceled != null && this.canceled.get()) {
                        return this.children;
                    }
                    for (CsmStatement st : body.getStatements()) {
                        if (this.canceled != null && this.canceled.get()) break;
                        StatementNode statementNode = StatementNode.createStatementNode((CsmOffsetable)st, null, this, this.cdo, this.canceled, this.text);
                        if (statementNode == null) continue;
                        this.children.add(statementNode);
                    }
                }
                return this.children;
            }
            for (Node n : this.node.getChildren().getNodes()) {
                this.children.add(new BreadcrumbsElementImpl(this, n, this.cdo, this.canceled, this.text));
            }
        }
        return this.children;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public BreadcrumbsElement getParent() {
        return this.parent;
    }

    Node getNode() {
        return this.node;
    }

    void setParent(BreadcrumbsRoot root) {
        this.parent = root;
    }

    static final class BreadcrumbsRoot
    implements BreadcrumbsElement {
        private final DataObject cdo;
        private final BreadcrumbsElementImpl root;

        BreadcrumbsRoot(DataObject cdo, BreadcrumbsElementImpl root) {
            this.cdo = cdo;
            this.root = root;
        }

        public String getHtmlDisplayName() {
            return "";
        }

        public Image getIcon(int type) {
            return this.cdo.getNodeDelegate().getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.cdo.getNodeDelegate().getOpenedIcon(type);
        }

        public List<BreadcrumbsElement> getChildren() {
            return Collections.singletonList(this.root);
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public BreadcrumbsElement getParent() {
            return null;
        }
    }

    private static final class OpenableImpl
    implements Openable,
    OpenCookie {
        private final Node node;

        public OpenableImpl(Node node) {
            this.node = node;
        }

        public void open() {
            Action preferredAction;
            if (this.node instanceof CppDeclarationNode && (preferredAction = ((CppDeclarationNode)this.node).getPreferredAction()) instanceof AbstractAction) {
                ((AbstractAction)preferredAction).actionPerformed(null);
            }
        }
    }
}

