/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.sendto.api.Configuration;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public final class ConfigurationsModel
implements Cloneable {
    private static final ConfigurationsModel defaultModel = new ConfigurationsModel();
    private final List<Configuration> model = new ArrayList<Configuration>();
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    private ConfigurationsModel() {
    }

    public static ConfigurationsModel getDefault() {
        return defaultModel;
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(WeakListeners.change((ChangeListener)l, (Object)this));
    }

    public Object clone() {
        ConfigurationsModel clone = new ConfigurationsModel();
        for (Configuration configuration : this.model) {
            clone.model.add((Configuration)configuration.clone());
        }
        return clone;
    }

    public synchronized void add(Configuration cfg) {
        if (this.model.contains(cfg)) {
            return;
        }
        this.model.add(cfg);
        Collections.sort(this.model);
        this.cs.fireChange();
    }

    public synchronized void remove(Configuration cfg) {
        this.model.remove(cfg);
        this.cs.fireChange();
    }

    public synchronized void setDataFrom(ConfigurationsModel src) {
        this.model.clear();
        this.model.addAll(src.model);
        this.cs.fireChange();
    }

    public List<Configuration> getConfigurations() {
        return Collections.unmodifiableList(this.model);
    }
}

