/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CudaArch;
import org.clang.basic.CudaVirtualArch;
import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.JobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.CudaToolChain;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchCharPtr;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.sys.WindowsEncodingMethod;

public final class NVPTXStatics {

    public static class Linker
    extends Tool
    implements Destructors.ClassWithDestructor {
        public Linker(ToolChain TC) {
            super(NativePointer.$((String)"NVPTX::Linker"), NativePointer.$((String)"fatbinary"), TC, Tool.ResponseFileSupport.RF_Full, WindowsEncodingMethod.WEM_UTF8, NativePointer.$((String)"--options-file"));
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                CudaToolChain TC = (CudaToolChain)this.getToolChain();
                assert (TC.getTriple().isNVPTX()) : "Wrong platform";
                ArgStringList CmdArgs = new ArgStringList();
                CmdArgs.push_back((Object)NativePointer.$((String)"--cuda"));
                CmdArgs.push_back((Object)(TC.getTriple().isArch64Bit() ? NativePointer.$((String)"-64") : NativePointer.$((String)"-32")));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine("--create")));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Output.getFilename())));
                for (InputInfo II : Inputs) {
                    Action A = II.getAction();
                    assert (A.getInputs().size() == 1) : "Device offload action is expected to have a single input";
                    char.ptr gpu_arch_str = Native.$tryClone((char.ptr)A.getOffloadingArch());
                    assert (gpu_arch_str != null) : "Device action expected to have associated a GPU architecture!";
                    CudaArch gpu_arch = BasicClangGlobals.StringToCudaArch((StringRef)new StringRef(gpu_arch_str));
                    char.ptr Arch = Native.$tryClone((char.ptr)(II.getType() == types.ID.TY_PP_Asm ? BasicClangGlobals.CudaVirtualArchToString((CudaVirtualArch)BasicClangGlobals.VirtualArchForCudaArch((CudaArch)gpu_arch)) : gpu_arch_str));
                    CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("--image=profile="), (Twine)new Twine(Arch)), (Twine)new Twine(",file=")), (Twine)new Twine(II.getFilename()))));
                }
                for (std.string A : (std.vectorString)$c$.clean($c$.track((Object)Args.getAllArgValues(new OptSpecifier(options.ID.OPT_Xcuda_fatbinary.getValue()))))) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(A)));
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(TC.GetProgramPath(NativePointer.$((String)"fatbinary")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assembler
    extends Tool
    implements Destructors.ClassWithDestructor {
        public Assembler(ToolChain TC) {
            super(NativePointer.$((String)"NVPTX::Assembler"), NativePointer.$((String)"ptxas"), TC, Tool.ResponseFileSupport.RF_Full, WindowsEncodingMethod.WEM_UTF8, NativePointer.$((String)"--options-file"));
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                CudaToolChain TC = (CudaToolChain)this.getToolChain();
                assert (TC.getTriple().isNVPTX()) : "Wrong platform";
                CudaArch gpu_arch = BasicClangGlobals.StringToCudaArch((StringRef)new StringRef(JA.getOffloadingArch()));
                assert (gpu_arch != CudaArch.UNKNOWN) : "Device action expected to have an architecture.";
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_no_cuda_version_check.getValue()))) {
                    TC.cudaInstallation().CheckCudaVersionSupportsArch(gpu_arch);
                }
                ArgStringList CmdArgs = new ArgStringList();
                CmdArgs.push_back((Object)(TC.getTriple().isArch64Bit() ? NativePointer.$((String)"-m64") : NativePointer.$((String)"-m32")));
                if (Args.hasFlag(new OptSpecifier(options.ID.OPT_cuda_noopt_device_debug.getValue()), new OptSpecifier(options.ID.OPT_no_cuda_noopt_device_debug.getValue()), false)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-g"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"--dont-merge-basicblocks"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"--return-at-end"));
                } else {
                    Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_O_Group.getValue()));
                    if (A != null) {
                        StringRef OOpt = new StringRef(NativePointer.$3);
                        if (A.getOption().matches(new OptSpecifier(options.ID.OPT_O4.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_Ofast.getValue()))) {
                            OOpt.$assignMove(NativePointer.$3);
                        } else if (A.getOption().matches(new OptSpecifier(options.ID.OPT_O0.getValue()))) {
                            OOpt.$assignMove(NativePointer.$0);
                        } else if (A.getOption().matches(new OptSpecifier(options.ID.OPT_O.getValue()))) {
                            OOpt.$assignMove(new StringSwitchCharPtr(A.getValue()).Case("1", NativePointer.$1).Case("2", NativePointer.$2).Case("3", NativePointer.$3).Case("s", NativePointer.$2).Case("z", NativePointer.$2).Default(NativePointer.$2));
                        }
                        CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-O"), (Twine)new Twine(OOpt))));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-O0"));
                    }
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"--gpu-name"));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(BasicClangGlobals.CudaArchToString((CudaArch)gpu_arch))));
                CmdArgs.push_back((Object)NativePointer.$((String)"--output-file"));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Output.getFilename())));
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(II.getFilename())));
                }
                for (std.string A : (std.vectorString)$c$.clean($c$.track((Object)Args.getAllArgValues(new OptSpecifier(options.ID.OPT_Xcuda_ptxas.getValue()))))) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(A)));
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(TC.GetProgramPath(NativePointer.$((String)"ptxas")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

