/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.rename;

import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.Validations;
import org.netbeans.modules.docker.ui.rename.Bundle;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RenamePanel
extends JPanel {
    private final JButton actionButton;
    private NotificationLineSupport messageLine;
    private JLabel nameLabel;
    private JTextField nameTextField;

    public RenamePanel(JButton actionButton) {
        this.initComponents();
        this.actionButton = actionButton;
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RenamePanel.this.validateInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RenamePanel.this.validateInput();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RenamePanel.this.validateInput();
            }
        });
    }

    public void setMessageLine(NotificationLineSupport messageLine) {
        this.messageLine = messageLine;
        this.validateInput();
    }

    private void validateInput() {
        String message;
        if (this.messageLine == null) {
            return;
        }
        this.messageLine.clearMessages();
        this.actionButton.setEnabled(true);
        if (this.getContainerName() == null) {
            this.messageLine.setErrorMessage(Bundle.MSG_EmptyName());
            this.actionButton.setEnabled(false);
            return;
        }
        String name = this.getContainerName();
        if (name != null && (message = Validations.validateContainer(name)) != null) {
            this.messageLine.setErrorMessage(message);
            this.actionButton.setEnabled(false);
            return;
        }
    }

    public String getContainerName() {
        return UiUtils.getValue(this.nameTextField);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(RenamePanel.class, (String)"RenamePanel.nameLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTextField, -1, 419, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

