/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.updatetask;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLFile {
    protected final Document doc;
    private File file;
    private final XPath xPath;

    protected XMLFile(File f) throws IOException {
        this(new FileInputStream(f));
        this.file = f;
    }

    protected XMLFile(InputStream resource) throws IOException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.doc = dBuilder.parse(resource);
            this.xPath = XPathFactory.newInstance().newXPath();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex);
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        finally {
            resource.close();
        }
    }

    protected final Node getXpathNode(String axpath) {
        try {
            return (Node)this.xPath.evaluate(axpath, this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected final NodeList getXpathNodes(String axpath) {
        try {
            return (NodeList)this.xPath.evaluate(axpath, this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected final Node getXpathAttribute(String xpath, String attribute) {
        return this.getXpathNode(xpath).getAttributes().getNamedItem(attribute);
    }

    protected final Node getNode(String axpath) {
        assert (axpath != null);
        assert (axpath.startsWith("/"));
        try {
            return (Node)this.xPath.evaluate(axpath, this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected final String getTextContent(Node node) {
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    protected final String getTextContent(String xpath) {
        Node node = this.getNode(xpath);
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    protected final void setTextContent(String xpath, String value) {
        this.createXpath(xpath).setTextContent(value);
    }

    private Node createXpath(String xpath) {
        Node node;
        Node n = this.getNode(xpath);
        if (n != null) {
            return n;
        }
        int indexOf = xpath.indexOf("/", 1);
        Node lastNode = node = this.getNode(xpath.substring(0, indexOf));
        int lastIndexOf = indexOf;
        while (node != null) {
            indexOf = xpath.indexOf("/", indexOf + 1);
            lastNode = node;
            node = indexOf < 0 ? null : this.getNode(xpath.substring(0, indexOf));
        }
        String rest = xpath.substring(lastIndexOf + 1, xpath.length());
        for (String newTag : rest.split("/")) {
            lastNode = lastNode.appendChild(this.doc.createElement(newTag));
        }
        return lastNode;
    }

    protected String getAttributeText(String path, String attrName) {
        return this.getAttributeText(this.getNode(path), attrName);
    }

    protected void setAttributeText(String path, String attrName, String value) {
        Attr attr = this.doc.createAttribute(attrName);
        attr.setValue(value);
        this.createXpath(path).getAttributes().setNamedItem(attr);
    }

    protected final String getAttributeText(Node node, String attrName) {
        if (node == null) {
            return null;
        }
        Node namedItem = node.getAttributes().getNamedItem(attrName);
        if (namedItem == null) {
            return null;
        }
        return namedItem.getTextContent();
    }

    final void printDocument(OutputStream out) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(this.doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    public final void save() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        try {
            this.printDocument(fileOutputStream);
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
        finally {
            fileOutputStream.close();
        }
    }
}

