/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationBase;
import org.netbeans.modules.cnd.makeproject.api.configurations.InheritedBooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationMakefileWriter;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.util.NbBundle;

public abstract class BasicCompilerConfiguration
implements AllOptionsProvider,
ConfigurationBase {
    private String baseDir;
    private BasicCompilerConfiguration master;
    public static final int DEVELOPMENT_MODE_FAST = 0;
    public static final int DEVELOPMENT_MODE_DEBUG = 1;
    public static final int DEVELOPMENT_MODE_DEBUG_PERF = 2;
    public static final int DEVELOPMENT_MODE_TEST = 3;
    public static final int DEVELOPMENT_MODE_RELEASE_DIAG = 4;
    public static final int DEVELOPMENT_MODE_RELEASE = 5;
    public static final int DEVELOPMENT_MODE_RELEASE_PERF = 6;
    private static final String[] DEVELOPMENT_MODE_NAMES = new String[]{BasicCompilerConfiguration.getString("FastBuildTxt"), BasicCompilerConfiguration.getString("DebugTxt"), BasicCompilerConfiguration.getString("PerformanceDebugTxt"), BasicCompilerConfiguration.getString("TestCoverageTxt"), BasicCompilerConfiguration.getString("DiagnosableReleaseTxt"), BasicCompilerConfiguration.getString("ReleaseTxt"), BasicCompilerConfiguration.getString("PerformanceReleaseTxt")};
    public static final int WARNING_LEVEL_NO = 0;
    public static final int WARNING_LEVEL_DEFAULT = 1;
    public static final int WARNING_LEVEL_MORE = 2;
    public static final int WARNING_LEVEL_TAGS = 3;
    public static final int WARNING_LEVEL_CONVERT = 4;
    public static final int WARNING_LEVEL_32_64 = 5;
    private static final String[] WARNING_LEVEL_NAMES = new String[]{BasicCompilerConfiguration.getString("NoWarningsTxt"), BasicCompilerConfiguration.getString("SomeWarningsTxt"), BasicCompilerConfiguration.getString("MoreWarningsTxt"), BasicCompilerConfiguration.getString("ConvertWarningsTxt")};
    public static final int BITS_DEFAULT = 0;
    public static final int BITS_32 = 1;
    public static final int BITS_64 = 2;
    private static final String[] BITS_NAMES = new String[]{BasicCompilerConfiguration.getString("BITS_DEFAULT"), BasicCompilerConfiguration.getString("BITS_32"), BasicCompilerConfiguration.getString("BITS_64")};
    public static final int MT_LEVEL_NONE = 0;
    public static final int MT_LEVEL_SAFE = 1;
    public static final int MT_LEVEL_AUTOMATIC = 2;
    public static final int MT_LEVEL_OPENMP = 3;
    private static final String[] MT_LEVEL_NAMES = new String[]{BasicCompilerConfiguration.getString("NoneTxt"), BasicCompilerConfiguration.getString("SafeTxt"), BasicCompilerConfiguration.getString("AutomaticTxt"), BasicCompilerConfiguration.getString("OpenMPTxt")};
    private MakeConfiguration owner;
    private final ConfigurationContainer container;
    private static final ConfigurationContainer UNMANAGED_CONTAINER = new UnmanagedConfigurationContainer();
    private static final String UNSUPPORTED = "Unsupported";
    protected static final IntConfiguration UNSUPPORTED_INT_CONFIGURATION = new UnsupportedIntConfiguration();
    protected static final StringConfiguration UNSUPPORTED_STRING_CONFIGURATION = new UnsupportedStringConfiguration();
    protected static final BooleanConfiguration UNSUPPORTED_BOOLEAN_CONFIGURATION = new UnsupportedBooleanConfiguration();
    protected static final InheritedBooleanConfiguration UNSUPPORTED_INHERITED_BOOLEAN_CONFIGURATION = new UnsupportedInheritedBooleanConfiguration();
    protected static final OptionsConfiguration UNSUPPORTED_OPTIONS_CONFIGURATION = new UnsupportedOptionsConfiguration();

    protected BasicCompilerConfiguration(String baseDir, BasicCompilerConfiguration master, MakeConfiguration owner) {
        assert (owner != null);
        this.owner = owner;
        this.baseDir = baseDir;
        this.master = master;
        this.container = !owner.isMakefileConfiguration() ? new ManagedConfigurationContainer(master) : UNMANAGED_CONTAINER;
    }

    public MakeConfiguration getOwner() {
        return this.owner;
    }

    public void setOwner(MakeConfiguration owner) {
        this.owner = owner;
    }

    public void fixupMasterLinks(BasicCompilerConfiguration compilerConfiguration) {
        this.getDevelopmentMode().setMaster(compilerConfiguration.getDevelopmentMode());
        this.getWarningLevel().setMaster(compilerConfiguration.getWarningLevel());
        this.getSixtyfourBits().setMaster(compilerConfiguration.getSixtyfourBits());
        this.getStrip().setMaster(compilerConfiguration.getStrip());
        this.getAdditionalDependencies().setMaster(compilerConfiguration.getAdditionalDependencies());
        this.getTool().setMaster(compilerConfiguration.getTool());
    }

    @Override
    public boolean getModified() {
        return this.container.getModified();
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public abstract String getOptions(AbstractCompiler var1);

    public void setMaster(BasicCompilerConfiguration master) {
        this.master = master;
    }

    public BasicCompilerConfiguration getMaster() {
        return this.master;
    }

    public List<BasicCompilerConfiguration> getMasters(boolean addThis) {
        ArrayList<BasicCompilerConfiguration> res = new ArrayList<BasicCompilerConfiguration>();
        if (addThis) {
            res.add(this);
        }
        for (BasicCompilerConfiguration current = this.master; current != null; current = current.getMaster()) {
            if (res.contains(current)) {
                assert (false) : "Infinite loop in configurations";
                break;
            }
            res.add(current);
        }
        return res;
    }

    public void setDevelopmentMode(IntConfiguration developmentMode) {
        this.container.setDevelopmentMode(developmentMode);
    }

    public IntConfiguration getDevelopmentMode() {
        return this.container.getDevelopmentMode();
    }

    public void setWarningLevel(IntConfiguration warningLevel) {
        this.container.setWarningLevel(warningLevel);
    }

    public IntConfiguration getWarningLevel() {
        return this.container.getWarningLevel();
    }

    public void setSixtyfourBits(IntConfiguration sixtyfourBits) {
        this.container.setSixtyfourBits(sixtyfourBits);
    }

    public IntConfiguration getSixtyfourBits() {
        return this.container.getSixtyfourBits();
    }

    public void setMTLevel(IntConfiguration mpLevel) {
        this.container.setMTLevel(mpLevel);
    }

    public IntConfiguration getMTLevel() {
        return this.container.getMTLevel();
    }

    public void setStrip(InheritedBooleanConfiguration strip) {
        this.container.setStrip(strip);
    }

    public InheritedBooleanConfiguration getStrip() {
        return this.container.getStrip();
    }

    public void setAdditionalDependencies(StringConfiguration additionalDependencies) {
        this.container.setAdditionalDependencies(additionalDependencies);
    }

    public StringConfiguration getAdditionalDependencies() {
        return this.container.getAdditionalDependencies();
    }

    public void setTool(StringConfiguration tool) {
        this.container.setTool(tool);
    }

    public StringConfiguration getTool() {
        return this.container.getTool();
    }

    public void setCommandLineConfiguration(OptionsConfiguration commandLineConfiguration) {
        this.container.setCommandLineConfiguration(commandLineConfiguration);
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.container.getCommandLineConfiguration();
    }

    protected String getCommandLineOptions(boolean inherit) {
        if (!inherit) {
            return this.getCommandLineConfiguration().getValue();
        }
        LinkedList<String> options = new LinkedList<String>();
        List<BasicCompilerConfiguration> masters = this.getMasters(true);
        for (int i = 0; i < masters.size() - 1; ++i) {
            options.add(0, masters.get(i).getCommandLineConfiguration().getValue());
        }
        StringBuilder sb = new StringBuilder();
        options.forEach(opt -> sb.append((String)opt).append(' '));
        return sb.toString().trim();
    }

    public String getOutputFile(Item item, MakeConfiguration conf, boolean expanded) {
        int i;
        String filePath = item.getPath(true);
        if (conf.isQmakeConfiguration()) {
            filePath = CndPathUtilities.getBaseName((String)filePath);
        }
        String fileName = filePath;
        String suffix = ".o";
        boolean append = false;
        if (item.hasHeaderOrSourceExtension(false, false)) {
            AbstractCompiler compiler;
            suffix = ".pch";
            ItemConfiguration itemConf = item.getItemConfiguration(conf);
            if (conf.getCompilerSet().getCompilerSet() != null && itemConf != null && (compiler = (AbstractCompiler)conf.getCompilerSet().getCompilerSet().getTool((ToolKind)itemConf.getTool())) != null && compiler.getDescriptor() != null) {
                suffix = compiler.getDescriptor().getPrecompiledHeaderSuffix();
                append = compiler.getDescriptor().getPrecompiledHeaderSuffixAppend();
            }
        }
        fileName = (i = fileName.lastIndexOf(46)) >= 0 && !append ? fileName.substring(0, i) + suffix : fileName + suffix;
        String dirName = item.getFolder() != null && item.getFolder().isTest() ? (expanded ? ConfigurationMakefileWriter.getTestObjectDir(conf) : "${TESTDIR}") : (expanded ? ConfigurationMakefileWriter.getObjectDir(conf) : "${OBJECTDIR}");
        if (CndPathUtilities.isPathAbsolute((CharSequence)fileName) || filePath.startsWith("..")) {
            String ofileName = CndPathUtilities.getBaseName((String)fileName);
            String odirName = CndPathUtilities.getDirName((String)fileName);
            if (odirName == null) {
                odirName = "";
            }
            String absPath = dirName + '/' + "_ext" + '/' + Integer.toHexString(odirName.hashCode()) + '/' + ofileName;
            absPath = CndPathUtilities.replaceOddCharacters((String)absPath, (char)'_');
            return absPath;
        }
        fileName = CndPathUtilities.escapeOddCharacters((String)fileName);
        return dirName + '/' + fileName;
    }

    protected void assign(BasicCompilerConfiguration conf) {
        this.setBaseDir(conf.getBaseDir());
        this.getDevelopmentMode().assign(conf.getDevelopmentMode());
        this.getWarningLevel().assign(conf.getWarningLevel());
        this.getSixtyfourBits().assign(conf.getSixtyfourBits());
        this.getStrip().assign(conf.getStrip());
        this.getMTLevel().assign(conf.getMTLevel());
        this.getAdditionalDependencies().assign(conf.getAdditionalDependencies());
        this.getTool().assign(conf.getTool());
        this.getCommandLineConfiguration().assign(conf.getCommandLineConfiguration());
    }

    private static String getString(String s) {
        return NbBundle.getMessage(BasicCompilerConfiguration.class, (String)s);
    }

    private static final class UnsupportedOptionsConfiguration
    extends OptionsConfiguration {
        protected UnsupportedOptionsConfiguration() {
        }

        @Override
        public void setDirty(boolean dirty) {
        }

        @Override
        public boolean getDirty() {
            return false;
        }

        @Override
        public void setValue(String commandLine) {
        }

        @Override
        public String getValue() {
            return "";
        }

        @Override
        public void setModified(boolean b) {
        }

        @Override
        public boolean getModified() {
            return false;
        }

        @Override
        public String getDefault() {
            return "";
        }

        @Override
        public void optionsReset() {
        }

        @Override
        public void setPreDefined(String preDefined) {
        }

        @Override
        public String getPreDefined() {
            return "";
        }

        @Override
        public void assign(OptionsConfiguration conf) {
        }

        @Override
        public OptionsConfiguration clone() {
            return this;
        }

        @Override
        public String toString() {
            return "{commandLine=" + this.getValue() + "] dirty=" + this.getDirty() + " commandLineModified=" + this.getModified() + '}';
        }
    }

    private static final class UnsupportedInheritedBooleanConfiguration
    extends InheritedBooleanConfiguration {
        protected UnsupportedInheritedBooleanConfiguration() {
        }

        @Override
        protected BooleanConfiguration getMaster() {
            return null;
        }

        @Override
        public void setMaster(InheritedBooleanConfiguration master) {
        }

        @Override
        public void setValue(boolean b) {
        }

        @Override
        public boolean getValue() {
            return false;
        }

        @Override
        public void setModified(boolean b) {
        }

        @Override
        public boolean getModified() {
            return false;
        }

        @Override
        public void setDirty(boolean dirty) {
        }

        @Override
        public boolean getDirty() {
            return false;
        }

        @Override
        public boolean getDefault() {
            return false;
        }

        @Override
        public void setDefault(boolean b) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void assign(InheritedBooleanConfiguration conf) {
        }

        @Override
        @SuppressWarnings(value={"CN"})
        public InheritedBooleanConfiguration clone() {
            return this;
        }

        @Override
        public String toString() {
            return "{value=" + this.getValue() + " modified=" + this.getModified() + " dirty=" + this.getDirty() + '}';
        }
    }

    private static final class UnsupportedBooleanConfiguration
    extends BooleanConfiguration {
        protected UnsupportedBooleanConfiguration() {
        }

        @Override
        public void setValue(boolean b) {
        }

        @Override
        public boolean getValue() {
            return false;
        }

        @Override
        public void setModified(boolean b) {
        }

        @Override
        public boolean getModified() {
            return false;
        }

        @Override
        public void setDirty(boolean dirty) {
        }

        @Override
        public boolean getDirty() {
            return false;
        }

        @Override
        public boolean getDefault() {
            return false;
        }

        @Override
        public void setDefault(boolean b) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void assign(BooleanConfiguration conf) {
        }

        @Override
        @SuppressWarnings(value={"CN"})
        public BooleanConfiguration clone() {
            return this;
        }

        @Override
        public String toString() {
            return "{value=" + this.getValue() + " modified=" + this.getModified() + " dirty=" + this.getDirty() + '}';
        }
    }

    private static final class UnsupportedStringConfiguration
    extends StringConfiguration {
        protected UnsupportedStringConfiguration() {
        }

        @Override
        public void setMaster(StringConfiguration master) {
        }

        @Override
        public void setValue(String b) {
        }

        @Override
        public String getValue() {
            return "";
        }

        @Override
        public String getValueDef(String def) {
            return "";
        }

        @Override
        public String getValue(String delim) {
            return "";
        }

        @Override
        public void setModified(boolean b) {
        }

        @Override
        public boolean getModified() {
            return false;
        }

        @Override
        public String getDefault() {
            return "";
        }

        @Override
        public void reset() {
        }

        @Override
        public void setDefaultValue(String def) {
        }

        @Override
        public void assign(StringConfiguration conf) {
        }

        @Override
        public StringConfiguration clone() {
            return this;
        }

        @Override
        public String toString() {
            return "{value=" + this.getValue() + " modified=" + this.getModified() + '}';
        }
    }

    private static final class UnsupportedIntConfiguration
    extends IntConfiguration {
        protected UnsupportedIntConfiguration() {
        }

        @Override
        public void setMaster(IntConfiguration master) {
        }

        @Override
        public void setValue(int value) {
        }

        @Override
        public void setValue(String s) {
        }

        @Override
        public int getValue() {
            return 0;
        }

        @Override
        public final void setModified(boolean b) {
        }

        @Override
        public boolean getModified() {
            return false;
        }

        @Override
        public void setDirty(boolean dirty) {
        }

        @Override
        public boolean getDirty() {
            return false;
        }

        @Override
        public int getDefault() {
            return 0;
        }

        @Override
        public void setDefault(int def) {
        }

        @Override
        public void reset() {
        }

        @Override
        public String getName() {
            return BasicCompilerConfiguration.UNSUPPORTED;
        }

        @Override
        public String[] getNames() {
            return new String[]{BasicCompilerConfiguration.UNSUPPORTED};
        }

        @Override
        public String getOption() {
            return BasicCompilerConfiguration.UNSUPPORTED;
        }

        @Override
        public void assign(IntConfiguration conf) {
        }

        @Override
        @SuppressWarnings(value={"CN"})
        public IntConfiguration clone() {
            return this;
        }

        @Override
        public byte getPreviousValue() {
            return 0;
        }

        @Override
        public String toString() {
            return "(" + this.getValue() + ")" + this.getName();
        }
    }

    private static final class UnmanagedConfigurationContainer
    implements ConfigurationContainer {
        private UnmanagedConfigurationContainer() {
        }

        @Override
        public void setDevelopmentMode(IntConfiguration developmentMode) {
        }

        @Override
        public IntConfiguration getDevelopmentMode() {
            return UNSUPPORTED_INT_CONFIGURATION;
        }

        @Override
        public void setWarningLevel(IntConfiguration warningLevel) {
        }

        @Override
        public IntConfiguration getWarningLevel() {
            return UNSUPPORTED_INT_CONFIGURATION;
        }

        @Override
        public void setSixtyfourBits(IntConfiguration sixtyfourBits) {
        }

        @Override
        public IntConfiguration getSixtyfourBits() {
            return UNSUPPORTED_INT_CONFIGURATION;
        }

        @Override
        public void setMTLevel(IntConfiguration mpLevel) {
        }

        @Override
        public IntConfiguration getMTLevel() {
            return UNSUPPORTED_INT_CONFIGURATION;
        }

        @Override
        public void setStrip(InheritedBooleanConfiguration strip) {
        }

        @Override
        public InheritedBooleanConfiguration getStrip() {
            return UNSUPPORTED_INHERITED_BOOLEAN_CONFIGURATION;
        }

        @Override
        public void setAdditionalDependencies(StringConfiguration additionalDependencies) {
        }

        @Override
        public StringConfiguration getAdditionalDependencies() {
            return UNSUPPORTED_STRING_CONFIGURATION;
        }

        @Override
        public void setTool(StringConfiguration tool) {
        }

        @Override
        public StringConfiguration getTool() {
            return UNSUPPORTED_STRING_CONFIGURATION;
        }

        @Override
        public void setCommandLineConfiguration(OptionsConfiguration commandLineConfiguration) {
        }

        @Override
        public OptionsConfiguration getCommandLineConfiguration() {
            return UNSUPPORTED_OPTIONS_CONFIGURATION;
        }

        @Override
        public boolean getModified() {
            return false;
        }
    }

    private static final class ManagedConfigurationContainer
    implements ConfigurationContainer {
        private IntConfiguration developmentMode;
        private IntConfiguration warningLevel;
        private IntConfiguration sixtyfourBits;
        private InheritedBooleanConfiguration strip;
        private IntConfiguration mpLevel;
        private StringConfiguration additionalDependencies;
        private StringConfiguration tool;
        private OptionsConfiguration commandLineConfiguration;

        private ManagedConfigurationContainer(BasicCompilerConfiguration master) {
            this.developmentMode = new IntConfiguration(master != null ? master.getDevelopmentMode() : null, 1, DEVELOPMENT_MODE_NAMES, null);
            this.warningLevel = new IntConfiguration(master != null ? master.getWarningLevel() : null, 1, WARNING_LEVEL_NAMES, null);
            this.sixtyfourBits = new IntConfiguration(master != null ? master.getSixtyfourBits() : null, 0, BITS_NAMES, null);
            this.strip = new InheritedBooleanConfiguration(master != null ? master.getStrip() : null, false);
            this.mpLevel = new IntConfiguration(master != null ? master.getMTLevel() : null, 0, MT_LEVEL_NAMES, null);
            this.additionalDependencies = new StringConfiguration(master != null ? master.getAdditionalDependencies() : null, "");
            this.tool = new StringConfiguration(master != null ? master.getTool() : null, "");
            this.commandLineConfiguration = new OptionsConfiguration();
        }

        @Override
        public void setDevelopmentMode(IntConfiguration developmentMode) {
            this.developmentMode = developmentMode;
        }

        @Override
        public IntConfiguration getDevelopmentMode() {
            return this.developmentMode;
        }

        @Override
        public void setWarningLevel(IntConfiguration warningLevel) {
            this.warningLevel = warningLevel;
        }

        @Override
        public IntConfiguration getWarningLevel() {
            return this.warningLevel;
        }

        @Override
        public void setSixtyfourBits(IntConfiguration sixtyfourBits) {
            this.sixtyfourBits = sixtyfourBits;
        }

        @Override
        public IntConfiguration getSixtyfourBits() {
            return this.sixtyfourBits;
        }

        @Override
        public void setMTLevel(IntConfiguration mpLevel) {
            this.mpLevel = mpLevel;
        }

        @Override
        public IntConfiguration getMTLevel() {
            return this.mpLevel;
        }

        @Override
        public void setStrip(InheritedBooleanConfiguration strip) {
            this.strip = strip;
        }

        @Override
        public InheritedBooleanConfiguration getStrip() {
            return this.strip;
        }

        @Override
        public void setAdditionalDependencies(StringConfiguration additionalDependencies) {
            this.additionalDependencies = additionalDependencies;
        }

        @Override
        public StringConfiguration getAdditionalDependencies() {
            return this.additionalDependencies;
        }

        @Override
        public void setTool(StringConfiguration tool) {
            this.tool = tool;
        }

        @Override
        public StringConfiguration getTool() {
            return this.tool;
        }

        @Override
        public void setCommandLineConfiguration(OptionsConfiguration commandLineConfiguration) {
            this.commandLineConfiguration = commandLineConfiguration;
        }

        @Override
        public OptionsConfiguration getCommandLineConfiguration() {
            return this.commandLineConfiguration;
        }

        @Override
        public boolean getModified() {
            return this.developmentMode.getModified() || this.mpLevel.getModified() || this.warningLevel.getModified() || this.sixtyfourBits.getModified() || this.strip.getModified() || this.additionalDependencies.getModified() || this.tool.getModified() || this.commandLineConfiguration.getModified();
        }
    }

    private static interface ConfigurationContainer {
        public void setDevelopmentMode(IntConfiguration var1);

        public IntConfiguration getDevelopmentMode();

        public void setWarningLevel(IntConfiguration var1);

        public IntConfiguration getWarningLevel();

        public void setSixtyfourBits(IntConfiguration var1);

        public IntConfiguration getSixtyfourBits();

        public void setMTLevel(IntConfiguration var1);

        public IntConfiguration getMTLevel();

        public void setStrip(InheritedBooleanConfiguration var1);

        public InheritedBooleanConfiguration getStrip();

        public void setAdditionalDependencies(StringConfiguration var1);

        public StringConfiguration getAdditionalDependencies();

        public void setTool(StringConfiguration var1);

        public StringConfiguration getTool();

        public void setCommandLineConfiguration(OptionsConfiguration var1);

        public OptionsConfiguration getCommandLineConfiguration();

        public boolean getModified();
    }
}

