/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.Locale;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platforms;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectOptionsFormat;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.util.NbBundle;

public class LinkerConfiguration
implements AllOptionsProvider,
Cloneable {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration output;
    private VectorConfiguration<String> additionalLibs;
    private VectorConfiguration<String> dynamicSearch;
    private BooleanConfiguration stripOption;
    private BooleanConfiguration picOption;
    private BooleanConfiguration norunpathOption;
    private BooleanConfiguration nameassignOption;
    private OptionsConfiguration commandLineConfiguration;
    private OptionsConfiguration additionalDependencies;
    private IntConfiguration runTimeSearchPath;
    private LibrariesConfiguration librariesConfiguration;
    private BooleanConfiguration copyLibrariesConfiguration;
    private StringConfiguration tool;
    public static final int SEARCH_PATH_NONE = 0;
    public static final int SEARCH_PATH_RELATIVE_TO_WORKING_DIR = 1;
    public static final int SEARCH_PATH_RELATIVE_TO_BINARY = 2;
    public static final int SEARCH_PATH_ABSOLUTE = 3;
    private static final String[] SEARCH_PATH_NAMES = new String[]{LinkerConfiguration.getString("SEARCH_PATH_NONE"), LinkerConfiguration.getString("SEARCH_PATH_RELATIVE_TO_WORKING_DIR"), LinkerConfiguration.getString("SEARCH_PATH_RELATIVE_TO_BINARY"), LinkerConfiguration.getString("SEARCH_PATH_ABSOLUTE")};

    public LinkerConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.output = new StringConfiguration(null, "");
        this.additionalLibs = new VectorConfiguration(null);
        this.dynamicSearch = new VectorConfiguration(null);
        this.stripOption = new BooleanConfiguration(false);
        this.picOption = new BooleanConfiguration(true);
        this.norunpathOption = new BooleanConfiguration(true);
        this.nameassignOption = new BooleanConfiguration(true);
        this.commandLineConfiguration = new OptionsConfiguration();
        this.additionalDependencies = new OptionsConfiguration();
        this.additionalDependencies.setPreDefined(this.getAdditionalDependenciesPredefined());
        this.librariesConfiguration = new LibrariesConfiguration();
        boolean isMac = makeConfiguration.getDevelopmentHost().getBuildPlatform() == 4;
        this.copyLibrariesConfiguration = new BooleanConfiguration(isMac);
        if (isMac) {
            this.dynamicSearch.add(".");
        }
        this.tool = new StringConfiguration(null, "");
        this.runTimeSearchPath = new IntConfiguration(null, 1, SEARCH_PATH_NAMES, null);
    }

    public boolean getModified() {
        return this.getOutput().getModified() || this.getAdditionalLibs().getModified() || this.getDynamicSearch().getModified() || this.getStripOption().getModified() || this.getPICOption().getModified() || this.getNorunpathOption().getModified() || this.getLibrariesRunTimeSearchPathKind().getModified() || this.getNameassignOption().getModified() || this.getAdditionalDependencies().getModified() || this.getTool().getModified() || this.getLibrariesConfiguration().getModified() || this.getCopyLibrariesConfiguration().getModified() || this.getCommandLineConfiguration().getModified();
    }

    private String getAdditionalDependenciesPredefined() {
        String pd = "${BUILD_SUBPROJECTS} ${OBJECTFILES}";
        return pd;
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setOutput(StringConfiguration output) {
        this.output = output;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public VectorConfiguration<String> getAdditionalLibs() {
        return this.additionalLibs;
    }

    public void setAdditionalLibs(VectorConfiguration<String> additionalLibs) {
        this.additionalLibs = additionalLibs;
    }

    public VectorConfiguration<String> getDynamicSearch() {
        return this.dynamicSearch;
    }

    public void setDynamicSearch(VectorConfiguration<String> dynamicSearch) {
        this.dynamicSearch = dynamicSearch;
    }

    public void setStripOption(BooleanConfiguration stripOption) {
        this.stripOption = stripOption;
    }

    public BooleanConfiguration getStripOption() {
        return this.stripOption;
    }

    public void setPICOption(BooleanConfiguration picOption) {
        this.picOption = picOption;
    }

    public BooleanConfiguration getPICOption() {
        return this.picOption;
    }

    public void setNorunpathOption(BooleanConfiguration norunpathOption) {
        this.norunpathOption = norunpathOption;
    }

    public BooleanConfiguration getNorunpathOption() {
        return this.norunpathOption;
    }

    public void setNameassignOption(BooleanConfiguration nameassignOption) {
        this.nameassignOption = nameassignOption;
    }

    public BooleanConfiguration getNameassignOption() {
        return this.nameassignOption;
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.commandLineConfiguration;
    }

    public void setCommandLineConfiguration(OptionsConfiguration commandLineConfiguration) {
        this.commandLineConfiguration = commandLineConfiguration;
    }

    public OptionsConfiguration getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public void setAdditionalDependencies(OptionsConfiguration additionalDependencies) {
        this.additionalDependencies = additionalDependencies;
    }

    public LibrariesConfiguration getLibrariesConfiguration() {
        return this.librariesConfiguration;
    }

    public void setLibrariesConfiguration(LibrariesConfiguration librariesConfiguration) {
        this.librariesConfiguration = librariesConfiguration;
    }

    public BooleanConfiguration getCopyLibrariesConfiguration() {
        return this.copyLibrariesConfiguration;
    }

    public void setCopyLibrariesConfiguration(BooleanConfiguration copyLibrariesConfiguration) {
        this.copyLibrariesConfiguration = copyLibrariesConfiguration;
    }

    public IntConfiguration getLibrariesRunTimeSearchPathKind() {
        return this.runTimeSearchPath;
    }

    public void setLibrariesRunTimeSearchPathKind(IntConfiguration runTimeSearchPath) {
        this.runTimeSearchPath = runTimeSearchPath;
    }

    public void setTool(StringConfiguration tool) {
        this.tool = tool;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void assign(LinkerConfiguration conf) {
        this.getOutput().assign(conf.getOutput());
        this.getAdditionalLibs().assign(conf.getAdditionalLibs());
        this.getDynamicSearch().assign(conf.getDynamicSearch());
        this.getCommandLineConfiguration().assign(conf.getCommandLineConfiguration());
        this.getAdditionalDependencies().assign(conf.getAdditionalDependencies());
        this.getStripOption().assign(conf.getStripOption());
        this.getPICOption().assign(conf.getPICOption());
        this.getNorunpathOption().assign(conf.getNorunpathOption());
        this.getLibrariesRunTimeSearchPathKind().assign(conf.getLibrariesRunTimeSearchPathKind());
        this.getNameassignOption().assign(conf.getNameassignOption());
        this.getLibrariesConfiguration().assign(conf.getLibrariesConfiguration());
        this.getCopyLibrariesConfiguration().assign(conf.getCopyLibrariesConfiguration());
        this.getTool().assign(conf.getTool());
    }

    public LinkerConfiguration clone() {
        LinkerConfiguration clone = new LinkerConfiguration(this.getMakeConfiguration());
        clone.setOutput(this.getOutput().clone());
        clone.setAdditionalLibs((VectorConfiguration<String>)this.getAdditionalLibs().clone());
        clone.setDynamicSearch((VectorConfiguration<String>)this.getDynamicSearch().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setStripOption(this.getStripOption().clone());
        clone.setPICOption(this.getPICOption().clone());
        clone.setNorunpathOption(this.getNorunpathOption().clone());
        clone.setLibrariesRunTimeSearchPathKind(this.getLibrariesRunTimeSearchPathKind().clone());
        clone.setNameassignOption(this.getNameassignOption().clone());
        clone.setLibrariesConfiguration(this.getLibrariesConfiguration().clone());
        clone.setCopyLibrariesConfiguration(this.getCopyLibrariesConfiguration().clone());
        clone.setTool(this.getTool().clone());
        return clone;
    }

    public String getOutputOptions() {
        String options = "";
        CompilerSet cs = this.getMakeConfiguration().getCompilerSet().getCompilerSet();
        if (cs != null) {
            options = options + cs.getCompilerFlavor().getToolchainDescriptor().getLinker().getOutputFileFlag() + this.getOutputValue() + " ";
        }
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    public String getBasicOptions() {
        String options = "";
        CompilerSet cs = this.getMakeConfiguration().getCompilerSet().getCompilerSet();
        if (this.getMakeConfiguration().isDynamicLibraryConfiguration()) {
            String libName = this.getOutputValue();
            int sep = libName.lastIndexOf(47);
            if (sep >= 0 && libName.length() > 1) {
                libName = libName.substring(sep + 1);
            }
            if (cs != null) {
                options = options + cs.getCompilerFlavor().getToolchainDescriptor().getLinker().getDynamicLibraryBasicFlag();
                if (cs.getCompilerFlavor().isGnuCompiler() && this.getMakeConfiguration().getDevelopmentHost().getBuildPlatform() == 4) {
                    options = options + libName + " ";
                }
            }
        }
        if (cs != null && this.getStripOption().getValue()) {
            options = options + cs.getCompilerFlavor().getToolchainDescriptor().getLinker().getStripFlag() + " ";
        }
        if (this.getMakeConfiguration().isDynamicLibraryConfiguration() && cs != null) {
            if (this.getPICOption().getValue()) {
                options = options + this.getPICOption(cs);
            }
            if (cs.getCompilerFlavor().isSunStudioCompiler()) {
                if (this.getNorunpathOption().getValue()) {
                    options = options + "-norunpath ";
                }
                options = options + this.getNameassignOption(this.getNameassignOption().getValue()) + " ";
            }
        }
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    public String getPICOption(CompilerSet cs) {
        ToolchainManager.LinkerDescriptor linker = cs.getCompilerFlavor().getToolchainDescriptor().getLinker();
        if (linker != null) {
            return linker.getPICFlag();
        }
        return null;
    }

    public String getLibraryItems() {
        ToolchainManager.LinkerDescriptor linker;
        CompilerSet cs = this.getMakeConfiguration().getCompilerSet().getCompilerSet();
        ToolchainManager.LinkerDescriptor linkerDescriptor = linker = cs == null ? null : cs.getCompilerFlavor().getToolchainDescriptor().getLinker();
        if (linker == null) {
            return "";
        }
        String options = "";
        CCCCompilerConfiguration.OptionToString staticSearchVisitor = new CCCCompilerConfiguration.OptionToString(cs, linker.getLibrarySearchFlag());
        options = options + this.getAdditionalLibs().toString(staticSearchVisitor) + " ";
        if (linker.getDynamicLibrarySearchFlag() != null && linker.getDynamicLibrarySearchFlag().length() > 0) {
            SearchOptionToString dynamicSearchVisitor = new SearchOptionToString(cs, linker.getDynamicLibrarySearchFlag());
            options = options + this.getDynamicSearch().toString(dynamicSearchVisitor) + " ";
        }
        LibraryToString libVisitor = new LibraryToString(this.getMakeConfiguration());
        options = options + this.getLibrariesConfiguration().toString(libVisitor) + " ";
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        String options = this.getOutputOptions() + " ";
        options = options + this.getLibraryItems() + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        options = options + this.getBasicOptions() + " ";
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    private String getNameassignOption(boolean val) {
        if (val) {
            return "-h " + CndPathUtilities.getBaseName((String)this.getOutputValue());
        }
        return "";
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    public String getOutputDefault() {
        String outputName = CndPathUtilities.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        switch (this.getMakeConfiguration().getConfigurationType().getValue()) {
            case 1: 
            case 7: {
                outputName = outputName.toLowerCase(Locale.getDefault());
                break;
            }
            case 2: 
            case 10: {
                outputName = Platforms.getPlatform(this.getMakeConfiguration().getDevelopmentHost().getBuildPlatform()).getLibraryNameWithoutExtension(outputName);
            }
        }
        outputName = ConfigurationSupport.makeNameLegal(outputName);
        if (this.getMakeConfiguration().isDynamicLibraryConfiguration()) {
            return "${CND_DISTDIR}/${CND_CONF}/${CND_PLATFORM}/" + outputName + "." + "${CND_DLIB_EXT}";
        }
        return "${CND_DISTDIR}/${CND_CONF}/${CND_PLATFORM}/" + outputName;
    }

    public String getOutputDefault27() {
        String outputName = CndPathUtilities.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 1 || this.getMakeConfiguration().getConfigurationType().getValue() == 7) {
            outputName = outputName.toLowerCase(Locale.getDefault());
        } else if (this.getMakeConfiguration().isDynamicLibraryConfiguration()) {
            outputName = "lib" + outputName + ".so";
        }
        return "dist/" + this.getMakeConfiguration().getName() + "/" + outputName;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(LinkerConfiguration.class, (String)s);
    }

    public String toString() {
        return "{output=" + this.output + " additionalLibs=" + this.additionalLibs + " dynamicSearch=" + this.dynamicSearch + " stripOption=" + this.stripOption + " picOption=" + this.picOption + " norunpathOption=" + this.norunpathOption + " nameassignOption=" + this.nameassignOption + " commandLineConfiguration=" + this.commandLineConfiguration + " additionalDependencies=" + this.additionalDependencies + " librariesConfiguration=" + this.librariesConfiguration + " copyLibrariesConfiguration=" + this.copyLibrariesConfiguration + " tool=" + this.tool + '}';
    }

    public static class SearchOptionToString
    implements VectorConfiguration.ToString<String> {
        private final CompilerSet compilerSet;
        private final String prepend;

        public SearchOptionToString(CompilerSet compilerSet, String prepend) {
            this.compilerSet = compilerSet;
            this.prepend = prepend;
        }

        @Override
        public String toString(String item) {
            if (0 < item.length()) {
                if (this.compilerSet != null) {
                    item = CppUtils.normalizeDriveLetter(this.compilerSet, item);
                }
                if ((item = CndPathUtilities.escapeOddCharacters((String)item)).startsWith("$ORIGIN")) {
                    item = "$" + item;
                }
                return this.prepend == null ? item : this.prepend + "'" + item + "'";
            }
            return "";
        }
    }

    public static class LibraryToString
    implements VectorConfiguration.ToString<LibraryItem> {
        private final MakeConfiguration conf;

        public LibraryToString(MakeConfiguration conf) {
            this.conf = conf;
        }

        @Override
        public String toString(LibraryItem item) {
            return item.getOption(this.conf);
        }
    }
}

