/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.TextFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CloseButton;
import org.netbeans.lib.profiler.ui.results.ColoredFilter;
import org.netbeans.lib.profiler.ui.results.PackageColorer;
import org.netbeans.lib.profiler.ui.swing.EditableHistoryCombo;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.spi.ActionsSupportProvider;

public final class FilterUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    public static final String ACTION_FILTER = messages.getString("FilterUtils_ActionFilter");
    private static final String SIDEBAR_CAPTION = messages.getString("FilterUtils_SidebarCaption");
    private static final String BTN_FILTER_TOOLTIP = messages.getString("FilterUtils_BtnFilterTooltip");
    private static final String BTN_MATCH_CASE_TOOLTIP = messages.getString("FilterUtils_BtnMatchCaseTooltip");
    private static final String BTN_CLOSE_TOOLTIP = messages.getString("FilterUtils_BtnCloseTooltip");
    private static final String MSG_INVALID_REGEXP = messages.getString("FilterUtils_MsgInvalidRegexp");
    private static final String FILTER_CONTAINS = messages.getString("FilterUtils_FilterContains");
    private static final String FILTER_NOT_CONTAINS = messages.getString("FilterUtils_FilterNotContains");
    private static final String FILTER_REGEXP = messages.getString("FilterUtils_FilterRegexp");
    private static final String FILTER_TYPE = messages.getString("FilterUtils_FilterType");
    private static final String INSERT_FILTER = messages.getString("FilterUtils_InsertFilter");
    public static final String FILTER_ACTION_KEY = "filter-action-key";

    public static boolean filterContains(ProfilerTable table, String filter) {
        return FilterUtils.filterContains(table, filter, false, null);
    }

    public static boolean filterContains(ProfilerTable table, String filter, boolean matchCase, RowFilter excludes) {
        return FilterUtils.filter(table, (GenericFilter)new TextFilter(filter, 10, matchCase), excludes);
    }

    public static boolean filterNotContains(ProfilerTable table, String filter, boolean matchCase, RowFilter excludes) {
        return FilterUtils.filter(table, (GenericFilter)new TextFilter(filter, 20, matchCase), excludes);
    }

    public static boolean filterRegExp(ProfilerTable table, String filter, RowFilter excludes) {
        return FilterUtils.filter(table, (GenericFilter)new TextFilter(filter, 30, false), excludes);
    }

    public static boolean filter(ProfilerTable table, final GenericFilter textFilter, final RowFilter excludesFilter) {
        final int mainColumn = table.getMainColumn();
        Filter filter = new Filter(){

            public boolean include(RowFilter.Entry entry) {
                if (excludesFilter != null && excludesFilter.include(entry)) {
                    return true;
                }
                return textFilter.passes(entry.getValue(mainColumn).toString());
            }
        };
        if (!textFilter.isEmpty()) {
            table.addRowFilter(filter);
            return table.getRowCount() > 0;
        }
        table.removeRowFilter(filter);
        return false;
    }

    public static JComponent createFilterPanel(ProfilerTable table) {
        return FilterUtils.createFilterPanel(table, null);
    }

    public static JComponent createFilterPanel(final ProfilerTable table, final RowFilter excludesFilter) {
        InvisibleToolbar toolbar = new InvisibleToolbar();
        if (UIUtils.isWindowsModernLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        }
        toolbar.add(Box.createHorizontalStrut(6));
        toolbar.add(new JLabel(SIDEBAR_CAPTION));
        toolbar.add(Box.createHorizontalStrut(3));
        final EditableHistoryCombo combo = new EditableHistoryCombo();
        final JTextComponent textC = combo.getTextComponent();
        JPanel comboContainer = new JPanel(new BorderLayout());
        comboContainer.add((Component)combo, "Center");
        comboContainer.setMinimumSize(combo.getMinimumSize());
        comboContainer.setPreferredSize(combo.getPreferredSize());
        comboContainer.setMaximumSize(combo.getMaximumSize());
        toolbar.add(comboContainer);
        if (PackageColorer.hasRegisteredColors()) {
            toolbar.add(new PopupButton(){
                {
                    this.setToolTipText(INSERT_FILTER);
                }

                @Override
                protected void populatePopup(JPopupMenu popup) {
                    for (final ColoredFilter color : PackageColorer.getRegisteredColors()) {
                        if (color.getValue().trim().isEmpty()) continue;
                        Icon icon = color.getColor() == null ? null : color.getIcon(12, 12);
                        popup.add(new JMenuItem(color.getName(), icon){

                            @Override
                            protected void fireActionPerformed(ActionEvent event) {
                                String current = FilterUtils.getFilterString(combo);
                                if (current == null) {
                                    current = "";
                                }
                                if (!current.isEmpty()) {
                                    current = current + " ";
                                }
                                current = current + color.getValue();
                                textC.setText(current);
                                combo.requestFocusInWindow();
                            }
                        });
                    }
                }
            });
        }
        toolbar.add(Box.createHorizontalStrut(5));
        KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
        KeyStroke filterKey = KeyStroke.getKeyStroke(10, 0);
        final TextFilter activeFilter = new TextFilter(){

            protected void handleInvalidFilter(String invalidValue, RuntimeException e) {
                ProfilerDialogs.displayError((String)MessageFormat.format(MSG_INVALID_REGEXP, invalidValue));
            }
        };
        final TextFilter currentFilter = new TextFilter();
        final JButton filter = new JButton(ACTION_FILTER, Icons.getIcon((String)"GeneralIcons.Filter")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                final 4 _this = this;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        activeFilter.copyFrom(currentFilter);
                        if (FilterUtils.filter(table, (GenericFilter)activeFilter, excludesFilter)) {
                            combo.addItem(activeFilter.getValue());
                        }
                        FilterUtils.updateFilterButton(_this, currentFilter, activeFilter);
                    }
                });
            }
        };
        String filterAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)filterKey);
        filter.setToolTipText(MessageFormat.format(BTN_FILTER_TOOLTIP, filterAccelerator));
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (filter.isEnabled()) {
                            filter.doClick();
                            combo.requestFocusInWindow();
                        }
                    }
                });
            }
        };
        FilterUtils.installAction(filter, filterAction, filterKey, FILTER_ACTION_KEY);
        toolbar.add(filter);
        FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
        toolbar.add(Box.createHorizontalStrut(2));
        ((JToolBar)toolbar).addSeparator();
        toolbar.add(Box.createHorizontalStrut(1));
        final JToggleButton matchCase = new JToggleButton(Icons.getIcon((String)"GeneralIcons.MatchCase")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                if (this.isEnabled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            currentFilter.setCaseSensitive(this.isSelected());
                            FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
                        }
                    });
                }
            }
        };
        matchCase.setToolTipText(BTN_MATCH_CASE_TOOLTIP);
        FilterUtils.installAction(matchCase, filterAction, filterKey, FILTER_ACTION_KEY);
        PopupButton filterType = new PopupButton(Icons.getIcon((String)"GeneralIcons.FilterContains")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JMenuItem(FILTER_CONTAINS, Icons.getIcon((String)"GeneralIcons.FilterContains")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.filterImpl(10, this.getIcon(), this.getText());
                    }
                });
                popup.add(new JMenuItem(FILTER_NOT_CONTAINS, Icons.getIcon((String)"GeneralIcons.FilterNotContains")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.filterImpl(20, this.getIcon(), this.getText());
                    }
                });
                popup.add(new JMenuItem(FILTER_REGEXP, Icons.getIcon((String)"GeneralIcons.FilterRegExp")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.filterImpl(30, this.getIcon(), this.getText());
                    }
                });
            }

            private void filterImpl(final int type, final Icon icon, final String name) {
                if (type == 30) {
                    matchCase.setEnabled(false);
                    matchCase.setSelected(false);
                } else if (!matchCase.isEnabled()) {
                    matchCase.setSelected(currentFilter.isCaseSensitive());
                    matchCase.setEnabled(true);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setIcon(icon);
                        this.setToolTipText(MessageFormat.format(FILTER_TYPE, name));
                        currentFilter.setType(type);
                        FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
                    }
                });
            }
        };
        filterType.setToolTipText(MessageFormat.format(FILTER_TYPE, FILTER_CONTAINS));
        FilterUtils.installAction(filterType, filterAction, filterKey, FILTER_ACTION_KEY);
        toolbar.add(filterType);
        toolbar.add(matchCase);
        toolbar.add(Box.createHorizontalStrut(2));
        combo.setOnTextChangeHandler(new Runnable(){

            @Override
            public void run() {
                currentFilter.setValue(FilterUtils.getFilterString(combo));
                FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
            }
        });
        final JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (!visible) {
                    table.requestFocusInWindow();
                }
            }

            @Override
            public boolean requestFocusInWindow() {
                if (textC != null) {
                    textC.selectAll();
                }
                return combo.requestFocusInWindow();
            }
        };
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")));
        panel.add((Component)toolbar, "Center");
        final Runnable hider = new Runnable(){

            @Override
            public void run() {
                activeFilter.setValue("");
                FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
                FilterUtils.filter(table, (GenericFilter)activeFilter, excludesFilter);
                panel.setVisible(false);
            }
        };
        JButton closeButton = CloseButton.create(hider);
        String escAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)escKey);
        closeButton.setToolTipText(MessageFormat.format(BTN_CLOSE_TOOLTIP, escAccelerator));
        panel.add((Component)closeButton, "East");
        String HIDE = "hide-action";
        InputMap map = panel.getInputMap(1);
        AbstractAction hiderAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                hider.run();
            }
        };
        panel.getActionMap().put(HIDE, hiderAction);
        map.put(escKey, HIDE);
        if (textC != null) {
            map = textC.getInputMap();
            AbstractAction _filterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (combo.isPopupVisible()) {
                        combo.hidePopup();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (filter.isEnabled()) {
                                filter.doClick();
                            }
                        }
                    });
                }
            };
            textC.getActionMap().put(FILTER_ACTION_KEY, _filterAction);
            map.put(filterKey, FILTER_ACTION_KEY);
        }
        return panel;
    }

    private static void installAction(JComponent comp, Action action, KeyStroke keyStroke, String actionKey) {
        comp.getActionMap().put(actionKey, action);
        comp.getInputMap().put(keyStroke, actionKey);
    }

    private static String getFilterString(EditableHistoryCombo combo) {
        String filter = combo.getText();
        return filter == null ? null : filter.trim();
    }

    private static void updateFilterButton(JButton button, TextFilter currentFilter, TextFilter activeFilter) {
        button.setEnabled(!currentFilter.equals((Object)activeFilter));
    }

    private FilterUtils() {
    }

    private static interface Support {

        public static final class FilterActionProvider
        extends ActionsSupportProvider {
            public KeyStroke registerAction(String actionKey, Action action, ActionMap actionMap, InputMap inputMap) {
                if (!FilterUtils.FILTER_ACTION_KEY.equals(actionKey)) {
                    return null;
                }
                KeyStroke ks = KeyStroke.getKeyStroke(71, 2);
                actionMap.put(actionKey, action);
                inputMap.put(ks, actionKey);
                return ks;
            }
        }
    }

    private static abstract class Filter
    extends RowFilter {
        private Filter() {
        }

        public boolean equals(Object o) {
            return o instanceof Filter;
        }

        public int hashCode() {
            return Integer.MAX_VALUE;
        }
    }
}

