/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.HistoryRegistry;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.VersionsCache;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.log.LogAction;
import org.netbeans.modules.mercurial.remote.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.history.HistoryActionVCSProxyBased;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HgHistoryProvider
implements VCSHistoryProvider {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final List<VCSHistoryProvider.HistoryChangeListener> listeners = new LinkedList<VCSHistoryProvider.HistoryChangeListener>();
    private Action[] actions;
    private static final Logger LOG = Logger.getLogger(HgHistoryProvider.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized VCSHistoryProvider.HistoryEntry[] getHistory(VCSFileProxy[] files, Date fromDate) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        this.logFiles("retrieving history for files: ", files);
        long t = System.currentTimeMillis();
        if (files == null || files.length == 0) {
            return null;
        }
        try {
            String toRevision;
            String fromRevision;
            if (!HgHistoryProvider.isClientAvailable(files[0])) {
                LOG.log(Level.WARNING, "Remote ''{0}'' Mercurial client is unavailable", VCSFileProxySupport.getFileSystem((VCSFileProxy)files[0]));
                VCSHistoryProvider.HistoryEntry[] historyEntryArray = null;
                return historyEntryArray;
            }
            Set<VCSFileProxy> repositories = HgHistoryProvider.getRepositoryRoots(files);
            if (repositories == null) {
                VCSHistoryProvider.HistoryEntry[] historyEntryArray = null;
                return historyEntryArray;
            }
            LinkedList<VCSHistoryProvider.HistoryEntry> ret = new LinkedList<VCSHistoryProvider.HistoryEntry>();
            HashMap<String, HashSet<VCSFileProxy>> rev2FileMap = new HashMap<String, HashSet<VCSFileProxy>>();
            HashMap<String, HgLogMessage> rev2LMMap = new HashMap<String, HgLogMessage>();
            if (fromDate == null) {
                fromRevision = "0";
                toRevision = "BASE";
            } else {
                fromRevision = this.dateFormat.format(fromDate);
                toRevision = this.dateFormat.format(new Date(System.currentTimeMillis()));
            }
            VCSFileProxy repositoryRoot = repositories.iterator().next();
            for (VCSFileProxy file : files) {
                HgLogMessage[] history;
                FileInformation info = Mercurial.getInstance().getFileStatusCache().refresh(file);
                int status = info.getStatus();
                if ((status & 0x1DF8) == 0) continue;
                for (HgLogMessage h : history = HistoryRegistry.getInstance().getLogs(repositoryRoot, files, fromRevision, toRevision)) {
                    String r = h.getHgRevision().getRevisionNumber();
                    rev2LMMap.put(r, h);
                    HashSet<VCSFileProxy> s = (HashSet<VCSFileProxy>)rev2FileMap.get(r);
                    if (s == null) {
                        s = new HashSet<VCSFileProxy>();
                        rev2FileMap.put(r, s);
                    }
                    s.add(file);
                }
            }
            for (HgLogMessage h : rev2LMMap.values()) {
                Set s = (Set)rev2FileMap.get(h.getHgRevision().getRevisionNumber());
                VCSFileProxy[] involvedFiles = s.toArray(new VCSFileProxy[s.size()]);
                ret.add(this.createHistoryEntry(h, repositoryRoot, involvedFiles));
            }
            VCSHistoryProvider.HistoryEntry[] historyEntryArray = ret.toArray(new VCSHistoryProvider.HistoryEntry[ret.size()]);
            return historyEntryArray;
        }
        finally {
            LOG.log(Level.FINE, "retrieving history took {0}", System.currentTimeMillis() - t);
        }
    }

    public Action createShowHistoryAction(VCSFileProxy[] files) {
        return new OpenHistoryAction(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHistoryChange(final VCSFileProxy[] files) {
        VCSHistoryProvider.HistoryChangeListener[] la;
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            la = this.listeners.toArray(new VCSHistoryProvider.HistoryChangeListener[this.listeners.size()]);
        }
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                for (VCSHistoryProvider.HistoryChangeListener l : la) {
                    l.fireHistoryChanged(new VCSHistoryProvider.HistoryEvent((VCSHistoryProvider)HgHistoryProvider.this, files));
                }
            }
        });
    }

    private void logFiles(String msg, VCSFileProxy[] files) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        for (int i = 0; i < files.length; ++i) {
            VCSFileProxy f = files[i];
            if (f == null) continue;
            sb.append(f.getPath());
            if (i >= files.length - 1) continue;
            sb.append(",");
        }
        LOG.fine(sb.toString());
    }

    private VCSHistoryProvider.HistoryEntry createHistoryEntry(HgLogMessage h, VCSFileProxy repository, VCSFileProxy[] files) {
        String username = h.getUsername();
        String author = h.getAuthor();
        if (username == null || "".equals(username.trim())) {
            username = author;
        }
        return new VCSHistoryProvider.HistoryEntry(files, h.getDate(), h.getMessage(), author, username, h.getHgRevision().getRevisionNumber() + ":" + h.getHgRevision().getChangesetId(), h.getHgRevision().getRevisionNumber(), this.getActions(), (VCSHistoryProvider.RevisionProvider)new RevisionProviderImpl(h.getHgRevision()), null, (VCSHistoryProvider.ParentProvider)new ParentProviderImpl(h, files, repository));
    }

    private synchronized Action[] getActions() {
        if (this.actions == null) {
            this.actions = new Action[]{new HistoryActionVCSProxyBased(){

                protected void perform(final VCSHistoryProvider.HistoryEntry entry, final Set<VCSFileProxy> files) {
                    final VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(files.iterator().next());
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                    HgProgressSupport support = new HgProgressSupport(){

                        @Override
                        public void perform() {
                            RevertModificationsAction.performRevert(root, HgHistoryProvider.this.getHgRevision(entry).getRevisionNumber(), new LinkedList<VCSFileProxy>(files), HgModuleConfig.getDefault(root).getBackupOnRevertModifications(), false, this.getLogger());
                        }
                    };
                    support.start(rp, root, NbBundle.getMessage(LogAction.class, (String)"MSG_Revert_Progress"));
                }

                protected boolean isMultipleHistory() {
                    return false;
                }

                public String getName() {
                    String rev = this.getRevisionShort();
                    if (rev == null) {
                        rev = "";
                    }
                    return NbBundle.getMessage(LogAction.class, (String)"CTL_SummaryView_RollbackTo", (Object)rev);
                }

                public HelpCtx getHelpCtx() {
                    return null;
                }
            }, new HistoryActionVCSProxyBased(NbBundle.getMessage(LogAction.class, (String)"CTL_SummaryView_View")){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<VCSFileProxy> files) {
                    HgHistoryProvider.this.view(entry, false, files);
                }

                public HelpCtx getHelpCtx() {
                    return null;
                }
            }, new HistoryActionVCSProxyBased(NbBundle.getMessage(LogAction.class, (String)"CTL_SummaryView_ShowAnnotations")){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<VCSFileProxy> files) {
                    HgHistoryProvider.this.view(entry, true, files);
                }

                public HelpCtx getHelpCtx() {
                    return null;
                }
            }};
        }
        return this.actions;
    }

    private void view(final VCSHistoryProvider.HistoryEntry entry, final boolean showAnnotations, final Set<VCSFileProxy> files) {
        VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(files.iterator().next());
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        rp.post(new Runnable(){

            @Override
            public void run() {
                for (VCSFileProxy f : files) {
                    try {
                        HgUtils.openInRevision(f, -1, HgHistoryProvider.this.getHgRevision(entry), showAnnotations);
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    private HgLogMessage.HgRevision getHgRevision(VCSHistoryProvider.HistoryEntry entry) {
        String[] revs = entry.getRevision().split(":");
        HgLogMessage.HgRevision revision = new HgLogMessage.HgRevision(revs[1], revs[0]);
        return revision;
    }

    private static boolean isClientAvailable(VCSFileProxy root) {
        return Mercurial.getInstance().isAvailable(root, true, false);
    }

    private static Set<VCSFileProxy> getRepositoryRoots(VCSFileProxy ... files) {
        Set<VCSFileProxy> repositories = HgUtils.getRepositoryRoots(new HashSet<VCSFileProxy>(Arrays.asList(files)));
        if (repositories.size() != 1) {
            LOG.log(Level.WARNING, "History requested for {0} repositories", repositories.size());
            return null;
        }
        return repositories;
    }

    private static class OpenHistoryAction
    extends AbstractAction {
        private final VCSFileProxy[] files;

        public OpenHistoryAction(VCSFileProxy[] files) {
            this.files = files;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.openHistory(this.files);
        }

        private void openHistory(VCSFileProxy[] files) {
            if (files == null || files.length == 0) {
                return;
            }
            if (!HgHistoryProvider.isClientAvailable(files[0])) {
                LOG.log(Level.WARNING, "Remote ''{0}'' Mercurial client is unavailable", VCSFileProxySupport.getFileSystem((VCSFileProxy)files[0]));
                return;
            }
            Set repositories = HgHistoryProvider.getRepositoryRoots(files);
            if (repositories == null) {
                return;
            }
            LogAction.openHistory((VCSFileProxy)repositories.iterator().next(), files);
        }
    }

    private class ParentProviderImpl
    implements VCSHistoryProvider.ParentProvider {
        private final HgLogMessage logMessage;
        private final VCSFileProxy[] files;
        private final VCSFileProxy repository;

        public ParentProviderImpl(HgLogMessage logMessage, VCSFileProxy[] files, VCSFileProxy repository) {
            this.logMessage = logMessage;
            this.files = files;
            this.repository = repository;
        }

        public VCSHistoryProvider.HistoryEntry getParentEntry(VCSFileProxy file) {
            VCSFileProxy originalFile;
            HgLogMessage.HgRevision ancestor = this.logMessage.getAncestor(file);
            if (ancestor.equals(HgLogMessage.HgRevision.EMPTY) && (originalFile = HistoryRegistry.getInstance().getHistoryFile(this.repository, file, this.logMessage.getCSetShortID(), false)) != null) {
                ancestor = this.logMessage.getAncestor(originalFile);
            }
            if (ancestor.equals(HgLogMessage.HgRevision.EMPTY)) {
                return null;
            }
            HgLogMessage history = HistoryRegistry.getInstance().getLog(this.repository, file, ancestor.getChangesetId());
            if (history == null) {
                return null;
            }
            return HgHistoryProvider.this.createHistoryEntry(history, this.repository, this.files);
        }
    }

    private static class RevisionProviderImpl
    implements VCSHistoryProvider.RevisionProvider {
        private final HgLogMessage.HgRevision hgRevision;

        public RevisionProviderImpl(HgLogMessage.HgRevision hgRevision) {
            this.hgRevision = hgRevision;
        }

        public void getRevisionFile(VCSFileProxy originalFile, VCSFileProxy revisionFile) {
            assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
            if (!HgHistoryProvider.isClientAvailable(originalFile)) {
                LOG.log(Level.WARNING, "Remote ''{0}''  Mercurial client is unavailable", VCSFileProxySupport.getFileSystem((VCSFileProxy)originalFile));
                return;
            }
            try {
                VCSFileProxy file;
                Set repositories;
                FileInformation info = Mercurial.getInstance().getFileStatusCache().refresh(originalFile);
                if (info != null && (info.getStatus() & 0x1000) != 0 && info.getStatus(null) != null && info.getStatus(null).getOriginalFile() != null) {
                    originalFile = info.getStatus(null).getOriginalFile();
                }
                if ((repositories = HgHistoryProvider.getRepositoryRoots(new VCSFileProxy[]{originalFile})) == null || repositories.isEmpty()) {
                    LOG.log(Level.WARNING, "Repository root not found for file {0}", originalFile);
                    return;
                }
                VCSFileProxy repository = (VCSFileProxy)repositories.iterator().next();
                VCSFileProxy historyFile = HistoryRegistry.getInstance().getHistoryFile(repository, originalFile, this.hgRevision.getChangesetId(), true);
                if (historyFile != null) {
                    originalFile = historyFile;
                }
                if ((file = VersionsCache.getInstance().getFileRevision(originalFile, this.hgRevision, false)) != null) {
                    VCSFileProxySupport.copyFile((VCSFileProxy)file, (VCSFileProxy)revisionFile);
                } else if (historyFile == null) {
                    LOG.log(Level.WARNING, "File {0} not found in revision {1}. Will make a guess ...", new Object[]{originalFile, this.hgRevision});
                    historyFile = HistoryRegistry.getInstance().getHistoryFile(repository, originalFile, this.hgRevision.getChangesetId(), false);
                    if (historyFile != null && (file = VersionsCache.getInstance().getFileRevision(historyFile, this.hgRevision, false)) != null) {
                        VCSFileProxySupport.copyFile((VCSFileProxy)file, (VCSFileProxy)revisionFile);
                    }
                }
            }
            catch (IOException e) {
                if (e.getCause() instanceof HgException.HgCommandCanceledException) {
                    LOG.log(Level.FINE, null, e);
                }
                LOG.log(Level.WARNING, null, e);
            }
        }
    }
}

