/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.remotefs.versioning.api.RemoteFileSystemConnectionListener;
import org.netbeans.modules.remotefs.versioning.api.RemoteFileSystemConnectionManager;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SubversionVisibilityQuery;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.core.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.core.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.CollocationQueryImplementation2;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class SubversionVCS
extends VersioningSystem
implements PropertyChangeListener,
VersioningListener,
PreferenceChangeListener,
RemoteFileSystemConnectionListener {
    static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    private VCSVisibilityQuery visibilityQuery;
    private final CollocationQueryImplementation2 collocationQueryImplementation = new CollocationQueryImplementation2(){

        public boolean areCollocated(URI file1, URI file2) {
            VCSFileProxy a = VCSFileProxySupport.fromURI((URI)file1);
            VCSFileProxy b = VCSFileProxySupport.fromURI((URI)file2);
            if (a == null || b == null) {
                return false;
            }
            VCSFileProxy fra = SubversionVCS.this.getTopmostManagedAncestor(a);
            VCSFileProxy frb = SubversionVCS.this.getTopmostManagedAncestor(b);
            if (fra == null || !fra.equals((Object)frb)) {
                return false;
            }
            try {
                SVNUrl ra = SvnUtils.getRepositoryRootUrl(a);
                if (ra == null) {
                    Subversion.LOG.log(Level.WARNING, "areCollocated returning false due to missing repository url for {0} {1}", new Object[]{a, b});
                    return false;
                }
                SVNUrl rb = SvnUtils.getRepositoryRootUrl(b);
                SVNUrl rr = SvnUtils.getRepositoryRootUrl(fra);
                return ra.equals(rb) && ra.equals(rr);
            }
            catch (SVNClientException e) {
                if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                    Subversion.LOG.log(Level.INFO, null, e);
                }
                Subversion.LOG.log(Level.WARNING, "areCollocated returning false due to catched exception " + a + " " + b);
                return false;
            }
        }

        public URI findRoot(URI file) {
            VCSFileProxy topmostManagedAncestor;
            VCSFileProxy fromURI = VCSFileProxySupport.fromURI((URI)file);
            if (fromURI != null && (topmostManagedAncestor = SubversionVCS.this.getTopmostManagedAncestor(fromURI)) != null) {
                return VCSFileProxySupport.toURI((VCSFileProxy)topmostManagedAncestor);
            }
            return null;
        }
    };

    public SubversionVCS() {
        RemoteFileSystemConnectionManager.getInstance().addRemoteFileSystemConnectionListener((RemoteFileSystemConnectionListener)this);
        for (FileSystem fileSystem : VCSFileProxySupport.getConnectedFileSystems()) {
            SvnModuleConfig.getDefault(fileSystem).getPreferences().addPreferenceChangeListener(this);
        }
        Subversion.getInstance().attachListeners(this);
    }

    public static String getDisplayName() {
        return NbBundle.getMessage(SubversionVCS.class, (String)"CTL_Subversion_DisplayName");
    }

    public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
        return Subversion.getInstance().getTopmostManagedAncestor(file);
    }

    public VCSAnnotator getVCSAnnotator() {
        return Subversion.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Subversion.getInstance().getInterceptor();
    }

    public void getOriginalFile(VCSFileProxy workingCopy, VCSFileProxy originalFile) {
        Subversion.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    public VCSHistoryProvider getVCSHistoryProvider() {
        return Subversion.getInstance().getHistoryProvider();
    }

    public CollocationQueryImplementation2 getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public VCSVisibilityQuery getVisibilityQuery() {
        if (this.visibilityQuery == null) {
            this.visibilityQuery = new SubversionVisibilityQuery();
        }
        return this.visibilityQuery;
    }

    public void versioningEvent(VersioningEvent event) {
        VCSFileProxy file;
        if (FileStatusCache.EVENT_FILE_STATUS_CHANGED.equals(event.getId()) && (file = (VCSFileProxy)event.getParams()[0]) != null) {
            this.fireStatusChanged(file);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(PROP_ANNOTATIONS_CHANGED)) {
            this.fireAnnotationsChanged((Set)evt.getNewValue());
        } else if (evt.getPropertyName().equals("baseFileChanged")) {
            this.fireStatusChanged((Set)evt.getNewValue());
        } else if (evt.getPropertyName().equals("versionedFilesChanged")) {
            Subversion.LOG.fine("cleaning unversioned parents cache");
            this.fireVersionedFilesChanged();
        }
    }

    public void connected(FileSystem fs) {
        Subversion.getInstance().versionedFilesChanged();
        this.postVersionedRootsChanged();
    }

    public void disconnected(FileSystem fs) {
        Subversion.getInstance().versionedFilesChanged();
        this.postVersionedRootsChanged();
    }

    private void postVersionedRootsChanged() {
        Subversion.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                VersioningSupport.versionedRootsChanged();
            }
        });
    }
}

