/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.config;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.config.KVFile;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public abstract class SVNCredentialFile
extends KVFile {
    protected SVNCredentialFile(VCSFileProxy file) {
        super(file);
    }

    @SuppressWarnings(value={"Dm"})
    protected static String getFileName(String realmString) {
        assert (realmString != null);
        StringBuilder fileName = new StringBuilder();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            try {
                md5.update(realmString.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                md5.update(realmString.getBytes());
            }
            byte[] md5digest = md5.digest();
            for (int i = 0; i < md5digest.length; ++i) {
                String hex = Integer.toHexString(md5digest[i] & 0xFF);
                fileName.append(hex);
                if (hex.length() != 1) continue;
                fileName.append('0');
            }
        }
        catch (NoSuchAlgorithmException e) {
            Subversion.LOG.log(Level.INFO, null, e);
        }
        return fileName.toString();
    }

    protected abstract String getRealmString();

    protected abstract void setRealmString(String var1);
}

