/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JConstantValueAttr;
import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantInteger;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class JField
extends FieldDefinition {
    private JConstantPool constant_pool;
    private int name_index;
    private int descriptor_index;
    private JAttribute[] attributes;
    private JConstant constant;

    public JField(JConstantPool jConstantPool) {
        this.constant_pool = jConstantPool;
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.access_flags = dataInputStream.readUnsignedShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.descriptor_index = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        this.attributes = new JAttribute[n];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readUnsignedShort();
            this.attributes[i] = JAttribute.create(this.constant_pool, n2);
            this.attributes[i].parse(dataInputStream);
        }
    }

    public JConstant getConstant() {
        return this.constant;
    }

    public void resolve() {
        this.field_name = this.constant_pool.getConstantUtf8(this.name_index).getString();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getString();
        if (!Modifier.isStatic(this.access_flags)) {
            return;
        }
        for (JAttribute jAttribute : this.attributes) {
            if (!(jAttribute instanceof JConstantValueAttr) || this.descriptor.length() != 1) continue;
            switch (this.descriptor.charAt(0)) {
                case 'B': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    this.value = new int[1];
                    JConstantInteger jConstantInteger = this.constant_pool.getConstantInteger(((JConstantValueAttr)jAttribute).getValueIndex());
                    if (jConstantInteger == null) {
                        throw new ClassFormatError();
                    }
                    this.value[0] = jConstantInteger.getInt();
                    return;
                }
            }
        }
    }
}

