/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.history;

import java.awt.EventQueue;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.remote.ui.history.Bundle;
import org.netbeans.modules.git.remote.ui.history.SearchOutgoingTopComponent;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class SearchOutgoingAction
extends MultipleRepositoryAction {
    @Override
    protected RequestProcessor.Task performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        this.openSearch(repository, roots, VCSFileProxySupport.getContextDisplayName((VCSContext)context));
        return null;
    }

    public void openSearch(VCSFileProxy repository, VCSFileProxy[] roots, String contextName) {
        String branchName = SearchOutgoingAction.getActiveBranchName(repository);
        if (branchName.equals("(no branch)")) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.MSG_SearchOutgoingTopComponent_err_noBranch(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        this.openSearch(repository, roots, branchName, contextName);
    }

    public void openSearch(final VCSFileProxy repository, final VCSFileProxy[] roots, final String branchName, String contextName) {
        final String title = Bundle.LBL_SearchOutgoingTopComponent_title(contextName, branchName);
        final RepositoryInfo info = RepositoryInfo.getInstance(repository);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchOutgoingTopComponent tc = new SearchOutgoingTopComponent(repository, info, roots);
                tc.setBranch(branchName);
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                tc.search(true);
            }
        });
    }

    private static String getActiveBranchName(VCSFileProxy repository) {
        GitBranch activeBranch = RepositoryInfo.getInstance(repository).getActiveBranch();
        String branchName = "(no branch)";
        if (activeBranch != GitBranch.NO_BRANCH_INSTANCE) {
            branchName = activeBranch.getName();
        }
        return branchName;
    }
}

