/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.repositorystep;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.WizardStepProgressSupport;
import org.netbeans.modules.subversion.kenai.SvnKenaiAccessor;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStepPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryStep
extends AbstractStep
implements WizardDescriptor.AsynchronousValidatingPanel,
PropertyChangeListener {
    public static final String IMPORT_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.import";
    public static final String CHECKOUT_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.checkout";
    public static final String URL_PATTERN_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.urlPattern";
    private Repository repository;
    private RepositoryStepPanel panel;
    private RepositoryFile repositoryFile;
    private int repositoryModeMask;
    private WizardStepProgressSupport support;
    private final String helpID;

    public RepositoryStep(String helpID) {
        this.repositoryModeMask = 0;
        this.helpID = helpID;
    }

    public RepositoryStep(int repositoryModeMask, String helpID) {
        this.repositoryModeMask = repositoryModeMask;
        this.helpID = helpID;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(this.helpID);
    }

    @Override
    protected JComponent createComponent() {
        if (this.repository == null) {
            this.repositoryModeMask = this.repositoryModeMask | 2 | 4 | 0x20 | 0x40;
            String title = NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Location");
            this.repository = new Repository(this.repositoryModeMask, title);
            this.repository.addPropertyChangeListener(this);
            this.panel = new RepositoryStepPanel();
            this.panel.repositoryPanel.add(this.repository.getPanel());
            Dimension size = this.panel.getPreferredSize();
            this.panel.setPreferredSize(new Dimension(size.width, size.height + new JLabel((String)"A").getPreferredSize().height + new JButton((String)"A").getPreferredSize().height + 20));
            this.valid();
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateBeforeNext() {
        try {
            this.support = new RepositoryStepProgressSupport(this.panel.progressPanel);
            SVNUrl url = this.getUrl();
            if (url != null) {
                this.support.setRepositoryRoot(url);
                RequestProcessor rp = Subversion.getInstance().getRequestProcessor(url);
                RequestProcessor.Task task = this.support.start(rp, url, NbBundle.getMessage(RepositoryStep.class, (String)"BK2012"));
                task.waitFinished();
            }
        }
        finally {
            this.support = null;
        }
    }

    public void prepareValidation() {
    }

    private SVNUrl getUrl() {
        try {
            return this.getSelectedRepositoryConnection().getSvnUrl();
        }
        catch (MalformedURLException mue) {
            this.invalid(new AbstractStep.WizardMessage(mue.getLocalizedMessage(), false));
            return null;
        }
    }

    private void storeHistory() {
        RepositoryConnection rc = this.getSelectedRepositoryConnection();
        if (rc != null) {
            SvnModuleConfig.getDefault().insertRecentUrl(rc);
        }
    }

    public RepositoryFile getRepositoryFile() {
        return this.repositoryFile;
    }

    private RepositoryConnection getSelectedRepositoryConnection() {
        try {
            return this.repository.getSelectedRC();
        }
        catch (Exception ex) {
            this.invalid(new AbstractStep.WizardMessage(ex.getLocalizedMessage(), false));
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("valid")) {
            if (this.repository.isValid()) {
                this.valid(new AbstractStep.WizardMessage(this.repository.getMessage(), false));
            } else {
                this.invalid(new AbstractStep.WizardMessage(this.repository.getMessage(), false));
            }
        }
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    static /* synthetic */ RepositoryConnection access$000(RepositoryStep x0) {
        return x0.getSelectedRepositoryConnection();
    }

    static /* synthetic */ void access$100(RepositoryStep x0) {
        x0.storeHistory();
    }

    static /* synthetic */ void access$200(RepositoryStep x0, AbstractStep.WizardMessage x1) {
        x0.invalid(x1);
    }

    static /* synthetic */ RepositoryFile access$302(RepositoryStep x0, RepositoryFile x1) {
        x0.repositoryFile = x1;
        return x0.repositoryFile;
    }

    static /* synthetic */ void access$500(RepositoryStep x0, AbstractStep.WizardMessage x1) {
        x0.valid(x1);
    }

    static /* synthetic */ void access$600(RepositoryStep x0) {
        x0.valid();
    }

    static /* synthetic */ void access$700(RepositoryStep x0, AbstractStep.WizardMessage x1) {
        x0.valid(x1);
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        public RepositoryStepProgressSupport(JPanel panel) {
            super(panel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void perform() {
            rc = RepositoryStep.access$000(RepositoryStep.this);
            if (rc == null) {
                return;
            }
            RepositoryStep.access$100(RepositoryStep.this);
            invalidMsg = null;
            RepositoryStep.access$200(RepositoryStep.this, null);
            url = rc.getSvnUrl();
            try {
                handledExceptions = 65544;
                client = Subversion.getInstance().getClient(url, rc.getUsername(), rc.getPassword(), handledExceptions);
                ** GOTO lbl37
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)ex, true, true);
                invalidMsg = new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Invalid", (Object)rc.getUrl()), false);
                if (this.isCanceled()) {
                    RepositoryStep.access$500(RepositoryStep.this, new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                    return;
                }
                if (invalidMsg == null) {
                    RepositoryStep.access$600(RepositoryStep.this);
                    return;
                }
                RepositoryStep.access$700(RepositoryStep.this, invalidMsg);
                return;
            }
            {
                catch (MalformedURLException ex) {
                    block30: {
                        try {
                            invalidMsg = new AbstractStep.WizardMessage(ex.getLocalizedMessage(), false);
                        }
                        catch (Throwable var11_15) {
                            if (this.isCanceled()) {
                                RepositoryStep.access$500(RepositoryStep.this, new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                                throw var11_15;
                            }
                            if (invalidMsg == null) {
                                RepositoryStep.access$600(RepositoryStep.this);
                                throw var11_15;
                            }
                            RepositoryStep.access$700(RepositoryStep.this, invalidMsg);
                            throw var11_15;
                        }
lbl37:
                        // 1 sources

                        RepositoryStep.access$302(RepositoryStep.this, null);
                        info = null;
                        try {
                            RepositoryStep.access$400(RepositoryStep.this).storeConfigValues();
                            this.setCancellableDelegate(client);
                            info = client.getInfo(url);
                            ** GOTO lbl58
                        }
                        catch (SVNClientException ex) {}
                        if (!SvnClientExceptionHandler.isAuthentication(ex.getMessage()) || SvnKenaiAccessor.getInstance().canRead(SvnUtils.decodeToString(url))) ** GOTO lbl-1000
                        invalidMsg = new AbstractStep.WizardMessage(NbBundle.getMessage(Repository.class, (String)"MSG_Repository.kenai.insufficientRights.read"), false);
                        if (this.isCanceled()) {
                            RepositoryStep.access$500(RepositoryStep.this, new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                            return;
                        }
                        if (invalidMsg == null) {
                            RepositoryStep.access$600(RepositoryStep.this);
                            return;
                        }
                        RepositoryStep.access$700(RepositoryStep.this, invalidMsg);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            this.annotate(ex);
                            invalidMsg = new AbstractStep.WizardMessage(SvnClientExceptionHandler.parseExceptionMessage(ex), false);
lbl58:
                            // 2 sources

                            if (!this.isCanceled()) ** GOTO lbl-1000
                        }
                        if (this.isCanceled()) {
                            RepositoryStep.access$500(RepositoryStep.this, new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                            return;
                        }
                        if (invalidMsg == null) {
                            RepositoryStep.access$600(RepositoryStep.this);
                            return;
                        }
                        RepositoryStep.access$700(RepositoryStep.this, invalidMsg);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            if (info == null) ** GOTO lbl89
                            repositoryUrl = SvnUtils.decode(info.getRepository());
                            if (repositoryUrl == null) {
                                repositoryUrl = rc.getSvnUrl();
                            }
                            revision = rc.getSvnRevision();
                            repositorySegments = repositoryUrl.getPathSegments();
                            selectedSegments = rc.getSvnUrl().getPathSegments();
                            if (selectedSegments.length >= repositorySegments.length || !SvnUtils.decodeToString(rc.getSvnUrl()).contains("\\")) ** GOTO lbl-1000
                            invalidMsg = new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Invalid", (Object)rc.getUrl()), false);
                        }
                        if (this.isCanceled()) {
                            RepositoryStep.access$500(RepositoryStep.this, new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                            return;
                        }
                        if (invalidMsg == null) {
                            RepositoryStep.access$600(RepositoryStep.this);
                            return;
                        }
                        RepositoryStep.access$700(RepositoryStep.this, invalidMsg);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            repositoryFolder = new String[selectedSegments.length - repositorySegments.length];
                            System.arraycopy(selectedSegments, repositorySegments.length, repositoryFolder, 0, repositoryFolder.length);
                            RepositoryStep.access$302(RepositoryStep.this, new RepositoryFile(repositoryUrl, repositoryFolder, revision));
                            break block30;
lbl89:
                            // 1 sources

                            invalidMsg = new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Invalid", (Object)rc.getUrl()), false);
                        }
                        if (this.isCanceled()) {
                            RepositoryStep.access$500(RepositoryStep.this, new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                            return;
                        }
                        if (invalidMsg == null) {
                            RepositoryStep.access$600(RepositoryStep.this);
                            return;
                        }
                        RepositoryStep.access$700(RepositoryStep.this, invalidMsg);
                        return;
                    }
                    if (this.isCanceled()) {
                        RepositoryStep.access$500(RepositoryStep.this, new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                        return;
                    }
                    if (invalidMsg == null) {
                        RepositoryStep.access$600(RepositoryStep.this);
                        return;
                    }
                    RepositoryStep.access$700(RepositoryStep.this, invalidMsg);
                    return;
                    if (this.isCanceled()) {
                        RepositoryStep.access$500(RepositoryStep.this, new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                        return;
                    }
                    if (invalidMsg == null) {
                        RepositoryStep.access$600(RepositoryStep.this);
                        return;
                    }
                    RepositoryStep.access$700(RepositoryStep.this, invalidMsg);
                    return;
                }
            }
        }

        @Override
        public void setEditable(boolean editable) {
            RepositoryStep.this.repository.setEditable(editable);
        }
    }
}

