/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.wizard.api.NodeConfiguration;

public abstract class NodeConfigurationImpl
implements NodeConfiguration {
    private boolean isOverrideIncludes;
    private boolean isOverrideFiles;
    private boolean isOverrideMacros;
    private boolean isOverrideUndefinedMacros;
    private NodeConfigurationImpl parent;
    private final Set<String> userIncludes = new LinkedHashSet<String>();
    private final Set<String> userFiles = new HashSet<String>();
    private final Map<String, String> userMacros = new HashMap<String, String>();
    private final Set<String> undefinedMacros = new LinkedHashSet<String>();

    @Override
    public boolean overrideIncludes() {
        return this.isOverrideIncludes;
    }

    public void setOverrideIncludes(boolean overrideIncludes) {
        this.isOverrideIncludes = overrideIncludes;
    }

    @Override
    public boolean overrideFiles() {
        return this.isOverrideFiles;
    }

    public void setOverrideFiles(boolean overrideFiles) {
        this.isOverrideFiles = overrideFiles;
    }

    @Override
    public boolean overrideMacros() {
        return this.isOverrideMacros;
    }

    public void setOverrideMacros(boolean overrideMacros) {
        this.isOverrideMacros = overrideMacros;
    }

    @Override
    public boolean overrideUndefinedMacros() {
        return this.isOverrideUndefinedMacros;
    }

    public void setOverrideUndefinedMacros(boolean isOverrideUndefinedMacros) {
        this.isOverrideUndefinedMacros = isOverrideUndefinedMacros;
    }

    public void setParent(NodeConfigurationImpl parent) {
        this.parent = parent;
    }

    public NodeConfigurationImpl getParent() {
        return this.parent;
    }

    @Override
    public Set<String> getUserInludePaths(boolean resulting) {
        if (resulting) {
            return this.countUserInludePaths();
        }
        return this.userIncludes;
    }

    public void setUserInludePaths(Collection<String> set) {
        this.userIncludes.clear();
        if (set != null) {
            this.userIncludes.addAll(set);
        }
    }

    @Override
    public Set<String> getUserInludeFiles(boolean resulting) {
        if (resulting) {
            return this.countUserInludeFiles();
        }
        return this.userFiles;
    }

    public void setUserInludeFiles(Collection<String> set) {
        this.userFiles.clear();
        if (set != null) {
            this.userFiles.addAll(set);
        }
    }

    @Override
    public Map<String, String> getUserMacros(boolean resulting) {
        if (resulting) {
            return this.countUserMacros();
        }
        return this.userMacros;
    }

    public void setUserMacros(Map<String, String> map) {
        this.userMacros.clear();
        if (map != null) {
            this.userMacros.putAll(map);
        }
    }

    @Override
    public Set<String> getUndefinedMacros(boolean resulting) {
        if (resulting) {
            return this.countUndefinedMacros();
        }
        return this.undefinedMacros;
    }

    public void setUndefinedMacros(Collection<String> set) {
        this.undefinedMacros.clear();
        if (set != null) {
            this.undefinedMacros.addAll(set);
        }
    }

    public Set<String> countUserInludePaths() {
        if (this.overrideIncludes()) {
            return this.userIncludes;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (NodeConfigurationImpl current = this; current != null; current = current.getParent()) {
            result.addAll(current.getUserInludePaths(false));
            if (current.overrideIncludes()) break;
        }
        return result;
    }

    public Set<String> countUserInludeFiles() {
        if (this.overrideFiles()) {
            return this.userFiles;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (NodeConfigurationImpl current = this; current != null; current = current.getParent()) {
            result.addAll(current.getUserInludeFiles(false));
            if (current.overrideFiles()) break;
        }
        return result;
    }

    public Map<String, String> countUserMacros() {
        if (this.overrideMacros()) {
            return this.userMacros;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (NodeConfigurationImpl current = this; current != null; current = current.getParent()) {
            result.putAll(current.getUserMacros(false));
            if (current.overrideMacros()) break;
        }
        return result;
    }

    public Set<String> countUndefinedMacros() {
        if (this.overrideUndefinedMacros()) {
            return this.undefinedMacros;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (NodeConfigurationImpl current = this; current != null; current = current.getParent()) {
            result.addAll(current.getUndefinedMacros(false));
            if (current.overrideUndefinedMacros()) break;
        }
        return result;
    }
}

