/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.UEIEmulatorConfiguratorImpl;
import org.netbeans.modules.mobility.cldcplatform.wizard.DetectWizardPanel;
import org.netbeans.modules.mobility.cldcplatform.wizard.SearchRunnable;
import org.netbeans.spi.mobility.cldcplatform.CLDCPlatformDescriptor;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DetectPanel
extends JPanel {
    static final String PROP_PLATFORMS = "Platforms";
    protected final DefaultListModel platformsListModel = new DefaultListModel();
    private final DefaultListModel javadocListModel = new DefaultListModel();
    private final DefaultListModel sourceListModel = new DefaultListModel();
    private final PlatformsRenderer platformsRenderer = new PlatformsRenderer();
    private final CheckListener checkListener = new CheckListener();
    private final DocumentListener nameFieldListener = new NameFieldListener();
    private final FoldersRenderer foldersRenderer = new FoldersRenderer();
    protected static final String DETECTION_IN_PROGRESS = NbBundle.getMessage(DetectPanel.class, (String)"msg_detection_in_progress");
    protected static final String INVALID_NAME = NbBundle.getMessage(DetectPanel.class, (String)"msg_invalid_name");
    protected static final String NAME_COLLISION = NbBundle.getMessage(DetectPanel.class, (String)"msg_name_collision");
    protected static final String ALREADY_INSTALLED = NbBundle.getMessage(DetectPanel.class, (String)"msg_already_installed");
    protected static final String DETECTION_FAILED = NbBundle.getMessage(DetectPanel.class, (String)"msg_detection_failed");
    protected static final Color COLOR_GRAY = UIManager.getColor("Label.disabledForeground");
    protected static final Color COLOR_RED = new Color(192, 0, 0);
    protected DetectWizardPanel wizardPanel;
    private WizardDescriptor wizardDescriptor;
    protected boolean stop;
    private final Map<File, PlatformDescriptor> descriptors = new HashMap<File, PlatformDescriptor>();
    private JButton addJavadocButton;
    private JButton addSourceButton;
    private JLabel errorPlatformLabel;
    private JPanel errorPlatformPanel;
    private JTextPane infoPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JList javadocList;
    private JTextField nameField;
    private JLabel notDetectedLabel;
    private JPanel notDetectedPanel;
    private JPanel notSelectedPanel;
    private JList platformsList;
    private JButton removeJavadocButton;
    private JButton removeSourceButton;
    private JList sourceList;
    private JPanel switchPanel;

    public DetectPanel(DetectWizardPanel wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
        this.platformsList.addMouseListener(this.checkListener);
        this.platformsList.addKeyListener(this.checkListener);
        this.platformsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DetectPanel.this.updateDetails();
            }
        });
        this.nameField.getDocument().addDocumentListener(this.nameFieldListener);
        this.infoPanel.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.infoPanel.setContentType("text/html;charset=UTF-8");
        this.infoPanel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.javadocList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DetectPanel.this.removeJavadocButton.setEnabled(DetectPanel.this.javadocList.getSelectedValue() != null);
            }
        });
        this.sourceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DetectPanel.this.removeSourceButton.setEnabled(DetectPanel.this.sourceList.getSelectedValue() != null);
            }
        });
    }

    public void showError(String message) {
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.platformsList = new JList();
        this.switchPanel = new JPanel();
        this.notSelectedPanel = new JPanel();
        this.notDetectedPanel = new JPanel();
        this.notDetectedLabel = new JLabel();
        this.errorPlatformPanel = new JPanel();
        this.errorPlatformLabel = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.infoPanel = new JTextPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.javadocList = new JList();
        this.addJavadocButton = new JButton();
        this.removeJavadocButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.sourceList = new JList();
        this.addSourceButton = new JButton();
        this.removeSourceButton = new JButton();
        this.setName(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Platforms"));
        this.setPreferredSize(new Dimension(540, 450));
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel5.setLabelFor(this.platformsList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Select_Platforms"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_DetectPanel_Select_Platform"));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 150));
        this.platformsList.setModel(this.platformsListModel);
        this.platformsList.setSelectionMode(0);
        this.platformsList.setCellRenderer(this.platformsRenderer);
        this.jScrollPane1.setViewportView(this.platformsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSplitPane1.setTopComponent(this.jPanel4);
        this.switchPanel.setLayout(new CardLayout());
        this.notSelectedPanel.setLayout(new BorderLayout());
        this.switchPanel.add((Component)this.notSelectedPanel, "NotSelected");
        this.notDetectedPanel.setLayout(new BorderLayout());
        this.notDetectedLabel.setForeground(this.notDetectedPanel.getBackground().darker());
        this.notDetectedLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.notDetectedLabel, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Detecting_details"));
        this.notDetectedLabel.setOpaque(true);
        this.notDetectedPanel.add((Component)this.notDetectedLabel, "Center");
        this.switchPanel.add((Component)this.notDetectedPanel, "NotDetected");
        this.errorPlatformPanel.setLayout(new BorderLayout());
        this.errorPlatformLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.errorPlatformLabel, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Platform_detection_error"));
        this.errorPlatformLabel.setOpaque(true);
        this.errorPlatformPanel.add((Component)this.errorPlatformLabel, "Center");
        this.switchPanel.add((Component)this.errorPlatformPanel, "ErrorPlatform");
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Platform_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_DetectPanel_Platform_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.jPanel3.add((Component)this.nameField, gridBagConstraints);
        this.jLabel2.setLabelFor(this.infoPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Platform_Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 6);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_DetectPanel_Platform_Details"));
        this.infoPanel.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.infoPanel.setEditable(false);
        this.jScrollPane2.setViewportView(this.infoPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Description"), this.jPanel3);
        this.jPanel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jPanel3"));
        this.jPanel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jPanel3"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.javadocList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Pl_Javadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Pl_Javadoc"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Pl_Javadoc"));
        this.javadocList.setModel(this.javadocListModel);
        this.javadocList.setCellRenderer(this.foldersRenderer);
        this.jScrollPane3.setViewportView(this.javadocList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addJavadocButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Add"));
        this.addJavadocButton.setActionCommand(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Add"));
        this.addJavadocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.addJavadocButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this.addJavadocButton, gridBagConstraints);
        this.addJavadocButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Add"));
        this.addJavadocButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeJavadocButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Remove"));
        this.removeJavadocButton.setActionCommand(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Remove"));
        this.removeJavadocButton.setEnabled(false);
        this.removeJavadocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.removeJavadocButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel1.add((Component)this.removeJavadocButton, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Javadoc"), this.jPanel1);
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jPanel1"));
        this.jPanel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jPanel1"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.sourceList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_PL_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_PL_Sources"));
        this.sourceList.setModel(this.sourceListModel);
        this.sourceList.setCellRenderer(this.foldersRenderer);
        this.jScrollPane4.setViewportView(this.sourceList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.jPanel2.add((Component)this.jScrollPane4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addSourceButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Add"));
        this.addSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.addSourceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel2.add((Component)this.addSourceButton, gridBagConstraints);
        this.addSourceButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Add"));
        this.addSourceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeSourceButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Remove"));
        this.removeSourceButton.setEnabled(false);
        this.removeSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.removeSourceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel2.add((Component)this.removeSourceButton, gridBagConstraints);
        this.removeSourceButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Remove"));
        this.removeSourceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Remove"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Sources"), this.jPanel2);
        this.jPanel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jPanel2"));
        this.jPanel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jPanel2"));
        this.switchPanel.add((Component)this.jTabbedPane1, "Details");
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jTabbedPanel1"));
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jTabbedPanel1"));
        this.jSplitPane1.setBottomComponent(this.switchPanel);
        this.add((Component)this.jSplitPane1, "Center");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jPanel"));
    }

    private void addJavadocButtonActionPerformed(ActionEvent evt) {
        J2MEPlatform platform = this.findSelectedPlatform();
        if (platform == null) {
            return;
        }
        String value = this.browse(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_DetectPanel_SelectJavaDoc"));
        if (value == null) {
            return;
        }
        URL o = J2MEPlatform.localfilepath2url(value);
        if (o == null) {
            return;
        }
        ArrayList<URL> list = new ArrayList<URL>(platform.getJavadocFolders());
        list.add(o);
        platform.setJavadocFolders(list);
        this.descriptorUpdated();
    }

    private void removeJavadocButtonActionPerformed(ActionEvent evt) {
        J2MEPlatform platform = this.findSelectedPlatform();
        if (platform == null) {
            return;
        }
        Object selectedValue = this.javadocList.getSelectedValue();
        if (selectedValue == null) {
            return;
        }
        int i = this.javadocList.getSelectedIndex();
        ArrayList<URL> list = new ArrayList<URL>(platform.getJavadocFolders());
        list.remove(selectedValue);
        platform.setJavadocFolders(list);
        this.descriptorUpdated();
        if (i >= this.javadocList.getModel().getSize()) {
            --i;
        }
        if (i >= 0) {
            this.javadocList.setSelectedIndex(i);
        }
    }

    private void addSourceButtonActionPerformed(ActionEvent evt) {
        J2MEPlatform platform = this.findSelectedPlatform();
        if (platform == null) {
            return;
        }
        String value = this.browse(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_DetectPanel_SelectSource"));
        if (value == null) {
            return;
        }
        FileObject o = platform.resolveRelativePathToFileObject(value);
        if (o == null) {
            return;
        }
        ArrayList<FileObject> list = new ArrayList<FileObject>(Arrays.asList(platform.getSourceFolders().getRoots()));
        list.add(o);
        platform.setSourceFolders(list);
        this.descriptorUpdated();
    }

    private void removeSourceButtonActionPerformed(ActionEvent evt) {
        J2MEPlatform platform = this.findSelectedPlatform();
        if (platform == null) {
            return;
        }
        Object selectedValue = this.sourceList.getSelectedValue();
        if (selectedValue == null) {
            return;
        }
        int i = this.sourceList.getSelectedIndex();
        ArrayList<FileObject> list = new ArrayList<FileObject>(Arrays.asList(platform.getSourceFolders().getRoots()));
        list.remove(selectedValue);
        platform.setSourceFolders(list);
        this.descriptorUpdated();
        if (i >= this.sourceList.getModel().getSize()) {
            --i;
        }
        if (i >= 0) {
            this.sourceList.setSelectedIndex(i);
        }
    }

    public void readSettings(WizardDescriptor descriptor) {
        this.wizardDescriptor = descriptor;
        File[] folders = ((Set)descriptor.getProperty("PlatformFolders")).toArray(new File[0]);
        this.platformsListModel.clear();
        for (int i = 0; i < folders.length; ++i) {
            PlatformDescriptor pd = this.descriptors.get(folders[i]);
            if (pd == null) {
                pd = new PlatformDescriptor(folders[i]);
                this.descriptors.put(folders[i], pd);
            }
            this.platformsListModel.addElement(pd);
        }
        if (folders.length > 0) {
            this.platformsList.setSelectedIndex(0);
        }
        this.showError(NbBundle.getMessage(DetectPanel.class, (String)"WARN_SearchInProgress"));
        this.stop = false;
        RequestProcessor.getDefault().post((Runnable)new DetectRunnable());
    }

    public void storeSettings(WizardDescriptor descriptor) {
        this.stop = true;
        for (J2MEPlatform jp : this.getPlatforms()) {
            jp.setName(DetectPanel.createAntName(jp.getName()));
        }
        descriptor.putProperty(PROP_PLATFORMS, (Object)this.getPlatforms());
    }

    private static String createAntName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        String antName = PropertyUtils.getUsablePropertyName((String)name);
        if (DetectPanel.platformExists(antName)) {
            String baseName = antName;
            int index = 1;
            antName = baseName + Integer.toString(index);
            while (DetectPanel.platformExists(antName)) {
                antName = baseName + Integer.toString(++index);
            }
        }
        return antName;
    }

    private static boolean platformExists(String antName) {
        JavaPlatformManager mgr = JavaPlatformManager.getDefault();
        JavaPlatform[] platforms = mgr.getInstalledPlatforms();
        for (int i = 0; i < platforms.length; ++i) {
            String val;
            if (!(platforms[i] instanceof J2MEPlatform) || !antName.equals(val = ((J2MEPlatform)platforms[i]).getName())) continue;
            return true;
        }
        return false;
    }

    public J2MEPlatform[] getPlatforms() {
        Object[] descs = this.platformsListModel.toArray();
        ArrayList<J2MEPlatform> list = new ArrayList<J2MEPlatform>();
        for (int i = 0; i < descs.length; ++i) {
            J2MEPlatform platform;
            PlatformDescriptor desc = (PlatformDescriptor)descs[i];
            if (!desc.isProbed() || !desc.isSelected() || (platform = desc.getPlatform()) == null) continue;
            list.add(platform);
        }
        return list.toArray(new J2MEPlatform[list.size()]);
    }

    public boolean isStateValid() {
        Object[] descs = this.platformsListModel.toArray();
        if (this.checkForError(this.findSelectedPlatformDescriptor())) {
            return false;
        }
        boolean selected = false;
        for (int i = 0; i < descs.length; ++i) {
            if (this.checkForError((PlatformDescriptor)descs[i])) {
                return false;
            }
            selected |= ((PlatformDescriptor)descs[i]).isSelected();
        }
        if (!selected) {
            this.showError(NbBundle.getMessage(DetectPanel.class, (String)"ERR_NothingSelected"));
            return false;
        }
        this.showError(null);
        return true;
    }

    private boolean checkForError(PlatformDescriptor pd) {
        if (pd == null) {
            return false;
        }
        if (!pd.isNameValid()) {
            this.showError(NbBundle.getMessage(DetectPanel.class, (String)"ERR_InvalidName"));
        } else if (pd.isNameCollision()) {
            this.showError(NbBundle.getMessage(DetectPanel.class, (String)"ERR_NameCollision"));
        } else {
            return false;
        }
        return true;
    }

    protected void descriptorUpdated() {
        this.platformsList.repaint();
        this.updateDetails();
        this.wizardPanel.fireChanged();
    }

    protected void updateDetails() {
        PlatformDescriptor descriptor = this.findSelectedPlatformDescriptor();
        if (descriptor == null) {
            ((CardLayout)this.switchPanel.getLayout()).show(this.switchPanel, "NotSelected");
            return;
        }
        if (!descriptor.isProbed()) {
            ((CardLayout)this.switchPanel.getLayout()).show(this.switchPanel, "NotDetected");
            return;
        }
        J2MEPlatform platform = descriptor.getPlatform();
        if (platform == null) {
            ((CardLayout)this.switchPanel.getLayout()).show(this.switchPanel, "ErrorPlatform");
            return;
        }
        this.nameField.getDocument().removeDocumentListener(this.nameFieldListener);
        this.nameField.setText(platform.getDisplayName());
        this.nameField.getDocument().addDocumentListener(this.nameFieldListener);
        this.infoPanel.setText(this.generateDescriptionForPlatform(platform));
        ((CardLayout)this.switchPanel.getLayout()).show(this.switchPanel, "Details");
        this.infoPanel.setCaretPosition(0);
        FileObject[] al = platform.getSourceFolders().getRoots();
        this.sourceListModel.clear();
        if (al != null) {
            for (int a = 0; a < al.length; ++a) {
                this.sourceListModel.addElement(al[a]);
            }
        }
        List<URL> li = platform.getJavadocFolders();
        this.javadocListModel.clear();
        if (li != null) {
            for (URL lia : li) {
                this.javadocListModel.addElement(lia);
            }
        }
        this.wizardPanel.fireChanged();
    }

    PlatformDescriptor findSelectedPlatformDescriptor() {
        return (PlatformDescriptor)this.platformsList.getSelectedValue();
    }

    private J2MEPlatform findSelectedPlatform() {
        PlatformDescriptor descriptor = this.findSelectedPlatformDescriptor();
        return descriptor != null ? descriptor.getPlatform() : null;
    }

    private String generateDescriptionForPlatform(J2MEPlatform platform) {
        StringBuffer sb = new StringBuffer(40);
        sb.append("<html><font face=\"dialog\" size=\"-1\">");
        sb.append(NbBundle.getMessage(DetectPanel.class, (String)"MSG_DetectPanel_Devices"));
        J2MEPlatform.Device[] devices = platform.getDevices();
        if (devices != null) {
            for (int i = 0; i < devices.length; ++i) {
                J2MEPlatform.Device device = devices[i];
                sb.append(i > 0 ? ", " : " ");
                sb.append(device.getName());
            }
        }
        ArrayList<String> profiles = new ArrayList<String>();
        ArrayList<String> configurations = new ArrayList<String>();
        ArrayList<String> optionals = new ArrayList<String>();
        if (devices != null) {
            for (int a = 0; a < devices.length; ++a) {
                J2MEPlatform.J2MEProfile[] ps = devices[a].getProfiles();
                if (ps == null) continue;
                for (int b = 0; b < ps.length; ++b) {
                    String n = ps[b].toString();
                    String type = ps[b].getType();
                    if ("profile".equals(type)) {
                        if (profiles.contains(n)) continue;
                        profiles.add(n);
                        continue;
                    }
                    if ("configuration".equals(type)) {
                        if (configurations.contains(n)) continue;
                        configurations.add(n);
                        continue;
                    }
                    if (!"optional".equals(type) || optionals.contains(n)) continue;
                    optionals.add(n);
                }
            }
        }
        sb.append(NbBundle.getMessage(DetectPanel.class, (String)"MSG_DetectPanel_Profiles"));
        this.printToStringBuffer(profiles.toArray(), sb);
        sb.append(NbBundle.getMessage(DetectPanel.class, (String)"MSG_DetectPanel_Configurations"));
        this.printToStringBuffer(configurations.toArray(), sb);
        sb.append(NbBundle.getMessage(DetectPanel.class, (String)"MSG_DetectPanel_Optional"));
        this.printToStringBuffer(optionals.toArray(), sb);
        return sb.toString();
    }

    private void printToStringBuffer(Object[] objs, StringBuffer sb) {
        Arrays.sort(objs);
        if (objs.length > 0) {
            for (int i = 0; i < objs.length; ++i) {
                sb.append(i > 0 ? ", " : " ").append(objs[i]);
            }
        } else {
            sb.append(NbBundle.getMessage(DetectPanel.class, (String)"Msg_DetectPanel_None"));
        }
    }

    private String browse(String title) {
        File f = new FileChooserBuilder(DetectPanel.class).setFileFilter((FileFilter)new BrowseFilter()).setTitle(title).showOpenDialog();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    class DetectRunnable
    extends JPanel
    implements Runnable {
        private final JLabel searchLabel;
        protected final ProgressHandle progress;

        public DetectRunnable() {
            this.setLayout(new GridBagLayout());
            this.searchLabel = new JLabel();
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 12, 6, 12), 0, 0);
            this.add((Component)this.searchLabel, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 12, 6, 12), 0, 0);
            this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SearchRunnable.class, (String)"Title_DetectRunnable_Searching"));
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchRunnable.class, (String)"ACSN_detectingPlatform"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchRunnable.class, (String)"ACSD_detectingPlatform"));
            JComponent component = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progress);
            component.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchRunnable.class, (String)"ACSN_detectingPlatform"));
            component.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchRunnable.class, (String)"ACSD_detectingPlatform"));
            this.add((Component)component, gbc);
            this.setPreferredSize(new Dimension(400, 70));
        }

        @Override
        public void run() {
            this.progress.start(DetectPanel.this.platformsListModel.size());
            final Dialog[] dialog = new Dialog[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        dialog[0] = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)DetectRunnable.this, NbBundle.getMessage(SearchRunnable.class, (String)"Title_DetectRunnable_Searching"), true, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION, 0, new HelpCtx(DetectPanel.class), new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DetectPanel.this.stop = true;
                            }
                        }));
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!DetectPanel.this.stop) {
                            dialog[0].setVisible(true);
                        }
                    }
                });
                for (int i = 0; !DetectPanel.this.stop && i < DetectPanel.this.platformsListModel.size(); ++i) {
                    this.progress.progress(i);
                    PlatformDescriptor pd = (PlatformDescriptor)DetectPanel.this.platformsListModel.getElementAt(i);
                    if (pd.isProbed()) continue;
                    this.setCurrentPath(pd.getRoot());
                    pd.detect();
                    DetectPanel.this.wizardPanel.fireChanged();
                }
                this.progress.progress(DetectPanel.this.platformsListModel.size());
                if (DetectPanel.this.stop) {
                    DetectPanel.this.showError(null);
                }
                DetectPanel.this.stop = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DetectRunnable.this.progress.finish();
                        dialog[0].setVisible(false);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        public void setCurrentPath(String platform) {
            this.searchLabel.setText(NbBundle.getMessage(SearchRunnable.class, (String)"LBL_DetectingPath", (Object)platform));
        }
    }

    private class FoldersRenderer
    extends JLabel
    implements ListCellRenderer {
        Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public FoldersRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? DetectPanel.this.platformsList.getSelectionBackground() : DetectPanel.this.platformsList.getBackground());
            this.setForeground(isSelected ? DetectPanel.this.platformsList.getSelectionForeground() : DetectPanel.this.platformsList.getForeground());
            Border border = null;
            if (cellHasFocus) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
            this.setBorder(border != null ? border : this.emptyBorder);
            String text = value instanceof FileObject ? J2MEPlatform.getFilePath((FileObject)value) : (value instanceof URL ? J2MEPlatform.getFilePath(URLMapper.findFileObject((URL)((URL)value))) : null);
            if (text == null) {
                text = value != null ? value.toString() : "";
            }
            this.setText(text);
            return this;
        }
    }

    private class NameFieldListener
    implements DocumentListener {
        NameFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            PlatformDescriptor descriptor = DetectPanel.this.findSelectedPlatformDescriptor();
            J2MEPlatform platform = descriptor.getPlatform();
            if (platform == null) {
                return;
            }
            String text = DetectPanel.this.nameField.getText();
            platform.setDisplayName(text);
            platform.setName(J2MEPlatform.computeUniqueName(text));
            DetectPanel.this.platformsList.repaint();
            DetectPanel.this.wizardPanel.fireChanged();
        }
    }

    private class CheckListener
    implements MouseListener,
    KeyListener {
        CheckListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getX() < 20) {
                this.check();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this.check();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private void check() {
            PlatformDescriptor descriptor = DetectPanel.this.findSelectedPlatformDescriptor();
            if (descriptor != null) {
                descriptor.invertSelection();
            }
        }
    }

    private class PlatformsRenderer
    extends JCheckBox
    implements ListCellRenderer {
        Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public PlatformsRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? DetectPanel.this.platformsList.getSelectionBackground() : DetectPanel.this.platformsList.getBackground());
            Border border = null;
            if (cellHasFocus) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
            this.setBorder(border != null ? border : this.emptyBorder);
            PlatformDescriptor descriptor = (PlatformDescriptor)value;
            descriptor.updateRenderer(this, isSelected);
            return this;
        }
    }

    private class PlatformDescriptor {
        private final String root;
        private boolean probed;
        private J2MEPlatform platform;
        private boolean selected;

        public PlatformDescriptor(File root) {
            this.root = root.getAbsolutePath();
        }

        public String getRoot() {
            return this.root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detect() {
            PlatformDescriptor platformDescriptor = this;
            synchronized (platformDescriptor) {
                this.platform = null;
                Iterator it = Lookup.getDefault().lookup(new Lookup.Template(CustomCLDCPlatformConfigurator.class)).allInstances().iterator();
                File rootDir = new File(this.root);
                while (it.hasNext() && this.platform == null) {
                    this.platform = this.createPlatformFromDescriptor(((CustomCLDCPlatformConfigurator)it.next()).getPlatform(rootDir));
                }
                if (this.platform == null) {
                    this.platform = new UEIEmulatorConfiguratorImpl(this.root).getPlatform();
                }
                this.selected = this.platform != null && !this.isAlreadyInstalled();
                this.probed = true;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DetectPanel.this.descriptorUpdated();
                }
            });
        }

        private J2MEPlatform createPlatformFromDescriptor(CLDCPlatformDescriptor desc) {
            if (desc == null) {
                return null;
            }
            return new J2MEPlatform(J2MEPlatform.computeUniqueName(desc.displayName), desc.home, desc.type, desc.displayName, desc.srcPath, desc.docPath, desc.preverifyCmd, desc.runCmd, desc.debugCmd, this.createDevices(desc.devices));
        }

        private J2MEPlatform.Device[] createDevices(List<CLDCPlatformDescriptor.Device> list) {
            J2MEPlatform.Device[] devices = new J2MEPlatform.Device[list.size()];
            for (int i = 0; i < devices.length; ++i) {
                CLDCPlatformDescriptor.Device d = list.get(i);
                devices[i] = new J2MEPlatform.Device(d.name, d.description, d.securityDomains == null ? null : d.securityDomains.toArray(new String[d.securityDomains.size()]), this.createProfiles(d.profiles), this.createScreen(d.screen));
            }
            return devices;
        }

        private J2MEPlatform.J2MEProfile[] createProfiles(List<CLDCPlatformDescriptor.Profile> list) {
            J2MEPlatform.J2MEProfile[] profiles = new J2MEPlatform.J2MEProfile[list.size()];
            for (int i = 0; i < profiles.length; ++i) {
                CLDCPlatformDescriptor.Profile p = list.get(i);
                profiles[i] = new J2MEPlatform.J2MEProfile(p.name, p.version, p.displayName, this.getProfileType(p.type), p.dependencies, p.classPath, p.def);
            }
            return profiles;
        }

        private String getProfileType(CLDCPlatformDescriptor.ProfileType type) {
            if (type == CLDCPlatformDescriptor.ProfileType.Configuration) {
                return "configuration";
            }
            if (type == CLDCPlatformDescriptor.ProfileType.Profile) {
                return "profile";
            }
            return "optional";
        }

        private J2MEPlatform.Screen createScreen(CLDCPlatformDescriptor.Screen s) {
            return new J2MEPlatform.Screen(String.valueOf(s.width), String.valueOf(s.height), String.valueOf(s.bitDepth), String.valueOf(s.color), String.valueOf(s.touch));
        }

        public boolean isAlreadyInstalled() {
            return this.platform == null ? false : JavaPlatformManager.getDefault().getPlatforms(this.platform.getDisplayName(), null).length > 0;
        }

        public boolean isNameCollision() {
            if (this.platform == null || !this.selected) {
                return false;
            }
            if (this.isAlreadyInstalled()) {
                return true;
            }
            Object[] descs = DetectPanel.this.platformsListModel.toArray();
            String name = this.getPlatform().getDisplayName();
            for (int i = 0; i < descs.length; ++i) {
                PlatformDescriptor pd = (PlatformDescriptor)descs[i];
                if (pd == this || !pd.isSelected() || pd.getPlatform() == null || !pd.getPlatform().getDisplayName().equals(name)) continue;
                return true;
            }
            return false;
        }

        public boolean isProbed() {
            return this.probed;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public J2MEPlatform getPlatform() {
            return this.platform;
        }

        public boolean isNameValid() {
            return this.platform == null ? true : !this.selected || this.platform.getDisplayName().trim().length() > 0;
        }

        public void updateRenderer(JCheckBox renderer, boolean isSelected) {
            renderer.setSelected(this.selected);
            if (!this.probed) {
                renderer.setText(this.root + DETECTION_IN_PROGRESS);
                renderer.setForeground(isSelected ? DetectPanel.this.platformsList.getSelectionForeground() : COLOR_GRAY);
            } else if (this.platform != null) {
                if (!this.isNameValid()) {
                    renderer.setText(this.root + INVALID_NAME);
                    renderer.setForeground(isSelected ? DetectPanel.this.platformsList.getSelectionForeground() : COLOR_RED);
                } else if (this.isNameCollision()) {
                    renderer.setText(this.root + NAME_COLLISION);
                    renderer.setForeground(isSelected ? DetectPanel.this.platformsList.getSelectionForeground() : COLOR_RED);
                } else if (this.isAlreadyInstalled()) {
                    renderer.setText(this.root + ALREADY_INSTALLED);
                    renderer.setForeground(isSelected ? DetectPanel.this.platformsList.getSelectionForeground() : DetectPanel.this.platformsList.getForeground());
                } else {
                    renderer.setText(this.root);
                    renderer.setForeground(isSelected ? DetectPanel.this.platformsList.getSelectionForeground() : DetectPanel.this.platformsList.getForeground());
                }
            } else {
                renderer.setText(this.root + DETECTION_FAILED);
                renderer.setForeground(isSelected ? DetectPanel.this.platformsList.getSelectionForeground() : COLOR_RED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invertSelection() {
            PlatformDescriptor platformDescriptor = this;
            synchronized (platformDescriptor) {
                if (this.selected) {
                    this.selected = false;
                    DetectPanel.this.descriptorUpdated();
                } else if (this.probed && this.platform != null) {
                    this.selected = true;
                    DetectPanel.this.descriptorUpdated();
                }
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof PlatformDescriptor && ((PlatformDescriptor)obj).root.equals(this.root);
        }
    }

    private static final class BrowseFilter
    extends FileFilter {
        private BrowseFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.exists() && f.canRead() && (f.isDirectory() || f.getName().endsWith(".zip") || f.getName().endsWith(".jar"));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(DetectPanel.class, (String)"TXT_ZipFilter");
        }
    }
}

