/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.finalize;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.finalize.Util;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class FinalizeDoesNotCallSuper {
    private static final String SUPER = "super";
    private static final String FINALIZE = "finalize";

    public static ErrorDescription hint(HintContext ctx) {
        assert (ctx != null);
        TreePath tp = ctx.getPath();
        MethodTree method = (MethodTree)tp.getLeaf();
        if (method.getBody() == null) {
            return null;
        }
        if (!Util.isFinalize(method)) {
            return null;
        }
        FindSuper scanner = new FindSuper();
        scanner.scan((Tree)method, null);
        if (scanner.found) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)method, (String)NbBundle.getMessage(FinalizeDoesNotCallSuper.class, (String)"TXT_FinalizeDoesNotCallSuper"), (Fix[])new Fix[]{new FixImpl(TreePathHandle.create((TreePath)ctx.getPath(), (CompilationInfo)ctx.getInfo())).toEditorFix()});
    }

    static class FixImpl
    extends JavaFix {
        public FixImpl(TreePathHandle handle) {
            super(handle);
            assert (handle != null);
        }

        public String getText() {
            return NbBundle.getMessage(FinalizeDoesNotCallSuper.class, (String)"FIX_FinalizeDoesNotCallSuper");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreeMaker tm = wc.getTreeMaker();
            TreePath tp = ctx.getPath();
            BlockTree oldBody = ((MethodTree)tp.getLeaf()).getBody();
            if (oldBody == null) {
                return;
            }
            ArrayList newStatements = new ArrayList(2);
            BlockTree superFinalize = tm.Block(Collections.singletonList(tm.ExpressionStatement((ExpressionTree)tm.MethodInvocation(Collections.emptyList(), (ExpressionTree)tm.MemberSelect((ExpressionTree)tm.Identifier((CharSequence)FinalizeDoesNotCallSuper.SUPER), (CharSequence)FinalizeDoesNotCallSuper.FINALIZE), Collections.emptyList()))), false);
            if (oldBody.getStatements().isEmpty()) {
                wc.rewrite((Tree)oldBody, (Tree)superFinalize);
            } else {
                TryTree soleTry = this.soleTryWithoutFinally(oldBody);
                if (soleTry != null) {
                    wc.rewrite((Tree)soleTry, (Tree)tm.Try(soleTry.getBlock(), soleTry.getCatches(), superFinalize));
                } else {
                    wc.rewrite((Tree)oldBody, (Tree)tm.Block(Collections.singletonList(tm.Try(oldBody, Collections.emptyList(), superFinalize)), false));
                }
            }
        }

        private TryTree soleTryWithoutFinally(BlockTree block) {
            if (block.getStatements().size() != 1) {
                return null;
            }
            StatementTree first = block.getStatements().get(0);
            if (first.getKind() != Tree.Kind.TRY) {
                return null;
            }
            TryTree tt = (TryTree)first;
            if (tt.getFinallyBlock() != null) {
                return null;
            }
            return tt;
        }
    }

    static final class FindSuper
    extends TreeScanner<Void, Void> {
        boolean found;

        FindSuper() {
        }

        @Override
        public Void scan(Tree node, Void p) {
            return this.found ? null : (Void)super.scan(node, p);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
            if (!node.getArguments().isEmpty()) {
                return null;
            }
            ExpressionTree et = node.getMethodSelect();
            if (et.getKind() != Tree.Kind.MEMBER_SELECT) {
                return null;
            }
            MemberSelectTree mst = (MemberSelectTree)et;
            if (!FinalizeDoesNotCallSuper.FINALIZE.contentEquals(mst.getIdentifier())) {
                return null;
            }
            if (mst.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
                return null;
            }
            if (!FinalizeDoesNotCallSuper.SUPER.contentEquals(((IdentifierTree)mst.getExpression()).getName())) {
                return null;
            }
            this.found = true;
            return null;
        }
    }
}

