/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.LogicalFolderNode;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemPasteType;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

final class ViewFolderPasteType
extends PasteType {
    private static final RequestProcessor RP = new RequestProcessor("ViewFolderPasteType", 1);
    private final Folder toFolder;
    private final Folder fromFolder;
    private final int type;
    private final MakeLogicalViewProvider provider;

    public ViewFolderPasteType(Folder toFolder, LogicalFolderNode viewFolderNode, int type, MakeLogicalViewProvider provider) {
        this.toFolder = toFolder;
        this.fromFolder = viewFolderNode.getFolder();
        this.type = type;
        this.provider = provider;
    }

    private void copyFolderConfigurations(FolderConfiguration[] newConfigurations, FolderConfiguration[] oldConfigurations) {
        if (newConfigurations == null || oldConfigurations == null) {
            return;
        }
        assert (newConfigurations.length == oldConfigurations.length);
        for (int i = 0; i < newConfigurations.length; ++i) {
            newConfigurations[i].assignValues(oldConfigurations[i]);
        }
    }

    private void copyItemConfigurations(ItemConfiguration[] newConfigurations, ItemConfiguration[] oldConfigurations) {
        if (newConfigurations == null || oldConfigurations == null) {
            return;
        }
        assert (newConfigurations.length == oldConfigurations.length);
        if (newConfigurations.length == 0 || oldConfigurations.length == 0) {
            return;
        }
        for (int i = 0; i < newConfigurations.length; ++i) {
            if (oldConfigurations[i] == null || newConfigurations[i] == null) continue;
            newConfigurations[i].assignValues((ConfigurationAuxObject)oldConfigurations[i]);
        }
    }

    private FileObject getFolderFileObject(Folder folder) {
        String rootPath = folder.getRootPath();
        return RemoteFileUtil.getFileObject((FileObject)folder.getConfigurationDescriptor().getBaseDirFileObject(), (String)rootPath);
    }

    public Transferable paste() throws IOException {
        RP.post(() -> {
            try {
                this.pasteImpl();
                this.provider.getMakeConfigurationDescriptor().save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pasteImpl() throws IOException {
        if (!this.provider.gotMakeConfigurationDescriptor() || !this.provider.getMakeConfigurationDescriptor().okToChange()) {
            return;
        }
        FileObject itemFO = this.getFolderFileObject(this.fromFolder);
        if (this.type == 2) {
            if (this.toFolder.isDiskFolder() && this.fromFolder.isDiskFolder()) {
                if (!itemFO.isValid()) return;
                String toFolderPath = CndPathUtilities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject().getFileSystem(), (CharSequence)toFolderPath);
                if (toFolderFO == null || !toFolderFO.isValid()) {
                    return;
                }
                String newName = CndPathUtilities.createUniqueFileName((FileObject)toFolderFO, (String)itemFO.getNameExt(), (String)"");
                FileLock lock = itemFO.lock();
                try {
                    FileObject movedFileFO = itemFO.move(lock, toFolderFO, newName, "");
                    Folder movedFolder = this.toFolder.findFolderByName(movedFileFO.getNameExt());
                    if (this.toFolder.getProject() != this.fromFolder.getProject() || this.fromFolder.getAllFolders(true).contains(this.toFolder) || movedFolder == null) return;
                    this.recussiveMoveConfigurations(this.fromFolder, this.toFolder, movedFolder.getName(), true);
                    return;
                }
                finally {
                    lock.releaseLock();
                }
            } else {
                if (this.toFolder.isDiskFolder() || this.fromFolder.isDiskFolder() || this.fromFolder.getAllFolders(true).contains(this.toFolder)) return;
                this.recussiveMove(this.fromFolder, this.toFolder, true);
            }
            return;
        } else {
            if (this.type != 1 && this.type != 0) return;
            if (this.toFolder.isDiskFolder() && this.fromFolder.isDiskFolder()) {
                if (!itemFO.isValid()) return;
                String toFolderPath = CndPathUtilities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileSystem(), (CharSequence)toFolderPath);
                String newName = CndPathUtilities.createUniqueFileName((FileObject)toFolderFO, (String)itemFO.getNameExt(), (String)"");
                FileObject copiedFileObject = itemFO.copy(toFolderFO, newName, "");
                Folder copiedFolder = this.toFolder.findFolderByName(copiedFileObject.getNameExt());
                if (this.toFolder.getProject() != this.fromFolder.getProject() || this.fromFolder.getAllFolders(true).contains(this.toFolder) || copiedFolder == null) return;
                this.recussiveMoveConfigurations(this.fromFolder, this.toFolder, copiedFolder.getName(), false);
                return;
            } else {
                if (this.toFolder.isDiskFolder() || this.fromFolder.isDiskFolder() || this.fromFolder.getAllFolders(true).contains(this.toFolder)) return;
                this.recussiveMove(this.fromFolder, this.toFolder, false);
            }
        }
    }

    private void recussiveMoveConfigurations(Folder folder, Folder toFolder, String newName, boolean move) throws IOException {
        Folder target = toFolder.findFolderByName(newName);
        if (target != null) {
            if (target.getProject() == folder.getProject()) {
                this.copyFolderConfigurations(target.getFolderConfigurations(), folder.getFolderConfigurations());
            }
            for (Folder sub : folder.getFolders()) {
                this.recussiveMoveConfigurations(sub, target, sub.getName(), move);
            }
            for (Item item : folder.getItemsAsArray()) {
                Item toItem = target.findItemByName(item.getName());
                if (toItem == null) continue;
                this.copyItemConfigurations(toItem.getItemConfigurations(), item.getItemConfigurations());
            }
        }
        if (move) {
            Folder parent = folder.getParent();
            parent.removeFolderAction(folder);
        }
    }

    private void recussiveMove(Folder folder, Folder toFolder, boolean move) throws IOException {
        Folder parent = folder.getParent();
        Folder target = toFolder.findFolderByDisplayName(folder.getDisplayName());
        if (target == null) {
            target = new Folder(toFolder.getConfigurationDescriptor(), toFolder, folder.getName(), folder.getDisplayName(), true, Folder.Kind.SOURCE_LOGICAL_FOLDER);
            if ((target = toFolder.addFolder(target, true)).getProject() == folder.getProject()) {
                this.copyFolderConfigurations(target.getFolderConfigurations(), folder.getFolderConfigurations());
            }
        }
        for (Folder sub : folder.getFolders()) {
            this.recussiveMove(sub, target, move);
        }
        for (Item item : folder.getItemsAsArray()) {
            ViewItemPasteType viewItemPasteType = new ViewItemPasteType(target, folder, item, this.type, this.provider);
            viewItemPasteType.pasteImpl();
        }
        if (move) {
            parent.removeFolderAction(folder);
        }
    }
}

