/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.ui.MakeProjectCustomizerEx;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.spi.configurations.CompileOptionsProvider;
import org.netbeans.modules.cnd.makeproject.ui.customizer.FolderNodeFactory;
import org.netbeans.modules.cnd.makeproject.ui.customizer.ItemNodeFactory;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.makeproject.ui.customizer.ProjectNodeFactory;
import org.netbeans.modules.cnd.makeproject.ui.customizer.PropertyNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.SharedItemConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.utils.ConfSelectorPanel;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class MakeCustomizer
extends JPanel
implements HelpCtx.Provider {
    private Component currentCustomizer;
    private PropertyNode currentConfigurationNode = null;
    private final GridBagConstraints fillConstraints;
    private final Project project;
    private DialogDescriptor dialogDescriptor;
    private final ConfigurationDescriptor projectDescriptor;
    private final List<Item> items;
    private final List<Folder> folders;
    private final List<JComponent> controls;
    private CategoryView currentCategoryView;
    private String currentNodeName;
    private Configuration[] configurationItems;
    private Configuration[] selectedConfigurations;
    private int lastComboboxIndex = -1;
    private MakeContext lastContext;
    private final Map<Item, SharedItemConfiguration> itemConfigurations = new HashMap<Item, SharedItemConfiguration>();
    private JComboBox allConfigurationComboBox;
    private JLabel categoryLabel;
    private JPanel categoryPanel;
    private JComboBox configurationComboBox;
    private JLabel configurationLabel;
    private JPanel configurationPanel;
    private JButton configurationsButton;
    private JPanel customizerPanel;
    private JPanel propertyPanel;

    public MakeCustomizer(Project project, String preselectedNodeName, ConfigurationDescriptor projectDescriptor, List<Item> items, List<Folder> folders, Collection<JComponent> controls) {
        int selectedIndex;
        this.initComponents();
        this.projectDescriptor = projectDescriptor;
        this.controls = new ArrayList<JComponent>(controls);
        this.project = project;
        this.items = items;
        this.folders = folders;
        this.controls.add(this.configurationComboBox);
        this.controls.add(this.configurationsButton);
        this.configurationItems = projectDescriptor.getConfs().toArray();
        for (int i = 0; i < this.configurationItems.length; ++i) {
            this.configurationComboBox.addItem(this.configurationItems[i]);
        }
        if (this.configurationItems.length > 1) {
            this.configurationComboBox.addItem(MakeCustomizer.getString("ALL_CONFIGURATIONS"));
        }
        if (this.configurationItems.length > 2) {
            this.configurationComboBox.addItem(MakeCustomizer.getString("MULTIPLE_CONFIGURATIONS"));
        }
        if ((selectedIndex = projectDescriptor.getConfs().getActiveAsIndex()) < 0) {
            selectedIndex = 0;
        }
        this.configurationComboBox.setSelectedIndex(selectedIndex);
        this.calculateSelectedConfs();
        HelpCtx.setHelpIDString((JComponent)this.customizerPanel, (String)"org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer");
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizer.class, (String)"AD_MakeCustomizer"));
        this.fillConstraints = new GridBagConstraints();
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.gridheight = 0;
        this.fillConstraints.fill = 1;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        this.currentCategoryView = new CategoryView(this.createRootNode(project, projectDescriptor, items, folders), preselectedNodeName);
        this.currentCategoryView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MakeCustomizer.class, (String)"AN_BeanTreeViewCategories"));
        this.currentCategoryView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizer.class, (String)"AD_BeanTreeViewCategories"));
        this.categoryPanel.add((Component)this.currentCategoryView, this.fillConstraints);
        this.configurationsButton.getAccessibleContext().setAccessibleDescription(MakeCustomizer.getString("CONFIGURATIONS_BUTTON_AD"));
        this.configurationComboBox.getAccessibleContext().setAccessibleDescription(MakeCustomizer.getString("CONFIGURATION_COMBOBOX_AD"));
        this.allConfigurationComboBox.addItem(MakeCustomizer.getString("ALL_CONFIGURATIONS"));
        this.allConfigurationComboBox.getAccessibleContext().setAccessibleDescription(MakeCustomizer.getString("CONFIGURATIONS_BUTTON_AD"));
        this.allConfigurationComboBox.getAccessibleContext().setAccessibleDescription(MakeCustomizer.getString("CONFIGURATION_COMBOBOX_AD"));
        this.allConfigurationComboBox.setToolTipText(MakeCustomizer.getString("ALL_CONFIGURATIONS_TOOLTIP"));
    }

    private SharedItemConfiguration getSharedItemConfiguration(Item item) {
        if (item == null) {
            return null;
        }
        SharedItemConfiguration res = this.itemConfigurations.get(item);
        if (res == null) {
            res = new SharedItemConfiguration(item);
            this.itemConfigurations.put(item, res);
        }
        return res;
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
    }

    private void initComponents() {
        this.categoryLabel = new JLabel();
        this.categoryPanel = new JPanel();
        this.propertyPanel = new JPanel();
        this.configurationPanel = new JPanel();
        this.configurationLabel = new JLabel();
        this.configurationComboBox = new JComboBox();
        this.allConfigurationComboBox = new JComboBox();
        this.configurationsButton = new JButton();
        this.customizerPanel = new JPanel();
        this.setPreferredSize(new Dimension(900, 520));
        this.setLayout(new GridBagLayout());
        this.categoryLabel.setLabelFor(this.categoryPanel);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/customizer/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.categoryLabel, (String)bundle.getString("CATEGORIES_LABEL_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 0);
        this.add((Component)this.categoryLabel, gridBagConstraints);
        this.categoryPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoryPanel.setMinimumSize(new Dimension(220, 4));
        this.categoryPanel.setPreferredSize(new Dimension(220, 4));
        this.categoryPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.categoryPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MakeCustomizer.class, (String)"ACSN_MakeCustomizer_categoryPanel"));
        this.categoryPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizer.class, (String)"ACSD_MakeCustomizer_categoryPanel"));
        this.propertyPanel.setLayout(new GridBagLayout());
        this.configurationPanel.setLayout(new GridBagLayout());
        this.configurationLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/customizer/Bundle").getString("CONFIGURATION_COMBOBOX_MNE").charAt(0));
        this.configurationLabel.setLabelFor(this.configurationComboBox);
        this.configurationLabel.setText(bundle.getString("CONFIGURATION_COMBOBOX_LBL"));
        this.configurationPanel.add((Component)this.configurationLabel, new GridBagConstraints());
        this.configurationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakeCustomizer.this.configurationComboBoxActionPerformed(evt);
            }
        });
        this.configurationPanel.add((Component)this.configurationComboBox, new GridBagConstraints());
        this.configurationPanel.add((Component)this.allConfigurationComboBox, new GridBagConstraints());
        Mnemonics.setLocalizedText((AbstractButton)this.configurationsButton, (String)bundle.getString("CONFIGURATIONS_BUTTON_LBL"));
        this.configurationsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakeCustomizer.this.configurationsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.configurationPanel.add((Component)this.configurationsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.propertyPanel.add((Component)this.configurationPanel, gridBagConstraints);
        this.customizerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.propertyPanel.add((Component)this.customizerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.propertyPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MakeCustomizer.class, (String)"ACSN_MakeCustomizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizer.class, (String)"ACSD_MakeCustomizer"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurationsButtonActionPerformed(ActionEvent evt) {
        MyListEditorPanel configurationsEditor = new MyListEditorPanel(this.projectDescriptor);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        outerPanel.add((Component)((Object)configurationsEditor), gridBagConstraints);
        Object[] options = new Object[]{NotifyDescriptor.OK_OPTION};
        DialogDescriptor dd = new DialogDescriptor((Object)outerPanel, MakeCustomizer.getString("CONFIGURATIONS_EDITOR_TITLE"), true, options, NotifyDescriptor.OK_OPTION, 0, null, null);
        DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
        Dialog dl = dialogDisplayer.createDialog(dd);
        dl.getAccessibleContext().setAccessibleDescription(MakeCustomizer.getString("CONFIGURATIONS_EDITOR_AD"));
        dl.pack();
        dl.setSize(new Dimension(400, (int)dl.getPreferredSize().getHeight()));
        try {
            dl.setVisible(true);
        }
        catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
            dd.setValue(DialogDescriptor.CLOSED_OPTION);
        }
        finally {
            dl.dispose();
        }
        Configuration[] editedConfs = configurationsEditor.getListData().toArray(new Configuration[configurationsEditor.getListData().size()]);
        int active = -1;
        for (int i = 0; i < editedConfs.length; ++i) {
            if (!editedConfs[i].isDefault()) continue;
            active = i;
            break;
        }
        this.projectDescriptor.getConfs().init(editedConfs, active);
        ActionListener[] actionListeners = this.configurationComboBox.getActionListeners();
        this.configurationComboBox.removeActionListener(actionListeners[0]);
        this.configurationComboBox.removeAllItems();
        this.configurationComboBox.addActionListener(actionListeners[0]);
        this.configurationItems = this.projectDescriptor.getConfs().toArray();
        for (int i = 0; i < this.configurationItems.length; ++i) {
            this.configurationComboBox.addItem(this.configurationItems[i]);
        }
        if (this.configurationItems.length > 1) {
            this.configurationComboBox.addItem(MakeCustomizer.getString("ALL_CONFIGURATIONS"));
        }
        if (this.configurationItems.length > 2) {
            this.configurationComboBox.addItem(MakeCustomizer.getString("MULTIPLE_CONFIGURATIONS"));
        }
        this.configurationComboBox.setSelectedIndex(configurationsEditor.getSelectedIndex());
        this.calculateSelectedConfs();
    }

    private void configurationComboBoxActionPerformed(ActionEvent evt) {
        this.calculateSelectedConfs();
        this.refresh();
    }

    public String getCurrentNodeName() {
        return this.currentNodeName;
    }

    public MakeContext getLastContext() {
        return this.lastContext;
    }

    public void refresh() {
        if (this.currentCategoryView != null) {
            String selectedNodeName = this.currentNodeName;
            this.categoryPanel.remove(this.currentCategoryView);
            this.currentCategoryView = new CategoryView(this.createRootNode(this.project, this.projectDescriptor, this.items, this.folders), null);
            this.currentCategoryView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MakeCustomizer.class, (String)"AN_BeanTreeViewCategories"));
            this.currentCategoryView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizer.class, (String)"AD_BeanTreeViewCategories"));
            this.categoryPanel.add((Component)this.currentCategoryView, this.fillConstraints);
            if (selectedNodeName != null) {
                this.currentCategoryView.selectNode(selectedNodeName);
            }
        }
    }

    public void save() {
        if (this.lastContext != null) {
            this.lastContext.save();
        }
    }

    public HelpCtx getHelpCtx() {
        if (this.currentConfigurationNode != null) {
            return HelpCtx.findHelp((Object)((Object)this.currentConfigurationNode));
        }
        return null;
    }

    private void calculateSelectedConfs() {
        if (this.configurationComboBox.getSelectedIndex() < this.configurationItems.length) {
            this.selectedConfigurations = new Configuration[]{(MakeConfiguration)this.configurationComboBox.getSelectedItem()};
            this.lastComboboxIndex = this.configurationComboBox.getSelectedIndex();
        } else if (this.configurationComboBox.getSelectedIndex() == this.configurationItems.length) {
            this.selectedConfigurations = this.configurationItems;
            this.lastComboboxIndex = this.configurationComboBox.getSelectedIndex();
        } else {
            while (true) {
                ConfSelectorPanel confSelectorPanel = new ConfSelectorPanel(MakeCustomizer.getString("SELECTED_CONFIGURATIONS_LBL"), 'v', this.configurationItems, null);
                DialogDescriptor dd = new DialogDescriptor((Object)confSelectorPanel, MakeCustomizer.getString("MULTIPLE_CONFIGURATIONS_TITLE"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (dd.getValue() != DialogDescriptor.OK_OPTION) {
                    if (this.lastComboboxIndex > this.configurationItems.length) break;
                    this.configurationComboBox.setSelectedIndex(this.lastComboboxIndex);
                    break;
                }
                if (confSelectorPanel.getSelectedConfs().length > 1) {
                    this.selectedConfigurations = confSelectorPanel.getSelectedConfs();
                    this.lastComboboxIndex = this.configurationComboBox.getSelectedIndex();
                    break;
                }
                String errormsg = MakeCustomizer.getString("SELECT_MORE");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
            }
        }
    }

    private Node createRootNode(Project project, ConfigurationDescriptor projectDescriptor, List<Item> items, List<Folder> folders) {
        if (items != null) {
            ArrayList<SharedItemConfiguration> configs = new ArrayList<SharedItemConfiguration>();
            for (Item item : items) {
                if (item == null) continue;
                configs.add(this.getSharedItemConfiguration(item));
            }
            this.lastContext = new MakeContext(MakeContext.Kind.Item, project, this.getSelectedHost(), this.selectedConfigurations).setSharedItem(configs.toArray(new SharedItemConfiguration[configs.size()])).setConfigurationDescriptor(projectDescriptor);
            Lookup lookup = Lookups.fixed((Object[])new Object[]{this.lastContext});
            return ItemNodeFactory.createRootNodeItem(lookup);
        }
        if (folders != null) {
            this.lastContext = new MakeContext(MakeContext.Kind.Folder, project, this.getSelectedHost(), this.selectedConfigurations).setFolders(folders.toArray(new Folder[folders.size()])).setConfigurationDescriptor(projectDescriptor);
            Folder[] array = folders.toArray(new Folder[folders.size()]);
            Lookup lookup = Lookups.fixed((Object[])new Object[]{this.lastContext, array});
            return FolderNodeFactory.createRootNodeFolder(lookup);
        }
        this.lastContext = new MakeContext(MakeContext.Kind.Project, project, this.getSelectedHost(), this.selectedConfigurations).setPanel(this).setConfigurationDescriptor(projectDescriptor);
        Lookup lookup = Lookups.fixed((Object[])new Object[]{this.lastContext, project});
        return ProjectNodeFactory.createRootNodeProject(lookup);
    }

    private ExecutionEnvironment getSelectedHost() {
        ExecutionEnvironment execEnv;
        if (this.configurationComboBox.getSelectedIndex() < this.configurationItems.length) {
            MakeConfiguration conf = (MakeConfiguration)this.configurationComboBox.getSelectedItem();
            execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
        } else {
            execEnv = ExecutionEnvironmentFactory.getLocal();
            if (this.selectedConfigurations != null && this.selectedConfigurations.length > 0) {
                MakeConfiguration conf;
                for (int i = 0; i < this.selectedConfigurations.length && !(execEnv = (conf = (MakeConfiguration)this.selectedConfigurations[i]).getDevelopmentHost().getExecutionEnvironment()).isLocal(); ++i) {
                }
            }
        }
        return execEnv;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(MakeCustomizer.class).getString(s);
    }

    private static final class MyListEditorPanel
    extends ListEditorPanel<Configuration> {
        final ConfigurationDescriptor projectDescriptor;

        public MyListEditorPanel(ConfigurationDescriptor descriptor) {
            super(descriptor.getConfs().getConfigurations());
            this.projectDescriptor = descriptor;
            this.setAllowedToRemoveAll(false);
        }

        private Folder getTestsRootFolder(MakeConfigurationDescriptor projectDescriptor) {
            Folder root = projectDescriptor.getLogicalFolders();
            for (Folder folder : root.getFolders()) {
                if (!folder.isTestRootFolder()) continue;
                return folder;
            }
            return null;
        }

        private void setCppUnitOptions(Configuration cfg, Folder rootFolder) {
            rootFolder.getAllTests().forEach(testFolder -> {
                FolderConfiguration folderConfiguration = testFolder.getFolderConfiguration(cfg);
                LinkerConfiguration linkerConfiguration = folderConfiguration.getLinkerConfiguration();
                LibrariesConfiguration librariesConfiguration = linkerConfiguration.getLibrariesConfiguration();
                librariesConfiguration.add((Object)new LibraryItem.OptionItem("`cppunit-config --libs`"));
                linkerConfiguration.getOutput().setValue("${TESTDIR}/" + testFolder.getPath());
                CCompilerConfiguration cCompilerConfiguration = folderConfiguration.getCCompilerConfiguration();
                CCCompilerConfiguration ccCompilerConfiguration = folderConfiguration.getCCCompilerConfiguration();
                cCompilerConfiguration.getCommandLineConfiguration().setValue("`cppunit-config --cflags`");
                ccCompilerConfiguration.getCommandLineConfiguration().setValue("`cppunit-config --cflags`");
                cCompilerConfiguration.getIncludeDirectories().add((Object)".");
                ccCompilerConfiguration.getIncludeDirectories().add((Object)".");
            });
        }

        public Configuration addAction() {
            String newName = ConfigurationSupport.getUniqueNewName((Configuration[])this.getConfs());
            int type = 0;
            String customizerId = null;
            String buildDir = null;
            if (this.getActive() != null) {
                type = ((MakeConfiguration)this.getActive()).getConfigurationType().getValue();
                customizerId = ((MakeConfiguration)this.getActive()).getCustomizerId();
                buildDir = ((MakeConfiguration)this.getActive()).getMakefileConfiguration().getBuildCommandWorkingDirValue();
            }
            Configuration newconf = this.projectDescriptor.defaultConf(newName, type, customizerId);
            if (buildDir != null) {
                ((MakeConfiguration)newconf).getMakefileConfiguration().getBuildCommandWorkingDir().setValue(buildDir);
            }
            ((MakeConfiguration)newconf).reCountLanguages((MakeConfigurationDescriptor)this.projectDescriptor);
            Configuration result = this.editActionImpl(newconf) ? newconf : null;
            Folder testFolder = this.getTestsRootFolder((MakeConfigurationDescriptor)this.projectDescriptor);
            if (testFolder != null) {
                this.setCppUnitOptions(result, testFolder);
            }
            return result;
        }

        public Configuration copyAction(Configuration o) {
            Configuration c = o;
            Configuration copyConf = c.copy();
            copyConf.setDefault(false);
            copyConf.setName(ConfigurationSupport.getUniqueCopyName((Configuration[])this.getConfs(), (Configuration)c));
            copyConf.setCloneOf(null);
            return copyConf;
        }

        public void removeAction(Configuration o, int i) {
            Configuration c = o;
            if (c.isDefault()) {
                if (this.getListData().get(0) == o) {
                    ((Configuration)this.getListData().get(1)).setDefault(true);
                } else {
                    ((Configuration)this.getListData().get(0)).setDefault(true);
                }
            }
            CompileOptionsProvider.getDefault().onRemove((MakeConfigurationDescriptor)this.projectDescriptor, (MakeConfiguration)c);
        }

        public void defaultAction(Configuration o) {
            List confs = this.getListData();
            confs.forEach(c -> c.setDefault(false));
            o.setDefault(true);
        }

        public void editAction(Configuration o, int i) {
            this.editActionImpl(o);
        }

        private boolean editActionImpl(Configuration o) {
            Configuration c = o;
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(MakeCustomizer.getString("CONFIGURATION_RENAME_DIALOG_LABEL"), MakeCustomizer.getString("CONFIGURATION_RENAME_DIALOG_TITLE"));
            notifyDescriptor.setInputText(c.getName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return false;
            }
            if (c.getName().equals(notifyDescriptor.getInputText())) {
                return true;
            }
            String suggestedName = ConfigurationSupport.makeNameLegal((String)notifyDescriptor.getInputText());
            String name = ConfigurationSupport.getUniqueName((Configuration[])this.getConfs(), (String)suggestedName);
            CompileOptionsProvider.getDefault().onRename((MakeConfigurationDescriptor)this.projectDescriptor, (MakeConfiguration)c, name);
            c.setName(name);
            return true;
        }

        public String getListLabelText() {
            return MakeCustomizer.getString("CONFIGURATIONS_LIST_NAME");
        }

        public char getListLabelMnemonic() {
            return MakeCustomizer.getString("CONFIGURATIONS_LIST_MNE").charAt(0);
        }

        public Configuration[] getConfs() {
            return this.getListData().toArray(new Configuration[this.getListData().size()]);
        }

        public Configuration getActive() {
            Configuration[] confs = this.getConfs();
            Configuration active = null;
            for (int i = 0; i < confs.length; ++i) {
                if (!confs[i].isDefault()) continue;
                active = confs[i];
                break;
            }
            return active;
        }

        protected void checkSelection() {
            super.checkSelection();
            int i = this.getSelectedIndex();
            if (i < 0) {
                return;
            }
            Configuration conf = (Configuration)this.getListData().get(i);
            this.getDefaultButton().setEnabled(!conf.isDefault());
        }
    }

    private static final class DummyNode
    extends AbstractNode {
        public DummyNode(Sheet sheet, String name) {
            super(Children.LEAF);
            if (sheet != null) {
                this.setSheet(sheet);
            }
            this.setName(name);
        }
    }

    private final class CategoryView
    extends JPanel
    implements ExplorerManager.Provider {
        private final ExplorerManager manager;
        private final BeanTreeView btv;
        private final String preselectedNodeName;

        CategoryView(Node rootNode, String preselectedNodeName) {
            this.preselectedNodeName = preselectedNodeName;
            this.manager = new ExplorerManager();
            this.setLayout(new BorderLayout());
            Dimension size = new Dimension(220, 4);
            this.btv = new BeanTreeView();
            this.btv.setSelectionMode(4);
            this.btv.setPopupAllowed(false);
            this.btv.setRootVisible(true);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setMinimumSize(size);
            this.btv.setPreferredSize(size);
            this.btv.setMaximumSize(size);
            this.btv.setDragSource(false);
            this.btv.setRootVisible(false);
            this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MakeCustomizer.class, (String)"AN_BeanTreeViewCategories"));
            this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizer.class, (String)"AD_BeanTreeViewCategories"));
            this.add((Component)this.btv, "Center");
            this.manager.setRootContext(rootNode);
            ManagerChangeListener managerChangeListener = new ManagerChangeListener();
            this.manager.addPropertyChangeListener((PropertyChangeListener)managerChangeListener);
            this.selectNode(preselectedNodeName);
            MakeCustomizer.this.controls.add(this.btv);
        }

        private void expandCollapseTree(Node rootNode, BeanTreeView btv) {
            Children children = rootNode.getChildren();
            Node[] nodes1 = children.getNodes();
            for (int i = 0; i < nodes1.length; ++i) {
                if (nodes1[i].getName().equals("Build") || nodes1[i].getName().equals("Debuggers")) {
                    btv.expandNode(nodes1[i]);
                    continue;
                }
                btv.collapseNode(nodes1[i]);
            }
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.expandCollapseTree(this.manager.getRootContext(), this.btv);
            if (this.preselectedNodeName != null && this.preselectedNodeName.length() > 0) {
                this.selectNode(this.preselectedNodeName);
            }
        }

        private Node findNode(Node pnode, String name) {
            Node node = NodeOp.findChild((Node)pnode, (String)name);
            if (node != null) {
                return node;
            }
            Children ch = pnode.getChildren();
            Node[] nodes = ch.getNodes(true);
            for (int i = 0; i < nodes.length; ++i) {
                Node cnode = this.findNode(nodes[i], name);
                if (cnode == null) continue;
                return cnode;
            }
            return null;
        }

        private void selectNode(String name) {
            Node node = null;
            if (name != null) {
                node = this.findNode(this.manager.getRootContext(), name);
            }
            if (node == null) {
                node = this.manager.getRootContext().getChildren().getNodes()[0];
            }
            if (node != null) {
                try {
                    this.manager.setSelectedNodes(new Node[]{node});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class ManagerChangeListener
        implements PropertyChangeListener {
            private ManagerChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != CategoryView.this.manager) {
                    return;
                }
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    Node[] nodes = CategoryView.this.manager.getSelectedNodes();
                    if (nodes == null || nodes.length <= 0) {
                        return;
                    }
                    Node node = nodes[0];
                    MakeCustomizer.this.currentNodeName = node.getName();
                    if (MakeCustomizer.this.currentCustomizer != null) {
                        MakeCustomizer.this.customizerPanel.remove(MakeCustomizer.this.currentCustomizer);
                    }
                    JPanel panel = new JPanel();
                    panel.setLayout(new GridBagLayout());
                    MakeCustomizer.this.currentConfigurationNode = (PropertyNode)node;
                    if (MakeCustomizer.this.currentConfigurationNode.customizerStyle() == CustomizerNode.CustomizerStyle.PANEL) {
                        panel.add((Component)MakeCustomizer.this.currentConfigurationNode.getPanel(null), MakeCustomizer.this.fillConstraints);
                        MakeCustomizer.this.configurationLabel.setEnabled(false);
                        MakeCustomizer.this.configurationComboBox.setEnabled(false);
                        MakeCustomizer.this.configurationsButton.setEnabled(true);
                        MakeCustomizer.this.configurationComboBox.setVisible(false);
                        MakeCustomizer.this.allConfigurationComboBox.setVisible(true);
                        MakeCustomizer.this.allConfigurationComboBox.setEnabled(false);
                    } else if (MakeCustomizer.this.currentConfigurationNode.customizerStyle() == CustomizerNode.CustomizerStyle.SHEET) {
                        panel.setBorder(new EtchedBorder());
                        PropertySheet propertySheet = new PropertySheet();
                        ArrayList<DummyNode> dummyNodes = new ArrayList<DummyNode>(MakeCustomizer.this.selectedConfigurations.length * nodes.length);
                        for (Node selNode : nodes) {
                            if (!(selNode instanceof PropertyNode) || ((PropertyNode)selNode).customizerStyle() != CustomizerNode.CustomizerStyle.SHEET) continue;
                            PropertyNode propNode = (PropertyNode)selNode;
                            for (int i = 0; i < MakeCustomizer.this.selectedConfigurations.length; ++i) {
                                Sheet[] sheets = propNode.getSheets(MakeCustomizer.this.selectedConfigurations[i]);
                                if (sheets == null) continue;
                                for (Sheet sheet : sheets) {
                                    if (((MakeConfigurationDescriptor)MakeCustomizer.this.projectDescriptor).hasProjectCustomizer()) {
                                        MakeProjectCustomizerEx makeProjectCustomizer = (MakeProjectCustomizerEx)((MakeConfigurationDescriptor)MakeCustomizer.this.projectDescriptor).getProjectCustomizer();
                                        sheet = makeProjectCustomizer.getPropertySheet(sheet);
                                    }
                                    dummyNodes.add(new DummyNode(sheet, MakeCustomizer.this.selectedConfigurations[i].getName()));
                                }
                            }
                        }
                        propertySheet.setNodes((Node[])dummyNodes.toArray(new DummyNode[dummyNodes.size()]));
                        panel.add((Component)propertySheet, MakeCustomizer.this.fillConstraints);
                        MakeCustomizer.this.configurationLabel.setEnabled(true);
                        MakeCustomizer.this.configurationComboBox.setEnabled(true);
                        MakeCustomizer.this.configurationsButton.setEnabled(true);
                        MakeCustomizer.this.configurationComboBox.setVisible(true);
                        MakeCustomizer.this.allConfigurationComboBox.setVisible(false);
                    } else {
                        MakeCustomizer.this.configurationLabel.setEnabled(false);
                        MakeCustomizer.this.configurationComboBox.setEnabled(false);
                        MakeCustomizer.this.configurationsButton.setEnabled(false);
                        MakeCustomizer.this.configurationComboBox.setVisible(true);
                        MakeCustomizer.this.allConfigurationComboBox.setVisible(false);
                    }
                    MakeCustomizer.this.customizerPanel.add((Component)panel, MakeCustomizer.this.fillConstraints);
                    MakeCustomizer.this.customizerPanel.validate();
                    MakeCustomizer.this.customizerPanel.repaint();
                    MakeCustomizer.this.currentCustomizer = panel;
                    CndUIUtilities.requestFocus((Component)CategoryView.this.btv);
                    if (MakeCustomizer.this.dialogDescriptor != null && MakeCustomizer.this.currentConfigurationNode != null) {
                        MakeCustomizer.this.dialogDescriptor.setHelpCtx(HelpCtx.findHelp((Object)((Object)MakeCustomizer.this.currentConfigurationNode)));
                    }
                    return;
                }
            }
        }
    }
}

