/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.wizards;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.impl.GrailsArtifacts;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.impl.GrailsTargetChooserPanel;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.impl.ProgressLineProcessor;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GrailsArtifactWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(GrailsArtifactWizardIterator.class.getName());
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private SourceCategory sourceCategory;
    private GrailsProject project;

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup group = GrailsArtifacts.getSourceGroupForCategory(this.project, GroovySources.getGroovySourceGroups((Sources)sources), this.sourceCategory);
        assert (group != null);
        if (group == null) {
            SourceGroup[] groups = sources.getSourceGroups("generic");
            return new WizardDescriptor.Panel[]{Templates.buildSimpleTargetChooser((Project)this.project, (SourceGroup[])groups).create()};
        }
        return new WizardDescriptor.Panel[]{new GrailsTargetChooserPanel(this.project, group, null, this.sourceCategory.getSuffix())};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public Set instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(final ProgressHandle handle) throws IOException {
        FileObject artifact;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
        String packageName = GrailsArtifactWizardIterator.getPackageName(dir);
        String artifactName = packageName == null || "".equals(packageName.trim()) ? targetName : packageName + "." + targetName;
        handle.start(100);
        try {
            String serverCommand = this.sourceCategory.getCommand();
            ProjectInformation inf = ProjectUtils.getInformation((Project)this.project);
            String displayName = inf.getDisplayName() + " (" + serverCommand + ")";
            final Callable grailsCallable = ExecutionSupport.getInstance().createSimpleCommand(serverCommand, GrailsProjectConfig.forProject((Project)this.project), new String[]{artifactName});
            final DialogLineProcessor dialogProcessor = new DialogLineProcessor();
            Callable<Process> callable = new Callable<Process>(){

                @Override
                public Process call() throws Exception {
                    Process process = (Process)grailsCallable.call();
                    dialogProcessor.setWriter(new OutputStreamWriter(process.getOutputStream()));
                    return process;
                }
            };
            ExecutionDescriptor descriptor = new ExecutionDescriptor().frontWindow(true).inputVisible(true);
            descriptor = descriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)new ProgressLineProcessor(handle, 100, 9))});
                }
            });
            descriptor = descriptor.errProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)dialogProcessor)});
                }
            });
            descriptor = descriptor.postExecution((Runnable)new RefreshProjectRunnable(this.project));
            ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
            Future future = service.run();
            try {
                Integer ret = (Integer)future.get();
                if (ret != 0) {
                    String msg = NbBundle.getMessage(GrailsArtifactWizardIterator.class, (String)"WIZARD_ERROR_MESSAGE_ARTIFACT");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex.getCause());
            }
        }
        finally {
            handle.progress(100);
            handle.finish();
        }
        LOG.log(Level.FINEST, "Artifact Name  {0}", artifactName);
        dir.refresh();
        String suffix = this.sourceCategory.getSuffix();
        if (suffix == null) {
            artifact = dir.getFileObject(targetName, Templates.getTemplate((WizardDescriptor)this.wiz).getExt());
            if (artifact == null) {
                artifact = dir.getFileObject(targetName, "groovy");
            }
        } else {
            artifact = dir.getFileObject(targetName + suffix);
        }
        if (artifact != null) {
            return Collections.singleton(artifact);
        }
        LOG.log(Level.WARNING, "Problem creating FileObject for {0} ", artifactName);
        return Collections.emptySet();
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        this.sourceCategory = GrailsArtifacts.getCategoryForTemplate(template);
        assert (this.sourceCategory != null);
        this.project = (GrailsProject)Templates.getProject((WizardDescriptor)wiz).getLookup().lookup(GrailsProject.class);
        this.index = 0;
        this.panels = this.createPanels(wiz);
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz = null;
        this.panels = null;
        this.sourceCategory = null;
        this.project = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    private static String getPackageName(FileObject targetFolder) {
        Project project = FileOwnerQuery.getOwner((FileObject)targetFolder);
        Sources sources = ProjectUtils.getSources((Project)project);
        List groups = GroovySources.getGroovySourceGroups((Sources)sources);
        String packageName = null;
        for (int i = 0; i < groups.size() && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)((SourceGroup)groups.get(i)).getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName != null) {
            packageName = packageName.replaceAll("/", ".");
        }
        return packageName;
    }

    private static class DialogLineProcessor
    implements LineProcessor {
        private static final Pattern OVERWRITE_PATTERN = Pattern.compile("^.*\\s([^\\s]+\\.groovy) already exists\\. Overwrite\\? \\[y/n\\]$");
        private static final Pattern DEFAULT_PACKAGE_PATTERN = Pattern.compile("^WARNING: You have not specified a package\\. .* Do you want to continue\\? \\(y, n\\)$");
        private Writer writer;

        private DialogLineProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String line) {
            Writer answerWriter;
            DialogLineProcessor dialogLineProcessor = this;
            synchronized (dialogLineProcessor) {
                answerWriter = this.writer;
            }
            if (answerWriter != null) {
                Matcher matcher = OVERWRITE_PATTERN.matcher(line);
                if (matcher.matches()) {
                    NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(GrailsArtifactWizardIterator.class, (String)"MSG_overwrite_file", (Object)matcher.group(1)), 0);
                    try {
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                            answerWriter.write("y\n");
                        } else {
                            answerWriter.write("n\n");
                        }
                        answerWriter.flush();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    matcher = DEFAULT_PACKAGE_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        try {
                            answerWriter.write("y\n");
                            answerWriter.flush();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWriter(Writer writer) {
            DialogLineProcessor dialogLineProcessor = this;
            synchronized (dialogLineProcessor) {
                this.writer = writer;
            }
        }

        public void close() {
        }

        public void reset() {
        }
    }
}

