/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.openssh.PEM;
import com.sshtools.j2ssh.util.Base64;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class PEMReader
extends PEM {
    private LineNumberReader reader;
    private String type;
    private Map header;
    private byte[] payload;

    public PEMReader(Reader r) throws IOException {
        this.reader = new LineNumberReader(r);
        this.read();
    }

    private void read() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            if (!line.startsWith("-----") || !line.endsWith("-----")) continue;
            if (line.startsWith("-----BEGIN ")) {
                this.type = line.substring("-----BEGIN ".length(), line.length() - "-----".length());
                break;
            }
            throw new IOException("Invalid PEM boundary at line " + this.reader.getLineNumber() + ": " + line);
        }
        this.header = new HashMap();
        block1: while ((line = this.reader.readLine()) != null) {
            int colon = line.indexOf(58);
            if (colon == -1) break;
            String key = line.substring(0, colon).trim();
            if (line.endsWith("\\")) {
                String v = line.substring(colon + 1, line.length() - 1).trim();
                StringBuffer value = new StringBuffer(v);
                while ((line = this.reader.readLine()) != null) {
                    if (line.endsWith("\\")) {
                        value.append(" ").append(line.substring(0, line.length() - 1).trim());
                        continue;
                    }
                    value.append(" ").append(line.trim());
                    continue block1;
                }
                continue;
            }
            String value = line.substring(colon + 1).trim();
            this.header.put(key, value);
        }
        if (line == null) {
            throw new IOException("The key format is invalid! OpenSSH formatted keys must begin with -----BEGIN RSA or -----BEGIN DSA");
        }
        StringBuffer body = new StringBuffer(line);
        while ((line = this.reader.readLine()) != null) {
            if (line.startsWith("-----") && line.endsWith("-----")) {
                if (line.startsWith("-----END " + this.type)) break;
                throw new IOException("Invalid PEM end boundary at line " + this.reader.getLineNumber() + ": " + line);
            }
            body.append(line);
        }
        this.payload = Base64.decode(body.toString());
    }

    public Map getHeader() {
        return this.header;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getType() {
        return this.type;
    }

    public byte[] decryptPayload(String passphrase) throws GeneralSecurityException {
        String dekInfo = (String)this.header.get("DEK-Info");
        if (dekInfo != null) {
            int comma = dekInfo.indexOf(44);
            String keyAlgorithm = dekInfo.substring(0, comma);
            if (!"DES-EDE3-CBC".equals(keyAlgorithm)) {
                throw new NoSuchAlgorithmException("Unsupported passphrase algorithm: " + keyAlgorithm);
            }
            String ivString = dekInfo.substring(comma + 1);
            byte[] iv = new byte[ivString.length() / 2];
            int i = 0;
            while (i < ivString.length()) {
                iv[i / 2] = (byte)Integer.parseInt(ivString.substring(i, i + 2), 16);
                i += 2;
            }
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            SecretKey key = PEMReader.getKeyFromPassphrase(passphrase, iv, 24);
            cipher.init(2, (Key)key, new IvParameterSpec(iv));
            byte[] plain = new byte[this.payload.length];
            cipher.update(this.payload, 0, this.payload.length, plain, 0);
            return plain;
        }
        return this.payload;
    }
}

