/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.MessageRequestId;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public class SshFxpOpen
extends SubsystemMessage
implements MessageRequestId {
    public static final int SSH_FXP_OPEN = 3;
    public static final int FXF_READ = 1;
    public static final int FXF_WRITE = 2;
    public static final int FXF_APPEND = 4;
    public static final int FXF_CREAT = 8;
    public static final int FXF_TRUNC = 16;
    public static final int FXF_EXCL = 32;
    private UnsignedInteger32 id;
    private String filename;
    private UnsignedInteger32 pflags;
    private FileAttributes attrs;

    public SshFxpOpen(UnsignedInteger32 id, String filename, UnsignedInteger32 pflags, FileAttributes attrs) {
        super(3);
        this.id = id;
        this.filename = filename;
        this.pflags = pflags;
        this.attrs = attrs;
    }

    public SshFxpOpen() {
        super(3);
    }

    public UnsignedInteger32 getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public UnsignedInteger32 getPflags() {
        return this.pflags;
    }

    public FileAttributes getAttributes() {
        return this.attrs;
    }

    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        this.id = bar.readUINT32();
        this.filename = bar.readString();
        this.pflags = bar.readUINT32();
        this.attrs = new FileAttributes(bar);
    }

    public String getMessageName() {
        return "SSH_FXP_OPEN";
    }

    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        baw.writeUINT32(this.id);
        baw.writeString(this.filename);
        baw.writeUINT32(this.pflags);
        baw.writeBinaryString(this.attrs.toByteArray());
    }
}

