/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;

public abstract class SshMessage {
    private int messageId;

    public SshMessage(int messageId) {
        this.messageId = messageId;
    }

    public final int getMessageId() {
        return this.messageId;
    }

    public abstract String getMessageName();

    public final byte[] toByteArray() throws InvalidMessageException {
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.write(this.messageId);
        this.constructByteArray(baw);
        return baw.toByteArray();
    }

    protected final void fromByteArray(ByteArrayReader data) throws InvalidMessageException {
        data.skip(5L);
        int id = data.read();
        if (id != this.messageId) {
            throw new InvalidMessageException("The message id " + String.valueOf(id) + " is not the same as the message implementation id " + String.valueOf(this.messageId));
        }
        this.constructMessage(data);
    }

    public static Integer getMessageId(byte[] msgdata) {
        return new Integer(msgdata[5]);
    }

    protected abstract void constructByteArray(ByteArrayWriter var1) throws InvalidMessageException;

    protected abstract void constructMessage(ByteArrayReader var1) throws InvalidMessageException;
}

