/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgServiceAccept
extends SshMessage {
    protected static final int SSH_MSG_SERVICE_ACCEPT = 6;
    private String serviceName;

    public SshMsgServiceAccept(String serviceName) {
        super(6);
        this.serviceName = serviceName;
    }

    public SshMsgServiceAccept() {
        super(6);
    }

    public String getMessageName() {
        return "SSH_MSG_SERVICE_ACCEPT";
    }

    public String getServiceName() {
        return this.serviceName;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeString(this.serviceName);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error writing message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.serviceName = bar.available() > 0 ? bar.readString() : "";
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error reading message data");
        }
    }
}

