/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2;

import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.data.OperationInfo;
import edu.harvard.mgh.purcell.gCLINE.data.RunCommand;
import edu.harvard.mgh.purcell.gPLINK2.data.Project;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLINK_Import
extends JDialog {
    private Logger logger = Logger.getLogger(PLINK_Import.class);
    private StartFrame frame;
    private Project data;
    private JComboBox nonincludedRoots;
    private JCheckBox allBox;
    private Vector<String> finalLogRoots;
    private ExitStatus done;

    private Vector<String[]> getInput(String cline) {
        HashSet<String> dynamicAns = new HashSet<String>();
        String[] commandArray = RunCommand.stripAndSplit(cline);
        int i = 0;
        while (i < commandArray.length) {
            String tempRoot;
            if (!(!commandArray[i].contains(".") || commandArray[i].matches("\\d*.?\\d*") || commandArray[i].endsWith(".exe") || commandArray[i].endsWith(".exe\"") || commandArray[i].endsWith("plink") || commandArray[i].endsWith("plink\""))) {
                dynamicAns.add(commandArray[i]);
            }
            if (commandArray[i].equals("--bfile")) {
                tempRoot = "plink";
                if (i + 1 < commandArray.length) {
                    tempRoot = commandArray[i + 1];
                }
                if (tempRoot.startsWith("--")) {
                    tempRoot = "plink";
                }
                dynamicAns.add(String.valueOf(tempRoot) + ".bed");
                dynamicAns.add(String.valueOf(tempRoot) + ".fam");
                dynamicAns.add(String.valueOf(tempRoot) + ".bim");
            }
            if (commandArray[i].equals("--file")) {
                tempRoot = "plink";
                if (i + 1 < commandArray.length) {
                    tempRoot = commandArray[i + 1];
                }
                if (tempRoot.startsWith("--")) {
                    tempRoot = "plink";
                }
                dynamicAns.add(String.valueOf(tempRoot) + ".map");
                dynamicAns.add(String.valueOf(tempRoot) + ".ped");
            }
            ++i;
        }
        Vector<String[]> ans = new Vector<String[]>();
        for (String s : dynamicAns) {
            ans.add(new String[]{s, ""});
        }
        return ans;
    }

    private String getCommandline(String outputRoot) {
        this.done = ExitStatus.RUNNING;
        File logFile = new File(this.data.getLocalFolder().getAbsolutePath(), String.valueOf(outputRoot) + ".log");
        String cline = FileInfo.quote(this.data.getPlinkPath());
        try {
            BufferedReader input = new BufferedReader(new FileReader(logFile));
            String line = input.readLine();
            while (line != null) {
                if (line.contains("Options in effect")) {
                    line = input.readLine();
                    while (line != null && !line.trim().equals("")) {
                        line = line.trim();
                        this.logger.info("Reading line[" + line + "]");
                        String[] temp = line.split("\\s");
                        if (temp.length <= 2) {
                            cline = String.valueOf(cline) + " " + line.trim();
                            this.logger.info("Simple add");
                        } else {
                            int index = line.indexOf(" ");
                            String filename = line.substring(index + 1);
                            if (filename.contains(".") && !filename.matches("\\d*.?\\d*")) {
                                cline = String.valueOf(cline) + " " + temp[0] + " " + FileInfo.quote(filename);
                                this.logger.info("adding file: [" + FileInfo.quote(filename) + "]");
                            } else {
                                this.logger.info("Simple add");
                                cline = String.valueOf(cline) + " " + line.trim();
                            }
                        }
                        line = input.readLine();
                    }
                }
                if (line.contains("Analysis finished")) {
                    this.done = ExitStatus.SUCCESS;
                }
                if (line.contains("ERROR")) {
                    this.done = ExitStatus.FAILURE;
                }
                line = input.readLine();
            }
            input.close();
        }
        catch (FileNotFoundException e) {
            this.frame.messanger.createError("File not found exception: [" + logFile.getAbsolutePath() + "]", "process(String)@PLINK_Import.java");
        }
        catch (IOException e2) {
            this.frame.messanger.createError("IO exception reading: [" + logFile.getAbsolutePath() + "]", "process(String)@PLINK_Import.java");
        }
        return cline;
    }

    /*
     * WARNING - void declaration
     */
    private void process() {
        Vector<Object> selectedRoots = new Vector<String>();
        if (this.allBox.isSelected()) {
            selectedRoots = this.finalLogRoots;
        } else {
            selectedRoots.add((String)this.nonincludedRoots.getSelectedItem());
        }
        if (this.data.isRemote()) {
            void var3_4;
            this.logger.info("[process()] pulling down the selected log files");
            String[] allLog = new String[selectedRoots.size()];
            boolean bl = false;
            while (var3_4 < selectedRoots.size()) {
                allLog[var3_4] = String.valueOf(this.data.getRemoteFolder()) + (String)selectedRoots.get((int)var3_4) + ".log";
                ++var3_4;
            }
            StartFrame startFrame = this.frame;
            startFrame.getClass();
            startFrame.new StartFrame.Download(this.data, false, this.data.getLocalFolder(), allLog).run();
        }
        HashMap<String, String> fileTimes = new HashMap<String, String>();
        if (this.data.isRemote()) {
            RunCommand runCommand = new RunCommand("ls --full-time " + this.data.getRemoteFolder(), this.data);
            runCommand.run();
            Vector<String> fullRemoteFiles = runCommand.outputLines;
            for (String line : fullRemoteFiles) {
                String[] t = line.split("\\s+");
                if (t.length <= 8) continue;
                String file = t[8];
                String date = String.valueOf(t[5]) + " " + t[6].substring(0, 8);
                fileTimes.put(file, date);
            }
        }
        for (String string : selectedRoots) {
            String cline = this.getCommandline(string);
            Vector<String[]> infiles = this.getInput(cline);
            String time = "No time found";
            if (this.data.isRemote()) {
                time = (String)fileTimes.get(String.valueOf(string) + this.data.getLogExt());
                if (time == null) {
                    time = "No time found";
                }
            } else {
                time = OperationInfo.DATEFORMAT.format(new Date(new File(this.data.getLocalFolder(), String.valueOf(string) + this.data.getLogExt()).lastModified()));
            }
            this.data.addOperation(string, "", cline, time, infiles, new Vector<String[]>());
            if (this.done.equals((Object)ExitStatus.RUNNING)) continue;
            try {
                File gplinkfile = new File(this.data.getLocalFolder(), String.valueOf(string) + Project.GPLINK_EXT);
                if (!gplinkfile.createNewFile()) continue;
                BufferedWriter out = new BufferedWriter(new FileWriter(gplinkfile));
                if (this.done.equals((Object)ExitStatus.SUCCESS)) {
                    out.write("0");
                } else {
                    out.write("1");
                }
                out.close();
                if (!this.data.isRemote()) continue;
                StartFrame startFrame = this.frame;
                startFrame.getClass();
                new Thread(startFrame.new StartFrame.Upload(this.data, false, this.data.getRemoteFolder(), new File[]{gplinkfile})).start();
            }
            catch (IOException e) {
                this.frame.messanger.createError("Error trying to create the .gplink file for imported operation.", "process()@PLINK_Import.java");
            }
        }
    }

    private JPanel createRoots() {
        Vector<OperationInfo> knownOps = this.data.getAllOp();
        Vector<String> knownOpNames = new Vector<String>();
        for (OperationInfo temo : knownOps) {
            knownOpNames.add(temo.getName());
        }
        Vector<String> allFiles = this.data.getHomeFiles();
        this.finalLogRoots = new Vector();
        for (String file : allFiles) {
            String logRoot;
            if (!file.endsWith(this.data.getLogExt()) || knownOpNames.contains(logRoot = file.substring(0, file.length() - this.data.getLogExt().length()))) continue;
            this.finalLogRoots.add(logRoot);
        }
        Collections.sort(this.finalLogRoots);
        this.nonincludedRoots = new JComboBox<String>(this.finalLogRoots);
        this.nonincludedRoots.setEditable(false);
        JPanel comboPane = new JPanel();
        comboPane.setLayout(new BoxLayout(comboPane, 3));
        comboPane.add(new JLabel("Select analysis to import:"));
        comboPane.add(this.nonincludedRoots);
        this.allBox = new JCheckBox("Import all operations.");
        comboPane.add(this.allBox);
        return comboPane;
    }

    private JPanel createButtons() {
        JButton okbutton = new JButton("OK");
        JButton cancelbutton = new JButton("Cancel");
        cancelbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PLINK_Import.this.dispose();
            }
        });
        okbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PLINK_Import.this.process();
                PLINK_Import.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.add(okbutton);
        buttonPane.add(cancelbutton);
        return buttonPane;
    }

    public PLINK_Import(StartFrame mf, Project d) {
        super((Frame)mf, "Import Analysis");
        this.frame = mf;
        this.data = d;
        this.getRootPane().setLayout(new BoxLayout(this.getRootPane(), 3));
        this.getRootPane().add(this.createRoots());
        this.getRootPane().add(this.createButtons());
        this.pack();
        this.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExitStatus {
        SUCCESS,
        FAILURE,
        RUNNING;

    }
}

