/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;

public class HaploFreq
extends Form {
    public static String name = "Haplotype Frequencies";
    Form.BrowseButton hapListBrowse;
    JRadioButton hapListButton;
    JRadioButton hapWindowButton;
    JTextField hapListText;
    JTextField hapWindowText;

    public HaploFreq(GPLINK mf) {
        super(mf, name);
        this.pack();
        this.setVisible(true);
    }

    protected JPanel createBody() {
        JPanel body = new JPanel();
        this.hapWindowText = new JTextField(10);
        this.hapWindowText.getDocument().addDocumentListener(this.validateBodyDL);
        this.hapListText = new JTextField(20);
        this.hapListText.getDocument().addDocumentListener(this.validateBodyDL);
        this.hapListBrowse = new Form.BrowseButton(this.hapListText, ".hlist", "Haplotype list (*.hlist)");
        this.hapWindowButton = new JRadioButton("Sliding window (--hap-window)");
        this.hapWindowButton.addActionListener(this.validateBodyAL);
        HaploFreq.bundel((JToggleButton)this.hapWindowButton, this.hapWindowText);
        this.hapListButton = new JRadioButton("Haplotype list (--hap)");
        this.hapListButton.addActionListener(this.validateBodyAL);
        HaploFreq.bundel((JToggleButton)this.hapListButton, this.hapListText, this.hapListBrowse);
        ButtonGroup pickOne = new ButtonGroup();
        pickOne.add(this.hapWindowButton);
        pickOne.add(this.hapListButton);
        body.setLayout(new GridBagLayout());
        body.setBorder(new TitledBorder("Haplotype specification"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        body.add((Component)this.hapListButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        body.add((Component)this.hapListText, c);
        c.weightx = 0.0;
        c.gridx = 2;
        body.add((Component)this.hapListBrowse, c);
        c.gridy = 1;
        c.gridx = 0;
        body.add((Component)this.hapWindowButton, c);
        c.gridwidth = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        body.add((Component)this.hapWindowText, c);
        return body;
    }

    protected void isBodyValid() {
        this.validBody = !this.hapListButton.isSelected() && !this.hapWindowButton.isSelected() ? false : (this.hapListButton.isSelected() && this.hapListText.getText().length() == 0 ? false : !this.hapWindowButton.isSelected() || this.hapWindowText.getText().matches("\\d+"));
        this.okForm();
    }

    protected String processBody() {
        String ans = "--hap-freq";
        if (this.hapListButton.isSelected()) {
            ans = String.valueOf(ans) + " --hap " + FileInfo.quote(this.hapListText.getText());
        }
        if (this.hapWindowButton.isSelected()) {
            ans = String.valueOf(ans) + " --hap-window " + this.hapWindowText.getText();
        }
        return ans;
    }
}

