/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class StratAnaly
extends Form {
    public static String name = "Stratified Analyses";
    JRadioButton mhButton;
    JRadioButton mh2Button;
    JRadioButton homogButton;
    JRadioButton withinButton;
    JRadioButton familyButton;
    JCheckBox ciButton;
    JCheckBox bdButton;
    JCheckBox adjustButton;
    JTextField withinText;
    JTextField ciText;
    Form.BrowseButton withinBrowse;
    static Double CI_DEFAULT = new Double(0.95);

    public StratAnaly(GPLINK mf) {
        super(mf, name);
        this.pack();
        this.setVisible(true);
    }

    protected JPanel createBody() {
        this.validBody = true;
        JPanel body = new JPanel();
        this.withinText = new JTextField(10);
        this.withinText.getDocument().addDocumentListener(this.validateBodyDL);
        this.withinBrowse = new Form.BrowseButton(this.withinText, ".cluster2", "CLUSTER");
        this.ciText = new JTextField(CI_DEFAULT.toString(), 4);
        this.ciText.getDocument().addDocumentListener(this.validateBodyDL);
        this.mhButton = new JRadioButton("Cochran-Mantel-Haenszel, \t\t\t\tSNP-DISEASE | CLUSTER (--mh)");
        this.mhButton.addActionListener(this.validateBodyAL);
        this.bdButton = new JCheckBox("Breslow-Day test of heterogeneous \t\t\t\tCMH ORs (--bd) ");
        this.bdButton.addActionListener(this.validateBodyAL);
        this.mh2Button = new JRadioButton("Cochran-Mantel-Haenszel, \t\t\t\tSNP-CLUSTER | DISEASE (--mh2)");
        this.mh2Button.addActionListener(this.validateBodyAL);
        this.adjustButton = new JCheckBox("Adjusted p-values (--adjust)");
        this.adjustButton.addActionListener(this.validateBodyAL);
        this.homogButton = new JRadioButton("Test of homogeneous association \t\t\t\t(--homog) ");
        this.homogButton.addActionListener(this.validateBodyAL);
        this.withinButton = new JRadioButton("Cluster file (--within) ");
        this.withinButton.addActionListener(this.validateBodyAL);
        StratAnaly.bundel((JToggleButton)this.withinButton, this.withinText, this.withinBrowse);
        this.familyButton = new JRadioButton("Cluster by family (--family)");
        this.familyButton.addActionListener(this.validateBodyAL);
        this.ciButton = new JCheckBox("Confidence intervals (--ci) ");
        this.ciButton.addActionListener(this.validateBodyAL);
        StratAnaly.bundel((JToggleButton)this.ciButton, this.ciText);
        ButtonGroup forceOne = new ButtonGroup();
        forceOne.add(this.mhButton);
        this.mhButton.setSelected(true);
        forceOne.add(this.mh2Button);
        forceOne.add(this.homogButton);
        ButtonGroup forceOne2 = new ButtonGroup();
        forceOne2.add(this.familyButton);
        this.familyButton.setSelected(true);
        forceOne2.add(this.withinButton);
        body.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 3;
        body.add((Component)this.mhButton, c);
        c.gridy = 1;
        body.add((Component)this.mh2Button, c);
        c.gridy = 2;
        body.add((Component)this.homogButton, c);
        c.gridy = 3;
        body.add((Component)new JSeparator(0), c);
        c.gridy = 4;
        body.add((Component)this.familyButton, c);
        c.weightx = 0.0;
        c.gridy = 5;
        c.gridwidth = 1;
        body.add((Component)this.withinButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        body.add((Component)this.withinText, c);
        c.gridx = 2;
        c.weightx = 0.0;
        body.add((Component)this.withinBrowse, c);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 6;
        body.add((Component)new JSeparator(0), c);
        c.gridy = 7;
        body.add((Component)this.bdButton, c);
        c.gridy = 8;
        body.add((Component)this.adjustButton, c);
        c.gridy = 9;
        c.gridwidth = 1;
        body.add((Component)this.ciButton, c);
        c.gridx = 1;
        body.add((Component)this.ciText, c);
        return body;
    }

    protected String processBody() {
        String ans = "";
        if (this.bdButton.isSelected()) {
            ans = String.valueOf(ans) + " --bd";
        }
        if (this.homogButton.isSelected()) {
            ans = String.valueOf(ans) + " --homog";
        }
        if (this.mhButton.isSelected()) {
            ans = String.valueOf(ans) + " --mh";
        }
        if (this.mh2Button.isSelected()) {
            ans = String.valueOf(ans) + " --mh2";
        }
        if (this.adjustButton.isSelected()) {
            ans = String.valueOf(ans) + " --adjust";
        }
        if (this.withinButton.isSelected()) {
            ans = String.valueOf(ans) + " --within " + FileInfo.quote(this.withinText.getText());
        }
        if (this.familyButton.isSelected()) {
            ans = String.valueOf(ans) + " --family";
        }
        if (this.ciButton.isSelected()) {
            ans = String.valueOf(ans) + " --ci " + this.ciText.getText();
        }
        ans = ans.replaceFirst(" ", "");
        return ans;
    }

    protected void isBodyValid() {
        this.validBody = !this.mhButton.isSelected() && !this.mh2Button.isSelected() && !this.homogButton.isSelected() ? false : (!this.withinButton.isSelected() && !this.familyButton.isSelected() ? false : !this.withinButton.isSelected() || this.withinText.getText().length() != 0);
        this.okForm();
    }
}

