/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.myers.MyersDiff;
import org.apache.commons.jrcs.util.ToString;

public class Diff
extends ToString {
    public static final String NL = System.getProperty("line.separator");
    public static final String RCS_EOL = "\n";
    protected final Object[] orig;
    protected DiffAlgorithm algorithm;

    public Diff(Object[] original) {
        this(original, null);
    }

    public Diff(Object[] original, DiffAlgorithm algorithm) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        this.orig = original;
        this.algorithm = algorithm != null ? algorithm : this.defaultAlgorithm();
    }

    protected DiffAlgorithm defaultAlgorithm() {
        return new MyersDiff();
    }

    public static Revision diff(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        if (orig == null || rev == null) {
            throw new IllegalArgumentException();
        }
        return Diff.diff(orig, rev, null);
    }

    public static Revision diff(Object[] orig, Object[] rev, DiffAlgorithm algorithm) throws DifferentiationFailedException {
        if (orig == null || rev == null) {
            throw new IllegalArgumentException();
        }
        return new Diff(orig, algorithm).diff(rev);
    }

    public Revision diff(Object[] rev) throws DifferentiationFailedException {
        Revision revision = this.algorithm.diff(this.orig, rev);
        revision.setOrgSize(this.orig.length);
        revision.setRevSize(rev.length);
        return revision;
    }

    public static boolean compare(Object[] orig, Object[] rev) {
        if (orig.length != rev.length) {
            return false;
        }
        for (int i = 0; i < orig.length; ++i) {
            if (orig[i].equals(rev[i])) continue;
            return false;
        }
        return true;
    }

    public static String arrayToString(Object[] o) {
        return Diff.arrayToString(o, NL);
    }

    public static Object[] editAll(Object[] text) {
        Object[] result = new String[text.length];
        for (int i = 0; i < text.length; ++i) {
            result[i] = text[i] + " <edited>";
        }
        return result;
    }

    public static Object[] randomEdit(Object[] text) {
        return Diff.randomEdit(text, text.length);
    }

    public static Object[] randomEdit(Object[] text, long seed) {
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(text));
        Random r = new Random(seed);
        int nops = r.nextInt(10);
        for (int i = 0; i < nops; ++i) {
            boolean del = r.nextBoolean();
            int pos = r.nextInt(result.size() + 1);
            int len = Math.min(result.size() - pos, 1 + r.nextInt(4));
            if (del && result.size() > 0) {
                result.subList(pos, pos + len).clear();
                continue;
            }
            int k = 0;
            while (k < len) {
                result.add(pos, "[" + i + "] random edit[" + i + "][" + i + "]");
                ++k;
                ++pos;
            }
        }
        return result.toArray();
    }

    public static Object[] shuffle(Object[] text) {
        return Diff.shuffle(text, text.length);
    }

    public static Object[] shuffle(Object[] text, long seed) {
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(text));
        Collections.shuffle(result);
        return result.toArray();
    }

    public static Object[] randomSequence(int size) {
        return Diff.randomSequence(size, size);
    }

    public static Object[] randomSequence(int size, long seed) {
        Object[] result = new Integer[size];
        Random r = new Random(seed);
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Integer(r.nextInt(size));
        }
        return result;
    }
}

