/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractPatternVisitor;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.edit.TextAnnotation;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.common.NameClassSplitter;
import com.thaiopensource.relaxng.output.xsd.ChildType;
import com.thaiopensource.relaxng.output.xsd.Guide;
import com.thaiopensource.relaxng.output.xsd.SchemaInfo;
import com.thaiopensource.relaxng.output.xsd.WildcardBuilder;
import com.thaiopensource.relaxng.output.xsd.basic.Annotation;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseChoice;
import com.thaiopensource.relaxng.output.xsd.basic.Comment;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeNotAllowedContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeSimpleContent;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.Facet;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Occurs;
import com.thaiopensource.relaxng.output.xsd.basic.OptionalAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeList;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRef;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRestriction;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.Wildcard;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BasicBuilder {
    private final PatternVisitor<SimpleType> simpleTypeBuilder = new SimpleTypeBuilder();
    private final PatternVisitor<AttributeUse> attributeUseBuilder = new AttributeUseBuilder();
    private final PatternVisitor<AttributeUse> optionalAttributeUseBuilder = new OptionalAttributeUseBuilder();
    private final PatternVisitor<Particle> particleBuilder = new ParticleBuilder();
    private final PatternVisitor<Occurs> occursCalculator = new OccursCalculator();
    private final ComponentVisitor<VoidValue> schemaBuilder;
    private final ErrorReporter er;
    private final String inheritedNamespace;
    private final Schema schema;
    private final SchemaInfo si;
    private final Guide guide;
    private static final String GUIDE_NAMESPACE = "http://www.thaiopensource.com/ns/relaxng/xsd";

    private BasicBuilder(ErrorReporter errorReporter, SchemaInfo schemaInfo, Guide guide, Schema schema, String string, Annotated annotated, boolean bl) {
        this.er = errorReporter;
        this.si = schemaInfo;
        this.guide = guide;
        this.schema = schema;
        this.inheritedNamespace = string;
        this.schemaBuilder = new SchemaBuilder(BasicBuilder.getGroupEnableAbstractElements(annotated, bl));
    }

    static Schema buildBasicSchema(SchemaInfo schemaInfo, Guide guide, ErrorReporter errorReporter) {
        GrammarPattern grammarPattern = schemaInfo.getGrammar();
        Schema schema = new Schema(grammarPattern.getSourceLocation(), BasicBuilder.makeAnnotation(grammarPattern), schemaInfo.getMainUri(), schemaInfo.getEncoding(schemaInfo.getMainUri()));
        new BasicBuilder(errorReporter, schemaInfo, guide, schema, "", grammarPattern, guide.getDefaultGroupEnableAbstractElements()).processGrammar(grammarPattern);
        return schema;
    }

    private void processGrammar(GrammarPattern grammarPattern) {
        BasicBuilder.copyComments(grammarPattern.getLeadingComments(), this.schema.getLeadingComments());
        this.addInitialChildComments(grammarPattern);
        grammarPattern.componentsAccept(this.schemaBuilder);
        BasicBuilder.copyComments(grammarPattern.getFollowingElementAnnotations(), this.schema.getTrailingComments());
    }

    private static SimpleType makeUnionWithEmptySimpleType(SimpleType simpleType, SourceLocation sourceLocation) {
        Vector<SimpleType> vector = new Vector<SimpleType>();
        vector.add(simpleType);
        vector.add(BasicBuilder.makeEmptySimpleType(sourceLocation));
        return new SimpleTypeUnion(sourceLocation, null, vector);
    }

    private static SimpleType makeEmptySimpleType(SourceLocation sourceLocation) {
        Vector<Facet> vector = new Vector<Facet>();
        vector.add(new Facet(sourceLocation, null, "length", "0"));
        return new SimpleTypeRestriction(sourceLocation, null, "token", vector);
    }

    private static SimpleType makeStringType(SourceLocation sourceLocation) {
        List<Facet> list = Collections.emptyList();
        return new SimpleTypeRestriction(sourceLocation, null, "string", list);
    }

    private Name makeName(NameNameClass nameNameClass) {
        return new Name(this.resolveNamespace(nameNameClass.getNamespaceUri()), nameNameClass.getLocalName());
    }

    private String resolveNamespace(String string) {
        return BasicBuilder.resolveNamespace(string, this.inheritedNamespace);
    }

    private static String resolveNamespace(String string, String string2) {
        if (string == NameNameClass.INHERIT_NS) {
            return string2;
        }
        return string;
    }

    private static Wildcard[] splitElementWildcard(Wildcard wildcard) {
        if (wildcard == null) {
            return new Wildcard[0];
        }
        if (wildcard.isPositive() || wildcard.getNamespaces().contains("") || wildcard.getNamespaces().size() != 1) {
            return new Wildcard[]{wildcard};
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("");
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add(wildcard.getNamespaces().iterator().next());
        hashSet2.add("");
        HashSet<Name> hashSet3 = new HashSet<Name>();
        HashSet<Name> hashSet4 = new HashSet<Name>();
        for (Name name : wildcard.getExcludedNames()) {
            (name.getNamespaceUri().equals("") ? hashSet3 : hashSet4).add(name);
        }
        return new Wildcard[]{new Wildcard(false, hashSet2, hashSet4), new Wildcard(true, hashSet, hashSet3)};
    }

    private boolean allowsAnyString(Pattern pattern) {
        while (pattern instanceof RefPattern) {
            pattern = this.si.getBody((RefPattern)pattern);
        }
        if (pattern instanceof TextPattern) {
            return true;
        }
        if (!(pattern instanceof DataPattern)) {
            return false;
        }
        DataPattern dataPattern = (DataPattern)pattern;
        if (dataPattern.getParams().size() != 0) {
            return false;
        }
        String string = dataPattern.getDatatypeLibrary();
        if (string.equals("")) {
            return true;
        }
        if (!string.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
            return false;
        }
        String string2 = dataPattern.getType();
        return string2.equals("string") || string2.equals("token") || string2.equals("normalizedString");
    }

    private static Annotation makeAnnotation(Annotated annotated) {
        List<AnnotationChild> list = annotated.mayContainText() ? annotated.getFollowingElementAnnotations() : annotated.getChildElementAnnotations();
        for (AnnotationChild annotationChild : list) {
            ElementAnnotation elementAnnotation;
            if (!(annotationChild instanceof ElementAnnotation) || !(elementAnnotation = (ElementAnnotation)annotationChild).getNamespaceUri().equals("http://relaxng.org/ns/compatibility/annotations/1.0") || !elementAnnotation.getLocalName().equals("documentation")) continue;
            String string = BasicBuilder.getAtomicValue(elementAnnotation);
            if (string == null) break;
            return new Annotation(string);
        }
        return null;
    }

    private static String getAtomicValue(ElementAnnotation elementAnnotation) {
        String string = null;
        StringBuffer stringBuffer = null;
        List<AnnotationChild> list = elementAnnotation.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AnnotationChild annotationChild = list.get(i);
            if (annotationChild instanceof TextAnnotation) {
                String string2 = ((TextAnnotation)annotationChild).getValue();
                if (stringBuffer != null) {
                    stringBuffer.append(string2);
                    continue;
                }
                if (string == null) {
                    string = string2;
                    continue;
                }
                stringBuffer = new StringBuffer(string);
                stringBuffer.append(string2);
                string = null;
                continue;
            }
            if (!(annotationChild instanceof ElementAnnotation)) continue;
            return null;
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        if (string != null) {
            return string;
        }
        return "";
    }

    private static boolean getGroupEnableAbstractElements(Annotated annotated, boolean bl) {
        String string = annotated.getAttributeAnnotation(GUIDE_NAMESPACE, "enableAbstractElements");
        if (string != null) {
            if ((string = string.trim()).equals("true")) {
                bl = true;
            } else if (string.equals("false")) {
                bl = false;
            }
        }
        return bl;
    }

    private void addLeadingComments(Annotated annotated) {
        this.addComments(annotated.getLeadingComments());
    }

    private void addInitialChildComments(Annotated annotated) {
        this.addComments(annotated.getChildElementAnnotations());
    }

    private void addTrailingComments(Annotated annotated) {
        this.addComments(annotated.getFollowingElementAnnotations());
    }

    private void addComments(List<? extends AnnotationChild> list) {
        for (AnnotationChild annotationChild : list) {
            if (!(annotationChild instanceof com.thaiopensource.relaxng.edit.Comment)) continue;
            com.thaiopensource.relaxng.edit.Comment comment = (com.thaiopensource.relaxng.edit.Comment)annotationChild;
            this.schema.addComment(comment.getValue(), comment.getSourceLocation());
        }
    }

    private static void copyComments(List<? extends AnnotationChild> list, List<Comment> list2) {
        for (AnnotationChild annotationChild : list) {
            if (!(annotationChild instanceof com.thaiopensource.relaxng.edit.Comment)) continue;
            com.thaiopensource.relaxng.edit.Comment comment = (com.thaiopensource.relaxng.edit.Comment)annotationChild;
            list2.add(new Comment(comment.getSourceLocation(), comment.getValue()));
        }
    }

    private class SimpleTypeBuilder
    extends AbstractPatternVisitor<SimpleType> {
        private SimpleTypeBuilder() {
        }

        @Override
        public SimpleType visitData(DataPattern dataPattern) {
            String string = dataPattern.getDatatypeLibrary();
            String string2 = dataPattern.getType();
            Vector<Facet> vector = new Vector<Facet>();
            SourceLocation sourceLocation = dataPattern.getSourceLocation();
            if (!string.equals("") && !string.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                string2 = "string";
                BasicBuilder.this.er.warning("unsupported_datatype_library", string, sourceLocation);
            } else {
                if (string2.equals("NOTATION")) {
                    string2 = "QName";
                }
                for (Param param : dataPattern.getParams()) {
                    vector.add(new Facet(param.getSourceLocation(), BasicBuilder.makeAnnotation(param), param.getName(), param.getValue()));
                }
            }
            return new SimpleTypeRestriction(sourceLocation, BasicBuilder.makeAnnotation(dataPattern), string2, vector);
        }

        @Override
        public SimpleType visitValue(ValuePattern valuePattern) {
            String string = valuePattern.getDatatypeLibrary();
            String string2 = valuePattern.getType();
            Vector<Facet> vector = new Vector<Facet>();
            SourceLocation sourceLocation = valuePattern.getSourceLocation();
            if (!string.equals("") && !string.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                string2 = "string";
                BasicBuilder.this.er.warning("unsupported_datatype_library", string, sourceLocation);
            } else {
                if (string2.equals("NOTATION")) {
                    string2 = "QName";
                }
                String string3 = null;
                String string4 = null;
                Iterator<Map.Entry<String, String>> iterator = valuePattern.getPrefixMap().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    string3 = entry.getKey();
                    string4 = BasicBuilder.this.resolveNamespace(entry.getValue());
                }
                vector.add(new Facet(sourceLocation, BasicBuilder.makeAnnotation(valuePattern), "enumeration", valuePattern.getValue(), string3, string4));
            }
            return new SimpleTypeRestriction(sourceLocation, null, string2, vector);
        }

        @Override
        public SimpleType visitComposite(CompositePattern compositePattern) {
            Vector<SimpleType> vector = new Vector<SimpleType>();
            for (Pattern pattern : compositePattern.getChildren()) {
                if (!BasicBuilder.this.si.getChildType(pattern).contains(ChildType.DATA)) continue;
                vector.add(pattern.accept(this));
            }
            if (vector.size() == 1) {
                return (SimpleType)vector.get(0);
            }
            return new SimpleTypeUnion(compositePattern.getSourceLocation(), BasicBuilder.makeAnnotation(compositePattern), vector);
        }

        @Override
        public SimpleType visitUnary(UnaryPattern unaryPattern) {
            return unaryPattern.getChild().accept(this);
        }

        @Override
        public SimpleType visitList(ListPattern listPattern) {
            SourceLocation sourceLocation = listPattern.getSourceLocation();
            Pattern pattern = listPattern.getChild();
            ChildType childType = BasicBuilder.this.si.getChildType(pattern);
            if (childType.equals(ChildType.EMPTY)) {
                return BasicBuilder.makeEmptySimpleType(sourceLocation);
            }
            boolean bl = false;
            if (childType.contains(ChildType.ELEMENT)) {
                BasicBuilder.this.er.warning("list_contains_element", sourceLocation);
                bl = true;
            }
            if (childType.contains(ChildType.ATTRIBUTE)) {
                BasicBuilder.this.er.warning("list_contains_attribute", sourceLocation);
                bl = true;
            }
            if (childType.contains(ChildType.TEXT)) {
                BasicBuilder.this.er.warning("list_contains_text", sourceLocation);
                bl = true;
            }
            if (bl) {
                return BasicBuilder.makeStringType(sourceLocation);
            }
            return new SimpleTypeList(sourceLocation, BasicBuilder.makeAnnotation(listPattern), pattern.accept(this), (Occurs)pattern.accept(BasicBuilder.this.occursCalculator));
        }

        @Override
        public SimpleType visitRef(RefPattern refPattern) {
            return new SimpleTypeRef(refPattern.getSourceLocation(), BasicBuilder.makeAnnotation(refPattern), refPattern.getName());
        }

        @Override
        public SimpleType visitPattern(Pattern pattern) {
            return null;
        }
    }

    class AttributeUseBuilder
    extends OptionalAttributeUseBuilder {
        AttributeUseBuilder() {
        }

        @Override
        boolean isOptional() {
            return false;
        }
    }

    class OptionalAttributeUseBuilder
    extends AbstractPatternVisitor<AttributeUse> {
        OptionalAttributeUseBuilder() {
        }

        @Override
        public AttributeUse visitAttribute(AttributePattern attributePattern) {
            SimpleType simpleType;
            SourceLocation sourceLocation = attributePattern.getSourceLocation();
            Pattern pattern = attributePattern.getChild();
            ChildType childType = BasicBuilder.this.si.getChildType(pattern);
            if (childType.contains(ChildType.DATA) && !childType.contains(ChildType.TEXT)) {
                simpleType = (SimpleType)pattern.accept(BasicBuilder.this.simpleTypeBuilder);
                if (childType.contains(ChildType.EMPTY)) {
                    simpleType = BasicBuilder.makeUnionWithEmptySimpleType(simpleType, sourceLocation);
                }
            } else {
                simpleType = childType.contains(ChildType.EMPTY) && !childType.contains(ChildType.TEXT) ? BasicBuilder.makeEmptySimpleType(sourceLocation) : null;
            }
            List<NameNameClass> list = NameClassSplitter.split(attributePattern.getNameClass());
            Wildcard wildcard = WildcardBuilder.createWildcard(attributePattern.getNameClass(), BasicBuilder.this.inheritedNamespace);
            Vector<AttributeUse> vector = new Vector<AttributeUse>();
            Annotation annotation = BasicBuilder.makeAnnotation(attributePattern);
            boolean bl = list.size() + (wildcard != null ? 1 : 0) == 1;
            Annotation annotation2 = bl ? annotation : null;
            for (NameNameClass nameNameClass : list) {
                Attribute attribute = new Attribute(sourceLocation, annotation2, BasicBuilder.this.makeName(nameNameClass), simpleType);
                if (!bl || this.isOptional()) {
                    vector.add(new OptionalAttribute(attribute.getLocation(), null, attribute, attributePattern.getAttributeAnnotation("http://relaxng.org/ns/compatibility/annotations/1.0", "defaultValue")));
                    continue;
                }
                vector.add(attribute);
            }
            if (wildcard != null) {
                if (!BasicBuilder.this.allowsAnyString(pattern)) {
                    BasicBuilder.this.er.warning("wildcard_attribute_value", attributePattern.getSourceLocation());
                }
                if (!this.isOptional()) {
                    BasicBuilder.this.er.warning("wildcard_attribute_optional", attributePattern.getSourceLocation());
                }
                vector.add(new WildcardAttribute(attributePattern.getSourceLocation(), annotation2, wildcard));
            }
            if (vector.size() == 1) {
                return (AttributeUse)vector.get(0);
            }
            return new AttributeGroup(attributePattern.getSourceLocation(), annotation, vector);
        }

        boolean isOptional() {
            return true;
        }

        @Override
        public AttributeUse visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return oneOrMorePattern.getChild().accept(this);
        }

        @Override
        public AttributeUse visitMixed(MixedPattern mixedPattern) {
            return mixedPattern.getChild().accept(this);
        }

        @Override
        public AttributeUse visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return (AttributeUse)zeroOrMorePattern.getChild().accept(BasicBuilder.this.optionalAttributeUseBuilder);
        }

        @Override
        public AttributeUse visitOptional(OptionalPattern optionalPattern) {
            return (AttributeUse)optionalPattern.getChild().accept(BasicBuilder.this.optionalAttributeUseBuilder);
        }

        @Override
        public AttributeUse visitRef(RefPattern refPattern) {
            AttributeGroupRef attributeGroupRef = new AttributeGroupRef(refPattern.getSourceLocation(), BasicBuilder.makeAnnotation(refPattern), refPattern.getName());
            if (!this.isOptional()) {
                return attributeGroupRef;
            }
            Vector<AttributeUse> vector = new Vector<AttributeUse>();
            vector.add(attributeGroupRef);
            vector.add(AttributeGroup.EMPTY);
            return new AttributeUseChoice(refPattern.getSourceLocation(), null, vector);
        }

        @Override
        public AttributeUse visitComposite(CompositePattern compositePattern) {
            Vector<AttributeUse> vector = new Vector<AttributeUse>();
            for (Pattern pattern : compositePattern.getChildren()) {
                if (!BasicBuilder.this.si.getChildType(pattern).contains(ChildType.ATTRIBUTE)) continue;
                vector.add(pattern.accept(this));
            }
            if (vector.size() == 0) {
                return AttributeGroup.EMPTY;
            }
            if (vector.size() == 1) {
                return (AttributeUse)vector.get(0);
            }
            if (this.isOptional()) {
                BasicBuilder.this.er.warning("optional_attribute_group", compositePattern.getSourceLocation());
            }
            return new AttributeGroup(compositePattern.getSourceLocation(), null, vector);
        }

        @Override
        public AttributeUse visitChoice(ChoicePattern choicePattern) {
            PatternVisitor<AttributeUse> patternVisitor = this;
            for (Pattern object2 : choicePattern.getChildren()) {
                if (BasicBuilder.this.si.getChildType(object2).contains(ChildType.ATTRIBUTE)) continue;
                patternVisitor = BasicBuilder.this.optionalAttributeUseBuilder;
                break;
            }
            boolean bl = false;
            Vector<AttributeUse> vector = new Vector<AttributeUse>();
            for (Pattern pattern : choicePattern.getChildren()) {
                ChildType childType = BasicBuilder.this.si.getChildType(pattern);
                if (childType.contains(ChildType.ATTRIBUTE)) {
                    AttributeUse attributeUse = pattern.accept(patternVisitor);
                    if (vector.size() != 1 || !attributeUse.equals(vector.get(0))) {
                        vector.add(attributeUse);
                    }
                }
                if (!childType.contains(ChildType.ELEMENT) && !childType.contains(ChildType.DATA) && !childType.contains(ChildType.TEXT)) continue;
                bl = true;
            }
            if (bl) {
                BasicBuilder.this.er.warning("attribute_child_choice", choicePattern.getSourceLocation());
            }
            if (vector.size() == 1) {
                return (AttributeUse)vector.get(0);
            }
            return new AttributeUseChoice(choicePattern.getSourceLocation(), null, vector);
        }

        @Override
        public AttributeUse visitPattern(Pattern pattern) {
            return null;
        }
    }

    class ParticleBuilder
    extends AbstractPatternVisitor<Particle> {
        ParticleBuilder() {
        }

        @Override
        public Particle visitElement(ElementPattern elementPattern) {
            Object object;
            ComplexType complexType;
            Pattern pattern = elementPattern.getChild();
            ChildType childType = BasicBuilder.this.si.getChildType(pattern);
            AttributeUse attributeUse = childType.contains(ChildType.ATTRIBUTE) ? (AttributeUse)pattern.accept(BasicBuilder.this.attributeUseBuilder) : AttributeGroup.EMPTY;
            Particle particle = null;
            boolean bl = false;
            if (childType.contains(ChildType.ELEMENT)) {
                if (childType.contains(ChildType.DATA)) {
                    bl = true;
                }
                particle = (Particle)pattern.accept(BasicBuilder.this.particleBuilder);
            }
            if (childType.contains(ChildType.TEXT)) {
                bl = true;
            }
            if (particle == null && bl && attributeUse.equals(AttributeGroup.EMPTY)) {
                complexType = new ComplexTypeSimpleContent(attributeUse, BasicBuilder.makeStringType(elementPattern.getSourceLocation()));
            } else if (childType.contains(ChildType.DATA) && !bl && particle == null) {
                object = (SimpleType)pattern.accept(BasicBuilder.this.simpleTypeBuilder);
                if (childType.contains(ChildType.EMPTY)) {
                    object = BasicBuilder.makeUnionWithEmptySimpleType((SimpleType)object, elementPattern.getSourceLocation());
                }
                complexType = new ComplexTypeSimpleContent(attributeUse, (SimpleType)object);
            } else {
                complexType = childType.equals(ChildType.NOT_ALLOWED) ? new ComplexTypeNotAllowedContent() : new ComplexTypeComplexContent(attributeUse, particle, bl);
            }
            object = NameClassSplitter.split(elementPattern.getNameClass());
            Wildcard[] wildcardArray = BasicBuilder.splitElementWildcard(WildcardBuilder.createWildcard(elementPattern.getNameClass(), BasicBuilder.this.inheritedNamespace));
            Annotation annotation = BasicBuilder.makeAnnotation(elementPattern);
            Annotation annotation2 = object.size() + wildcardArray.length == 1 ? annotation : null;
            Vector<Particle> vector = new Vector<Particle>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                NameNameClass nameNameClass = (NameNameClass)iterator.next();
                vector.add(new Element(elementPattern.getSourceLocation(), annotation2, BasicBuilder.this.makeName(nameNameClass), complexType));
            }
            for (int i = 0; i < wildcardArray.length; ++i) {
                vector.add(new WildcardElement(elementPattern.getSourceLocation(), annotation2, wildcardArray[i]));
            }
            if (vector.size() == 1) {
                return (Particle)vector.get(0);
            }
            return new ParticleChoice(elementPattern.getSourceLocation(), annotation, vector);
        }

        @Override
        public Particle visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return new ParticleRepeat(oneOrMorePattern.getSourceLocation(), BasicBuilder.makeAnnotation(oneOrMorePattern), oneOrMorePattern.getChild().accept(this), Occurs.ONE_OR_MORE);
        }

        @Override
        public Particle visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return new ParticleRepeat(zeroOrMorePattern.getSourceLocation(), BasicBuilder.makeAnnotation(zeroOrMorePattern), zeroOrMorePattern.getChild().accept(this), Occurs.ZERO_OR_MORE);
        }

        @Override
        public Particle visitOptional(OptionalPattern optionalPattern) {
            return new ParticleRepeat(optionalPattern.getSourceLocation(), BasicBuilder.makeAnnotation(optionalPattern), optionalPattern.getChild().accept(this), Occurs.OPTIONAL);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Particle visitChoice(ChoicePattern choicePattern) {
            void var5_8;
            Vector<Particle> vector = new Vector<Particle>();
            boolean bl = false;
            for (Pattern object2 : choicePattern.getChildren()) {
                ChildType childType = BasicBuilder.this.si.getChildType(object2);
                if (childType.contains(ChildType.ELEMENT)) {
                    vector.add(object2.accept(this));
                    continue;
                }
                if (childType.equals(ChildType.NOT_ALLOWED)) continue;
                bl = true;
            }
            Annotation annotation = BasicBuilder.makeAnnotation(choicePattern);
            if (vector.size() == 1 && annotation == null) {
                Particle particle = (Particle)vector.get(0);
            } else {
                ParticleChoice particleChoice = new ParticleChoice(choicePattern.getSourceLocation(), annotation, vector);
            }
            if (bl) {
                return new ParticleRepeat(choicePattern.getSourceLocation(), null, (Particle)var5_8, Occurs.OPTIONAL);
            }
            return var5_8;
        }

        @Override
        public Particle visitGroup(GroupPattern groupPattern) {
            Annotation annotation = BasicBuilder.makeAnnotation(groupPattern);
            List<Particle> list = this.buildChildren(groupPattern);
            if (list.size() == 1 && annotation == null) {
                return list.get(0);
            }
            return new ParticleSequence(groupPattern.getSourceLocation(), annotation, list);
        }

        @Override
        public Particle visitInterleave(InterleavePattern interleavePattern) {
            Annotation annotation = BasicBuilder.makeAnnotation(interleavePattern);
            List<Particle> list = this.buildChildren(interleavePattern);
            if (list.size() == 1 && annotation == null) {
                return list.get(0);
            }
            return new ParticleAll(interleavePattern.getSourceLocation(), annotation, list);
        }

        private List<Particle> buildChildren(CompositePattern compositePattern) {
            Vector<Particle> vector = new Vector<Particle>();
            for (Pattern pattern : compositePattern.getChildren()) {
                if (!BasicBuilder.this.si.getChildType(pattern).contains(ChildType.ELEMENT)) continue;
                vector.add(pattern.accept(this));
            }
            return vector;
        }

        @Override
        public Particle visitMixed(MixedPattern mixedPattern) {
            return mixedPattern.getChild().accept(this);
        }

        @Override
        public Particle visitRef(RefPattern refPattern) {
            return new GroupRef(refPattern.getSourceLocation(), BasicBuilder.makeAnnotation(refPattern), refPattern.getName());
        }

        @Override
        public Particle visitPattern(Pattern pattern) {
            return null;
        }
    }

    class OccursCalculator
    extends AbstractPatternVisitor<Occurs> {
        OccursCalculator() {
        }

        @Override
        public Occurs visitOptional(OptionalPattern optionalPattern) {
            return new Occurs(0, optionalPattern.getChild().accept(this).getMax());
        }

        @Override
        public Occurs visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return new Occurs(0, Integer.MAX_VALUE);
        }

        @Override
        public Occurs visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return new Occurs(oneOrMorePattern.getChild().accept(this).getMin(), Integer.MAX_VALUE);
        }

        @Override
        public Occurs visitData(DataPattern dataPattern) {
            return Occurs.EXACTLY_ONE;
        }

        @Override
        public Occurs visitValue(ValuePattern valuePattern) {
            return Occurs.EXACTLY_ONE;
        }

        @Override
        public Occurs visitEmpty(EmptyPattern emptyPattern) {
            return new Occurs(0, 0);
        }

        private Occurs sum(CompositePattern compositePattern) {
            Occurs occurs = new Occurs(0, 0);
            List<Pattern> list = compositePattern.getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                occurs = Occurs.add(occurs, list.get(i).accept(this));
            }
            return occurs;
        }

        @Override
        public Occurs visitInterleave(InterleavePattern interleavePattern) {
            return this.sum(interleavePattern);
        }

        @Override
        public Occurs visitGroup(GroupPattern groupPattern) {
            return this.sum(groupPattern);
        }

        @Override
        public Occurs visitChoice(ChoicePattern choicePattern) {
            List<Pattern> list = choicePattern.getChildren();
            Occurs occurs = list.get(0).accept(this);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                Occurs occurs2 = list.get(i).accept(this);
                occurs = new Occurs(Math.min(occurs.getMin(), occurs2.getMin()), Math.max(occurs.getMax(), occurs2.getMax()));
            }
            return occurs;
        }

        @Override
        public Occurs visitRef(RefPattern refPattern) {
            return BasicBuilder.this.si.getBody(refPattern).accept(this);
        }

        @Override
        public Occurs visitPattern(Pattern pattern) {
            return null;
        }
    }

    class SchemaBuilder
    implements ComponentVisitor<VoidValue> {
        boolean groupEnableAbstractElements;

        SchemaBuilder(boolean bl) {
            this.groupEnableAbstractElements = bl;
        }

        @Override
        public VoidValue visitDefine(DefineComponent defineComponent) {
            BasicBuilder.this.addLeadingComments(defineComponent);
            String string = defineComponent.getName();
            SourceLocation sourceLocation = defineComponent.getSourceLocation();
            Annotation annotation = BasicBuilder.makeAnnotation(defineComponent);
            if (string == DefineComponent.START) {
                if (!BasicBuilder.this.si.isIgnored(defineComponent)) {
                    Pattern pattern = defineComponent.getBody();
                    ChildType childType = BasicBuilder.this.si.getChildType(pattern);
                    if (childType.contains(ChildType.ELEMENT)) {
                        BasicBuilder.this.schema.addRoot((Particle)pattern.accept(BasicBuilder.this.particleBuilder), sourceLocation, annotation);
                    }
                }
            } else {
                Pattern pattern = BasicBuilder.this.si.getBody(defineComponent);
                if (pattern != null) {
                    ChildType childType = BasicBuilder.this.si.getChildType(pattern);
                    if (childType.contains(ChildType.ELEMENT)) {
                        BasicBuilder.this.guide.setGroupEnableAbstractElement(string, BasicBuilder.getGroupEnableAbstractElements(defineComponent, this.groupEnableAbstractElements));
                        BasicBuilder.this.schema.defineGroup(string, (Particle)pattern.accept(BasicBuilder.this.particleBuilder), sourceLocation, annotation);
                    } else if (childType.contains(ChildType.DATA) && !childType.contains(ChildType.TEXT)) {
                        BasicBuilder.this.schema.defineSimpleType(string, (SimpleType)pattern.accept(BasicBuilder.this.simpleTypeBuilder), sourceLocation, annotation);
                    }
                    if (childType.contains(ChildType.ATTRIBUTE)) {
                        BasicBuilder.this.schema.defineAttributeGroup(string, (AttributeUse)pattern.accept(BasicBuilder.this.attributeUseBuilder), sourceLocation, annotation);
                    }
                }
            }
            BasicBuilder.this.addTrailingComments(defineComponent);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitDiv(DivComponent divComponent) {
            BasicBuilder.this.addLeadingComments(divComponent);
            BasicBuilder.this.addInitialChildComments(divComponent);
            boolean bl = this.groupEnableAbstractElements;
            this.groupEnableAbstractElements = BasicBuilder.getGroupEnableAbstractElements(divComponent, this.groupEnableAbstractElements);
            divComponent.componentsAccept(this);
            this.groupEnableAbstractElements = bl;
            BasicBuilder.this.addTrailingComments(divComponent);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitInclude(IncludeComponent includeComponent) {
            BasicBuilder.this.addLeadingComments(includeComponent);
            BasicBuilder.this.addInitialChildComments(includeComponent);
            boolean bl = this.groupEnableAbstractElements;
            this.groupEnableAbstractElements = BasicBuilder.getGroupEnableAbstractElements(includeComponent, this.groupEnableAbstractElements);
            includeComponent.componentsAccept(this);
            String string = includeComponent.getUri();
            Schema schema = BasicBuilder.this.schema.addInclude(string, BasicBuilder.this.si.getEncoding(string), includeComponent.getSourceLocation(), BasicBuilder.makeAnnotation(includeComponent));
            GrammarPattern grammarPattern = BasicBuilder.this.si.getSchema(string);
            new BasicBuilder(BasicBuilder.this.er, BasicBuilder.this.si, BasicBuilder.this.guide, schema, BasicBuilder.this.resolveNamespace(includeComponent.getNs()), grammarPattern, this.groupEnableAbstractElements).processGrammar(grammarPattern);
            this.groupEnableAbstractElements = bl;
            BasicBuilder.this.addTrailingComments(includeComponent);
            return VoidValue.VOID;
        }
    }
}

