; Resident part is found in memory
@140:       pop    ax             
            cmp    byte ptr cs:80h,0 ; Any command-line directives?
            jne    @params           ; Yes - process them             
            mov    ah,  9      ; Warn about attempt to reload
            mov    dx,  offset already                       
            int    21h                                       
            jmp    @SwitchH ; Display the help screen
                                                     
curptr dw  ?  ;  Used for scanning the command line
                             
; String scanning procedure  
; Call:                      
; ES:SI - Memory area        
; AL - symbol to be found    
; CX - Quantity to be scanned

;===========================
; This procedure is to be optimised
;===========================
                             
@scanparams:                 
            push   dx        
            xor    dh,  dh   
            mov    dl,  [byte ptr cs:80h]
@search:                     
            cmp [byte ptr cs:81h+si], al
            je     @endit    
            inc    si        
            cmp    si,  dx   
            jb     @search   
            mov    al,0      
@endit:                      
            pop    dx        
            ret              
                             
;Directives search loops         
@params:                     
            cld              
            push   cs        
            pop    es ; ES=PSP segment
            mov    si,  0 ;starting at 81h in PSP Command line is stored
            xor    cx,  cx ;CX=0                                        
            mov    cl, byte ptr cs:80h; CX=length of the command line 
                                                                      
@process:                                                             
            mov    al,  '-'    ; Search the symbol                          
            call   @scanparams                                        
            cmp    al,  0      ; Found it?                             
            je     @Slash      ; No! Look for the other             
            inc    si                                  
            mov    al,  [byte ptr cs:81h+si]           
            call   UpCase      
            mov    curptr, si                          
            call   @switch     ; Process the directive found
            mov    si,  curptr                              
            xor    ah,  ah                                  
            mov    al,  [byte ptr cs:80h]                   
            cmp    si,  ax                                  
            jb     @process  ;and back in search...
@Slash:                                                     
     ; These lines are exact copies of the ones above.          
     ; So, I don't comment them                  
                                                   
            cld                                    
            push   cs                              
            pop    es 
            mov si,  0 
            xor    cx,  cx 
            mov    cl, byte ptr cs:80h
                                      
@process2:                            
            mov    al,  '/'           
            call   @scanparams        
            cmp    al,  0             
            je     @endproc           
            inc    si                 
            mov    al,  [byte ptr cs:81h+si]
            call   UpCase             
            mov    curptr, si         
            call   @switch            
            mov    si,  curptr        
            xor    ah,  ah            
            mov    al,  [byte ptr cs:80h]
            cmp    si,  ax            
            jb     @process2          
@endproc:                             
            ret                       
@switch:                              
            cmp    al,  0 ;Directive found?
            jne    @StartSwitches ;Yes. Start recognition
            ret    ;No. Return and try again
@StartSwitches:                             
                                            
   irp Switches,L,R,U,H,C,D,?  ;In this pseudoloop the directives read from
; the command line are recognized and the appropriate routines are called     
; This is TASM - specific structure
            cmp    al, '&Switches&'         
            jne    @N_&Switches&            
            push   ax                       
            call   @Switch&Switches&
            pop    ax              
   @N_&Switches& :                 
endm                               
            ret                    
                                   
@SwitchR:                          
@SwitchU:                          
;The unload procedure    
            push   cs         ;Is there a program to unload?
            pop    ax                                       
            cmp    ax, progseg                              
            jne    @unin      ; Yes. Remove it.                
            ret               ; No. Process next directive    
@unin:                                                    
       irp No,09,2f,08,33 ; Check for the vectors, hooked by another TSR
            mov ax,35&No&h                                              
            int    21h                                                  
            mov    ax,  es                                              
            cmp    ax,  progseg                                         
            je     @NextInt&No&                                         
            jmp    @attached ; There's one. Display the message        
@NextInt&No&:                                                           
       endm                                                    
            push  cs                                           
            pop   ds                                           
            mov   cx,   progseg                                
            mov   es,   cx                                     
       irp  No,09,2f,08,33 ; Restore the interrupt vectors
            mov    ax,  25&No&h                                
            mov    dx,  word ptr es:adr_&No&                   
            mov    cx,  word ptr es:adr_&No&+2            
            mov    ds,  cx                                
            int    21h                                    
       endm                                               
            push   cs           ; Free the memory used by the TSR
            pop    ds                                            
            mov    cx,  progseg                                  
            add    cx,  paragraphstocopy                         
            mov    ah,  49h                                      
            mov    es,  cx                                       
            int    21h                                           
            jc     @removeerror ; Memory has not been freed. Display message
            mov    dx,  offset removed;Tell about the success 
            mov    ah,  9                                        
            int    21h                                       
            int    20h                                       
                                                             
@attached:                                                   
; Display the error message when a vector has been hooked by another TSR
; and exit the program
            mov    dx,  offset attached                      
            mov    ah,  9                                    
            int    21h        
            int    20h        
@removeerror:                 
; Display the message when the memory cannot be freed
; and stop the execution               
            mov    dx,  offset remerror
            mov    ah,  9     
            int    21h        
            int    20h        
                              
@SwitchH:                     
@Switch?:                     
; Display the help information and stop
                              
            mov    ah,  9     
            push   cs         
            pop    ds         
            mov    dx,  offset help
            int    21h        
            int    20h        
                              
@SwitchL:                     
; Toggle the state of the blinking frame
            push   es                   
            mov    ax,  progseg         
            mov    es,  ax ;es= the segment of the main copy
            mov al,  byte ptr es:  options; Check the frame status
            and    al,  noFrame            
            jnz    @Fram  ; If the flag is off, turn it on 
            or     byte ptr es:options,noFrame ; and vice versa
            pop    es                                          
            mov    ah,  9 ; Display the message
            mov    dx,  offset lightoff        
            int    21h                         
            ret                                
@Fram:                                         
            and    byte ptr es:options,0ffh-noFrame; ON!!!
            pop    es                                     
            mov    ah,  9 ;Display the message
            mov    dx,  offset lighton                    
            int    21h                                    
            ret                               
                                              
; The lock from the command line routine
; I am too tired to comment it. It is quite much a copy of the code
; from the user interface listing.
@SwitchD:                    
            mov    ax,  cs:progseg            
            mov    ds,  ax                    
            mov    count,0                    
            mov    si,  cs:curptr             
            inc    si                         
            cmp    cs:[byte ptr 81h+si], ':'  
            jne    @err1
            inc    si                         
            xor    di,  di                    
@doit1:                                        
            mov    al, cs: [byte ptr 81h+si]  
                                              
                                              
            call   UpCase                     
            cmp    al,  20h    
            je     @1pass1      
            cmp    al,  '/'    
            je     @1pass1      
            cmp    al,  '-'    
            je     @1pass1      
            cmp    al,  20     
            jb     @passerror1
            cmp    al,  ''       
            ja     @passerror1
            inc    si
            mov    byte ptr [di+offset password],al
            inc    di
            xor    ch,  ch
            mov    cl,  [byte ptr cs:80h]
            cmp    si,  cx
            jb     @doit1
                               
@1pass1:                 
            mov    cs:curptr, si
                               
            mov    cx,  di     
            mov    count, cx   
            mov    passcount, cx
            xor    si, si      
@cycle1:                        
            mov    al, byte ptr [si+offset password]
            mov    byte ptr [si+offset userpass], al
            inc    si          
            cmp    si, cx      
            jne    @cycle1
            mov    ax, cs
            mov    ds, ax
            mov    es, ax
            write  Setdef
            ret                
@err1:
            mov    dx, offset colonerr
            jmp    @show

@passerror1:
            mov    dx, offset passerr
            jmp    @show

@SwitchC:                                     
            mov    ax,  cs:progseg            
            mov    ds,  ax                    
            mov    count,0                    
            mov    si,  cs:curptr             
            inc    si                         
            cmp    cs:[byte ptr 81h+si], ':'  
            jne    @err                       
            inc    si                         
            xor    di,  di                    
@doit:                                        
            mov    al, cs: [byte ptr 81h+si]  
                                              
                                              
            call   UpCase                     
            cmp    al,  20h    
            je     @1pass      
            cmp    al,  '/'    
            je     @1pass      
            cmp    al,  '-'    
            je     @1pass      
            cmp    al,  20     
            jb     @passerror  
            cmp    al,  ''       
            ja     @passerror  
            inc    si          
            mov    byte ptr [di+offset password],al
            inc    di          
            xor    ch,  ch     
            mov    cl,  [byte ptr cs:80h]
            cmp    si,  cx     
            jb     @doit       
                               
@1pass:                        
            mov    cs:curptr, si
                               
            mov    cx,  di     
            mov    count, cx   
            mov    passcount, cx
            xor    si, si      
@cycle:                        
            mov    al, byte ptr [si+offset password]
            mov    byte ptr [si+offset userpass], al
            inc    si          
            cmp    si, cx      
            jne    @cycle      
            mov    ax, 0002h   
            int    33h         
            or     status, closed
            mov    ax,  cs     
            mov    ds,  ax     
            mov    es,  ax     
            mov    ah, 9h      
            mov    dx,  offset closedbyc
            int    21h         
            ret                
                               
@err:                          
            mov    dx, offset colonerr
            jmp    @show       
@passerror:                    
            mov    dx,  offset passerr
            jmp    @show       
@longpass:                     
            mov    dx,  offset longpass
@show:                         
            push   cs          
            pop    ds          
            mov    ah,  9      
            int    21h         
            int    20h         
                               
@end:       ret                
                               
