/*    
   defrag.c - main module.
   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>

#include "..\..\modlgate\modlgate.h"
#include "..\..\modlgate\defrpars.h"
#include "..\..\misc\version.h"
#include "..\..\misc\misc.h"
#include "..\..\misc\boot.h"

#include "..\..\misc\drvtypes.h"

#include "chkargs.h"
#include "checkos.h"

static void ShowHelp(char switchchar);
static void ShowContributors(void);
static void OnExit(void);
static int OnCBreak(void);

static char* Contributors[] = CONTRIBUTORS;

#define METHODBORDER 80

int main(int argc, char *argv[])
{
    char switchchar = SwitchChar();
    int  factor;

char answer[5]; 

    /* Check parameters. */
    if (argc == 2)
    {
      /* Show help if requested. */
      if ((argv[1][0] == switchchar) || (argv[1][0] == '/'))  
      {
         if (argv[1][1] == '?')
         {
            ShowHelp(switchchar);
            return 0;
         }
         if (stricmp(&argv[1][1], "CONTRIB") == 0)
         {
            ShowContributors();
            return 0;
         }
      }
    }
    ParseArguments(argc, argv, switchchar);

printf("This is an alpha version of defrag!!!\n");
printf("Are you sure you want to continue (YES/No)?");
scanf("%5s", answer);

if (stricmp(answer, "YES") != 0) return 1;

    /* Check file system integrity. */
    if (!CheckOS()) return 1;

    /* Show copyright on the screen. */
    printf("This program is free software. It comes with ABSOLUTELY NO WARANTIES.\n"
           "You are welcome to redistribute it under the terms of the\n" 
           "GNU General Public License, see http://www.GNU.org for details.\n\n");

    atexit(OnExit);
    ctrlbrk(OnCBreak);

    if (GetDriveType(GetOptimizationDrive() - 'A' + 1) != dtRemovable)
    {
       printf("Invalid or unsupported drive type!");
       return 1;
    }

    if (!CheckDiskIntegrity())
    {
       printf("Disk corrupted, cannot defragment!");
       return 1;
    }
    else
    {
       if ((factor = ScanDrive()) == 255)
       {
          printf("Disk corrupted, cannot defragment!");
          return 1;
       }
       else
       {
          printf("%d%% of drive %c: is not fragmented.\n",
                 factor,
                 GetOptimizationDrive());

          if (!IsMethodEntered())
          {
             if (factor == 100)
             {
                printf("No optimization necessary.\n");
                return 0;
             }
             else if (factor > METHODBORDER)
                SetOptimizationMethod(UNFRAGMENT_FILES);
             else /* if (factor < METHODBORDER) */
                SetOptimizationMethod(FULL_OPTIMIZATION);
          }
          
          if (GetOptimizationMethod() == UNFRAGMENT_FILES)
             printf("Optimization method is unfragment files only.\n");   
          else
             printf("Optimization method is full optimization.\n");
          
          printf("The actual defragmentation process is not implemented yet!\n");

          if (IsRebootRequested())
          {
             printf("Rebooting the computer...");
             delay(20000);
             ColdReboot();
          }
      }
    }

    return 0;
}

static void ShowHelp (char switchchar)
{
     printf("FreeDOS defrag " VERSION "\n"
            "Optimizes file loading times by moving file fragments together.\n"
            "\n"
            "(C) 2000 by Imre Leber under the GNU General Public License.\n"
            "\n"
            "defrag <drive>: [{%cF|%cU}] [%cSorder[-]] [%cB] [%cX] [%cA] [%cFO]\n"
            "\n"
            "drive : drive letter of drive to optimize.\n"
            "\n"
            "%cF  : Fully optimizes specified drive.\n"
            "%cU  : Unfragments files, possibly leaving space between files.\n"
            "%cS  : Sort files by specified order.\n"
            "       order: N  by Name (alphabetic)            E by Extension (alphabetic)\n"
            "              D  by Date & time (earliest first) S by Size (smallest first)\n"
            "       - suffix to sort in descending order.\n"
            "%cB  : Restarts computer after optimization.\n"
            "%cX  : Allways automatically exits.\n"
            "%cA  : Audible warning for user action.\n"
            "%cFO : Full textual output.\n"
            "\n"
            "Remarks:\n"
            "    Enter %ccontrib for a list of contributors.\n"
            "    You can only specify floppy drives or hard disks.\n",
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar);
}

static void ShowContributors()
{
    int i;

    printf("Main programmer: Imre Leber\n\n");
    
    printf("Contributors to FreeDOS defrag:\n");
    
    for (i = 0; i < AMOFCONTRIBUTORS; i++)
        printf("%s\n", Contributors[i]);

    puts("\nWeb site: " WEBSITE);
    puts("E-Group:  "  EGROUP);
}

static void OnExit()
{
}

static int OnCBreak ()
{
      return 1;
}
