/*    
   Mrkunmve.c - mark unmovable clusters.

   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdlib.h>

#include "fte.h"
#include "expected.h"
#include "inffat12.h"

static int UnmovableMarker(RDWRHandle handle,
                           struct DirectoryEntry* entry,
                           void** structure);

static int RealMarker(RDWRHandle handle,
                      CLUSTER label,
                      SECTOR  sector,
                      void**  structure);

int MarkUnmovables(RDWRHandle handle)
{
    return WalkDirectoryTree(handle, UnmovableMarker, NULL);
}

static int UnmovableMarker(RDWRHandle handle,
                           struct DirectoryEntry* entry,
                           void** structure)
{
    if ((entry->attribute & FA_HIDDEN) || (entry->attribute & FA_SYSTEM))
       FileTraverseFat(handle, entry->firstclust, RealMarker, NULL);

    return TRUE;
}

static int RealMarker(RDWRHandle handle,
                      CLUSTER label,
                      SECTOR  sector,
                      void**  structure)
{
    CLUSTER cluster;
    cluster = DataSectorToCluster(handle, sector);

    DrawOnDriveMap(cluster, UNMOVABLESYMBOL);

    return TRUE;
}
