/*    
   Rdentrs.c - read entries in memory.

   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/


static int EntryGetter(RDWRHandle handle,
                       struct DirectoryPosition* pos,
                       void** buffer);

struct PipeStruct {

       unsigned epos;
       struct   DirectoryEntry entries;

       unsigned cpos;
       CLUSTER* clusters;
};


int ReadEntries(RDWRHandle handle, CLUSTER cluster,
                struct DirectoryPosition* pos,
                struct DirectoryEntry* entries, CLUSTER* clusters)
{
    struct PipeStruct pipe, *ppipe = &pipe;

    pipe->epos     = 0;
    pipe->entries  = entries;
    pipe->cpos     = 0;
    pipe->clusters = clusters;

    return TraverseSubdir(handle, cluster, EntryGetter,
                          (void**) ppipe, TRUE);
}

static int EntryGetter(RDWRHandle handle,
                       struct DirectoryPosition* pos,
                       void** buffer)
{
    unsigned char sectorspercluster;
    CLUSTER cluster;

    struct PipeStruct* pipe = *((struct PipeStruct**) buffer);
    GetDirectory(handle, pos, pipe->entries[pipe->epos]);
    pipe->epos++;

    sectorspercluster = GetSectorsPerCluster(handle);
    cluster = pos->sector / sectorspercluster;

    if (pipe->clusters[pipe->cpos] != cluster)
    {
       pipe->clusters[pipe->cpos] = cluster;
       pipe->cpos++;
    }

    return TRUE;
}
